/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.ODetachable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OPropertyAccess;
import com.orientechnologies.orient.core.metadata.security.OPropertyEncryption;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ODocument
extends ORecordAbstract
implements Iterable<Map.Entry<String, Object>>,
ORecordSchemaAware,
ODetachable,
Externalizable,
OElement {
    public static final byte RECORD_TYPE = 100;
    protected static final String[] EMPTY_STRINGS = new String[0];
    private static final long serialVersionUID = 1L;
    protected int fieldSize;
    protected Map<String, ODocumentEntry> fields;
    protected boolean trackingChanges = true;
    protected boolean ordered = true;
    protected boolean lazyLoad = true;
    protected boolean allowChainedAccess = true;
    protected transient WeakReference<ORecordElement> owner = null;
    protected OImmutableSchema schema;
    private String className;
    private OImmutableClass immutableClazz;
    private int immutableSchemaVersion = 1;
    protected OPropertyAccess propertyAccess;
    protected OPropertyEncryption propertyEncryption;

    public ODocument() {
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
    }

    public ODocument(ODatabaseSession database) {
        this.setup((ODatabaseDocumentInternal)database);
    }

    @Deprecated
    public ODocument(byte[] iSource) {
        this.source = iSource;
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
    }

    public ODocument(InputStream iSource) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OIOUtils.copyStream(iSource, out, -1L);
        this.source = out.toByteArray();
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
    }

    public ODocument(ORID iRID) {
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
        this.recordId = (ORecordId)iRID;
        this.status = ORecordElement.STATUS.NOT_LOADED;
        this.dirty = false;
        this.contentChanged = false;
    }

    public ODocument(String iClassName, ORID iRID) {
        this(iClassName);
        OImmutableSchema schema;
        OClass cls;
        this.recordId = (ORecordId)iRID;
        ODatabaseDocumentInternal database = this.getDatabaseInternal();
        if (this.recordId.getClusterId() > -1 && (cls = (schema = database.getMetadata().getImmutableSchemaSnapshot()).getClassByClusterId(this.recordId.getClusterId())) != null && !cls.getName().equals(iClassName)) {
            throw new IllegalArgumentException("Cluster id does not correspond class name should be " + iClassName + " but found " + cls.getName());
        }
        this.dirty = false;
        this.contentChanged = false;
        this.status = ORecordElement.STATUS.NOT_LOADED;
    }

    public ODocument(String iClassName) {
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
        this.setClassName(iClassName);
    }

    public ODocument(ODatabaseSession session, String iClassName) {
        this.setup((ODatabaseDocumentInternal)session);
        this.setClassName(iClassName);
    }

    public ODocument(OClass iClass) {
        this(iClass != null ? iClass.getName() : null);
    }

    public ODocument(Object[] iFields) {
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; i += 2) {
                this.field(iFields[i].toString(), iFields[i + 1]);
            }
        }
    }

    public ODocument(Map<?, Object> iFieldMap) {
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
        if (iFieldMap != null && !iFieldMap.isEmpty()) {
            for (Map.Entry<?, Object> entry : iFieldMap.entrySet()) {
                this.field(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public ODocument(String iFieldName, Object iFieldValue, Object ... iFields) {
        this(iFields);
        this.field(iFieldName, iFieldValue);
    }

    @Override
    public Optional<OVertex> asVertex() {
        if (this instanceof OVertex) {
            return Optional.of((OVertex)((Object)this));
        }
        OClass type = this.getSchemaClass();
        if (type == null) {
            return Optional.empty();
        }
        if (type.isVertexType()) {
            return Optional.of(new OVertexDelegate(this));
        }
        return Optional.empty();
    }

    @Override
    public Optional<OEdge> asEdge() {
        if (this instanceof OEdge) {
            return Optional.of((OEdge)((Object)this));
        }
        OClass type = this.getSchemaClass();
        if (type == null) {
            return Optional.empty();
        }
        if (type.isEdgeType()) {
            return Optional.of(new OEdgeDelegate(this));
        }
        return Optional.empty();
    }

    @Override
    public boolean isVertex() {
        if (this instanceof OVertex) {
            return true;
        }
        OClass type = this.getSchemaClass();
        if (type == null) {
            return false;
        }
        return type.isVertexType();
    }

    @Override
    public boolean isEdge() {
        if (this instanceof OEdge) {
            return true;
        }
        OClass type = this.getSchemaClass();
        if (type == null) {
            return false;
        }
        return type.isEdgeType();
    }

    @Override
    public Optional<OClass> getSchemaType() {
        return Optional.ofNullable(this.getSchemaClass());
    }

    private Stream<String> calculatePropertyNames() {
        String[] fieldNames;
        this.checkForLoading();
        if (this.status == ORecordElement.STATUS.LOADED && this.source != null && ODatabaseRecordThreadLocal.instance().isDefined() && !ODatabaseRecordThreadLocal.instance().get().isClosed() && (fieldNames = this.recordFormat.getFieldNames(this, this.source)) != null) {
            if (this.propertyAccess != null) {
                return Arrays.stream(fieldNames).filter(e -> this.propertyAccess.isReadable((String)e));
            }
            return Arrays.stream(fieldNames);
        }
        this.checkForFields(new String[0]);
        if (this.fields == null || this.fields.size() == 0) {
            return Stream.empty();
        }
        return this.fields.entrySet().stream().filter(s -> ((ODocumentEntry)s.getValue()).exists() && (this.propertyAccess == null || this.propertyAccess.isReadable((String)s.getKey()))).map(Map.Entry::getKey);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.calculatePropertyNames().collect(Collectors.toSet());
    }

    @Override
    public <RET> RET getProperty(String iFieldName) {
        Object newValue;
        if (iFieldName == null) {
            return null;
        }
        this.checkForLoading();
        Object value = ODocumentHelper.getIdentifiableValue(this, iFieldName);
        if (!iFieldName.startsWith("@") && this.lazyLoad && value instanceof ORID && (((ORID)value).isPersistent() || ((ORID)value).isNew()) && ODatabaseRecordThreadLocal.instance().isDefined() && (newValue = this.getDatabase().load((ORID)value)) != null) {
            this.unTrack((ORID)value);
            this.track((OIdentifiable)newValue);
            value = newValue;
            if (this.isTrackingChanges()) {
                ORecordInternal.setDirtyManager((ORecord)value, this.getDirtyManager());
            }
            ODocumentEntry entry = this.fields.get(iFieldName);
            entry.disableTracking(this, entry.value);
            entry.value = value;
            entry.enableTracking(this);
        }
        if (value instanceof OElement) {
            if (((OElement)value).isVertex()) {
                value = ((OElement)value).asVertex().get();
            } else if (((OElement)value).isEdge()) {
                value = ((OElement)value).asEdge().get();
            }
        }
        return (RET)value;
    }

    protected <RET> RET getRawProperty(String iFieldName) {
        if (iFieldName == null) {
            return null;
        }
        this.checkForLoading();
        return (RET)ODocumentHelper.getIdentifiableValue(this, iFieldName);
    }

    @Override
    public void setProperty(String iFieldName, Object iPropertyValue) {
        if (iPropertyValue instanceof OElement && !((OElement)iPropertyValue).getSchemaType().isPresent() && !((OElement)iPropertyValue).getIdentity().isValid()) {
            this.setProperty(iFieldName, iPropertyValue, OType.EMBEDDED);
        } else {
            this.setProperty(iFieldName, iPropertyValue, OCommonConst.EMPTY_TYPES_ARRAY);
        }
    }

    @Override
    public void setProperty(String iPropetyName, Object iPropertyValue, OType ... iFieldType) {
        ORidBag ridBag;
        OType oldType;
        Object oldValue;
        boolean knownProperty;
        if (iPropetyName == null) {
            throw new IllegalArgumentException("Field is null");
        }
        if (iPropetyName.isEmpty()) {
            throw new IllegalArgumentException("Field name is empty");
        }
        if ("@class".equals(iPropetyName)) {
            this.setClassName(iPropertyValue.toString());
            return;
        }
        if ("@rid".equals(iPropetyName)) {
            this.recordId.fromString(iPropertyValue.toString());
            return;
        }
        if ("@version".equals(iPropetyName)) {
            if (iPropertyValue != null) {
                int v = iPropertyValue instanceof Number ? ((Number)iPropertyValue).intValue() : Integer.parseInt(iPropertyValue.toString());
                this.recordVersion = v;
            }
            return;
        }
        this.checkForLoading();
        this.checkForFields(new String[0]);
        ODocumentEntry entry = this.fields.get(iPropetyName);
        if (entry == null) {
            entry = new ODocumentEntry();
            ++this.fieldSize;
            this.fields.put(iPropetyName, entry);
            entry.markCreated();
            knownProperty = false;
            oldValue = null;
            oldType = null;
        } else {
            knownProperty = entry.exists();
            oldValue = entry.value;
            oldType = entry.type;
        }
        OType fieldType = this.deriveFieldType(iPropetyName, entry, iFieldType);
        if (iPropertyValue != null && fieldType != null) {
            iPropertyValue = ODocumentHelper.convertField(this, iPropetyName, fieldType, null, iPropertyValue);
        } else if (iPropertyValue instanceof Enum) {
            iPropertyValue = iPropertyValue.toString();
        }
        if (knownProperty) {
            if (iPropertyValue == null) {
                if (oldValue == null) {
                    return;
                }
            } else {
                try {
                    if (iPropertyValue.equals(oldValue) && fieldType == oldType) {
                        if (!(iPropertyValue instanceof ORecordElement)) {
                            this.setDirty();
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error on checking the value of property %s against the record %s", e, iPropetyName, this.getIdentity());
                }
            }
        }
        if (oldValue instanceof ORidBag) {
            ridBag = (ORidBag)oldValue;
            ridBag.setOwner(null);
        } else if (oldValue instanceof ODocument) {
            ((ODocument)oldValue).removeOwner(this);
        }
        if (oldValue instanceof OIdentifiable) {
            this.unTrack((OIdentifiable)oldValue);
        }
        if (iPropertyValue != null) {
            if (iPropertyValue instanceof ODocument && OType.EMBEDDED.equals((Object)fieldType)) {
                ODocument embeddedDocument = (ODocument)iPropertyValue;
                ODocumentInternal.addOwner(embeddedDocument, this);
            }
            if (iPropertyValue instanceof OIdentifiable) {
                this.track((OIdentifiable)iPropertyValue);
            }
            if (iPropertyValue instanceof ORidBag) {
                ridBag = (ORidBag)iPropertyValue;
                ridBag.setOwner(null);
                ridBag.setOwner(this);
            }
        }
        if (fieldType == OType.CUSTOM && !OGlobalConfiguration.DB_CUSTOM_SUPPORT.getValueAsBoolean()) {
            throw new ODatabaseException(String.format("OType CUSTOM used by serializable types, for value  '%s' is not enabled, set `db.custom.support` to true for enable it", iPropertyValue));
        }
        if (oldType != fieldType && oldType != null && (iPropertyValue == null || fieldType != null || oldType != OType.getTypeByValue(iPropertyValue))) {
            entry.type = fieldType;
        }
        entry.disableTracking(this, oldValue);
        entry.value = iPropertyValue;
        if (!entry.exists()) {
            entry.setExists(true);
            ++this.fieldSize;
        }
        entry.enableTracking(this);
        this.setDirty();
        if (!entry.isChanged()) {
            entry.original = oldValue;
            entry.markChanged();
        }
    }

    @Override
    public <RET> RET removeProperty(String iFieldName) {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if ("@class".equalsIgnoreCase(iFieldName)) {
            this.setClassName(null);
        } else if ("@rid".equalsIgnoreCase(iFieldName)) {
            this.recordId = new ORecordId();
        }
        ODocumentEntry entry = this.fields.get(iFieldName);
        if (entry == null) {
            return null;
        }
        Object oldValue = entry.value;
        if (entry.exists() && this.trackingChanges) {
            if (entry.original == null) {
                entry.original = entry.value;
            }
            entry.value = null;
            entry.setExists(false);
            entry.markChanged();
        } else {
            this.fields.remove(iFieldName);
        }
        --this.fieldSize;
        entry.disableTracking(this, oldValue);
        if (oldValue instanceof OIdentifiable) {
            this.unTrack((OIdentifiable)oldValue);
        }
        if (oldValue instanceof ORidBag) {
            ((ORidBag)oldValue).setOwner(null);
        }
        this.setDirty();
        return (RET)oldValue;
    }

    protected static void validateFieldsSecurity(ODatabaseDocumentInternal internal, ODocument iRecord) throws OValidationException {
        if (internal == null) {
            return;
        }
        OSecurityInternal security = internal.getSharedContext().getSecurity();
        for (Map.Entry<String, ODocumentEntry> mapEntry : iRecord.fields.entrySet()) {
            ODocumentEntry entry = mapEntry.getValue();
            if (entry == null || !entry.isChanged() && !entry.isTrackedModified() || security.isAllowedWrite(internal, iRecord, mapEntry.getKey())) continue;
            throw new OSecurityException(String.format("Change of field '%s' is not allowed for user '%s'", iRecord.getClassName() + "." + mapEntry.getKey(), internal.getUser().getName()));
        }
    }

    protected static void validateField(ODocument iRecord, OImmutableProperty p) throws OValidationException {
        Object fieldValue;
        ODocumentEntry entry = iRecord.fields.get(p.getName());
        if (entry != null && entry.exists()) {
            fieldValue = entry.value;
            if (p.isNotNull() && fieldValue == null) {
                throw new OValidationException("The field '" + p.getFullName() + "' cannot be null, record: " + iRecord);
            }
            if (fieldValue != null && p.getRegexp() != null && p.getType().equals((Object)OType.STRING) && !((String)fieldValue).matches(p.getRegexp())) {
                throw new OValidationException("The field '" + p.getFullName() + "' does not match the regular expression '" + p.getRegexp() + "'. Field value is: " + fieldValue + ", record: " + iRecord);
            }
        } else {
            if (p.isMandatory()) {
                throw new OValidationException("The field '" + p.getFullName() + "' is mandatory, but not found on record: " + iRecord);
            }
            fieldValue = null;
        }
        OType type = p.getType();
        if (fieldValue != null && type != null) {
            switch (type) {
                case LINK: {
                    ODocument.validateLink(p, fieldValue, false);
                    break;
                }
                case LINKLIST: {
                    if (!(fieldValue instanceof List)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKLIST but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, (Collection)fieldValue, entry);
                    break;
                }
                case LINKSET: {
                    if (!(fieldValue instanceof Set)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKSET but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, (Collection)fieldValue, entry);
                    break;
                }
                case LINKMAP: {
                    if (!(fieldValue instanceof Map)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKMAP but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, ((Map)fieldValue).values(), entry);
                    break;
                }
                case LINKBAG: {
                    if (!(fieldValue instanceof ORidBag)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKBAG but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, (Iterable)fieldValue, entry);
                    break;
                }
                case EMBEDDED: {
                    ODocument.validateEmbedded(p, fieldValue);
                    break;
                }
                case EMBEDDEDLIST: {
                    if (!(fieldValue instanceof List)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDLIST but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Object object : (List)fieldValue) {
                            ODocument.validateEmbedded(p, object);
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Object object : (List)fieldValue) {
                            ODocument.validateType(p, object);
                        }
                    }
                    break;
                }
                case EMBEDDEDSET: {
                    if (!(fieldValue instanceof Set)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDSET but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Object object : (Set)fieldValue) {
                            ODocument.validateEmbedded(p, object);
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Object object : (Set)fieldValue) {
                            ODocument.validateType(p, object);
                        }
                    }
                    break;
                }
                case EMBEDDEDMAP: {
                    if (!(fieldValue instanceof Map)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDMAP but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Map.Entry entry2 : ((Map)fieldValue).entrySet()) {
                            ODocument.validateEmbedded(p, entry2.getValue());
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Map.Entry entry3 : ((Map)fieldValue).entrySet()) {
                            ODocument.validateType(p, entry3.getValue());
                        }
                    }
                    break;
                }
            }
        }
        if (p.getMin() != null && fieldValue != null) {
            String min = p.getMin();
            if (p.getMinComparable().compareTo(fieldValue) > 0) {
                switch (p.getType()) {
                    case STRING: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains fewer characters than " + min + " requested");
                    }
                    case DATE: 
                    case DATETIME: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the date " + fieldValue + " which precedes the first acceptable date (" + min + ")");
                    }
                    case BINARY: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains fewer bytes than " + min + " requested");
                    }
                    case LINKLIST: 
                    case LINKSET: 
                    case LINKMAP: 
                    case EMBEDDEDLIST: 
                    case EMBEDDEDSET: 
                    case EMBEDDEDMAP: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains fewer items than " + min + " requested");
                    }
                }
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
        }
        if (p.getMaxComparable() != null && fieldValue != null) {
            String max = p.getMax();
            if (p.getMaxComparable().compareTo(fieldValue) < 0) {
                switch (p.getType()) {
                    case STRING: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains more characters than " + max + " requested");
                    }
                    case DATE: 
                    case DATETIME: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the date " + fieldValue + " which is after the last acceptable date (" + max + ")");
                    }
                    case BINARY: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains more bytes than " + max + " requested");
                    }
                    case LINKLIST: 
                    case LINKSET: 
                    case LINKMAP: 
                    case EMBEDDEDLIST: 
                    case EMBEDDEDSET: 
                    case EMBEDDEDMAP: {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains more items than " + max + " requested");
                    }
                }
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
        }
        if (p.isReadonly() && !ORecordVersionHelper.isTombstone(iRecord.getVersion()) && entry != null && (entry.isChanged() || entry.isTrackedModified()) && !entry.isCreated()) {
            boolean bl;
            Object orgVal = entry.original;
            boolean bl2 = bl = fieldValue != null ? OType.isSimpleType(fieldValue) : OType.isSimpleType(orgVal);
            if (bl || fieldValue != null && orgVal == null || fieldValue == null && orgVal != null || fieldValue != null && !fieldValue.equals(orgVal)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is immutable and cannot be altered. Field value is: " + entry.value);
            }
        }
    }

    protected static void validateLinkCollection(OProperty property, Iterable<Object> values, ODocumentEntry value) {
        if (property.getLinkedClass() != null) {
            if (value.getTimeLine() != null) {
                List<OMultiValueChangeEvent<Object, Object>> event = value.getTimeLine().getMultiValueChangeEvents();
                for (OMultiValueChangeEvent<Object, Object> object : event) {
                    if (object.getChangeType() != OMultiValueChangeEvent.OChangeType.ADD && (object.getChangeType() != OMultiValueChangeEvent.OChangeType.UPDATE || object.getValue() == null)) continue;
                    ODocument.validateLink(property, object.getValue(), true);
                }
            } else {
                boolean autoconvert = false;
                if (values instanceof ORecordLazyMultiValue) {
                    autoconvert = ((ORecordLazyMultiValue)((Object)values)).isAutoConvertToRecord();
                    ((ORecordLazyMultiValue)((Object)values)).setAutoConvertToRecord(false);
                }
                for (Object object : values) {
                    ODocument.validateLink(property, object, true);
                }
                if (values instanceof ORecordLazyMultiValue) {
                    ((ORecordLazyMultiValue)((Object)values)).setAutoConvertToRecord(autoconvert);
                }
            }
        }
    }

    protected static void validateType(OProperty p, Object value) {
        if (value != null && OType.convert(value, p.getLinkedType().getDefaultJavaType()) == null) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + (Object)((Object)p.getLinkedType()) + "' but the value is " + value);
        }
    }

    protected static void validateLink(OProperty p, Object fieldValue, boolean allowNull) {
        Object linkedRecord;
        ORID rid;
        if (fieldValue == null) {
            if (allowNull) {
                return;
            }
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but contains a null record (probably a deleted record?)");
        }
        if (!(fieldValue instanceof OIdentifiable)) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is not a record or a record-id");
        }
        OClass schemaClass = p.getLinkedClass();
        if (schemaClass != null && !schemaClass.isSubClassOf("OIdentity") && !schemaClass.hasPolymorphicClusterId((rid = ((OIdentifiable)fieldValue).getIdentity()).getClusterId()) && (linkedRecord = ((OIdentifiable)fieldValue).getRecord()) != null) {
            if (!(linkedRecord instanceof ODocument)) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + schemaClass + "' but the value is the record " + linkedRecord.getIdentity() + " that is not a document");
            }
            ODocument doc = (ODocument)linkedRecord;
            if (doc.getImmutableSchemaClass() != null && !schemaClass.isSuperClassOf(doc.getImmutableSchemaClass())) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + schemaClass.getName() + "' but the value is the document " + linkedRecord.getIdentity() + " of class '" + doc.getImmutableSchemaClass() + "'");
            }
        }
    }

    protected static void validateEmbedded(OProperty p, Object fieldValue) {
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof ORecordId) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is the RecordID " + fieldValue);
        }
        if (fieldValue instanceof OIdentifiable) {
            OIdentifiable embedded = (OIdentifiable)fieldValue;
            if (embedded.getIdentity().isValid()) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is a document with the valid RecordID " + fieldValue);
            }
            OClass embeddedClass = p.getLinkedClass();
            if (embeddedClass != null) {
                Object embeddedRecord = embedded.getRecord();
                if (!(embeddedRecord instanceof ODocument)) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record was not a document");
                }
                ODocument doc = (ODocument)embeddedRecord;
                if (doc.getImmutableSchemaClass() == null) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record has no class");
                }
                if (!doc.getImmutableSchemaClass().isSubClassOf(embeddedClass)) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record is of class '" + doc.getImmutableSchemaClass().getName() + "' that is not a subclass of that");
                }
                doc.validate();
            }
        } else {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but an incompatible type is used. Value: " + fieldValue);
        }
    }

    public ODocument copy() {
        return (ODocument)this.copyTo(new ODocument());
    }

    @Override
    public ORecordAbstract copyTo(ORecordAbstract iDestination) {
        this.checkForFields(new String[0]);
        ODocument destination = (ODocument)iDestination;
        super.copyTo(iDestination);
        destination.ordered = this.ordered;
        destination.className = this.className;
        destination.immutableSchemaVersion = -1;
        destination.immutableClazz = null;
        destination.trackingChanges = this.trackingChanges;
        destination.owner = this.owner;
        if (this.fields != null) {
            destination.fields = this.fields instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
            for (Map.Entry<String, ODocumentEntry> entry : this.fields.entrySet()) {
                ODocumentEntry docEntry = entry.getValue().clone();
                destination.fields.put(entry.getKey(), docEntry);
                docEntry.value = ODocumentHelper.cloneValue(destination, entry.getValue().value);
            }
        } else {
            destination.fields = null;
        }
        destination.fieldSize = this.fieldSize;
        destination.addAllMultiValueChangeListeners();
        destination.dirty = this.dirty;
        destination.contentChanged = this.contentChanged;
        return destination;
    }

    @Deprecated
    public ORecord placeholder() {
        ODocument cloned = new ODocument();
        cloned.source = null;
        cloned.recordId = this.recordId;
        cloned.status = ORecordElement.STATUS.NOT_LOADED;
        cloned.dirty = false;
        cloned.contentChanged = false;
        return cloned;
    }

    @Override
    public boolean detach() {
        this.deserializeFields(new String[0]);
        boolean fullyDetached = true;
        if (this.fields != null) {
            for (Map.Entry<String, ODocumentEntry> entry : this.fields.entrySet()) {
                Object fieldValue = entry.getValue().value;
                if (fieldValue instanceof ORecord) {
                    if (((ORecord)fieldValue).getIdentity().isNew()) {
                        fullyDetached = false;
                    } else {
                        entry.getValue().value = ((ORecord)fieldValue).getIdentity();
                    }
                }
                if (!(fieldValue instanceof ODetachable) || ((ODetachable)fieldValue).detach()) continue;
                fullyDetached = false;
            }
        }
        return fullyDetached;
    }

    public ODocument load(String iFetchPlan) {
        return this.load(iFetchPlan, false);
    }

    public ODocument load(String iFetchPlan, boolean iIgnoreCache) {
        Object result;
        try {
            result = this.getDatabase().load(this, iFetchPlan, iIgnoreCache);
        }
        catch (Exception e) {
            throw OException.wrapException(new ORecordNotFoundException(this.getIdentity()), e);
        }
        if (result == null) {
            throw new ORecordNotFoundException(this.getIdentity());
        }
        return (ODocument)result;
    }

    @Override
    public ODocument reload(String fetchPlan, boolean ignoreCache) {
        super.reload(fetchPlan, ignoreCache);
        if (!this.lazyLoad) {
            this.checkForLoading();
            this.checkForFields(new String[0]);
        }
        return this;
    }

    public boolean hasSameContentOf(ODocument iOther) {
        ODatabaseDocumentInternal currentDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        return ODocumentHelper.hasSameContentOf(this, currentDb, iOther, currentDb, null);
    }

    @Override
    public byte[] toStream() {
        if (this.recordFormat == null) {
            this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
        }
        return this.toStream(false);
    }

    public Map<String, Object> toMap() {
        String className;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String field : this.fieldNames()) {
            map.put(field, this.field(field));
        }
        ORID id = this.getIdentity();
        if (id.isValid()) {
            map.put("@rid", id);
        }
        if ((className = this.getClassName()) != null) {
            map.put("@class", className);
        }
        return map;
    }

    @Override
    public String toString() {
        return this.toString(new HashSet<ORecord>());
    }

    @Deprecated
    public void fromString(String iValue) {
        this.dirty = true;
        this.contentChanged = true;
        try {
            this.source = iValue.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error reading content from string"), e);
        }
        this.removeAllCollectionChangeListeners();
        this.fields = null;
        this.fieldSize = 0;
    }

    @Override
    public String[] fieldNames() {
        return this.calculatePropertyNames().collect(Collectors.toList()).toArray(new String[0]);
    }

    @Override
    public Object[] fieldValues() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        ArrayList<Object> res = new ArrayList<Object>(this.fields.size());
        for (Map.Entry<String, ODocumentEntry> entry : this.fields.entrySet()) {
            if (!entry.getValue().exists() || this.propertyAccess != null && !this.propertyAccess.isReadable(entry.getKey())) continue;
            res.add(entry.getValue().value);
        }
        return res.toArray();
    }

    public <RET> RET rawField(String iFieldName) {
        if (iFieldName == null || iFieldName.length() == 0) {
            return null;
        }
        this.checkForLoading();
        if (!this.checkForFields(iFieldName)) {
            return null;
        }
        if (!this.allowChainedAccess || iFieldName.charAt(0) != '@' && OStringSerializerHelper.indexOf(iFieldName, 0, '.', '[') == -1) {
            return (RET)this.accessProperty(iFieldName);
        }
        return ODocumentHelper.getFieldValue(this, iFieldName);
    }

    public Object eval(String iExpression) {
        return this.eval(iExpression, null);
    }

    public Object eval(String iExpression, OCommandContext iContext) {
        return new OSQLPredicate(iExpression).evaluate(this, null, iContext);
    }

    @Override
    public <RET> RET field(String iFieldName) {
        Object newValue;
        RET value = this.rawField(iFieldName);
        if (!iFieldName.startsWith("@") && this.lazyLoad && value instanceof ORID && (((ORID)value).isPersistent() || ((ORID)value).isNew()) && ODatabaseRecordThreadLocal.instance().isDefined() && (newValue = this.getDatabase().load((ORID)value)) != null) {
            this.unTrack((ORID)value);
            this.track((OIdentifiable)newValue);
            value = newValue;
            if (this.isTrackingChanges()) {
                ORecordInternal.setDirtyManager((ORecord)value, this.getDirtyManager());
            }
            if (!iFieldName.contains(".")) {
                ODocumentEntry entry = this.fields.get(iFieldName);
                entry.disableTracking(this, entry.value);
                entry.value = value;
                entry.enableTracking(this);
            }
        }
        return value;
    }

    public <RET> RET field(String iFieldName, Class<?> iFieldType) {
        RET value = this.rawField(iFieldName);
        if (value != null) {
            value = ODocumentHelper.convertField(this, iFieldName, OType.getTypeByClass(iFieldType), iFieldType, value);
        }
        return value;
    }

    @Override
    public <RET> RET field(String iFieldName, OType iFieldType) {
        OType original;
        Object value = this.field(iFieldName);
        if (iFieldType != null && iFieldType != (original = this.fieldType(iFieldName))) {
            if (original == null && iFieldType == (original = OType.getTypeByValue(value))) {
                return value;
            }
            Object newValue = iFieldType == OType.BINARY && value instanceof String ? OStringSerializerHelper.getBinaryContent(value) : (iFieldType == OType.DATE && value instanceof Long ? (Object)new Date((Long)value) : ((iFieldType == OType.EMBEDDEDSET || iFieldType == OType.LINKSET) && value instanceof List ? (Object)Collections.unmodifiableSet((Set)ODocumentHelper.convertField(this, iFieldName, iFieldType, null, value)) : ((iFieldType == OType.EMBEDDEDLIST || iFieldType == OType.LINKLIST) && value instanceof Set ? (Object)Collections.unmodifiableList((List)ODocumentHelper.convertField(this, iFieldName, iFieldType, null, value)) : ((iFieldType == OType.EMBEDDEDMAP || iFieldType == OType.LINKMAP) && value instanceof Map ? (Object)Collections.unmodifiableMap((Map)ODocumentHelper.convertField(this, iFieldName, iFieldType, null, value)) : (Object)OType.convert(value, iFieldType.getDefaultJavaType())))));
            if (newValue != null) {
                value = newValue;
            }
        }
        return value;
    }

    @Override
    public ODocument field(String iFieldName, Object iPropertyValue) {
        return this.field(iFieldName, iPropertyValue, OCommonConst.EMPTY_TYPES_ARRAY);
    }

    public ODocument fields(String iFieldName, Object iFieldValue, Object ... iFields) {
        if (iFields != null && iFields.length % 2 != 0) {
            throw new IllegalArgumentException("Fields must be passed in pairs as name and value");
        }
        this.field(iFieldName, iFieldValue);
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; i += 2) {
                this.field(iFields[i].toString(), iFields[i + 1]);
            }
        }
        return this;
    }

    @Deprecated
    public ODocument fields(Map<String, Object> iMap) {
        return this.fromMap(iMap);
    }

    public ODocument fromMap(Map<String, ?> iMap) {
        if (iMap != null) {
            for (Map.Entry<String, ?> entry : iMap.entrySet()) {
                this.field(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public ODocument field(String iFieldName, Object iPropertyValue, OType ... iFieldType) {
        ORidBag ridBag;
        OType oldType;
        Object oldValue;
        boolean knownProperty;
        boolean lastIsArray;
        if (iFieldName == null) {
            throw new IllegalArgumentException("Field is null");
        }
        if (iFieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name is empty");
        }
        if ("@class".equals(iFieldName)) {
            this.setClassName(iPropertyValue.toString());
            return this;
        }
        if ("@rid".equals(iFieldName)) {
            this.recordId.fromString(iPropertyValue.toString());
            return this;
        }
        if ("@version".equals(iFieldName)) {
            if (iPropertyValue != null) {
                int v = iPropertyValue instanceof Number ? ((Number)iPropertyValue).intValue() : Integer.parseInt(iPropertyValue.toString());
                this.recordVersion = v;
            }
            return this;
        }
        int lastDotSep = this.allowChainedAccess ? iFieldName.lastIndexOf(46) : -1;
        int lastArraySep = this.allowChainedAccess ? iFieldName.lastIndexOf(91) : -1;
        int lastSep = Math.max(lastArraySep, lastDotSep);
        boolean bl = lastIsArray = lastArraySep > lastDotSep;
        if (lastSep > -1) {
            Object subObject = this.field(iFieldName.substring(0, lastSep));
            if (subObject != null) {
                String subFieldName;
                String string = subFieldName = lastIsArray ? iFieldName.substring(lastSep) : iFieldName.substring(lastSep + 1);
                if (subObject instanceof ODocument) {
                    ((ODocument)subObject).field(subFieldName, iPropertyValue);
                    return ((ODocument)subObject).isEmbedded() ? this : subObject;
                }
                if (subObject instanceof Map) {
                    ((Map)subObject).put(subFieldName, iPropertyValue);
                } else if (OMultiValue.isMultiValue(subObject)) {
                    if ((subObject instanceof List || subObject.getClass().isArray()) && lastIsArray) {
                        int subFieldNameLen = subFieldName.length();
                        if (subFieldName.charAt(subFieldNameLen - 1) != ']') {
                            throw new IllegalArgumentException("Missed closing ']'");
                        }
                        String indexPart = subFieldName.substring(1, subFieldNameLen - 1);
                        Object indexPartObject = ODocumentHelper.getIndexPart(null, indexPart);
                        String indexAsString = indexPartObject == null ? null : indexPartObject.toString();
                        try {
                            int index = Integer.parseInt(indexAsString);
                            OMultiValue.setValue(subObject, iPropertyValue, index);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("List / array subscripts must resolve to integer values.", e);
                        }
                    } else {
                        for (Object subObjectItem : OMultiValue.getMultiValueIterable(subObject)) {
                            if (subObjectItem instanceof ODocument) {
                                if (!((ODocument)subObjectItem).isEmbedded()) {
                                    throw new IllegalArgumentException("Property '" + iFieldName + "' points to linked collection of items. You can only change embedded documents in this way");
                                }
                                ((ODocument)subObjectItem).field(subFieldName, iPropertyValue);
                                continue;
                            }
                            if (!(subObjectItem instanceof Map)) continue;
                            ((Map)subObjectItem).put(subFieldName, iPropertyValue);
                        }
                    }
                    return this;
                }
            } else {
                throw new IllegalArgumentException("Property '" + iFieldName.substring(0, lastSep) + "' is null, is possible to set a value with dotted notation only on not null property");
            }
            return null;
        }
        iFieldName = this.checkFieldName(iFieldName);
        this.checkForLoading();
        this.checkForFields(new String[0]);
        ODocumentEntry entry = this.fields.get(iFieldName);
        if (entry == null) {
            entry = new ODocumentEntry();
            ++this.fieldSize;
            this.fields.put(iFieldName, entry);
            entry.markCreated();
            knownProperty = false;
            oldValue = null;
            oldType = null;
        } else {
            knownProperty = entry.exists();
            oldValue = entry.value;
            oldType = entry.type;
        }
        OType fieldType = this.deriveFieldType(iFieldName, entry, iFieldType);
        if (iPropertyValue != null && fieldType != null) {
            iPropertyValue = ODocumentHelper.convertField(this, iFieldName, fieldType, null, iPropertyValue);
        } else if (iPropertyValue instanceof Enum) {
            iPropertyValue = iPropertyValue.toString();
        }
        if (knownProperty) {
            if (iPropertyValue == null) {
                if (oldValue == null) {
                    return this;
                }
            } else {
                try {
                    if (iPropertyValue.equals(oldValue)) {
                        if (fieldType == oldType) {
                            if (!(iPropertyValue instanceof ORecordElement)) {
                                this.setDirty();
                            }
                            return this;
                        }
                    } else if (iPropertyValue instanceof byte[] && Arrays.equals((byte[])iPropertyValue, (byte[])oldValue)) {
                        return this;
                    }
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error on checking the value of property %s against the record %s", e, iFieldName, this.getIdentity());
                }
            }
        }
        if (oldValue instanceof ORidBag) {
            ridBag = (ORidBag)oldValue;
            ridBag.setOwner(null);
            ridBag.setRecordAndField(this.recordId, iFieldName);
        } else if (oldValue instanceof ODocument) {
            ((ODocument)oldValue).removeOwner(this);
        }
        if (oldValue instanceof OIdentifiable) {
            this.unTrack((OIdentifiable)oldValue);
        }
        if (iPropertyValue != null) {
            if (iPropertyValue instanceof ODocument) {
                ODocument embeddedDocument;
                if (OType.EMBEDDED.equals((Object)fieldType)) {
                    embeddedDocument = (ODocument)iPropertyValue;
                    ODocumentInternal.addOwner(embeddedDocument, this);
                } else if (OType.LINK.equals((Object)fieldType)) {
                    embeddedDocument = (ODocument)iPropertyValue;
                    ODocumentInternal.removeOwner(embeddedDocument, this);
                }
            }
            if (iPropertyValue instanceof OIdentifiable) {
                this.track((OIdentifiable)iPropertyValue);
            }
            if (iPropertyValue instanceof ORidBag) {
                ridBag = (ORidBag)iPropertyValue;
                ridBag.setOwner(null);
                ridBag.setOwner(this);
                ridBag.setRecordAndField(this.recordId, iFieldName);
            }
        }
        if (fieldType == OType.CUSTOM && !OGlobalConfiguration.DB_CUSTOM_SUPPORT.getValueAsBoolean()) {
            throw new ODatabaseException(String.format("OType CUSTOM used by serializable types, for value  '%s' is not enabled, set `db.custom.support` to true for enable it", iPropertyValue));
        }
        if (oldType != fieldType && oldType != null && (iPropertyValue == null || fieldType != null || oldType != OType.getTypeByValue(iPropertyValue))) {
            entry.type = fieldType;
        }
        entry.disableTracking(this, oldValue);
        entry.value = iPropertyValue;
        if (!entry.exists()) {
            entry.setExists(true);
            ++this.fieldSize;
        }
        entry.enableTracking(this);
        this.setDirty();
        if (!entry.isChanged()) {
            entry.original = oldValue;
            entry.markChanged();
        }
        return this;
    }

    @Override
    public Object removeField(String iFieldName) {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if ("@class".equalsIgnoreCase(iFieldName)) {
            this.setClassName(null);
        } else if ("@rid".equalsIgnoreCase(iFieldName)) {
            this.recordId = new ORecordId();
        }
        ODocumentEntry entry = this.fields.get(iFieldName);
        if (entry == null) {
            return null;
        }
        Object oldValue = entry.value;
        if (entry.exists() && this.trackingChanges) {
            if (entry.original == null) {
                entry.original = entry.value;
            }
            entry.value = null;
            entry.setExists(false);
            entry.markChanged();
        } else {
            this.fields.remove(iFieldName);
        }
        --this.fieldSize;
        entry.disableTracking(this, oldValue);
        if (oldValue instanceof OIdentifiable) {
            this.unTrack((OIdentifiable)oldValue);
        }
        if (oldValue instanceof ORidBag) {
            ((ORidBag)oldValue).setOwner(null);
        }
        this.setDirty();
        return oldValue;
    }

    public ODocument merge(ODocument iOther, boolean iUpdateOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        iOther.checkForLoading();
        iOther.checkForFields(new String[0]);
        if (this.className == null && iOther.getImmutableSchemaClass() != null) {
            this.className = iOther.getImmutableSchemaClass().getName();
        }
        return this.mergeMap(iOther.fields, iUpdateOnlyMode, iMergeSingleItemsOfMultiValueFields);
    }

    public ODocument merge(Map<String, Object> iOther, boolean iUpdateOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        throw new UnsupportedOperationException();
    }

    public String[] getDirtyFields() {
        if (this.fields == null || this.fields.isEmpty()) {
            return EMPTY_STRINGS;
        }
        HashSet<String> dirtyFields = new HashSet<String>();
        for (Map.Entry<String, ODocumentEntry> entry : this.fields.entrySet()) {
            if (!entry.getValue().isChanged() && !entry.getValue().isTrackedModified()) continue;
            dirtyFields.add(entry.getKey());
        }
        return dirtyFields.toArray(new String[dirtyFields.size()]);
    }

    public Object getOriginalValue(String iFieldName) {
        ODocumentEntry entry;
        if (this.fields != null && (entry = this.fields.get(iFieldName)) != null) {
            return entry.original;
        }
        return null;
    }

    public OMultiValueChangeTimeLine<Object, Object> getCollectionTimeLine(String iFieldName) {
        ODocumentEntry entry = this.fields != null ? this.fields.get(iFieldName) : null;
        return entry != null ? entry.getTimeLine() : null;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if (this.fields == null) {
            return OEmptyMapEntryIterator.INSTANCE;
        }
        final Iterator<Map.Entry<String, ODocumentEntry>> iterator = this.fields.entrySet().iterator();
        return new Iterator<Map.Entry<String, Object>>(){
            private Map.Entry<String, ODocumentEntry> current;
            private boolean read = true;

            @Override
            public boolean hasNext() {
                while (iterator.hasNext()) {
                    this.current = (Map.Entry)iterator.next();
                    if (!this.current.getValue().exists() || ODocument.this.propertyAccess != null && !ODocument.this.propertyAccess.isReadable(this.current.getKey())) continue;
                    this.read = false;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, Object> next() {
                if (this.read && !this.hasNext()) {
                    iterator.next();
                }
                Map.Entry<String, Object> toRet = new Map.Entry<String, Object>(){
                    private Map.Entry<String, ODocumentEntry> intern;
                    {
                        this.intern = current;
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Object getValue() {
                        return this.intern.getValue().value;
                    }

                    @Override
                    public String getKey() {
                        return this.intern.getKey();
                    }
                };
                this.read = true;
                return toRet;
            }

            @Override
            public void remove() {
                if (ODocument.this.trackingChanges) {
                    if (this.current.getValue().isChanged()) {
                        this.current.getValue().original = this.current.getValue().value;
                    }
                    this.current.getValue().value = null;
                    this.current.getValue().setExists(false);
                    this.current.getValue().markChanged();
                } else {
                    iterator.remove();
                }
                --ODocument.this.fieldSize;
                this.current.getValue().disableTracking(ODocument.this, this.current.getValue().value);
            }
        };
    }

    @Override
    public boolean containsField(String iFieldName) {
        return this.hasProperty(iFieldName);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        if (propertyName == null) {
            return false;
        }
        this.checkForLoading();
        if (this.checkForFields(propertyName) && (this.propertyAccess == null || this.propertyAccess.isReadable(propertyName))) {
            ODocumentEntry entry = this.fields.get(propertyName);
            return entry != null && entry.exists();
        }
        return false;
    }

    public boolean hasOwners() {
        return this.owner != null && this.owner.get() != null;
    }

    @Override
    public ORecordElement getOwner() {
        if (this.owner == null) {
            return null;
        }
        return (ORecordElement)this.owner.get();
    }

    @Deprecated
    public Iterable<ORecordElement> getOwners() {
        if (this.owner == null && this.owner.get() == null) {
            return Collections.emptyList();
        }
        ArrayList<ORecordElement> result = new ArrayList<ORecordElement>();
        result.add((ORecordElement)this.owner.get());
        return result;
    }

    @Override
    public ORecordAbstract setDirty() {
        ODatabaseDocumentInternal database;
        ORecordElement owner;
        if (this.owner != null && this.owner.get() != null) {
            ((ORecordElement)this.owner.get()).setDirty();
        } else if (!this.isDirty()) {
            this.getDirtyManager().setDirty(this);
        }
        this.checkForFields(new String[0]);
        super.setDirty();
        boolean addToChangedList = false;
        if (!this.isEmbedded()) {
            owner = this;
        } else {
            for (owner = this.getOwner(); owner != null && owner.getOwner() != null; owner = owner.getOwner()) {
            }
        }
        if (owner instanceof ODocument && ((ODocument)owner).isTrackingChanges() && ((ODocument)owner).getIdentity().isPersistent()) {
            addToChangedList = true;
        }
        if (addToChangedList && (database = this.getDatabaseIfDefined()) != null) {
            OBasicTransaction transaction = database.getMicroOrRegularTransaction();
            transaction.addChangedDocument(this);
        }
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.owner != null && this.owner.get() != null) {
            ((ORecordElement)this.owner.get()).setDirtyNoChanged();
        }
        this.getDirtyManager().setDirty(this);
        this.checkForFields(new String[0]);
        super.setDirtyNoChanged();
    }

    @Override
    public ODocument fromStream(byte[] iRecordBuffer) {
        this.removeAllCollectionChangeListeners();
        this.fields = null;
        this.fieldSize = 0;
        this.contentChanged = false;
        this.schema = null;
        this.fetchSchemaIfCan();
        super.fromStream(iRecordBuffer);
        if (!this.lazyLoad) {
            this.checkForLoading();
            this.checkForFields(new String[0]);
        }
        return this;
    }

    public OType fieldType(String iFieldName) {
        this.checkForLoading();
        this.checkForFields(iFieldName);
        ODocumentEntry entry = this.fields.get(iFieldName);
        if (entry != null) {
            if (this.propertyAccess == null || this.propertyAccess.isReadable(iFieldName)) {
                return entry.type;
            }
            return null;
        }
        return null;
    }

    @Override
    public ODocument unload() {
        super.unload();
        this.internalReset();
        return this;
    }

    @Override
    public ODocument clear() {
        super.clear();
        this.internalReset();
        this.owner = null;
        return this;
    }

    @Override
    public ODocument reset() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db != null && db.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot reset documents during a transaction. Create a new one each time");
        }
        super.reset();
        this.className = null;
        this.immutableClazz = null;
        this.immutableSchemaVersion = -1;
        this.internalReset();
        this.owner = null;
        return this;
    }

    public ODocument undo() {
        if (!this.trackingChanges) {
            throw new OConfigurationException("Cannot undo the document because tracking of changes is disabled");
        }
        if (this.fields != null) {
            Iterator<Map.Entry<String, ODocumentEntry>> vals = this.fields.entrySet().iterator();
            while (vals.hasNext()) {
                Map.Entry<String, ODocumentEntry> next = vals.next();
                ODocumentEntry val = next.getValue();
                if (val.isCreated()) {
                    vals.remove();
                    continue;
                }
                val.undo();
            }
            this.fieldSize = this.fields.size();
        }
        return this;
    }

    public ODocument undo(String field) {
        ODocumentEntry value;
        if (!this.trackingChanges) {
            throw new OConfigurationException("Cannot undo the document because tracking of changes is disabled");
        }
        if (this.fields != null && (value = this.fields.get(field)) != null) {
            if (value.isCreated()) {
                this.fields.remove(field);
            } else {
                value.undo();
            }
        }
        return this;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean iLazyLoad) {
        this.lazyLoad = iLazyLoad;
        this.checkForFields(new String[0]);
        if (this.fields != null) {
            for (Map.Entry<String, ODocumentEntry> field : this.fields.entrySet()) {
                if (!(field.getValue().value instanceof ORecordLazyMultiValue)) continue;
                ((ORecordLazyMultiValue)field.getValue().value).setAutoConvertToRecord(false);
            }
        }
    }

    public boolean isTrackingChanges() {
        return this.trackingChanges;
    }

    public ODocument setTrackingChanges(boolean iTrackingChanges) {
        this.trackingChanges = iTrackingChanges;
        if (!iTrackingChanges && this.fields != null) {
            Iterator<Map.Entry<String, ODocumentEntry>> iter = this.fields.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, ODocumentEntry> cur = iter.next();
                if (!cur.getValue().exists()) {
                    iter.remove();
                    continue;
                }
                cur.getValue().clear();
            }
            this.removeAllCollectionChangeListeners();
        } else {
            this.addAllMultiValueChangeListeners();
        }
        return this;
    }

    protected void clearTrackData() {
        if (this.fields != null) {
            for (Map.Entry<String, ODocumentEntry> cur : this.fields.entrySet()) {
                if (cur.getValue().exists()) {
                    cur.getValue().clear();
                    cur.getValue().enableTracking(this);
                    continue;
                }
                cur.getValue().clearNotExists();
            }
        }
    }

    protected void clearTransactionTrackData() {
        if (this.fields != null) {
            Iterator<Map.Entry<String, ODocumentEntry>> iter = this.fields.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, ODocumentEntry> cur = iter.next();
                if (cur.getValue().exists()) {
                    cur.getValue().transactionClear();
                    continue;
                }
                iter.remove();
            }
        }
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public ODocument setOrdered(boolean iOrdered) {
        this.ordered = iOrdered;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this == obj || this.recordId.isValid();
    }

    @Override
    public int hashCode() {
        if (this.recordId.isValid()) {
            return super.hashCode();
        }
        return System.identityHashCode(this);
    }

    @Override
    public int fields() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        return this.fieldSize;
    }

    public boolean isEmpty() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        return this.fields == null || this.fields.isEmpty();
    }

    public ODocument fromJSON(String iSource, String iOptions) {
        return (ODocument)super.fromJSON(iSource, iOptions);
    }

    public ODocument fromJSON(String iSource) {
        return (ODocument)super.fromJSON(iSource);
    }

    public ODocument fromJSON(InputStream iContentResult) throws IOException {
        return (ODocument)super.fromJSON(iContentResult);
    }

    public ODocument fromJSON(String iSource, boolean needReload) {
        return (ODocument)super.fromJSON(iSource, needReload);
    }

    public boolean isEmbedded() {
        return this.owner != null;
    }

    public ODocument setFieldType(String iFieldName, OType iFieldType) {
        ODocumentEntry entry;
        this.checkForLoading();
        this.checkForFields(iFieldName);
        if (iFieldType != null) {
            if (this.fields == null) {
                Map<Object, Object> map = this.fields = this.ordered ? new LinkedHashMap() : new HashMap();
            }
            if (iFieldType == OType.CUSTOM && !OGlobalConfiguration.DB_CUSTOM_SUPPORT.getValueAsBoolean()) {
                throw new ODatabaseException(String.format("OType CUSTOM used by serializable types is not enabled, set `db.custom.support` to true for enable it", new Object[0]));
            }
            ODocumentEntry entry2 = this.getOrCreate(iFieldName);
            if (entry2.type != iFieldType) {
                this.field(iFieldName, this.field(iFieldName), iFieldType);
            }
        } else if (this.fields != null && (entry = this.fields.get(iFieldName)) != null) {
            entry.type = null;
        }
        return this;
    }

    @Override
    public ODocument save() {
        return (ODocument)this.save(null, false);
    }

    @Override
    public ODocument save(String iClusterName) {
        return (ODocument)this.save(iClusterName, false);
    }

    @Override
    public ORecordAbstract save(String iClusterName, boolean forceCreate) {
        return (ORecordAbstract)this.getDatabase().save(this, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, forceCreate, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deserializeFields(String ... iFields) {
        ArrayList<String> additional = null;
        if (this.source == null) {
            return true;
        }
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; ++i) {
                int pos;
                String f = iFields[i];
                if (f == null || f.startsWith("@")) continue;
                int pos1 = f.indexOf(91);
                int pos2 = f.indexOf(46);
                if (pos1 <= -1 && pos2 <= -1) continue;
                int n = pos = pos1 > -1 ? pos1 : pos2;
                if (pos2 > -1 && pos2 < pos) {
                    pos = pos2;
                }
                if (additional == null) {
                    additional = new ArrayList<String>();
                }
                additional.add(f.substring(0, pos));
            }
            if (additional != null && iFields != null) {
                String[] copy = new String[iFields.length + additional.size()];
                System.arraycopy(iFields, 0, copy, 0, iFields.length);
                int next = iFields.length;
                for (String s : additional) {
                    copy[next++] = s;
                }
                iFields = copy;
            }
            if (this.fields != null && !this.fields.isEmpty()) {
                boolean allFound = true;
                for (String f : iFields) {
                    if (f == null || f.startsWith("@") || this.fields.containsKey(f)) continue;
                    allFound = false;
                    break;
                }
                if (allFound) {
                    return true;
                }
            }
        }
        if (this.recordFormat == null) {
            this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
        }
        this.status = ORecordElement.STATUS.UNMARSHALLING;
        try {
            this.recordFormat.fromStream(this.source, this, iFields);
        }
        finally {
            this.status = ORecordElement.STATUS.LOADED;
        }
        if (iFields != null && iFields.length > 0) {
            for (String field : iFields) {
                if (field == null || !field.startsWith("@")) continue;
                return true;
            }
            if (this.fields != null && !this.fields.isEmpty()) {
                for (String f : iFields) {
                    if (f == null || !this.fields.containsKey(f)) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.source != null) {
            this.source = null;
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getFormat("onet_ser_v0");
        byte[] idBuffer = this.recordId.toStream();
        stream.writeInt(-1);
        stream.writeInt(idBuffer.length);
        stream.write(idBuffer);
        stream.writeInt(this.recordVersion);
        byte[] content = serializer.toStream(this);
        stream.writeInt(content.length);
        stream.write(content);
        stream.writeBoolean(this.dirty);
        stream.writeObject(serializer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        int i = stream.readInt();
        int size = i < 0 ? stream.readInt() : i;
        byte[] idBuffer = new byte[size];
        stream.readFully(idBuffer);
        this.recordId.fromStream(idBuffer);
        this.recordVersion = stream.readInt();
        int len = stream.readInt();
        byte[] content = new byte[len];
        stream.readFully(content);
        this.dirty = stream.readBoolean();
        ORecordSerializer serializer = this.recordFormat;
        if (i < 0) {
            String str = (String)stream.readObject();
            serializer = ORecordSerializerFactory.instance().getFormat(str);
        }
        this.status = ORecordElement.STATUS.UNMARSHALLING;
        try {
            serializer.fromStream(content, this, null);
        }
        finally {
            this.status = ORecordElement.STATUS.LOADED;
        }
    }

    public boolean isAllowChainedAccess() {
        return this.allowChainedAccess;
    }

    public ODocument setAllowChainedAccess(boolean allowChainedAccess) {
        this.allowChainedAccess = allowChainedAccess;
        return this;
    }

    @Override
    public void setClassNameIfExists(String iClassName) {
        OClass _clazz;
        this.immutableClazz = null;
        this.immutableSchemaVersion = -1;
        this.className = iClassName;
        if (iClassName == null) {
            return;
        }
        ODatabaseDocumentInternal db = this.getDatabaseIfDefined();
        if (db != null && (_clazz = ((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().getClass(iClassName)) != null) {
            this.className = _clazz.getName();
            this.convertFieldsToClass(_clazz);
        }
    }

    @Override
    public OClass getSchemaClass() {
        if (this.className == null) {
            this.fetchClassName();
        }
        if (this.className == null) {
            return null;
        }
        ODatabaseDocumentInternal databaseRecord = this.getDatabaseIfDefined();
        if (databaseRecord != null) {
            return databaseRecord.getMetadata().getSchema().getClass(this.className);
        }
        return null;
    }

    @Override
    public String getClassName() {
        if (this.className == null) {
            this.fetchClassName();
        }
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        this.immutableClazz = null;
        this.immutableSchemaVersion = -1;
        this.className = className;
        if (className == null) {
            return;
        }
        ODatabaseDocumentInternal db = this.getDatabaseIfDefined();
        if (db != null) {
            OMetadataInternal metadata = (OMetadataInternal)db.getMetadata();
            this.immutableClazz = (OImmutableClass)metadata.getImmutableSchemaSnapshot().getClass(className);
            OClass clazz = this.immutableClazz != null ? this.immutableClazz : metadata.getSchema().getOrCreateClass(className);
            if (clazz != null) {
                this.className = clazz.getName();
                this.convertFieldsToClass(clazz);
            }
        }
    }

    @Override
    public void validate() throws OValidationException {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        this.autoConvertValues();
        ODatabaseDocumentInternal internal = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (internal != null) {
            ODocument.validateFieldsSecurity(internal, this);
        }
        if (internal != null && !internal.isValidationEnabled()) {
            return;
        }
        OImmutableClass immutableSchemaClass = this.getImmutableSchemaClass();
        if (immutableSchemaClass != null) {
            if (immutableSchemaClass.isStrictMode()) {
                for (String f : this.fieldNames()) {
                    if (immutableSchemaClass.getProperty(f) != null) continue;
                    throw new OValidationException("Found additional field '" + (String)f + "'. It cannot be added because the schema class '" + immutableSchemaClass.getName() + "' is defined as STRICT");
                }
            }
            for (OProperty p : immutableSchemaClass.properties()) {
                ODocument.validateField(this, (OImmutableProperty)p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toString(Set<ORecord> inspected) {
        if (inspected.contains(this)) {
            return "<recursion:rid=" + (this.recordId != null ? this.recordId : "null") + ">";
        }
        inspected.add(this);
        boolean saveDirtyStatus = this.dirty;
        boolean oldUpdateContent = this.contentChanged;
        try {
            String clsName;
            StringBuilder buffer = new StringBuilder(128);
            this.checkForFields(new String[0]);
            ODatabaseDocumentInternal db = this.getDatabaseIfDefined();
            if (db != null && !db.isClosed() && (clsName = this.getClassName()) != null) {
                buffer.append(clsName);
            }
            if (this.recordId != null && this.recordId.isValid()) {
                buffer.append(this.recordId);
            }
            boolean first = true;
            for (Map.Entry<String, ODocumentEntry> f : this.fields.entrySet()) {
                if (this.propertyAccess != null && !this.propertyAccess.isReadable(f.getKey())) continue;
                buffer.append(first ? (char)'{' : ',');
                buffer.append(f.getKey());
                buffer.append(':');
                if (f.getValue().value == null) {
                    buffer.append("null");
                } else if (f.getValue().value instanceof Collection || f.getValue().value instanceof Map || f.getValue().value.getClass().isArray()) {
                    buffer.append('[');
                    buffer.append(OMultiValue.getSize(f.getValue().value));
                    buffer.append(']');
                } else if (f.getValue().value instanceof ORecord) {
                    ORecord record = (ORecord)f.getValue().value;
                    if (record.getIdentity().isValid()) {
                        record.getIdentity().toString(buffer);
                    } else if (record instanceof ODocument) {
                        buffer.append(((ODocument)record).toString(inspected));
                    } else {
                        buffer.append(record.toString());
                    }
                } else {
                    buffer.append(f.getValue().value);
                }
                if (!first) continue;
                first = false;
            }
            if (!first) {
                buffer.append('}');
            }
            if (this.recordId != null && this.recordId.isValid()) {
                buffer.append(" v");
                buffer.append(this.recordVersion);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.dirty = saveDirtyStatus;
            this.contentChanged = oldUpdateContent;
        }
    }

    protected ODocument mergeMap(Map<String, ODocumentEntry> iOther, boolean iUpdateOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        this.source = null;
        for (String f : iOther.keySet()) {
            ODocumentEntry docEntry = iOther.get(f);
            if (!docEntry.exists()) continue;
            Object otherValue = docEntry.value;
            ODocumentEntry curValue = this.fields.get(f);
            if (curValue != null && curValue.exists()) {
                Object value = curValue.value;
                if (iMergeSingleItemsOfMultiValueFields) {
                    boolean autoConvert = false;
                    if (otherValue instanceof OAutoConvertToRecord) {
                        autoConvert = ((OAutoConvertToRecord)otherValue).isAutoConvertToRecord();
                        ((OAutoConvertToRecord)otherValue).setAutoConvertToRecord(false);
                    }
                    if (value instanceof Map) {
                        Map map = (Map)value;
                        Map otherMap = (Map)otherValue;
                        for (Map.Entry entry : otherMap.entrySet()) {
                            map.put(entry.getKey(), entry.getValue());
                        }
                        if (!(otherValue instanceof OAutoConvertToRecord)) continue;
                        ((OAutoConvertToRecord)otherValue).setAutoConvertToRecord(autoConvert);
                        continue;
                    }
                    if (OMultiValue.isMultiValue(value) && !(value instanceof ORidBag)) {
                        for (Object item : OMultiValue.getMultiValueIterable(otherValue)) {
                            if (OMultiValue.contains(value, item)) continue;
                            OMultiValue.add(value, item);
                        }
                        if (!(otherValue instanceof OAutoConvertToRecord)) continue;
                        ((OAutoConvertToRecord)otherValue).setAutoConvertToRecord(autoConvert);
                        continue;
                    }
                }
                boolean bagsMerged = false;
                if (value instanceof ORidBag && otherValue instanceof ORidBag) {
                    bagsMerged = ((ORidBag)value).tryMerge((ORidBag)otherValue, iMergeSingleItemsOfMultiValueFields);
                }
                if ((bagsMerged || value == null || value.equals(otherValue)) && (value != null || otherValue == null)) continue;
                this.setProperty(f, otherValue);
                continue;
            }
            this.setProperty(f, otherValue);
        }
        if (!iUpdateOnlyMode) {
            for (String f : this.fieldNames()) {
                if (iOther.containsKey(f) && iOther.get(f).exists()) continue;
                this.removeField(f);
            }
        }
        return this;
    }

    @Override
    protected ORecordAbstract fill(ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty) {
        this.schema = null;
        this.fetchSchemaIfCan();
        return super.fill(iRid, iVersion, iBuffer, iDirty);
    }

    @Override
    protected ORecordAbstract fill(ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty, ODatabaseDocumentInternal db) {
        this.schema = null;
        this.fetchSchemaIfCan(db);
        return super.fill(iRid, iVersion, iBuffer, iDirty, db);
    }

    @Override
    protected void clearSource() {
        super.clearSource();
        this.schema = null;
    }

    protected OGlobalProperty getGlobalPropertyById(int id) {
        OGlobalProperty prop;
        if (this.schema == null) {
            OMetadataInternal metadata = this.getDatabase().getMetadata();
            this.schema = metadata.getImmutableSchemaSnapshot();
        }
        if ((prop = this.schema.getGlobalPropertyById(id)) == null) {
            ODatabaseDocumentInternal db = this.getDatabase();
            if (db == null || db.isClosed()) {
                throw new ODatabaseException("Cannot unmarshall the document because no database is active, use detach for use the document outside the database session scope");
            }
            OMetadataInternal metadata = (OMetadataInternal)db.getMetadata();
            if (metadata.getImmutableSchemaSnapshot() != null) {
                metadata.clearThreadLocalSchemaSnapshot();
            }
            metadata.reload();
            metadata.makeThreadLocalSchemaSnapshot();
            this.schema = metadata.getImmutableSchemaSnapshot();
            prop = this.schema.getGlobalPropertyById(id);
        }
        return prop;
    }

    protected void fillClassIfNeed(String iClassName) {
        if (this.className == null) {
            this.immutableClazz = null;
            this.immutableSchemaVersion = -1;
            this.className = iClassName;
        }
    }

    protected OImmutableClass getImmutableSchemaClass() {
        return this.getImmutableSchemaClass(null);
    }

    protected OImmutableClass getImmutableSchemaClass(ODatabaseDocumentInternal database) {
        if (this.immutableClazz == null) {
            if (this.className == null) {
                this.fetchClassName();
            }
            if (this.className != null) {
                if (database == null) {
                    database = this.getDatabaseIfDefined();
                }
                if (database != null && !database.isClosed()) {
                    OImmutableSchema immutableSchema = database.getMetadata().getImmutableSchemaSnapshot();
                    if (immutableSchema == null) {
                        return null;
                    }
                    this.immutableSchemaVersion = immutableSchema.getVersion();
                    this.immutableClazz = (OImmutableClass)immutableSchema.getClass(this.className);
                }
            }
        }
        return this.immutableClazz;
    }

    protected void rawField(String iFieldName, Object iFieldValue, OType iFieldType) {
        if (this.fields == null) {
            this.fields = this.ordered ? new LinkedHashMap() : new HashMap();
        }
        ODocumentEntry entry = this.getOrCreate(iFieldName);
        entry.disableTracking(this, entry.value);
        entry.value = iFieldValue;
        entry.type = iFieldType;
        entry.enableTracking(this);
        if (iFieldValue instanceof ORidBag) {
            ((ORidBag)iFieldValue).setRecordAndField(this.recordId, iFieldName);
        }
        if (iFieldValue instanceof OIdentifiable && !((OIdentifiable)iFieldValue).getIdentity().isPersistent()) {
            this.track((OIdentifiable)iFieldValue);
        }
    }

    protected ODocumentEntry getOrCreate(String key) {
        ODocumentEntry entry = this.fields.get(key);
        if (entry == null) {
            entry = new ODocumentEntry();
            ++this.fieldSize;
            this.fields.put(key, entry);
        }
        return entry;
    }

    protected boolean rawContainsField(String iFiledName) {
        return this.fields != null && this.fields.containsKey(iFiledName);
    }

    protected void autoConvertValues() {
        OImmutableClass clazz = this.getImmutableSchemaClass();
        if (clazz != null) {
            for (OProperty prop : clazz.properties()) {
                Object value;
                OType type = prop.getType();
                OType linkedType = prop.getLinkedType();
                OClass linkedClass = prop.getLinkedClass();
                if (type == OType.EMBEDDED && linkedClass != null) {
                    this.convertToEmbeddedType(prop);
                    continue;
                }
                ODocumentEntry entry = this.fields.get(prop.getName());
                if (entry == null || !entry.isCreated() && !entry.isChanged() || (value = entry.value) == null) continue;
                try {
                    Object values;
                    OTrackedMap map;
                    if (type == OType.LINKBAG && entry.value != null && !(entry.value instanceof ORidBag) && entry.value instanceof Collection) {
                        ORidBag newValue = new ORidBag();
                        newValue.setRecordAndField(this.recordId, prop.getName());
                        for (Object o : (Collection)entry.value) {
                            if (!(o instanceof OIdentifiable)) {
                                throw new OValidationException("Invalid value in ridbag: " + o);
                            }
                            newValue.add((OIdentifiable)o);
                        }
                        entry.value = newValue;
                    }
                    if (type == OType.LINKMAP && entry.value instanceof Map) {
                        map = (OTrackedMap)entry.value;
                        ORecordLazyMap newMap = new ORecordLazyMap(this);
                        boolean changed = false;
                        for (Map.Entry stringObjectEntry : map.entrySet()) {
                            Object val = stringObjectEntry.getValue();
                            if (OMultiValue.isMultiValue(val) && OMultiValue.getSize(val) == 1) {
                                if ((val = OMultiValue.getFirstValue(val)) instanceof OResult) {
                                    val = ((OResult)val).getIdentity().orElse(null);
                                }
                                changed = true;
                            }
                            newMap.put(stringObjectEntry.getKey(), val);
                        }
                        if (changed) {
                            entry.value = newMap;
                        }
                    }
                    if (linkedType == null) continue;
                    if (type == OType.EMBEDDEDLIST) {
                        OTrackedList<Object> list = new OTrackedList<Object>(this);
                        values = (Collection)value;
                        Iterator iterator = values.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            list.add(OType.convert(e, linkedType.getDefaultJavaType()));
                        }
                        entry.value = list;
                        this.replaceListenerOnAutoconvert(entry, value);
                        continue;
                    }
                    if (type == OType.EMBEDDEDMAP) {
                        map = new OTrackedMap(this);
                        values = (Map)value;
                        for (Map.Entry entry2 : values.entrySet()) {
                            map.put(entry2.getKey(), OType.convert(entry2.getValue(), linkedType.getDefaultJavaType()));
                        }
                        entry.value = map;
                        this.replaceListenerOnAutoconvert(entry, value);
                        continue;
                    }
                    if (type != OType.EMBEDDEDSET) continue;
                    OTrackedSet set = new OTrackedSet(this);
                    values = (Collection)value;
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        set.add(OType.convert(e, linkedType.getDefaultJavaType()));
                    }
                    entry.value = set;
                    this.replaceListenerOnAutoconvert(entry, value);
                }
                catch (Exception e) {
                    throw OException.wrapException(new OValidationException("impossible to convert value of field \"" + prop.getName() + "\""), e);
                }
            }
        }
    }

    private void convertToEmbeddedType(OProperty prop) {
        block10: {
            ODocumentEntry entry = this.fields.get(prop.getName());
            OClass linkedClass = prop.getLinkedClass();
            if (entry == null || linkedClass == null) {
                return;
            }
            if (!entry.isCreated() && !entry.isChanged()) {
                return;
            }
            Object value = entry.value;
            if (value == null) {
                return;
            }
            try {
                if (value instanceof ODocument) {
                    OClass docClass = ((ODocument)value).getSchemaClass();
                    if (docClass == null) {
                        ((ODocument)value).setClass(linkedClass);
                    } else if (!docClass.isSubClassOf(linkedClass)) {
                        throw new OValidationException("impossible to convert value of field \"" + prop.getName() + "\", incompatible with " + linkedClass);
                    }
                    break block10;
                }
                if (value instanceof Map) {
                    entry.disableTracking(this, value);
                    ODocument newValue = new ODocument(linkedClass);
                    newValue.fromMap((Map)value);
                    entry.value = newValue;
                    newValue.addOwner(this);
                    break block10;
                }
                throw new OValidationException("impossible to convert value of field \"" + prop.getName() + "\"");
            }
            catch (Exception e) {
                throw OException.wrapException(new OValidationException("impossible to convert value of field \"" + prop.getName() + "\""), e);
            }
        }
    }

    private void replaceListenerOnAutoconvert(ODocumentEntry entry, Object oldValue) {
        entry.replaceListener(this, oldValue);
    }

    protected byte[] toStream(boolean iOnlyDelta) {
        ORecordElement.STATUS prev = this.status;
        this.status = ORecordElement.STATUS.MARSHALLING;
        try {
            if (this.source == null) {
                this.source = this.recordFormat.toStream(this);
            }
        }
        finally {
            this.status = prev;
        }
        return this.source;
    }

    @Override
    protected byte getRecordType() {
        return 100;
    }

    protected void addOwner(ORecordElement iOwner) {
        if (iOwner == null) {
            return;
        }
        if (this.owner == null && this.dirtyManager != null && this.getIdentity().isNew()) {
            this.dirtyManager.removeNew(this);
        }
        this.owner = new WeakReference<ORecordElement>(iOwner);
    }

    protected void removeOwner(ORecordElement iRecordElement) {
        if (this.owner != null && this.owner.get() == iRecordElement) {
            this.owner = null;
        }
    }

    protected void convertAllMultiValuesToTrackedVersions() {
        if (this.fields == null) {
            return;
        }
        for (Map.Entry<String, ODocumentEntry> fieldEntry : this.fields.entrySet()) {
            OImmutableClass clazz;
            ODocumentEntry entry = fieldEntry.getValue();
            Object fieldValue = entry.value;
            if (fieldValue instanceof ORidBag) {
                if (this.isEmbedded()) {
                    throw new ODatabaseException("RidBag are supported only at document root");
                }
                ((ORidBag)fieldValue).checkAndConvert();
            }
            if (!(fieldValue instanceof Collection) && !(fieldValue instanceof Map) && !(fieldValue instanceof ODocument)) continue;
            if (entry.enableTracking(this)) {
                if (entry.getTimeLine() == null || entry.getTimeLine().getMultiValueChangeEvents().isEmpty()) continue;
                this.checkTimelineTrackable(entry.getTimeLine(), (OTrackedMultiValue)entry.value);
                continue;
            }
            if (fieldValue instanceof ODocument && ((ODocument)fieldValue).isEmbedded()) {
                ((ODocument)fieldValue).convertAllMultiValuesToTrackedVersions();
                continue;
            }
            OType fieldType = entry.type;
            if (fieldType == null && (clazz = this.getImmutableSchemaClass()) != null) {
                OProperty prop = clazz.getProperty(fieldEntry.getKey());
                OType oType = fieldType = prop != null ? prop.getType() : null;
            }
            if (fieldType == null) {
                fieldType = OType.getTypeByValue(fieldValue);
            }
            ORecordElement newValue = null;
            switch (fieldType) {
                case EMBEDDEDLIST: {
                    if (!(fieldValue instanceof List)) break;
                    newValue = new OTrackedList(this);
                    this.fillTrackedCollection((Collection<Object>)((Object)newValue), newValue, (Collection)fieldValue);
                    break;
                }
                case EMBEDDEDSET: {
                    if (!(fieldValue instanceof Set)) break;
                    newValue = new OTrackedSet(this);
                    this.fillTrackedCollection((Collection<Object>)((Object)newValue), newValue, (Collection)fieldValue);
                    break;
                }
                case EMBEDDEDMAP: {
                    if (!(fieldValue instanceof Map)) break;
                    newValue = new OTrackedMap(this);
                    this.fillTrackedMap((Map)((Object)newValue), newValue, (Map)fieldValue);
                    break;
                }
                case LINKLIST: {
                    if (!(fieldValue instanceof List)) break;
                    newValue = new ORecordLazyList(this, (Collection)fieldValue);
                    break;
                }
                case LINKSET: {
                    if (!(fieldValue instanceof Set)) break;
                    newValue = new ORecordLazySet(this, (Collection)fieldValue);
                    break;
                }
                case LINKMAP: {
                    if (!(fieldValue instanceof Map)) break;
                    newValue = new ORecordLazyMap(this, (Map)fieldValue);
                    break;
                }
                case LINKBAG: {
                    if (!(fieldValue instanceof Collection)) break;
                    ORidBag bag = new ORidBag();
                    bag.setOwner(this);
                    bag.setRecordAndField(this.recordId, fieldEntry.getKey());
                    bag.addAll((Collection)fieldValue);
                    newValue = bag;
                    break;
                }
            }
            if (newValue == null) continue;
            entry.enableTracking(this);
            entry.value = newValue;
            if (fieldType == OType.LINKSET || fieldType == OType.LINKLIST) {
                boolean pre = ((OAutoConvertToRecord)((Object)newValue)).isAutoConvertToRecord();
                ((OAutoConvertToRecord)((Object)newValue)).setAutoConvertToRecord(false);
                for (OIdentifiable rec : (Collection)((Object)newValue)) {
                    if (!(rec instanceof ODocument)) continue;
                    ((ODocument)rec).convertAllMultiValuesToTrackedVersions();
                }
                ((OAutoConvertToRecord)((Object)newValue)).setAutoConvertToRecord(pre);
                continue;
            }
            if (fieldType != OType.LINKMAP) continue;
            boolean pre = ((OAutoConvertToRecord)((Object)newValue)).isAutoConvertToRecord();
            ((OAutoConvertToRecord)((Object)newValue)).setAutoConvertToRecord(false);
            for (OIdentifiable rec : ((Map)((Object)newValue)).values()) {
                if (!(rec instanceof ODocument)) continue;
                ((ODocument)rec).convertAllMultiValuesToTrackedVersions();
            }
            ((OAutoConvertToRecord)((Object)newValue)).setAutoConvertToRecord(pre);
        }
    }

    private void checkTimelineTrackable(OMultiValueChangeTimeLine<Object, Object> timeLine, OTrackedMultiValue origin) {
        List<OMultiValueChangeEvent<Object, Object>> events = timeLine.getMultiValueChangeEvents();
        for (OMultiValueChangeEvent<Object, Object> event : events) {
            AbstractCollection newCollection;
            Object value = event.getValue();
            if (event.getChangeType() != OMultiValueChangeEvent.OChangeType.ADD || value instanceof OTrackedMultiValue) continue;
            if (value instanceof List) {
                newCollection = new OTrackedList<Object>(this);
                this.fillTrackedCollection(newCollection, (ORecordElement)((Object)newCollection), (Collection)value);
                origin.replace(event, newCollection);
                continue;
            }
            if (value instanceof Set) {
                newCollection = new OTrackedSet(this);
                this.fillTrackedCollection(newCollection, (ORecordElement)((Object)newCollection), (Collection)value);
                origin.replace(event, newCollection);
                continue;
            }
            if (!(value instanceof Map)) continue;
            OTrackedMap<Object> newMap = new OTrackedMap<Object>(this);
            this.fillTrackedMap(newMap, newMap, (Map)value);
            origin.replace(event, newMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fillTrackedCollection(Collection<Object> dest, ORecordElement parent, Collection<Object> source) {
        for (Object object : source) {
            void var5_5;
            if (object instanceof ODocument) {
                ((ODocument)object).addOwner((ORecordElement)((Object)dest));
                ((ODocument)object).convertAllMultiValuesToTrackedVersions();
                ((ODocument)object).clearTrackData();
            } else if (object instanceof List) {
                OTrackedList<Object> newList = new OTrackedList<Object>(parent);
                this.fillTrackedCollection(newList, newList, (Collection)object);
                OTrackedList<Object> oTrackedList = newList;
            } else if (object instanceof Set) {
                OTrackedSet<Object> newSet = new OTrackedSet<Object>(parent);
                this.fillTrackedCollection(newSet, newSet, (Collection)object);
                OTrackedSet<Object> oTrackedSet = newSet;
            } else if (object instanceof Map) {
                OTrackedMap<Object> newMap = new OTrackedMap<Object>(parent);
                this.fillTrackedMap(newMap, newMap, (Map)object);
                OTrackedMap<Object> oTrackedMap = newMap;
            } else if (object instanceof ORidBag) {
                throw new ODatabaseException("RidBag are supported only at document root");
            }
            dest.add(var5_5);
        }
    }

    private void fillTrackedMap(Map<Object, Object> dest, ORecordElement parent, Map<Object, Object> source) {
        for (Map.Entry<Object, Object> cur : source.entrySet()) {
            Cloneable value = cur.getValue();
            if (value instanceof ODocument) {
                ((ODocument)((Object)value)).convertAllMultiValuesToTrackedVersions();
                ((ODocument)((Object)value)).clearTrackData();
            } else if (cur.getValue() instanceof List) {
                OTrackedList<Object> newList = new OTrackedList<Object>(parent);
                this.fillTrackedCollection(newList, newList, (Collection<Object>)((Object)value));
                value = newList;
            } else if (value instanceof Set) {
                OTrackedSet<Object> newSet = new OTrackedSet<Object>(parent);
                this.fillTrackedCollection(newSet, newSet, (Collection<Object>)((Object)value));
                value = newSet;
            } else if (value instanceof Map) {
                OTrackedMap<Object> newMap = new OTrackedMap<Object>(parent);
                this.fillTrackedMap(newMap, newMap, (Map)((Object)value));
                value = newMap;
            } else if (value instanceof ORidBag) {
                throw new ODatabaseException("RidBag are supported only at document root");
            }
            dest.put(cur.getKey(), value);
        }
    }

    protected void internalReset() {
        this.removeAllCollectionChangeListeners();
        if (this.fields != null) {
            this.fields.clear();
        }
        this.fieldSize = 0;
    }

    protected boolean checkForFields(String ... iFields) {
        if (this.fields == null) {
            Map<Object, Object> map = this.fields = this.ordered ? new LinkedHashMap() : new HashMap();
        }
        if (this.status == ORecordElement.STATUS.LOADED && this.source != null) {
            return this.deserializeFields(iFields);
        }
        return true;
    }

    protected Object accessProperty(String property) {
        if (this.checkForFields(property)) {
            if (this.propertyAccess == null || this.propertyAccess.isReadable(property)) {
                ODocumentEntry entry = this.fields.get(property);
                return entry != null ? entry.value : null;
            }
            return null;
        }
        return null;
    }

    @Override
    protected void setup(ODatabaseDocumentInternal db) {
        super.setup(db);
        if (db != null) {
            this.recordFormat = db.getSerializer();
        }
        if (this.recordFormat == null) {
            this.recordFormat = ODatabaseDocumentTx.getDefaultSerializer();
        }
    }

    protected String checkFieldName(String iFieldName) {
        Character c = OSchemaShared.checkFieldNameIfValid(iFieldName);
        if (c != null) {
            throw new IllegalArgumentException("Invalid field name '" + iFieldName + "'. Character '" + c + "' is invalid");
        }
        return iFieldName;
    }

    protected void setClass(OClass iClass) {
        if (iClass != null && iClass.isAbstract()) {
            throw new OSchemaException("Cannot create a document of the abstract class '" + iClass + "'");
        }
        this.className = iClass == null ? null : iClass.getName();
        this.immutableClazz = null;
        this.immutableSchemaVersion = -1;
        if (iClass != null) {
            this.convertFieldsToClass(iClass);
        }
    }

    protected Set<Map.Entry<String, ODocumentEntry>> getRawEntries() {
        this.checkForFields(new String[0]);
        return this.fields == null ? new HashSet() : this.fields.entrySet();
    }

    protected List<Map.Entry<String, ODocumentEntry>> getFilteredEntries() {
        this.checkForFields(new String[0]);
        if (this.fields == null) {
            return Collections.emptyList();
        }
        if (this.propertyAccess == null) {
            return this.fields.entrySet().stream().filter(x -> ((ODocumentEntry)x.getValue()).exists()).collect(Collectors.toList());
        }
        return this.fields.entrySet().stream().filter(x -> ((ODocumentEntry)x.getValue()).exists() && this.propertyAccess.isReadable((String)x.getKey())).collect(Collectors.toList());
    }

    private void fetchSchemaIfCan() {
        ODatabaseDocumentInternal db;
        if (this.schema == null && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null && !db.isClosed()) {
            OMetadataInternal metadata = db.getMetadata();
            this.schema = metadata.getImmutableSchemaSnapshot();
        }
    }

    private void fetchSchemaIfCan(ODatabaseDocumentInternal db) {
        if (this.schema == null && db != null && !db.isClosed()) {
            OMetadataInternal metadata = db.getMetadata();
            this.schema = metadata.getImmutableSchemaSnapshot();
        }
    }

    private void fetchClassName() {
        ODatabaseDocumentInternal database = this.getDatabaseIfDefinedInternal();
        if (database != null && database.getStorageVersions() != null) {
            if (this.recordId.getClusterId() < 0) {
                this.checkForLoading();
                this.checkForFields("@class");
            } else {
                OClass clazz;
                OImmutableSchema schema = database.getMetadata().getImmutableSchemaSnapshot();
                if (schema != null && (clazz = schema.getClassByClusterId(this.recordId.getClusterId())) != null) {
                    this.className = clazz.getName();
                }
            }
        } else {
            this.checkForLoading();
            this.checkForFields("@class");
        }
    }

    protected void autoConvertFieldsToClass(ODatabaseDocumentInternal database) {
        OClass klazz;
        if (this.className != null && (klazz = database.getMetadata().getImmutableSchemaSnapshot().getClass(this.className)) != null) {
            this.convertFieldsToClass(klazz);
        }
    }

    private void convertFieldsToClass(OClass clazz) {
        for (OProperty prop : clazz.properties()) {
            ODocumentEntry entry;
            ODocumentEntry oDocumentEntry = entry = this.fields != null ? this.fields.get(prop.getName()) : null;
            if (entry != null && entry.exists()) {
                if (entry.type != null && entry.type == prop.getType()) continue;
                boolean preChanged = entry.isChanged();
                boolean preCreated = entry.isCreated();
                this.field(prop.getName(), entry.value, prop.getType());
                if (!this.recordId.isNew()) continue;
                if (preChanged) {
                    entry.markChanged();
                } else {
                    entry.unmarkChanged();
                }
                if (preCreated) {
                    entry.markCreated();
                    continue;
                }
                entry.unmarkCreated();
                continue;
            }
            String defValue = prop.getDefaultValue();
            if (defValue == null || this.containsField(prop.getName())) continue;
            Object curFieldValue = OSQLHelper.parseDefaultValue(this, defValue);
            Object fieldValue = ODocumentHelper.convertField(this, prop.getName(), prop.getType(), null, curFieldValue);
            this.rawField(prop.getName(), fieldValue, prop.getType());
        }
    }

    private OType deriveFieldType(String iFieldName, ODocumentEntry entry, OType[] iFieldType) {
        OProperty prop;
        OType fieldType;
        if (iFieldType != null && iFieldType.length == 1) {
            entry.type = iFieldType[0];
            fieldType = iFieldType[0];
        } else {
            fieldType = null;
        }
        OImmutableClass clazz = this.getImmutableSchemaClass();
        if (clazz != null && (prop = clazz.getProperty(iFieldName)) != null) {
            entry.property = prop;
            fieldType = prop.getType();
            if (fieldType != OType.ANY) {
                entry.type = fieldType;
            }
        }
        return fieldType;
    }

    private void removeAllCollectionChangeListeners() {
        if (this.fields == null) {
            return;
        }
        for (Map.Entry<String, ODocumentEntry> field : this.fields.entrySet()) {
            field.getValue().disableTracking(this, field.getValue().value);
        }
    }

    private void addAllMultiValueChangeListeners() {
        if (this.fields == null) {
            return;
        }
        for (Map.Entry<String, ODocumentEntry> field : this.fields.entrySet()) {
            field.getValue().enableTracking(this);
        }
    }

    protected void checkClass(ODatabaseDocumentInternal database) {
        OImmutableSchema immutableSchema;
        if (this.className == null) {
            this.fetchClassName();
        }
        if ((immutableSchema = database.getMetadata().getImmutableSchemaSnapshot()) == null) {
            return;
        }
        if (this.immutableClazz == null) {
            this.immutableSchemaVersion = immutableSchema.getVersion();
            this.immutableClazz = (OImmutableClass)immutableSchema.getClass(this.className);
        } else if (this.immutableSchemaVersion < immutableSchema.getVersion()) {
            this.immutableSchemaVersion = immutableSchema.getVersion();
            this.immutableClazz = (OImmutableClass)immutableSchema.getClass(this.className);
        }
    }

    @Override
    protected void track(OIdentifiable id) {
        if (this.isTrackingChanges() && id.getIdentity().getClusterId() != -2) {
            super.track(id);
        }
    }

    @Override
    protected void unTrack(OIdentifiable id) {
        if (this.isTrackingChanges() && id.getIdentity().getClusterId() != -2) {
            super.unTrack(id);
        }
    }

    protected OImmutableSchema getImmutableSchema() {
        return this.schema;
    }
}

