/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class ODocumentEntry {
    public Object value;
    public Object original;
    public OType type;
    public OProperty property;
    private boolean changed = false;
    private boolean exists = true;
    private boolean created = false;
    private boolean txChanged = false;
    private boolean txExists = true;
    private boolean txCreated = false;

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
        this.txExists = exists;
    }

    public boolean isCreated() {
        return this.created;
    }

    protected ODocumentEntry clone() {
        ODocumentEntry entry = new ODocumentEntry();
        entry.type = this.type;
        entry.property = this.property;
        entry.value = this.value;
        entry.changed = this.changed;
        entry.created = this.created;
        entry.exists = this.exists;
        entry.txChanged = this.changed;
        entry.txCreated = this.created;
        entry.txExists = this.exists;
        return entry;
    }

    public OMultiValueChangeTimeLine<Object, Object> getTimeLine() {
        if (!this.isChanged() && this.value instanceof OTrackedMultiValue) {
            return ((OTrackedMultiValue)this.value).getTimeLine();
        }
        return null;
    }

    public void clear() {
        this.created = false;
        this.changed = false;
        this.original = null;
        this.removeTimeline();
    }

    public void clearNotExists() {
        this.original = null;
        this.removeTimeline();
    }

    public void removeTimeline() {
        if (!(this.value instanceof OTrackedMultiValue)) {
            return;
        }
        ((OTrackedMultiValue)this.value).disableTracking(null);
    }

    public void replaceListener(ODocument document, Object oldValue) {
        this.enableTracking(document);
    }

    public boolean enableTracking(ODocument document) {
        if (!(this.value instanceof OTrackedMultiValue)) {
            return false;
        }
        ((OTrackedMultiValue)this.value).enableTracking(document);
        return true;
    }

    public void disableTracking(ODocument document, Object fieldValue) {
        if (!(fieldValue instanceof OTrackedMultiValue)) {
            return;
        }
        ((OTrackedMultiValue)fieldValue).disableTracking(document);
    }

    public boolean isTrackedModified() {
        if (this.value instanceof OTrackedMultiValue) {
            return ((OTrackedMultiValue)this.value).isModified();
        }
        if (this.value instanceof ODocument && ((ODocument)this.value).isEmbedded()) {
            return ((ODocument)this.value).isDirty();
        }
        return false;
    }

    public boolean isTxTrackedModified() {
        if (this.value instanceof OTrackedMultiValue) {
            return ((OTrackedMultiValue)this.value).isTransactionModified();
        }
        if (this.value instanceof ODocument && ((ODocument)this.value).isEmbedded()) {
            return ((ODocument)this.value).isDirty();
        }
        return false;
    }

    public void markChanged() {
        this.changed = true;
        this.txChanged = true;
    }

    public void unmarkChanged() {
        this.changed = false;
    }

    public void markCreated() {
        this.created = true;
        this.txCreated = true;
    }

    public void unmarkCreated() {
        this.created = false;
    }

    public void undo() {
        if (this.isChanged()) {
            this.value = this.original;
            this.unmarkChanged();
            this.original = null;
            this.exists = true;
        }
    }

    public void transactionClear() {
        if (this.value instanceof OTrackedMultiValue) {
            ((OTrackedMultiValue)this.value).transactionClear();
        }
        this.txCreated = false;
        this.txChanged = false;
    }

    public boolean isTxChanged() {
        return this.txChanged;
    }

    public boolean isTxCreated() {
        return this.txCreated;
    }

    public boolean isTxExists() {
        return this.txExists;
    }
}

