/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OEdgeIterator;
import com.orientechnologies.orient.core.record.impl.OEdgeToVertexIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OVertexDocument
extends ODocument
implements OVertex {
    private static final String CONNECTION_OUT_PREFIX = "out_";
    private static final String CONNECTION_IN_PREFIX = "in_";

    public OVertexDocument(OClass cl) {
        super(cl);
        if (!this.getSchemaClass().isVertexType()) {
            throw new IllegalArgumentException("" + this.getClassName() + " is not a vertex class");
        }
    }

    public OVertexDocument() {
    }

    public OVertexDocument(ODatabaseSession session) {
        super(session);
    }

    public OVertexDocument(ODatabaseSession session, String klass) {
        super(session, klass);
        if (!this.getSchemaClass().isVertexType()) {
            throw new IllegalArgumentException("" + this.getClassName() + " is not a vertex class");
        }
    }

    public OVertexDocument(String klass) {
        super(klass);
        if (!this.getSchemaClass().isVertexType()) {
            throw new IllegalArgumentException("" + this.getClassName() + " is not a vertex class");
        }
    }

    @Override
    public Iterable<OEdge> getEdges(ODirection direction) {
        String[] fieldNames;
        HashSet<String> prefixes = new HashSet<String>();
        switch (direction) {
            case BOTH: {
                prefixes.add(CONNECTION_IN_PREFIX);
            }
            case OUT: {
                prefixes.add(CONNECTION_OUT_PREFIX);
                break;
            }
            case IN: {
                prefixes.add(CONNECTION_IN_PREFIX);
            }
        }
        HashSet candidateClasses = new HashSet();
        for (String fieldName : fieldNames = this.fieldNames()) {
            prefixes.stream().filter(prefix -> fieldName.startsWith((String)prefix)).forEach(prefix -> {
                if (fieldName.equals(prefix)) {
                    candidateClasses.add("E");
                } else {
                    candidateClasses.add(fieldName.substring(prefix.length()));
                }
            });
        }
        return this.getEdges(direction, candidateClasses.toArray(new String[0]));
    }

    @Override
    public Iterable<OEdge> getEdges(ODirection direction, String ... labels) {
        OMultiCollectionIterator<OEdge> iterable = new OMultiCollectionIterator().setEmbedded(true);
        labels = this.resolveAliases(labels);
        Set<String> fieldNames = null;
        if (labels != null && labels.length > 0 && (fieldNames = this.getEdgeFieldNames(direction, labels)) != null) {
            this.deserializeFields(fieldNames.toArray(new String[0]));
        }
        if (fieldNames == null) {
            fieldNames = this.getPropertyNames();
        }
        for (String fieldName : fieldNames) {
            Object fieldValue;
            OPair<ODirection, String> connection = this.getConnection(direction, fieldName, labels);
            if (connection == null || (fieldValue = this.getProperty(fieldName)) == null) continue;
            if (fieldValue instanceof OIdentifiable) {
                fieldValue = Collections.singleton(fieldValue);
            }
            if (fieldValue instanceof Collection) {
                Collection coll = (Collection)fieldValue;
                if (coll instanceof ORecordLazyMultiValue) {
                    iterable.add(new OEdgeIterator(this, coll, ((ORecordLazyMultiValue)((Object)coll)).rawIterator(), connection, labels, coll.size()));
                    continue;
                }
                iterable.add(new OEdgeIterator(this, coll, coll.iterator(), connection, labels, -1));
                continue;
            }
            if (!(fieldValue instanceof ORidBag)) continue;
            iterable.add(new OEdgeIterator(this, fieldValue, ((ORidBag)fieldValue).rawIterator(), connection, labels, ((ORidBag)fieldValue).size()));
        }
        return iterable;
    }

    private String[] resolveAliases(String[] labels) {
        if (labels == null) {
            return null;
        }
        ODatabaseDocumentInternal db = this.getDatabaseIfDefined();
        if (db == null) {
            return labels;
        }
        OSchema schema = this.getDatabaseIfDefined().getMetadata().getSchema();
        String[] result = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            OClass clazz = schema.getClass(labels[i]);
            result[i] = clazz != null ? clazz.getName() : labels[i];
        }
        return result;
    }

    @Override
    public Iterable<OEdge> getEdges(ODirection direction, OClass ... type) {
        ArrayList<String> types = new ArrayList<String>();
        if (type != null) {
            for (OClass t : type) {
                types.add(t.getName());
            }
        }
        return this.getEdges(direction, types.toArray(new String[0]));
    }

    @Override
    public Iterable<OVertex> getVertices(ODirection direction) {
        return this.getVertices(direction, (String[])null);
    }

    @Override
    public Iterable<OVertex> getVertices(ODirection direction, String ... type) {
        if (direction == ODirection.BOTH) {
            OMultiCollectionIterator<OVertex> result = new OMultiCollectionIterator<OVertex>();
            result.add(this.getVertices(ODirection.OUT, type));
            result.add(this.getVertices(ODirection.IN, type));
            return result;
        }
        Iterable<OEdge> edges = this.getEdges(direction, type);
        return new OEdgeToVertexIterable(edges, direction);
    }

    @Override
    public Iterable<OVertex> getVertices(ODirection direction, OClass ... type) {
        ArrayList<String> types = new ArrayList<String>();
        if (type != null) {
            for (OClass t : type) {
                types.add(t.getName());
            }
        }
        return this.getVertices(direction, types.toArray(new String[0]));
    }

    @Override
    public OEdge addEdge(OVertex to) {
        return this.addEdge(to, "E");
    }

    @Override
    public OEdge addEdge(OVertex to, String type) {
        ODatabaseDocumentInternal db = this.getDatabase();
        return db.newEdge((OVertex)this, to, type == null ? "E" : type);
    }

    @Override
    public OEdge addEdge(OVertex to, OClass type) {
        String className = "E";
        if (type != null) {
            className = type.getName();
        }
        return this.addEdge(to, className);
    }

    @Override
    public ORID moveTo(String iClassName, String iClusterName) {
        return OVertexDocument.moveTo(iClassName, iClusterName, this, this.getDatabase());
    }

    protected static ORID moveTo(String iClassName, String iClusterName, OVertex toMove, ODatabaseSession db) {
        if (toMove == null) {
            throw new ORecordNotFoundException(null, "The vertex is null");
        }
        if (OVertexDocument.checkDeletedInTx(toMove.getIdentity())) {
            throw new ORecordNotFoundException(toMove.getIdentity(), "The vertex " + toMove.getIdentity() + " has been deleted");
        }
        boolean moveTx = !db.getTransaction().isActive();
        try {
            ORID oldIdentity;
            Object oldRecord;
            if (moveTx) {
                db.begin();
            }
            if ((oldRecord = (oldIdentity = toMove.getIdentity().copy()).getRecord()) == null) {
                throw new ORecordNotFoundException(oldIdentity, "The vertex " + oldIdentity + " has been deleted");
            }
            ODocument doc = (ODocument)toMove.getRecord().copy();
            Iterable<OEdge> outEdges = toMove.getEdges(ODirection.OUT);
            Iterable<OEdge> inEdges = toMove.getEdges(ODirection.IN);
            OVertexDocument.copyRidBags(oldRecord, doc);
            OVertexDocument.detachRidbags(oldRecord);
            db.delete(oldRecord);
            if (iClassName != null) {
                doc.setClassName(iClassName);
            }
            doc.setDirty();
            ORecordInternal.setIdentity(doc, new ORecordId());
            db.save(doc, iClusterName);
            ORID newIdentity = doc.getIdentity();
            for (OEdge oe : outEdges) {
                if (oe.isLightweight()) {
                    OVertex inV = oe.getVertex(ODirection.IN);
                    String inFieldName = OVertexDocument.getConnectionFieldName(ODirection.IN, oe.getSchemaType().map(x -> x.getName()).orElse(null), true);
                    OVertexDocument.replaceLinks((ODocument)inV.getRecord(), inFieldName, oldIdentity, newIdentity);
                } else {
                    oe.setProperty("out", newIdentity);
                }
                db.save(oe);
            }
            for (OEdge oe : inEdges) {
                if (oe.isLightweight()) {
                    OVertex outV = oe.getVertex(ODirection.OUT);
                    String outFieldName = OVertexDocument.getConnectionFieldName(ODirection.OUT, oe.getSchemaType().map(x -> x.getName()).orElse(null), true);
                    OVertexDocument.replaceLinks((ODocument)outV.getRecord(), outFieldName, oldIdentity, newIdentity);
                } else {
                    oe.setProperty("in", newIdentity);
                }
                db.save(oe);
            }
            db.save(doc);
            if (moveTx) {
                db.commit();
            }
            return newIdentity;
        }
        catch (RuntimeException ex) {
            if (moveTx) {
                db.rollback();
            }
            throw ex;
        }
    }

    private static void detachRidbags(ORecord oldRecord) {
        ODocument oldDoc = (ODocument)oldRecord;
        for (String field : oldDoc.fieldNames()) {
            Object val;
            if (!field.equalsIgnoreCase("out") && !field.equalsIgnoreCase("in") && !field.startsWith(CONNECTION_OUT_PREFIX) && !field.startsWith(CONNECTION_IN_PREFIX) && !field.startsWith("OUT_") && !field.startsWith("IN_") || !((val = oldDoc.rawField(field)) instanceof ORidBag)) continue;
            oldDoc.removeField(field);
        }
    }

    @Override
    public OVertexDocument delete() {
        OVertexDocument.deleteLinks(this);
        super.delete();
        return this;
    }

    public static void deleteLinks(OVertex delegate) {
        Iterable<OEdge> allEdges = delegate.getEdges(ODirection.BOTH);
        ArrayList<OEdge> items = new ArrayList<OEdge>();
        for (OEdge edge : allEdges) {
            items.add(edge);
        }
        for (OEdge edge : items) {
            edge.delete();
        }
    }

    public static String getConnectionFieldName(ODirection iDirection, String iClassName, boolean useVertexFieldsForEdgeLabels) {
        if (iDirection == null || iDirection == ODirection.BOTH) {
            throw new IllegalArgumentException("Direction not valid");
        }
        if (useVertexFieldsForEdgeLabels) {
            String prefix;
            String string = prefix = iDirection == ODirection.OUT ? CONNECTION_OUT_PREFIX : CONNECTION_IN_PREFIX;
            if (iClassName == null || iClassName.isEmpty() || iClassName.equals("E")) {
                return prefix;
            }
            return prefix + iClassName;
        }
        return iDirection == ODirection.OUT ? "out" : "in";
    }

    protected Set<String> getEdgeFieldNames(ODirection iDirection, String ... iClassNames) {
        if (iClassNames != null && iClassNames.length == 1 && iClassNames[0].equalsIgnoreCase("E")) {
            iClassNames = null;
        }
        HashSet<String> result = new HashSet<String>();
        if (iClassNames == null) {
            return null;
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db == null) {
            return null;
        }
        OSchema schema = db.getMetadata().getSchema();
        HashSet<String> allClassNames = new HashSet<String>();
        for (String className : iClassNames) {
            allClassNames.add(className);
            OClass clazz = schema.getClass(className);
            if (clazz == null) continue;
            allClassNames.add(clazz.getName());
            Collection<OClass> subClasses = clazz.getAllSubclasses();
            for (OClass subClass : subClasses) {
                allClassNames.add(subClass.getName());
            }
        }
        for (String className : allClassNames) {
            switch (iDirection) {
                case OUT: {
                    result.add(CONNECTION_OUT_PREFIX + className);
                    break;
                }
                case IN: {
                    result.add(CONNECTION_IN_PREFIX + className);
                    break;
                }
                case BOTH: {
                    result.add(CONNECTION_OUT_PREFIX + className);
                    result.add(CONNECTION_IN_PREFIX + className);
                }
            }
        }
        return result;
    }

    protected static boolean checkDeletedInTx(ORID id) {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (db == null) {
            return false;
        }
        ORecordOperation oper = db.getTransaction().getRecordEntry(id);
        if (oper == null) {
            return id.isTemporary();
        }
        return oper.type == 2;
    }

    private static void copyRidBags(ORecord oldRecord, ODocument newDoc) {
        ODocument oldDoc = (ODocument)oldRecord;
        for (String field : oldDoc.fieldNames()) {
            ORidBag bag;
            Object val;
            if (!field.equalsIgnoreCase("out") && !field.equalsIgnoreCase("in") && !field.startsWith(CONNECTION_OUT_PREFIX) && !field.startsWith(CONNECTION_IN_PREFIX) && !field.startsWith("OUT_") && !field.startsWith("IN_") || !((val = oldDoc.rawField(field)) instanceof ORidBag) || (bag = (ORidBag)val).isEmbedded()) continue;
            ORidBag newBag = new ORidBag();
            Iterator<OIdentifiable> rawIter = bag.rawIterator();
            while (rawIter.hasNext()) {
                newBag.add(rawIter.next());
            }
            newDoc.field(field, newBag);
        }
    }

    public static void replaceLinks(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, OIdentifiable iNewVertex) {
        Collection col;
        Object fieldValue;
        if (iVertex == null) {
            return;
        }
        Object object = fieldValue = iVertexToRemove != null ? iVertex.field(iFieldName) : iVertex.removeField(iFieldName);
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof OIdentifiable) {
            if (iVertexToRemove != null) {
                if (!fieldValue.equals(iVertexToRemove)) {
                    return;
                }
                iVertex.field(iFieldName, iNewVertex);
            }
        } else if (fieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)fieldValue;
            boolean found = false;
            Iterator<OIdentifiable> it = bag.rawIterator();
            while (it.hasNext()) {
                if (!it.next().equals(iVertexToRemove)) continue;
                found = true;
                it.remove();
            }
            if (found) {
                bag.add(iNewVertex);
            }
        } else if (fieldValue instanceof Collection && (col = (Collection)fieldValue).remove(iVertexToRemove)) {
            col.add(iNewVertex);
        }
        iVertex.save();
    }

    protected OPair<ODirection, String> getConnection(ODirection iDirection, String iFieldName, String ... iClassNames) {
        OClass type;
        if (iClassNames != null && iClassNames.length == 1 && iClassNames[0].equalsIgnoreCase("E")) {
            iClassNames = null;
        }
        OSchema schema = ODatabaseRecordThreadLocal.instance().get().getMetadata().getSchema();
        if ((iDirection == ODirection.OUT || iDirection == ODirection.BOTH) && iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
            if (iClassNames == null || iClassNames.length == 0) {
                return new OPair<ODirection, String>(ODirection.OUT, this.getConnectionClass(ODirection.OUT, iFieldName));
            }
            for (String clsName : iClassNames) {
                if (iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) {
                    return new OPair<ODirection, String>(ODirection.OUT, clsName);
                }
                type = schema.getClass(clsName);
                if (type == null) continue;
                for (OClass subType : type.getAllSubclasses()) {
                    clsName = subType.getName();
                    if (!iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) continue;
                    return new OPair<ODirection, String>(ODirection.OUT, clsName);
                }
            }
        }
        if ((iDirection == ODirection.IN || iDirection == ODirection.BOTH) && iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
            if (iClassNames == null || iClassNames.length == 0) {
                return new OPair<ODirection, String>(ODirection.IN, this.getConnectionClass(ODirection.IN, iFieldName));
            }
            for (String clsName : iClassNames) {
                if (iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) {
                    return new OPair<ODirection, String>(ODirection.IN, clsName);
                }
                type = schema.getClass(clsName);
                if (type == null) continue;
                for (OClass subType : type.getAllSubclasses()) {
                    clsName = subType.getName();
                    if (!iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) continue;
                    return new OPair<ODirection, String>(ODirection.IN, clsName);
                }
            }
        }
        return null;
    }

    private String getConnectionClass(ODirection iDirection, String iFieldName) {
        if (iDirection == ODirection.OUT) {
            if (iFieldName.length() > CONNECTION_OUT_PREFIX.length()) {
                return iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
        } else if (iDirection == ODirection.IN && iFieldName.length() > CONNECTION_IN_PREFIX.length()) {
            return iFieldName.substring(CONNECTION_IN_PREFIX.length());
        }
        return "E";
    }

    @Override
    public OVertexDocument copy() {
        return (OVertexDocument)this.copyTo(new OVertexDocument());
    }
}

