/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OCronExpression;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class OScheduledEvent
extends ODocumentWrapper {
    public static final String CLASS_NAME = "OSchedule";
    public static final String PROP_NAME = "name";
    public static final String PROP_RULE = "rule";
    public static final String PROP_ARGUMENTS = "arguments";
    public static final String PROP_STATUS = "status";
    public static final String PROP_FUNC = "function";
    public static final String PROP_STARTTIME = "starttime";
    public static final String PROP_EXEC_ID = "nextExecId";
    private OFunction function;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private OCronExpression cron;
    private volatile TimerTask timer;
    private final AtomicLong nextExecutionId = new AtomicLong(this.getNextExecutionId());

    public OScheduledEvent(ODocument doc) {
        super(doc);
        this.getFunction();
        try {
            this.cron = new OCronExpression(this.getRule());
        }
        catch (ParseException e) {
            OLogManager.instance().error(this, "Error on compiling cron expression " + this.getRule(), e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        OScheduledEvent oScheduledEvent = this;
        synchronized (oScheduledEvent) {
            TimerTask t = this.timer;
            this.timer = null;
            if (t != null) {
                t.cancel();
            }
        }
    }

    public OFunction getFunction() {
        OFunction fun = this.getFunctionSafe();
        if (fun == null) {
            throw new OCommandScriptException("Function cannot be null");
        }
        return fun;
    }

    public String getRule() {
        return (String)this.document.field(PROP_RULE);
    }

    public String getName() {
        return (String)this.document.field(PROP_NAME);
    }

    public long getNextExecutionId() {
        Long value = (Long)this.document.field(PROP_EXEC_ID);
        return value != null ? value : 0L;
    }

    public String getStatus() {
        return (String)this.document.field(PROP_STATUS);
    }

    public Map<Object, Object> getArguments() {
        return (Map)this.document.field(PROP_ARGUMENTS);
    }

    public Date getStartTime() {
        return (Date)this.document.field(PROP_STARTTIME);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public OScheduledEvent schedule(String database, String user, OrientDBInternal orientDB) {
        if (this.isRunning()) {
            this.interrupt();
        }
        ScheduledTimerTask task = new ScheduledTimerTask(this, database, user, orientDB);
        task.schedule();
        this.timer = task;
        return this;
    }

    @Override
    public String toString() {
        return "OSchedule [name:" + this.getName() + ",rule:" + this.getRule() + ",current status:" + this.getStatus() + ",func:" + this.getFunctionSafe() + ",started:" + this.getStartTime() + "]";
    }

    @Override
    public void fromStream(ODocument iDocument) {
        super.fromStream(iDocument);
        try {
            this.cron.buildExpression(this.getRule());
        }
        catch (ParseException e) {
            OLogManager.instance().error(this, "Error on compiling cron expression " + this.getRule(), e, new Object[0]);
        }
    }

    private void setRunning(boolean running) {
        this.running.set(running);
    }

    private OFunction getFunctionSafe() {
        Object funcDoc;
        if (this.function == null && (funcDoc = this.document.field(PROP_FUNC)) != null) {
            if (funcDoc instanceof OFunction) {
                this.function = (OFunction)funcDoc;
                this.document.field(PROP_FUNC, this.function.getId());
            } else if (funcDoc instanceof ODocument) {
                this.function = new OFunction((ODocument)funcDoc);
            } else if (funcDoc instanceof ORecordId) {
                this.function = new OFunction((ORecordId)funcDoc);
            }
        }
        return this.function;
    }

    private static class ScheduledTimerTask
    extends TimerTask {
        private final OScheduledEvent event;
        private final String database;
        private final String user;
        private final OrientDBInternal orientDB;

        private ScheduledTimerTask(OScheduledEvent event, String database, String user, OrientDBInternal orientDB) {
            this.event = event;
            this.database = database;
            this.user = user;
            this.orientDB = orientDB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule() {
            ScheduledTimerTask scheduledTimerTask = this;
            synchronized (scheduledTimerTask) {
                this.event.nextExecutionId.incrementAndGet();
                Date now = new Date();
                long time = this.event.cron.getNextValidTimeAfter(now).getTime();
                long delay = time - now.getTime();
                this.orientDB.scheduleOnce(this, delay);
            }
        }

        @Override
        public void run() {
            this.orientDB.execute(this.database, this.user, db -> {
                this.runTask(db);
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(ODatabaseSession db) {
            this.event.reload();
            if (this.event.running.get()) {
                OLogManager.instance().error(this, "Error: The scheduled event '" + this.event.getName() + "' is already running", null, new Object[0]);
                return;
            }
            if (this.event.function == null) {
                OLogManager.instance().error(this, "Error: The scheduled event '" + this.event.getName() + "' has no configured function", null, new Object[0]);
                return;
            }
            try {
                this.event.setRunning(true);
                OLogManager.instance().info((Object)this, "Checking for the execution of the scheduled event '%s' executionId=%d...", this.event.getName(), this.event.nextExecutionId.get());
                try {
                    boolean executeEvent = this.executeEvent();
                    if (executeEvent) {
                        OLogManager.instance().info((Object)this, "Executing scheduled event '%s' executionId=%d...", this.event.getName(), this.event.nextExecutionId.get());
                        this.executeEventFunction();
                    }
                }
                finally {
                    this.event.setRunning(false);
                }
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during execution of scheduled function", e, new Object[0]);
            }
            finally {
                if (this.event.timer != null) {
                    this.event.schedule(this.database, this.user, this.orientDB);
                }
            }
        }

        private boolean executeEvent() {
            for (int retry = 0; retry < 10; ++retry) {
                try {
                    if (!this.isEventAlreadyExecuted()) {
                        this.event.document.field(OScheduledEvent.PROP_STATUS, (Object)OScheduler.STATUS.RUNNING);
                        this.event.document.field(OScheduledEvent.PROP_STARTTIME, System.currentTimeMillis());
                        this.event.document.field(OScheduledEvent.PROP_EXEC_ID, this.event.nextExecutionId.get());
                        this.event.document.save();
                        return true;
                    }
                    break;
                }
                catch (ONeedRetryException e) {
                    this.event.document.reload(null, true);
                    if (this.isEventAlreadyExecuted()) break;
                    OLogManager.instance().info((Object)this, "Cannot change the status of the scheduled event '%s' executionId=%d, retry %d", e, this.event.getName(), this.event.nextExecutionId.get(), retry);
                    continue;
                }
                catch (ORecordNotFoundException e) {
                    OLogManager.instance().info((Object)this, "Scheduled event '%s' executionId=%d not found on database, removing event", e, this.event.getName(), this.event.nextExecutionId.get());
                    this.event.interrupt();
                    break;
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error during starting of scheduled event '%s' executionId=%d", e, this.event.getName(), this.event.nextExecutionId.get());
                    this.event.interrupt();
                    break;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeEventFunction() {
            Object result = null;
            try {
                result = this.event.function.execute(this.event.getArguments());
            }
            catch (Throwable throwable) {
                OLogManager.instance().info((Object)this, "Scheduled event '%s' executionId=%d completed with result: %s", this.event.getName(), this.event.nextExecutionId.get(), result);
                for (int retry = 0; retry < 10; ++retry) {
                    try {
                        this.event.document.field(OScheduledEvent.PROP_STATUS, (Object)OScheduler.STATUS.WAITING);
                        this.event.document.save();
                        continue;
                    }
                    catch (ONeedRetryException e) {
                        this.event.document.reload(null, true);
                        continue;
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on saving status for event '%s'", e, this.event.getName());
                    }
                }
                throw throwable;
            }
            OLogManager.instance().info((Object)this, "Scheduled event '%s' executionId=%d completed with result: %s", this.event.getName(), this.event.nextExecutionId.get(), result);
            for (int retry = 0; retry < 10; ++retry) {
                try {
                    this.event.document.field(OScheduledEvent.PROP_STATUS, (Object)OScheduler.STATUS.WAITING);
                    this.event.document.save();
                    continue;
                }
                catch (ONeedRetryException e) {
                    this.event.document.reload(null, true);
                    continue;
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error on saving status for event '%s'", e, this.event.getName());
                }
            }
        }

        private boolean isEventAlreadyExecuted() {
            Object rec = this.event.document.getIdentity().getRecord();
            if (rec == null) {
                return true;
            }
            ODocument updated = (ODocument)rec.reload();
            Long currentExecutionId = (Long)updated.field(OScheduledEvent.PROP_EXEC_ID);
            if (currentExecutionId == null) {
                return false;
            }
            if (currentExecutionId >= this.event.nextExecutionId.get()) {
                OLogManager.instance().info((Object)this, "Scheduled event '%s' with id %d is already running (current id=%d)", this.event.getName(), this.event.nextExecutionId.get(), currentExecutionId);
                return true;
            }
            return false;
        }
    }
}

