/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.security;

import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OAuditingOperation;
import com.orientechnologies.orient.core.security.OInvalidPasswordException;
import java.util.HashMap;
import java.util.Map;

public interface OSecuritySystem {
    public void shutdown();

    public boolean isDefaultAllowed();

    public String authenticate(String var1, String var2);

    public String getAuthenticationHeader(String var1);

    default public Map<String, String> getAuthenticationHeaders(String databaseName) {
        return new HashMap<String, String>();
    }

    public ODocument getConfig();

    public ODocument getComponentConfig(String var1);

    public OUser getSystemUser(String var1, String var2);

    public boolean isAuthorized(String var1, String var2);

    public boolean isEnabled();

    public boolean arePasswordsStored();

    public boolean isSingleSignOnSupported();

    public void log(OAuditingOperation var1, String var2, OSecurityUser var3, String var4);

    public void registerSecurityClass(Class<?> var1);

    public void reload(String var1);

    public void reload(ODocument var1);

    default public void reload(OSecurityUser user, ODocument jsonConfig) {
        this.reload(jsonConfig);
    }

    default public void reload(OSecurityUser user, String jsonConfig) {
        this.reload(jsonConfig);
    }

    public void reloadComponent(OSecurityUser var1, String var2, ODocument var3);

    public void securityRecordChange(String var1, ODocument var2);

    public void unregisterSecurityClass(Class<?> var1);

    public void validatePassword(String var1, String var2) throws OInvalidPasswordException;
}

