/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.security.symmetrickey;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceProperty;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.security.symmetrickey.OSymmetricKey;
import com.orientechnologies.orient.core.security.symmetrickey.OUserSymmetricKeyConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OSymmetricKeySecurity
implements OSecurityInternal {
    private OSecurityInternal delegate;

    public OSymmetricKeySecurity(OSecurityInternal iDelegate) {
        this.delegate = iDelegate;
    }

    @Override
    public OUser authenticate(ODatabaseSession session, String username, String password) {
        if (this.delegate == null) {
            throw new OSecurityAccessException("OSymmetricKeySecurity.authenticate() Delegate is null for username: " + username);
        }
        if (session == null) {
            throw new OSecurityAccessException("OSymmetricKeySecurity.authenticate() Database is null for username: " + username);
        }
        String dbName = session.getName();
        OUser user = this.delegate.getUser(session, username);
        if (user == null) {
            throw new OSecurityAccessException(dbName, "OSymmetricKeySecurity.authenticate() Username or Key is invalid for username: " + username);
        }
        if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
            throw new OSecurityAccessException(dbName, "OSymmetricKeySecurity.authenticate() User '" + username + "' is not active");
        }
        try {
            OUserSymmetricKeyConfig userConfig = new OUserSymmetricKeyConfig(user);
            OSymmetricKey sk = OSymmetricKey.fromConfig(userConfig);
            String decryptedUsername = sk.decryptAsString(password);
            if (OSecurityManager.instance().checkPassword(username, decryptedUsername)) {
                return user;
            }
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityAccessException(dbName, "OSymmetricKeySecurity.authenticate() Exception for session: " + dbName + ", username: " + username + " " + ex.getMessage()), ex);
        }
        throw new OSecurityAccessException(dbName, "OSymmetricKeySecurity.authenticate() Username or Key is invalid for session: " + dbName + ", username: " + username);
    }

    @Override
    public boolean isAllowed(ODatabaseSession session, Set<OIdentifiable> iAllowAll, Set<OIdentifiable> iAllowOperation) {
        return this.delegate.isAllowed(session, iAllowAll, iAllowOperation);
    }

    @Override
    public OIdentifiable allowUser(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperationType, String iUserName) {
        return this.delegate.allowUser(session, iDocument, iOperationType, iUserName);
    }

    @Override
    public OIdentifiable allowRole(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperationType, String iRoleName) {
        return this.delegate.allowRole(session, iDocument, iOperationType, iRoleName);
    }

    @Override
    public OIdentifiable denyUser(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperationType, String iUserName) {
        return this.delegate.denyUser(session, iDocument, iOperationType, iUserName);
    }

    @Override
    public OIdentifiable denyRole(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperationType, String iRoleName) {
        return this.delegate.denyRole(session, iDocument, iOperationType, iRoleName);
    }

    @Override
    public OIdentifiable allowIdentity(ODatabaseSession session, ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        return this.delegate.allowIdentity(session, iDocument, iAllowFieldName, iId);
    }

    @Override
    public OIdentifiable disallowIdentity(ODatabaseSession session, ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        return this.delegate.disallowIdentity(session, iDocument, iAllowFieldName, iId);
    }

    @Override
    public OUser create(ODatabaseSession session) {
        return this.delegate.create(session);
    }

    @Override
    public void load(ODatabaseSession session) {
        this.delegate.load(session);
    }

    @Override
    public OUser authenticate(ODatabaseSession session, OToken authToken) {
        return null;
    }

    @Override
    public OUser getUser(ODatabaseSession session, String iUserName) {
        return this.delegate.getUser(session, iUserName);
    }

    @Override
    public OUser getUser(ODatabaseSession session, ORID iUserId) {
        return this.delegate.getUser(session, iUserId);
    }

    @Override
    public OUser createUser(ODatabaseSession session, String iUserName, String iUserPassword, String ... iRoles) {
        return this.delegate.createUser(session, iUserName, iUserPassword, iRoles);
    }

    @Override
    public OUser createUser(ODatabaseSession session, String iUserName, String iUserPassword, ORole ... iRoles) {
        return this.delegate.createUser(session, iUserName, iUserPassword, iRoles);
    }

    @Override
    public ORole getRole(ODatabaseSession session, String iRoleName) {
        return this.delegate.getRole(session, iRoleName);
    }

    @Override
    public ORole getRole(ODatabaseSession session, OIdentifiable iRole) {
        return this.delegate.getRole(session, iRole);
    }

    @Override
    public ORole createRole(ODatabaseSession session, String iRoleName, OSecurityRole.ALLOW_MODES iAllowMode) {
        return this.delegate.createRole(session, iRoleName, iAllowMode);
    }

    @Override
    public ORole createRole(ODatabaseSession session, String iRoleName, ORole iParent, OSecurityRole.ALLOW_MODES iAllowMode) {
        return this.delegate.createRole(session, iRoleName, iParent, iAllowMode);
    }

    @Override
    public List<ODocument> getAllUsers(ODatabaseSession session) {
        return this.delegate.getAllUsers(session);
    }

    @Override
    public List<ODocument> getAllRoles(ODatabaseSession session) {
        return this.delegate.getAllRoles(session);
    }

    @Override
    public Map<String, OSecurityPolicy> getSecurityPolicies(ODatabaseSession session, OSecurityRole role) {
        return this.delegate.getSecurityPolicies(session, role);
    }

    @Override
    public OSecurityPolicy getSecurityPolicy(ODatabaseSession session, OSecurityRole role, String resource) {
        return this.delegate.getSecurityPolicy(session, role, resource);
    }

    @Override
    public void setSecurityPolicy(ODatabaseSession session, OSecurityRole role, String resource, OSecurityPolicy policy) {
        this.delegate.setSecurityPolicy(session, role, resource, policy);
    }

    @Override
    public OSecurityPolicy createSecurityPolicy(ODatabaseSession session, String name) {
        return this.delegate.createSecurityPolicy(session, name);
    }

    @Override
    public OSecurityPolicy getSecurityPolicy(ODatabaseSession session, String name) {
        return this.delegate.getSecurityPolicy(session, name);
    }

    @Override
    public void saveSecurityPolicy(ODatabaseSession session, OSecurityPolicy policy) {
        this.delegate.saveSecurityPolicy(session, policy);
    }

    @Override
    public void deleteSecurityPolicy(ODatabaseSession session, String name) {
        this.delegate.deleteSecurityPolicy(session, name);
    }

    @Override
    public void removeSecurityPolicy(ODatabaseSession session, ORole role, String resource) {
        this.delegate.removeSecurityPolicy(session, role, resource);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean dropUser(ODatabaseSession session, String iUserName) {
        return this.delegate.dropUser(session, iUserName);
    }

    @Override
    public boolean dropRole(ODatabaseSession session, String iRoleName) {
        return this.delegate.dropRole(session, iRoleName);
    }

    @Override
    public void createClassTrigger(ODatabaseSession session) {
        this.delegate.createClassTrigger(session);
    }

    @Override
    public long getVersion(ODatabaseSession session) {
        return this.delegate.getVersion(session);
    }

    @Override
    public void incrementVersion(ODatabaseSession session) {
        this.delegate.incrementVersion(session);
    }

    @Override
    public Set<String> getFilteredProperties(ODatabaseSession session, ODocument document) {
        return this.delegate.getFilteredProperties(session, document);
    }

    @Override
    public boolean isAllowedWrite(ODatabaseSession session, ODocument document, String propertyName) {
        return this.delegate.isAllowedWrite(session, document, propertyName);
    }

    @Override
    public boolean canCreate(ODatabaseSession session, ORecord record) {
        return this.delegate.canCreate(session, record);
    }

    @Override
    public boolean canRead(ODatabaseSession session, ORecord record) {
        return this.delegate.canRead(session, record);
    }

    @Override
    public boolean canUpdate(ODatabaseSession session, ORecord record) {
        return this.delegate.canUpdate(session, record);
    }

    @Override
    public boolean canDelete(ODatabaseSession session, ORecord record) {
        return this.delegate.canDelete(session, record);
    }

    @Override
    public boolean canExecute(ODatabaseSession session, OFunction function) {
        return this.delegate.canExecute(session, function);
    }

    @Override
    public boolean isReadRestrictedBySecurityPolicy(ODatabaseSession session, String resource) {
        return this.delegate.isReadRestrictedBySecurityPolicy(session, resource);
    }

    @Override
    public Set<OSecurityResourceProperty> getAllFilteredProperties(ODatabaseDocumentInternal database) {
        return this.delegate.getAllFilteredProperties(database);
    }

    @Override
    public void close() {
    }
}

