/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OUTF8Serializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OCompactedLinkSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public final class CompositeKeySerializer
implements OBinarySerializer<OCompositeKey> {
    @Override
    public int getObjectSize(OCompositeKey compositeKey, Object ... hints) {
        OType[] types = (OType[])hints;
        List<Object> keys2 = compositeKey.getKeys();
        int size = 0;
        for (int i = 0; i < keys2.size(); ++i) {
            OType type = types[i];
            Object key = keys2.get(i);
            ++size;
            if (key == null) continue;
            size += CompositeKeySerializer.sizeOfKey(type, key);
        }
        return size + 8;
    }

    private static int sizeOfKey(OType type, Object key) {
        switch (type) {
            case BOOLEAN: 
            case BYTE: {
                return 1;
            }
            case DATE: 
            case DATETIME: 
            case DOUBLE: 
            case LONG: {
                return 8;
            }
            case BINARY: {
                return ((byte[])key).length + 4;
            }
            case DECIMAL: {
                BigDecimal bigDecimal = (BigDecimal)key;
                return 8 + bigDecimal.unscaledValue().toByteArray().length;
            }
            case FLOAT: 
            case INTEGER: {
                return 4;
            }
            case LINK: {
                return OCompactedLinkSerializer.INSTANCE.getObjectSize((ORID)key, new Object[0]);
            }
            case SHORT: {
                return 2;
            }
            case STRING: {
                return OUTF8Serializer.INSTANCE.getObjectSize((String)key, new Object[0]);
            }
        }
        throw new OIndexException("Unsupported key type " + (Object)((Object)type));
    }

    @Override
    public void serialize(OCompositeKey compositeKey, byte[] stream, int startPosition, Object ... hints) {
        ByteBuffer buffer = ByteBuffer.wrap(stream);
        buffer.position(startPosition);
        CompositeKeySerializer.serialize(compositeKey, buffer, (OType[])hints);
    }

    private static void serialize(OCompositeKey compositeKey, ByteBuffer buffer, OType[] types) {
        List<Object> keys2 = compositeKey.getKeys();
        int startPosition = buffer.position();
        buffer.position(startPosition + 4);
        buffer.putInt(types.length);
        for (int i = 0; i < types.length; ++i) {
            OType type = types[i];
            Object key = keys2.get(i);
            if (key == null) {
                buffer.put((byte)(-(type.getId() + 1)));
                continue;
            }
            buffer.put((byte)type.getId());
            CompositeKeySerializer.serializeKeyToByteBuffer(buffer, type, key);
        }
        buffer.putInt(startPosition, buffer.position() - startPosition);
    }

    private static void serializeKeyToByteBuffer(ByteBuffer buffer, OType type, Object key) {
        switch (type) {
            case BINARY: {
                byte[] array = (byte[])key;
                buffer.putInt(array.length);
                buffer.put(array);
                return;
            }
            case BOOLEAN: {
                buffer.put((Boolean)key != false ? (byte)1 : 0);
                return;
            }
            case BYTE: {
                buffer.put((Byte)key);
                return;
            }
            case DATE: 
            case DATETIME: {
                buffer.putLong(((Date)key).getTime());
                return;
            }
            case DECIMAL: {
                BigDecimal decimal = (BigDecimal)key;
                buffer.putInt(decimal.scale());
                byte[] unscaledValue = decimal.unscaledValue().toByteArray();
                buffer.putInt(unscaledValue.length);
                buffer.put(unscaledValue);
                return;
            }
            case DOUBLE: {
                buffer.putLong(Double.doubleToLongBits((Double)key));
                return;
            }
            case FLOAT: {
                buffer.putInt(Float.floatToIntBits(((Float)key).floatValue()));
                return;
            }
            case INTEGER: {
                buffer.putInt((Integer)key);
                return;
            }
            case LINK: {
                OCompactedLinkSerializer.INSTANCE.serializeInByteBufferObject((ORID)key, buffer, new Object[0]);
                return;
            }
            case LONG: {
                buffer.putLong((Long)key);
                return;
            }
            case SHORT: {
                buffer.putShort((Short)key);
                return;
            }
            case STRING: {
                OUTF8Serializer.INSTANCE.serializeInByteBufferObject((String)key, buffer, new Object[0]);
                return;
            }
        }
        throw new OIndexException("Unsupported index type " + (Object)((Object)type));
    }

    @Override
    public OCompositeKey deserialize(byte[] stream, int startPosition) {
        ByteBuffer buffer = ByteBuffer.wrap(stream);
        buffer.position(startPosition);
        return CompositeKeySerializer.deserialize(buffer);
    }

    private static OCompositeKey deserialize(ByteBuffer buffer) {
        buffer.position(buffer.position() + 4);
        int keyLen = buffer.getInt();
        ArrayList<Object> keys2 = new ArrayList<Object>(keyLen);
        for (int i = 0; i < keyLen; ++i) {
            byte typeId = buffer.get();
            if (typeId < 0) {
                keys2.add(null);
                continue;
            }
            OType type = OType.getById(typeId);
            assert (type != null);
            keys2.add(CompositeKeySerializer.deserializeKeyFromByteBuffer(buffer, type));
        }
        return new OCompositeKey(keys2);
    }

    private static Object deserializeKeyFromByteBuffer(ByteBuffer buffer, OType type) {
        switch (type) {
            case BINARY: {
                int len = buffer.getInt();
                byte[] array = new byte[len];
                buffer.get(array);
                return array;
            }
            case BOOLEAN: {
                return buffer.get() > 0;
            }
            case BYTE: {
                return buffer.get();
            }
            case DATE: 
            case DATETIME: {
                return new Date(buffer.getLong());
            }
            case DECIMAL: {
                int scale = buffer.getInt();
                int unscaledValueLen = buffer.getInt();
                byte[] unscaledValue = new byte[unscaledValueLen];
                buffer.get(unscaledValue);
                return new BigDecimal(new BigInteger(unscaledValue), scale);
            }
            case DOUBLE: {
                return Double.longBitsToDouble(buffer.getLong());
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(buffer.getInt()));
            }
            case INTEGER: {
                return buffer.getInt();
            }
            case LINK: {
                return OCompactedLinkSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
            }
            case LONG: {
                return buffer.getLong();
            }
            case SHORT: {
                return buffer.getShort();
            }
            case STRING: {
                return OUTF8Serializer.INSTANCE.deserializeFromByteBufferObject(buffer);
            }
        }
        throw new OIndexException("Unsupported index type " + (Object)((Object)type));
    }

    private static Object deserializeKeyFromByteBuffer(int offset, ByteBuffer buffer, OType type, OWALChanges walChanges) {
        switch (type) {
            case BINARY: {
                int len = walChanges.getIntValue(buffer, offset);
                return walChanges.getBinaryValue(buffer, offset + 4, len);
            }
            case BOOLEAN: {
                return walChanges.getByteValue(buffer, offset) > 0;
            }
            case BYTE: {
                return walChanges.getByteValue(buffer, offset);
            }
            case DATE: 
            case DATETIME: {
                return new Date(walChanges.getLongValue(buffer, offset));
            }
            case DECIMAL: {
                int scale = walChanges.getIntValue(buffer, offset);
                int unscaledValueLen = walChanges.getIntValue(buffer, offset + 4);
                byte[] unscaledValue = walChanges.getBinaryValue(buffer, offset + 8, unscaledValueLen);
                return new BigDecimal(new BigInteger(unscaledValue), scale);
            }
            case DOUBLE: {
                return Double.longBitsToDouble(walChanges.getLongValue(buffer, offset));
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(walChanges.getIntValue(buffer, offset)));
            }
            case INTEGER: {
                return walChanges.getIntValue(buffer, offset);
            }
            case LINK: {
                return OCompactedLinkSerializer.INSTANCE.deserializeFromByteBufferObject(buffer, walChanges, offset);
            }
            case LONG: {
                return walChanges.getLongValue(buffer, offset);
            }
            case SHORT: {
                return walChanges.getShortValue(buffer, offset);
            }
            case STRING: {
                return OUTF8Serializer.INSTANCE.deserializeFromByteBufferObject(buffer, walChanges, offset);
            }
        }
        throw new OIndexException("Unsupported index type " + (Object)((Object)type));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return ((ByteBuffer)ByteBuffer.wrap(stream).position(startPosition)).getInt();
    }

    @Override
    public byte getId() {
        return -1;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return ((ByteBuffer)ByteBuffer.wrap(stream).order(ByteOrder.nativeOrder()).position(startPosition)).getInt();
    }

    @Override
    public void serializeNativeObject(OCompositeKey compositeKey, byte[] stream, int startPosition, Object ... hints) {
        ByteBuffer buffer = (ByteBuffer)ByteBuffer.wrap(stream).order(ByteOrder.nativeOrder()).position(startPosition);
        CompositeKeySerializer.serialize(compositeKey, buffer, (OType[])hints);
    }

    @Override
    public OCompositeKey deserializeNativeObject(byte[] stream, int startPosition) {
        ByteBuffer buffer = (ByteBuffer)ByteBuffer.wrap(stream).order(ByteOrder.nativeOrder()).position(startPosition);
        return CompositeKeySerializer.deserialize(buffer);
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public OCompositeKey preprocess(OCompositeKey value, Object ... hints) {
        if (value == null) {
            return null;
        }
        OType[] types = (OType[])hints;
        List<Object> keys2 = value.getKeys();
        boolean preprocess = false;
        for (int i = 0; i < keys2.size(); ++i) {
            OType type = types[i];
            if (type != OType.DATE && (type != OType.LINK || keys2.get(i) instanceof ORID)) continue;
            preprocess = true;
            break;
        }
        if (!preprocess) {
            return value;
        }
        OCompositeKey compositeKey = new OCompositeKey();
        for (int i = 0; i < keys2.size(); ++i) {
            Object key = keys2.get(i);
            OType type = types[i];
            if (key != null) {
                if (type == OType.DATE) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)key);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    compositeKey.addKey(calendar.getTime());
                    continue;
                }
                if (type == OType.LINK) {
                    compositeKey.addKey(((OIdentifiable)key).getIdentity());
                    continue;
                }
                compositeKey.addKey(key);
                continue;
            }
            compositeKey.addKey(null);
        }
        return compositeKey;
    }

    @Override
    public void serializeInByteBufferObject(OCompositeKey object, ByteBuffer buffer, Object ... hints) {
        CompositeKeySerializer.serialize(object, buffer, (OType[])hints);
    }

    @Override
    public OCompositeKey deserializeFromByteBufferObject(ByteBuffer buffer) {
        return CompositeKeySerializer.deserialize(buffer);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return buffer.getInt();
    }

    @Override
    public OCompositeKey deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        int keyLen = walChanges.getIntValue(buffer, offset += 4);
        offset += 4;
        ArrayList<Object> keys2 = new ArrayList<Object>(keyLen);
        for (int i = 0; i < keyLen; ++i) {
            byte typeId = walChanges.getByteValue(buffer, offset);
            ++offset;
            if (typeId < 0) {
                keys2.add(null);
                continue;
            }
            OType type = OType.getById(typeId);
            assert (type != null);
            Object key = CompositeKeySerializer.deserializeKeyFromByteBuffer(offset, buffer, type, walChanges);
            offset += CompositeKeySerializer.sizeOfKey(type, key);
            keys2.add(key);
        }
        return new OCompositeKey(keys2);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getIntValue(buffer, offset);
    }
}

