/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OUUIDSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEmbedded;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.HelperClasses;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OSerializableWrapper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.ChangeSerializationHelper;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;

public class ODocumentSerializerDelta {
    protected static final byte CREATED = 1;
    protected static final byte REPLACED = 2;
    protected static final byte CHANGED = 3;
    protected static final byte REMOVED = 4;
    public static final byte DELTA_RECORD_TYPE = 10;
    private static ODocumentSerializerDelta INSTANCE = new ODocumentSerializerDelta();

    public static ODocumentSerializerDelta instance() {
        return INSTANCE;
    }

    protected ODocumentSerializerDelta() {
    }

    public byte[] serialize(ODocument document) {
        BytesContainer bytes = new BytesContainer();
        this.serialize(document, bytes);
        return bytes.fitBytes();
    }

    public byte[] serializeDelta(ODocument document) {
        BytesContainer bytes = new BytesContainer();
        this.serializeDelta(bytes, document);
        return bytes.fitBytes();
    }

    protected OClass serializeClass(ODocument document, BytesContainer bytes) {
        OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        String name = null;
        if (clazz != null) {
            name = clazz.getName();
        }
        if (name == null) {
            name = document.getClassName();
        }
        if (name != null) {
            HelperClasses.writeString(bytes, name);
        } else {
            this.writeEmptyString(bytes);
        }
        return clazz;
    }

    private int writeEmptyString(BytesContainer bytes) {
        return OVarIntSerializer.write(bytes, 0L);
    }

    private void serialize(ODocument document, BytesContainer bytes) {
        this.serializeClass(document, bytes);
        OImmutableClass oClass = ODocumentInternal.getImmutableSchemaClass(document);
        Set<Map.Entry<String, ODocumentEntry>> fields = ODocumentInternal.rawEntries(document);
        OVarIntSerializer.write(bytes, (long)document.fields());
        for (Map.Entry<String, ODocumentEntry> entry : fields) {
            ODocumentEntry docEntry = entry.getValue();
            if (!docEntry.exists()) continue;
            HelperClasses.writeString(bytes, entry.getKey());
            Object value = entry.getValue().value;
            if (value != null) {
                OType type = this.getFieldType(entry.getValue());
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the Result binary serializer");
                }
                ODocumentSerializerDelta.writeNullableType(bytes, type);
                this.serializeValue(bytes, value, type, HelperClasses.getLinkedType(oClass, type, entry.getKey()));
                continue;
            }
            ODocumentSerializerDelta.writeNullableType(bytes, null);
        }
    }

    public void deserialize(byte[] content, ODocument toFill) {
        BytesContainer bytesContainer = new BytesContainer(content);
        this.deserialize(toFill, bytesContainer);
    }

    private void deserialize(ODocument document, BytesContainer bytes) {
        String className = HelperClasses.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        int size = OVarIntSerializer.readAsInteger(bytes);
        while (size-- > 0) {
            String fieldName = HelperClasses.readString(bytes);
            OType type = ODocumentSerializerDelta.readNullableType(bytes);
            Object value = type == null ? null : this.deserializeValue(bytes, type, document);
            document.setProperty(fieldName, value, type);
        }
    }

    public void deserializeDelta(byte[] content, ODocument toFill) {
        BytesContainer bytesContainer = new BytesContainer(content);
        this.deserializeDelta(bytesContainer, toFill);
    }

    public void deserializeDelta(BytesContainer bytes, ODocument toFill) {
        String className = HelperClasses.readString(bytes);
        if (className.length() != 0 && toFill != null) {
            ODocumentInternal.fillClassNameIfNeeded(toFill, className);
        }
        long count = OVarIntSerializer.readAsLong(bytes);
        while (count-- > 0L) {
            switch (this.deserializeByte(bytes)) {
                case 1: {
                    this.deserializeFullEntry(bytes, toFill);
                    break;
                }
                case 2: {
                    this.deserializeFullEntry(bytes, toFill);
                    break;
                }
                case 3: {
                    this.deserializeDeltaEntry(bytes, toFill);
                    break;
                }
                case 4: {
                    String property = HelperClasses.readString(bytes);
                    if (toFill == null) break;
                    toFill.removeProperty(property);
                }
            }
        }
    }

    private void deserializeDeltaEntry(BytesContainer bytes, ODocument toFill) {
        String name = HelperClasses.readString(bytes);
        OType type = ODocumentSerializerDelta.readNullableType(bytes);
        Object toUpdate = toFill != null ? toFill.getProperty(name) : null;
        this.deserializeDeltaValue(bytes, type, toUpdate);
    }

    private void deserializeDeltaValue(BytesContainer bytes, OType type, Object toUpdate) {
        switch (type) {
            case EMBEDDEDLIST: {
                this.deserializeDeltaEmbeddedList(bytes, (OTrackedList)toUpdate);
                break;
            }
            case EMBEDDEDSET: {
                this.deserializeDeltaEmbeddedSet(bytes, (OTrackedSet)toUpdate);
                break;
            }
            case EMBEDDEDMAP: {
                this.deserializeDeltaEmbeddedMap(bytes, (OTrackedMap)toUpdate);
                break;
            }
            case EMBEDDED: {
                this.deserializeDelta(bytes, (ODocument)toUpdate);
                break;
            }
            case LINKLIST: {
                this.deserializeDeltaLinkList(bytes, (ORecordLazyList)toUpdate);
                break;
            }
            case LINKSET: {
                this.deserializeDeltaLinkSet(bytes, (ORecordLazySet)toUpdate);
                break;
            }
            case LINKMAP: {
                this.deserializeDeltaLinkMap(bytes, (ORecordLazyMap)toUpdate);
                break;
            }
            case LINKBAG: {
                this.deserializeDeltaLinkBag(bytes, (ORidBag)toUpdate);
                break;
            }
            default: {
                throw new OSerializationException("delta not supported for type:" + (Object)((Object)type));
            }
        }
    }

    private void deserializeDeltaLinkMap(BytesContainer bytes, ORecordLazyMap toUpdate) {
        long rootChanges = OVarIntSerializer.readAsLong(bytes);
        while (rootChanges-- > 0L) {
            byte change = this.deserializeByte(bytes);
            switch (change) {
                case 1: {
                    String key = HelperClasses.readString(bytes);
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.put((Object)key, link);
                    break;
                }
                case 2: {
                    String key = HelperClasses.readString(bytes);
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.put((Object)key, link);
                    break;
                }
                case 4: {
                    String key = HelperClasses.readString(bytes);
                    if (toUpdate == null) break;
                    toUpdate.remove(key);
                    break;
                }
            }
        }
    }

    protected void deserializeDeltaLinkBag(BytesContainer bytes, ORidBag toUpdate) {
        UUID uuid = OUUIDSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
        bytes.skip(16);
        if (toUpdate != null) {
            toUpdate.setTemporaryId(uuid);
        }
        long rootChanges = OVarIntSerializer.readAsLong(bytes);
        while (rootChanges-- > 0L) {
            byte change = this.deserializeByte(bytes);
            switch (change) {
                case 1: {
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.add(link);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.remove(link);
                    break;
                }
            }
        }
    }

    private void deserializeDeltaLinkList(BytesContainer bytes, ORecordLazyList toUpdate) {
        long rootChanges = OVarIntSerializer.readAsLong(bytes);
        while (rootChanges-- > 0L) {
            byte change = this.deserializeByte(bytes);
            switch (change) {
                case 1: {
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.add(link);
                    break;
                }
                case 2: {
                    long position = OVarIntSerializer.readAsLong(bytes);
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.set((int)position, link);
                    break;
                }
                case 4: {
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.remove(link);
                    break;
                }
            }
        }
    }

    private void deserializeDeltaLinkSet(BytesContainer bytes, ORecordLazySet toUpdate) {
        long rootChanges = OVarIntSerializer.readAsLong(bytes);
        while (rootChanges-- > 0L) {
            byte change = this.deserializeByte(bytes);
            switch (change) {
                case 1: {
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.add(link);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.remove(link);
                    break;
                }
            }
        }
    }

    private void deserializeDeltaEmbeddedMap(BytesContainer bytes, OTrackedMap toUpdate) {
        long rootChanges = OVarIntSerializer.readAsLong(bytes);
        while (rootChanges-- > 0L) {
            byte change = this.deserializeByte(bytes);
            switch (change) {
                case 1: {
                    String key = HelperClasses.readString(bytes);
                    OType type = ODocumentSerializerDelta.readNullableType(bytes);
                    Object value = type != null ? this.deserializeValue(bytes, type, toUpdate) : null;
                    if (toUpdate == null) break;
                    toUpdate.put(key, value);
                    break;
                }
                case 2: {
                    String key = HelperClasses.readString(bytes);
                    OType type = ODocumentSerializerDelta.readNullableType(bytes);
                    Object value = type != null ? this.deserializeValue(bytes, type, toUpdate) : null;
                    if (toUpdate == null) break;
                    toUpdate.put(key, value);
                    break;
                }
                case 4: {
                    String key = HelperClasses.readString(bytes);
                    if (toUpdate == null) break;
                    toUpdate.remove(key);
                }
            }
        }
        long nestedChanges = OVarIntSerializer.readAsLong(bytes);
        while (nestedChanges-- > 0L) {
            byte other = this.deserializeByte(bytes);
            assert (other == 3);
            String key = HelperClasses.readString(bytes);
            Object nested = toUpdate != null ? toUpdate.get(key) : null;
            OType type = ODocumentSerializerDelta.readNullableType(bytes);
            this.deserializeDeltaValue(bytes, type, nested);
        }
    }

    private void deserializeDeltaEmbeddedSet(BytesContainer bytes, OTrackedSet toUpdate) {
        long rootChanges = OVarIntSerializer.readAsLong(bytes);
        while (rootChanges-- > 0L) {
            byte change = this.deserializeByte(bytes);
            switch (change) {
                case 1: {
                    OType type = ODocumentSerializerDelta.readNullableType(bytes);
                    Object value = type != null ? this.deserializeValue(bytes, type, toUpdate) : null;
                    if (toUpdate == null) break;
                    toUpdate.add(value);
                    break;
                }
                case 2: {
                    assert (false) : "this can't ever happen";
                }
                case 4: {
                    OType type = ODocumentSerializerDelta.readNullableType(bytes);
                    Object value = type != null ? this.deserializeValue(bytes, type, toUpdate) : null;
                    if (toUpdate == null) break;
                    toUpdate.remove(value);
                }
            }
        }
        long nestedChanges = OVarIntSerializer.readAsLong(bytes);
        while (nestedChanges-- > 0L) {
            Object nested;
            byte other = this.deserializeByte(bytes);
            assert (other == 3);
            long position = OVarIntSerializer.readAsLong(bytes);
            OType type = ODocumentSerializerDelta.readNullableType(bytes);
            if (toUpdate != null) {
                Iterator iter = toUpdate.iterator();
                int i = 0;
                while ((long)i < position) {
                    iter.next();
                    ++i;
                }
                nested = iter.next();
            } else {
                nested = null;
            }
            this.deserializeDeltaValue(bytes, type, nested);
        }
    }

    private void deserializeDeltaEmbeddedList(BytesContainer bytes, OTrackedList toUpdate) {
        long rootChanges = OVarIntSerializer.readAsLong(bytes);
        while (rootChanges-- > 0L) {
            byte change = this.deserializeByte(bytes);
            switch (change) {
                case 1: {
                    OType type = ODocumentSerializerDelta.readNullableType(bytes);
                    Object value = type != null ? this.deserializeValue(bytes, type, toUpdate) : null;
                    if (toUpdate == null) break;
                    toUpdate.add(value);
                    break;
                }
                case 2: {
                    long pos = OVarIntSerializer.readAsLong(bytes);
                    OType type = ODocumentSerializerDelta.readNullableType(bytes);
                    Object value = type != null ? this.deserializeValue(bytes, type, toUpdate) : null;
                    if (toUpdate == null) break;
                    toUpdate.set((int)pos, value);
                    break;
                }
                case 4: {
                    long pos = OVarIntSerializer.readAsLong(bytes);
                    if (toUpdate == null) break;
                    toUpdate.remove((int)pos);
                    break;
                }
            }
        }
        long nestedChanges = OVarIntSerializer.readAsLong(bytes);
        while (nestedChanges-- > 0L) {
            byte other = this.deserializeByte(bytes);
            assert (other == 3);
            long position = OVarIntSerializer.readAsLong(bytes);
            Object nested = toUpdate != null ? toUpdate.get((int)position) : null;
            OType type = ODocumentSerializerDelta.readNullableType(bytes);
            this.deserializeDeltaValue(bytes, type, nested);
        }
    }

    private void deserializeFullEntry(BytesContainer bytes, ODocument toFill) {
        String name = HelperClasses.readString(bytes);
        OType type = ODocumentSerializerDelta.readNullableType(bytes);
        Object value = type != null ? this.deserializeValue(bytes, type, toFill) : null;
        if (toFill != null) {
            toFill.setProperty(name, value, type);
        }
    }

    public void serializeDelta(BytesContainer bytes, ODocument document) {
        this.serializeClass(document, bytes);
        OImmutableClass oClass = ODocumentInternal.getImmutableSchemaClass(document);
        long count = ODocumentInternal.rawEntries(document).stream().filter(e -> {
            ODocumentEntry entry = (ODocumentEntry)e.getValue();
            return entry.isTxCreated() || entry.isTxChanged() || entry.isTxTrackedModified() || !entry.isTxExists();
        }).count();
        Set<Map.Entry<String, ODocumentEntry>> entries = ODocumentInternal.rawEntries(document);
        OVarIntSerializer.write(bytes, count);
        for (Map.Entry<String, ODocumentEntry> entry : entries) {
            ODocumentEntry docEntry = entry.getValue();
            if (!docEntry.isTxExists()) {
                this.serializeByte(bytes, (byte)4);
                HelperClasses.writeString(bytes, entry.getKey());
                continue;
            }
            if (docEntry.isTxCreated()) {
                this.serializeByte(bytes, (byte)1);
                this.serializeFullEntry(bytes, oClass, entry.getKey(), docEntry);
                continue;
            }
            if (docEntry.isTxChanged()) {
                this.serializeByte(bytes, (byte)2);
                this.serializeFullEntry(bytes, oClass, entry.getKey(), docEntry);
                continue;
            }
            if (!docEntry.isTxTrackedModified()) continue;
            this.serializeByte(bytes, (byte)3);
            this.serializeDeltaEntry(bytes, oClass, entry.getKey(), docEntry);
        }
    }

    private void serializeDeltaEntry(BytesContainer bytes, OClass oClass, String name, ODocumentEntry entry) {
        Object value = entry.value;
        assert (value != null);
        OType type = this.getFieldType(entry);
        if (type == null) {
            throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the delta serializer");
        }
        HelperClasses.writeString(bytes, name);
        ODocumentSerializerDelta.writeNullableType(bytes, type);
        this.serializeDeltaValue(bytes, value, type, HelperClasses.getLinkedType(oClass, type, name));
    }

    private void serializeDeltaValue(BytesContainer bytes, Object value, OType type, OType linkedType) {
        switch (type) {
            case EMBEDDEDLIST: {
                this.serializeDeltaEmbeddedList(bytes, (OTrackedList)value);
                break;
            }
            case EMBEDDEDSET: {
                this.serializeDeltaEmbeddedSet(bytes, (OTrackedSet)value);
                break;
            }
            case EMBEDDEDMAP: {
                this.serializeDeltaEmbeddedMap(bytes, (OTrackedMap)value);
                break;
            }
            case EMBEDDED: {
                this.serializeDelta(bytes, (ODocument)value);
                break;
            }
            case LINKLIST: {
                this.serializeDeltaLinkList(bytes, (ORecordLazyList)value);
                break;
            }
            case LINKSET: {
                this.serializeDeltaLinkSet(bytes, (ORecordLazySet)value);
                break;
            }
            case LINKMAP: {
                this.serializeDeltaLinkMap(bytes, (ORecordLazyMap)value);
                break;
            }
            case LINKBAG: {
                this.serializeDeltaLinkBag(bytes, (ORidBag)value);
                break;
            }
            default: {
                throw new OSerializationException("delta not supported for type:" + (Object)((Object)type));
            }
        }
    }

    protected void serializeDeltaLinkBag(BytesContainer bytes, ORidBag value) {
        OSBTreeCollectionManager sbTreeCollectionManager;
        UUID uuid = null;
        ODatabaseDocumentInternal instance = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (instance != null && (sbTreeCollectionManager = instance.getSbTreeCollectionManager()) != null) {
            uuid = sbTreeCollectionManager.listenForChanges(value);
        }
        if (uuid == null) {
            uuid = new UUID(-1L, -1L);
        }
        int uuidPos = bytes.alloc(16);
        OUUIDSerializer.INSTANCE.serialize(uuid, bytes.bytes, uuidPos, new Object[0]);
        OMultiValueChangeTimeLine<OIdentifiable, OIdentifiable> timeline = value.getTransactionTimeLine();
        assert (timeline != null) : "Collection timeline required for serialization of link types";
        OVarIntSerializer.write(bytes, (long)timeline.getMultiValueChangeEvents().size());
        for (OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event : timeline.getMultiValueChangeEvents()) {
            switch (event.getChangeType()) {
                case ADD: {
                    this.serializeByte(bytes, (byte)1);
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, event.getValue());
                    break;
                }
                case UPDATE: {
                    throw new UnsupportedOperationException("update do not happen in sets, it will be like and add");
                }
                case REMOVE: {
                    this.serializeByte(bytes, (byte)4);
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, event.getOldValue());
                }
            }
        }
    }

    private void serializeDeltaLinkSet(BytesContainer bytes, OTrackedMultiValue<OIdentifiable, OIdentifiable> value) {
        OMultiValueChangeTimeLine<OIdentifiable, OIdentifiable> timeline = value.getTransactionTimeLine();
        assert (timeline != null) : "Collection timeline required for link* types serialization";
        OVarIntSerializer.write(bytes, (long)timeline.getMultiValueChangeEvents().size());
        for (OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event : timeline.getMultiValueChangeEvents()) {
            switch (event.getChangeType()) {
                case ADD: {
                    this.serializeByte(bytes, (byte)1);
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, event.getValue());
                    break;
                }
                case UPDATE: {
                    throw new UnsupportedOperationException("update do not happen in sets, it will be like and add");
                }
                case REMOVE: {
                    this.serializeByte(bytes, (byte)4);
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, event.getOldValue());
                }
            }
        }
    }

    private void serializeDeltaLinkList(BytesContainer bytes, ORecordLazyList value) {
        OMultiValueChangeTimeLine timeline = value.getTransactionTimeLine();
        assert (timeline != null) : "Collection timeline required for link* types serialization";
        OVarIntSerializer.write(bytes, (long)timeline.getMultiValueChangeEvents().size());
        for (OMultiValueChangeEvent event : timeline.getMultiValueChangeEvents()) {
            switch (event.getChangeType()) {
                case ADD: {
                    this.serializeByte(bytes, (byte)1);
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, (OIdentifiable)event.getValue());
                    break;
                }
                case UPDATE: {
                    this.serializeByte(bytes, (byte)2);
                    OVarIntSerializer.write(bytes, event.getKey().longValue());
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, (OIdentifiable)event.getValue());
                    break;
                }
                case REMOVE: {
                    this.serializeByte(bytes, (byte)4);
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, (OIdentifiable)event.getOldValue());
                }
            }
        }
    }

    private void serializeDeltaLinkMap(BytesContainer bytes, ORecordLazyMap value) {
        OMultiValueChangeTimeLine timeline = value.getTransactionTimeLine();
        assert (timeline != null) : "Collection timeline required for link* types serialization";
        OVarIntSerializer.write(bytes, (long)timeline.getMultiValueChangeEvents().size());
        for (OMultiValueChangeEvent event : timeline.getMultiValueChangeEvents()) {
            switch (event.getChangeType()) {
                case ADD: {
                    this.serializeByte(bytes, (byte)1);
                    HelperClasses.writeString(bytes, event.getKey().toString());
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, (OIdentifiable)event.getValue());
                    break;
                }
                case UPDATE: {
                    this.serializeByte(bytes, (byte)2);
                    HelperClasses.writeString(bytes, event.getKey().toString());
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, (OIdentifiable)event.getValue());
                    break;
                }
                case REMOVE: {
                    this.serializeByte(bytes, (byte)4);
                    HelperClasses.writeString(bytes, event.getKey().toString());
                }
            }
        }
    }

    private void serializeDeltaEmbeddedMap(BytesContainer bytes, OTrackedMap value) {
        OMultiValueChangeTimeLine timeline = value.getTransactionTimeLine();
        if (timeline != null) {
            OVarIntSerializer.write(bytes, (long)timeline.getMultiValueChangeEvents().size());
            for (OMultiValueChangeEvent event : timeline.getMultiValueChangeEvents()) {
                switch (event.getChangeType()) {
                    case ADD: {
                        OType type;
                        this.serializeByte(bytes, (byte)1);
                        HelperClasses.writeString(bytes, event.getKey().toString());
                        if (event.getValue() != null) {
                            type = OType.getTypeByValue(event.getValue());
                            ODocumentSerializerDelta.writeNullableType(bytes, type);
                            this.serializeValue(bytes, event.getValue(), type, null);
                            break;
                        }
                        ODocumentSerializerDelta.writeNullableType(bytes, null);
                        break;
                    }
                    case UPDATE: {
                        OType type;
                        this.serializeByte(bytes, (byte)2);
                        HelperClasses.writeString(bytes, event.getKey().toString());
                        if (event.getValue() != null) {
                            type = OType.getTypeByValue(event.getValue());
                            ODocumentSerializerDelta.writeNullableType(bytes, type);
                            this.serializeValue(bytes, event.getValue(), type, null);
                            break;
                        }
                        ODocumentSerializerDelta.writeNullableType(bytes, null);
                        break;
                    }
                    case REMOVE: {
                        this.serializeByte(bytes, (byte)4);
                        HelperClasses.writeString(bytes, event.getKey().toString());
                    }
                }
            }
        } else {
            OVarIntSerializer.write(bytes, 0L);
        }
        long count = value.values().stream().filter(v -> v instanceof OTrackedMultiValue && ((OTrackedMultiValue)v).isModified() || v instanceof ODocument && ((ODocument)v).isEmbedded() && ((ODocument)v).isDirty()).count();
        OVarIntSerializer.write(bytes, count);
        for (Map.Entry singleEntry : value.entrySet()) {
            OType type;
            Object singleValue = singleEntry.getValue();
            if (singleValue instanceof OTrackedMultiValue && ((OTrackedMultiValue)singleValue).isModified()) {
                this.serializeByte(bytes, (byte)3);
                HelperClasses.writeString(bytes, singleEntry.getKey().toString());
                type = OType.getTypeByValue(singleValue);
                ODocumentSerializerDelta.writeNullableType(bytes, type);
                this.serializeDeltaValue(bytes, singleValue, type, null);
                continue;
            }
            if (!(singleValue instanceof ODocument) || !((ODocument)singleValue).isEmbedded() || !((ODocument)singleValue).isDirty()) continue;
            this.serializeByte(bytes, (byte)3);
            HelperClasses.writeString(bytes, singleEntry.getKey().toString());
            type = OType.getTypeByValue(singleValue);
            ODocumentSerializerDelta.writeNullableType(bytes, type);
            this.serializeDeltaValue(bytes, singleValue, type, null);
        }
    }

    private void serializeDeltaEmbeddedList(BytesContainer bytes, OTrackedList value) {
        OMultiValueChangeTimeLine timeline = value.getTransactionTimeLine();
        if (timeline != null) {
            OVarIntSerializer.write(bytes, (long)timeline.getMultiValueChangeEvents().size());
            for (OMultiValueChangeEvent event : timeline.getMultiValueChangeEvents()) {
                switch (event.getChangeType()) {
                    case ADD: {
                        OType type;
                        this.serializeByte(bytes, (byte)1);
                        if (event.getValue() != null) {
                            type = OType.getTypeByValue(event.getValue());
                            ODocumentSerializerDelta.writeNullableType(bytes, type);
                            this.serializeValue(bytes, event.getValue(), type, null);
                            break;
                        }
                        ODocumentSerializerDelta.writeNullableType(bytes, null);
                        break;
                    }
                    case UPDATE: {
                        OType type;
                        this.serializeByte(bytes, (byte)2);
                        OVarIntSerializer.write(bytes, event.getKey().longValue());
                        if (event.getValue() != null) {
                            type = OType.getTypeByValue(event.getValue());
                            ODocumentSerializerDelta.writeNullableType(bytes, type);
                            this.serializeValue(bytes, event.getValue(), type, null);
                            break;
                        }
                        ODocumentSerializerDelta.writeNullableType(bytes, null);
                        break;
                    }
                    case REMOVE: {
                        this.serializeByte(bytes, (byte)4);
                        OVarIntSerializer.write(bytes, event.getKey().longValue());
                    }
                }
            }
        } else {
            OVarIntSerializer.write(bytes, 0L);
        }
        long count = value.stream().filter(v -> v instanceof OTrackedMultiValue && ((OTrackedMultiValue)v).isModified() || v instanceof ODocument && ((ODocument)v).isEmbedded() && ((ODocument)v).isDirty()).count();
        OVarIntSerializer.write(bytes, count);
        for (int i = 0; i < value.size(); ++i) {
            OType type;
            Object singleValue = value.get(i);
            if (singleValue instanceof OTrackedMultiValue && ((OTrackedMultiValue)singleValue).isModified()) {
                this.serializeByte(bytes, (byte)3);
                OVarIntSerializer.write(bytes, (long)i);
                type = OType.getTypeByValue(singleValue);
                ODocumentSerializerDelta.writeNullableType(bytes, type);
                this.serializeDeltaValue(bytes, singleValue, type, null);
                continue;
            }
            if (!(singleValue instanceof ODocument) || !((ODocument)singleValue).isEmbedded() || !((ODocument)singleValue).isDirty()) continue;
            this.serializeByte(bytes, (byte)3);
            OVarIntSerializer.write(bytes, (long)i);
            type = OType.getTypeByValue(singleValue);
            ODocumentSerializerDelta.writeNullableType(bytes, type);
            this.serializeDeltaValue(bytes, singleValue, type, null);
        }
    }

    private void serializeDeltaEmbeddedSet(BytesContainer bytes, OTrackedSet value) {
        OMultiValueChangeTimeLine timeline = value.getTransactionTimeLine();
        if (timeline != null) {
            OVarIntSerializer.write(bytes, (long)timeline.getMultiValueChangeEvents().size());
            for (OMultiValueChangeEvent event : timeline.getMultiValueChangeEvents()) {
                switch (event.getChangeType()) {
                    case ADD: {
                        OType type;
                        this.serializeByte(bytes, (byte)1);
                        if (event.getValue() != null) {
                            type = OType.getTypeByValue(event.getValue());
                            ODocumentSerializerDelta.writeNullableType(bytes, type);
                            this.serializeValue(bytes, event.getValue(), type, null);
                            break;
                        }
                        ODocumentSerializerDelta.writeNullableType(bytes, null);
                        break;
                    }
                    case UPDATE: {
                        throw new UnsupportedOperationException("update do not happen in sets, it will be like and add");
                    }
                    case REMOVE: {
                        OType type;
                        this.serializeByte(bytes, (byte)4);
                        if (event.getOldValue() != null) {
                            type = OType.getTypeByValue(event.getOldValue());
                            ODocumentSerializerDelta.writeNullableType(bytes, type);
                            this.serializeValue(bytes, event.getOldValue(), type, null);
                            break;
                        }
                        ODocumentSerializerDelta.writeNullableType(bytes, null);
                    }
                }
            }
        } else {
            OVarIntSerializer.write(bytes, 0L);
        }
        long count = value.stream().filter(v -> v instanceof OTrackedMultiValue && ((OTrackedMultiValue)v).isModified() || v instanceof ODocument && ((ODocument)v).isEmbedded() && ((ODocument)v).isDirty()).count();
        OVarIntSerializer.write(bytes, count);
        int i = 0;
        for (Object singleValue : value) {
            OType type;
            if (singleValue instanceof OTrackedMultiValue && ((OTrackedMultiValue)singleValue).isModified()) {
                this.serializeByte(bytes, (byte)3);
                OVarIntSerializer.write(bytes, (long)i);
                type = OType.getTypeByValue(singleValue);
                ODocumentSerializerDelta.writeNullableType(bytes, type);
                this.serializeDeltaValue(bytes, singleValue, type, null);
            } else if (singleValue instanceof ODocument && ((ODocument)singleValue).isEmbedded() && ((ODocument)singleValue).isDirty()) {
                this.serializeByte(bytes, (byte)3);
                OVarIntSerializer.write(bytes, (long)i);
                type = OType.getTypeByValue(singleValue);
                ODocumentSerializerDelta.writeNullableType(bytes, type);
                this.serializeDeltaValue(bytes, singleValue, type, null);
            }
            ++i;
        }
    }

    protected OType getFieldType(ODocumentEntry entry) {
        OProperty prop;
        OType type = entry.type;
        if (type == null && (prop = entry.property) != null) {
            type = prop.getType();
        }
        if (type == null || OType.ANY == type) {
            type = OType.getTypeByValue(entry.value);
        }
        return type;
    }

    private void serializeFullEntry(BytesContainer bytes, OClass oClass, String name, ODocumentEntry entry) {
        Object value = entry.value;
        if (value != null) {
            OType type = this.getFieldType(entry);
            if (type == null) {
                throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the delta serializer");
            }
            HelperClasses.writeString(bytes, name);
            ODocumentSerializerDelta.writeNullableType(bytes, type);
            this.serializeValue(bytes, value, type, HelperClasses.getLinkedType(oClass, type, name));
        } else {
            HelperClasses.writeString(bytes, name);
            ODocumentSerializerDelta.writeNullableType(bytes, null);
        }
    }

    protected byte deserializeByte(BytesContainer bytes) {
        int pos = bytes.offset;
        bytes.skip(1);
        return bytes.bytes[pos];
    }

    protected void serializeByte(BytesContainer bytes, byte value) {
        int pointer = bytes.alloc(1);
        bytes.bytes[pointer] = value;
    }

    public void serializeValue(BytesContainer bytes, Object value, OType type, OType linkedType) {
        int pointer = 0;
        switch (type) {
            case INTEGER: 
            case LONG: 
            case SHORT: {
                OVarIntSerializer.write(bytes, ((Number)value).longValue());
                break;
            }
            case STRING: {
                HelperClasses.writeString(bytes, value.toString());
                break;
            }
            case DOUBLE: {
                long dg = Double.doubleToLongBits((Double)value);
                pointer = bytes.alloc(8);
                OLongSerializer.INSTANCE.serializeLiteral(dg, bytes.bytes, pointer);
                break;
            }
            case FLOAT: {
                int fg = Float.floatToIntBits(((Float)value).floatValue());
                pointer = bytes.alloc(4);
                OIntegerSerializer.INSTANCE.serializeLiteral(fg, bytes.bytes, pointer);
                break;
            }
            case BYTE: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Byte)value;
                break;
            }
            case BOOLEAN: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Boolean)value != false ? (byte)1 : 0;
                break;
            }
            case DATETIME: {
                if (value instanceof Long) {
                    OVarIntSerializer.write(bytes, (long)((Long)value));
                    break;
                }
                OVarIntSerializer.write(bytes, ((Date)value).getTime());
                break;
            }
            case DATE: {
                long dateValue = value instanceof Long ? ((Long)value).longValue() : ((Date)value).getTime();
                dateValue = HelperClasses.convertDayToTimezone(ODateHelper.getDatabaseTimeZone(), TimeZone.getTimeZone("GMT"), dateValue);
                OVarIntSerializer.write(bytes, dateValue / 86400000L);
                break;
            }
            case EMBEDDED: {
                if (value instanceof ODocumentSerializable) {
                    ODocument cur = ((ODocumentSerializable)value).toDocument();
                    cur.field("__orientdb_serilized_class__ ", value.getClass().getName());
                    this.serialize(cur, bytes);
                    break;
                }
                this.serialize((ODocument)value, bytes);
                break;
            }
            case EMBEDDEDLIST: 
            case EMBEDDEDSET: {
                if (value.getClass().isArray()) {
                    this.writeEmbeddedCollection(bytes, Arrays.asList(OMultiValue.array(value)), linkedType);
                    break;
                }
                this.writeEmbeddedCollection(bytes, (Collection)value, linkedType);
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = (BigDecimal)value;
                pointer = bytes.alloc(ODecimalSerializer.INSTANCE.getObjectSize(decimalValue, new Object[0]));
                ODecimalSerializer.INSTANCE.serialize(decimalValue, bytes.bytes, pointer, new Object[0]);
                break;
            }
            case BINARY: {
                pointer = HelperClasses.writeBinary(bytes, (byte[])value);
                break;
            }
            case LINKLIST: 
            case LINKSET: {
                Collection ridCollection = (Collection)value;
                this.writeLinkCollection(bytes, ridCollection);
                break;
            }
            case LINK: {
                if (!(value instanceof OIdentifiable)) {
                    throw new OValidationException("Value '" + value + "' is not a OIdentifiable");
                }
                ODocumentSerializerDelta.writeOptimizedLink(bytes, (OIdentifiable)value);
                break;
            }
            case LINKMAP: {
                this.writeLinkMap(bytes, (Map)value);
                break;
            }
            case EMBEDDEDMAP: {
                this.writeEmbeddedMap(bytes, (Map)value);
                break;
            }
            case LINKBAG: {
                this.writeRidBag(bytes, (ORidBag)value);
                break;
            }
            case CUSTOM: {
                if (!(value instanceof OSerializableStream)) {
                    value = new OSerializableWrapper((Serializable)value);
                }
                HelperClasses.writeString(bytes, value.getClass().getName());
                HelperClasses.writeBinary(bytes, ((OSerializableStream)value).toStream());
                break;
            }
            case TRANSIENT: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLinkCollection(BytesContainer bytes, Collection<OIdentifiable> value) {
        boolean disabledAutoConversion;
        int pos = OVarIntSerializer.write(bytes, (long)value.size());
        boolean bl = disabledAutoConversion = value instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)value)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(false);
        }
        try {
            for (OIdentifiable itemValue : value) {
                if (itemValue == null) {
                    HelperClasses.writeNullLink(bytes);
                    continue;
                }
                ODocumentSerializerDelta.writeOptimizedLink(bytes, itemValue);
            }
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(true);
            }
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLinkMap(BytesContainer bytes, Map<Object, OIdentifiable> map) {
        boolean disabledAutoConversion;
        boolean bl = disabledAutoConversion = map instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)map)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(false);
        }
        try {
            int fullPos = OVarIntSerializer.write(bytes, (long)map.size());
            for (Map.Entry<Object, OIdentifiable> entry : map.entrySet()) {
                OType type = OType.STRING;
                HelperClasses.writeOType(bytes, bytes.alloc(1), type);
                HelperClasses.writeString(bytes, entry.getKey().toString());
                if (entry.getValue() == null) {
                    HelperClasses.writeNullLink(bytes);
                    continue;
                }
                ODocumentSerializerDelta.writeOptimizedLink(bytes, entry.getValue());
            }
            int n = fullPos;
            return n;
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(true);
            }
        }
    }

    private int writeEmbeddedCollection(BytesContainer bytes, Collection<?> value, OType linkedType) {
        int pos = OVarIntSerializer.write(bytes, (long)value.size());
        for (Object itemValue : value) {
            if (itemValue == null) {
                ODocumentSerializerDelta.writeNullableType(bytes, null);
                continue;
            }
            OType type = linkedType == null ? HelperClasses.getTypeFromValueEmbedded(itemValue) : linkedType;
            if (type != null) {
                ODocumentSerializerDelta.writeNullableType(bytes, type);
                this.serializeValue(bytes, itemValue, type, null);
                continue;
            }
            throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
        }
        return pos;
    }

    private int writeEmbeddedMap(BytesContainer bytes, Map<Object, Object> map) {
        int fullPos = OVarIntSerializer.write(bytes, (long)map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            HelperClasses.writeString(bytes, entry.getKey().toString());
            Object value = entry.getValue();
            if (value != null) {
                OType type = HelperClasses.getTypeFromValueEmbedded(value);
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the Result binary serializer");
                }
                ODocumentSerializerDelta.writeNullableType(bytes, type);
                this.serializeValue(bytes, value, type, null);
                continue;
            }
            ODocumentSerializerDelta.writeNullableType(bytes, null);
        }
        return fullPos;
    }

    public Object deserializeValue(BytesContainer bytes, OType type, ORecordElement owner) {
        Object value = null;
        switch (type) {
            case INTEGER: {
                value = OVarIntSerializer.readAsInteger(bytes);
                break;
            }
            case LONG: {
                value = OVarIntSerializer.readAsLong(bytes);
                break;
            }
            case SHORT: {
                value = OVarIntSerializer.readAsShort(bytes);
                break;
            }
            case STRING: {
                value = HelperClasses.readString(bytes);
                break;
            }
            case DOUBLE: {
                value = Double.longBitsToDouble(HelperClasses.readLong(bytes));
                break;
            }
            case FLOAT: {
                value = Float.valueOf(Float.intBitsToFloat(HelperClasses.readInteger(bytes)));
                break;
            }
            case BYTE: {
                value = HelperClasses.readByte(bytes);
                break;
            }
            case BOOLEAN: {
                value = HelperClasses.readByte(bytes) == 1;
                break;
            }
            case DATETIME: {
                value = new Date(OVarIntSerializer.readAsLong(bytes));
                break;
            }
            case DATE: {
                long savedTime = OVarIntSerializer.readAsLong(bytes) * 86400000L;
                savedTime = HelperClasses.convertDayToTimezone(TimeZone.getTimeZone("GMT"), ODateHelper.getDatabaseTimeZone(), savedTime);
                value = new Date(savedTime);
                break;
            }
            case EMBEDDED: {
                value = new ODocumentEmbedded();
                this.deserialize((ODocument)value, bytes);
                if (((ODocument)value).containsField("__orientdb_serilized_class__ ")) {
                    String className = (String)((ODocument)value).field("__orientdb_serilized_class__ ");
                    try {
                        Class<?> clazz = Class.forName(className);
                        ODocumentSerializable newValue = (ODocumentSerializable)clazz.newInstance();
                        newValue.fromDocument((ODocument)value);
                        value = newValue;
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ODocumentInternal.addOwner((ODocument)value, owner);
                break;
            }
            case EMBEDDEDSET: {
                value = this.readEmbeddedSet(bytes, owner);
                break;
            }
            case EMBEDDEDLIST: {
                value = this.readEmbeddedList(bytes, owner);
                break;
            }
            case LINKSET: {
                value = this.readLinkSet(bytes, owner);
                break;
            }
            case LINKLIST: {
                value = this.readLinkList(bytes, owner);
                break;
            }
            case BINARY: {
                value = HelperClasses.readBinary(bytes);
                break;
            }
            case LINK: {
                value = ODocumentSerializerDelta.readOptimizedLink(bytes);
                break;
            }
            case LINKMAP: {
                value = this.readLinkMap(bytes, owner);
                break;
            }
            case EMBEDDEDMAP: {
                value = this.readEmbeddedMap(bytes, owner);
                break;
            }
            case DECIMAL: {
                value = ODecimalSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
                bytes.skip(ODecimalSerializer.INSTANCE.getObjectSize(bytes.bytes, bytes.offset));
                break;
            }
            case LINKBAG: {
                ORidBag bag = this.readRidBag(bytes);
                bag.setOwner(owner);
                value = bag;
                break;
            }
            case TRANSIENT: {
                break;
            }
            case CUSTOM: {
                try {
                    String className = HelperClasses.readString(bytes);
                    Class<?> clazz = Class.forName(className);
                    OSerializableStream stream = (OSerializableStream)clazz.newInstance();
                    stream.fromStream(HelperClasses.readBinary(bytes));
                    if (stream instanceof OSerializableWrapper) {
                        value = ((OSerializableWrapper)stream).getSerializable();
                        break;
                    }
                    value = stream;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return value;
    }

    private Collection<?> readEmbeddedList(BytesContainer bytes, ORecordElement owner) {
        OTrackedList<Object> found = new OTrackedList<Object>(owner);
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            OType itemType = ODocumentSerializerDelta.readNullableType(bytes);
            if (itemType == null) {
                found.addInternal((Object)null);
                continue;
            }
            found.addInternal(this.deserializeValue(bytes, itemType, found));
        }
        return found;
    }

    private Collection<?> readEmbeddedSet(BytesContainer bytes, ORecordElement owner) {
        OTrackedSet<Object> found = new OTrackedSet<Object>(owner);
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            OType itemType = ODocumentSerializerDelta.readNullableType(bytes);
            if (itemType == null) {
                found.addInternal((Object)null);
                continue;
            }
            found.addInternal(this.deserializeValue(bytes, itemType, found));
        }
        return found;
    }

    private Collection<OIdentifiable> readLinkList(BytesContainer bytes, ORecordElement owner) {
        ORecordLazyList found = new ORecordLazyList(owner);
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            ORecordId id = ODocumentSerializerDelta.readOptimizedLink(bytes);
            if (((Object)id).equals(HelperClasses.NULL_RECORD_ID)) {
                found.addInternal(null);
                continue;
            }
            found.addInternal(id);
        }
        return found;
    }

    private Collection<OIdentifiable> readLinkSet(BytesContainer bytes, ORecordElement owner) {
        ORecordLazySet found = new ORecordLazySet(owner);
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            ORecordId id = ODocumentSerializerDelta.readOptimizedLink(bytes);
            if (((Object)id).equals(HelperClasses.NULL_RECORD_ID)) {
                found.addInternal(null);
                continue;
            }
            found.addInternal(id);
        }
        return found;
    }

    private Map<Object, OIdentifiable> readLinkMap(BytesContainer bytes, ORecordElement owner) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        ORecordLazyMap result = new ORecordLazyMap(owner);
        while (size-- > 0) {
            OType keyType = HelperClasses.readOType(bytes, false);
            Object key = this.deserializeValue(bytes, keyType, result);
            ORecordId value = ODocumentSerializerDelta.readOptimizedLink(bytes);
            if (((Object)value).equals(HelperClasses.NULL_RECORD_ID)) {
                result.putInternal(key, null);
                continue;
            }
            result.putInternal(key, value);
        }
        return result;
    }

    private Object readEmbeddedMap(BytesContainer bytes, ORecordElement owner) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        OTrackedMap<Object> result = new OTrackedMap<Object>(owner);
        while (size-- > 0) {
            String key = HelperClasses.readString(bytes);
            OType valType = ODocumentSerializerDelta.readNullableType(bytes);
            Object value = null;
            if (valType != null) {
                value = this.deserializeValue(bytes, valType, result);
            }
            result.putInternal(key, value);
        }
        return result;
    }

    private ORidBag readRidBag(BytesContainer bytes) {
        UUID uuid = OUUIDSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
        bytes.skip(16);
        if (uuid.getMostSignificantBits() == -1L && uuid.getLeastSignificantBits() == -1L) {
            uuid = null;
        }
        byte b = bytes.bytes[bytes.offset];
        bytes.skip(1);
        if (b == 1) {
            ORidBag bag = new ORidBag(uuid);
            int size = OVarIntSerializer.readAsInteger(bytes);
            for (int i = 0; i < size; ++i) {
                ORecordId id = ODocumentSerializerDelta.readOptimizedLink(bytes);
                if (((Object)id).equals(HelperClasses.NULL_RECORD_ID)) {
                    bag.add(null);
                    continue;
                }
                bag.add(id);
            }
            return bag;
        }
        long fileId = OVarIntSerializer.readAsLong(bytes);
        long pageIndex = OVarIntSerializer.readAsLong(bytes);
        int pageOffset = OVarIntSerializer.readAsInteger(bytes);
        int bagSize = OVarIntSerializer.readAsInteger(bytes);
        HashMap<OIdentifiable, Change> changes = new HashMap<OIdentifiable, Change>();
        int size = OVarIntSerializer.readAsInteger(bytes);
        while (size-- > 0) {
            ORecordId link = ODocumentSerializerDelta.readOptimizedLink(bytes);
            byte type = bytes.bytes[bytes.offset];
            bytes.skip(1);
            int change = OVarIntSerializer.readAsInteger(bytes);
            changes.put(link, ChangeSerializationHelper.createChangeInstance(type, change));
        }
        OBonsaiCollectionPointer pointer = null;
        if (fileId != -1L) {
            pointer = new OBonsaiCollectionPointer(fileId, new OBonsaiBucketPointer(pageIndex, pageOffset));
        }
        return new ORidBag(pointer, changes, uuid);
    }

    private void writeRidBag(BytesContainer bytes, ORidBag bag) {
        OSBTreeCollectionManager sbTreeCollectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
        UUID uuid = null;
        if (sbTreeCollectionManager != null) {
            uuid = sbTreeCollectionManager.listenForChanges(bag);
        }
        if (uuid == null) {
            uuid = new UUID(-1L, -1L);
        }
        int uuidPos = bytes.alloc(16);
        OUUIDSerializer.INSTANCE.serialize(uuid, bytes.bytes, uuidPos, new Object[0]);
        if (bag.isToSerializeEmbedded()) {
            int pos = bytes.alloc(1);
            bytes.bytes[pos] = 1;
            OVarIntSerializer.write(bytes, (long)bag.size());
            Iterator<OIdentifiable> iterator = bag.rawIterator();
            while (iterator.hasNext()) {
                OIdentifiable itemValue = iterator.next();
                if (itemValue == null) {
                    HelperClasses.writeNullLink(bytes);
                    continue;
                }
                ODocumentSerializerDelta.writeOptimizedLink(bytes, itemValue);
            }
        } else {
            int pos = bytes.alloc(1);
            bytes.bytes[pos] = 2;
            OBonsaiCollectionPointer pointer = bag.getPointer();
            if (pointer == null) {
                pointer = OBonsaiCollectionPointer.INVALID;
            }
            OVarIntSerializer.write(bytes, pointer.getFileId());
            OVarIntSerializer.write(bytes, pointer.getRootPointer().getPageIndex());
            OVarIntSerializer.write(bytes, (long)pointer.getRootPointer().getPageOffset());
            OVarIntSerializer.write(bytes, (long)bag.size());
            NavigableMap<OIdentifiable, Change> changes = bag.getChanges();
            if (changes != null) {
                OVarIntSerializer.write(bytes, (long)changes.size());
                for (Map.Entry change : changes.entrySet()) {
                    ODocumentSerializerDelta.writeOptimizedLink(bytes, (OIdentifiable)change.getKey());
                    int posAll = bytes.alloc(1);
                    bytes.bytes[posAll] = ((Change)change.getValue()).getType();
                    OVarIntSerializer.write(bytes, (long)((Change)change.getValue()).getValue());
                }
            } else {
                OVarIntSerializer.write(bytes, 0L);
            }
        }
    }

    public static void writeNullableType(BytesContainer bytes, OType type) {
        int pos = bytes.alloc(1);
        bytes.bytes[pos] = type == null ? -1 : (byte)type.getId();
    }

    public static OType readNullableType(BytesContainer bytes) {
        byte typeId;
        if ((typeId = bytes.bytes[bytes.offset++]) == -1) {
            return null;
        }
        return OType.getById(typeId);
    }

    public static ORecordId readOptimizedLink(BytesContainer bytes) {
        int clusterId = OVarIntSerializer.readAsInteger(bytes);
        long clusterPos = OVarIntSerializer.readAsLong(bytes);
        if (clusterId == -2 && clusterId == -2) {
            return null;
        }
        return new ORecordId(clusterId, clusterPos);
    }

    public static void writeOptimizedLink(BytesContainer bytes, OIdentifiable link) {
        if (link == null) {
            OVarIntSerializer.write(bytes, -2L);
            OVarIntSerializer.write(bytes, -2L);
        } else {
            if (!link.getIdentity().isPersistent()) {
                try {
                    Object real = link.getRecord();
                    if (real != null) {
                        link = real;
                    }
                }
                catch (ORecordNotFoundException oRecordNotFoundException) {
                    // empty catch block
                }
            }
            OVarIntSerializer.write(bytes, (long)link.getIdentity().getClusterId());
            OVarIntSerializer.write(bytes, link.getIdentity().getClusterPosition());
        }
    }
}

