/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializerDelta;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;

public class ODocumentSerializerDeltaDistributed
extends ODocumentSerializerDelta {
    private static ODocumentSerializerDeltaDistributed INSTANCE = new ODocumentSerializerDeltaDistributed();

    public static ODocumentSerializerDeltaDistributed instance() {
        return INSTANCE;
    }

    @Override
    protected void deserializeDeltaLinkBag(BytesContainer bytes, ORidBag toUpdate) {
        boolean isTree = this.deserializeByte(bytes) == 1;
        long rootChanges = OVarIntSerializer.readAsLong(bytes);
        while (rootChanges-- > 0L) {
            byte change = this.deserializeByte(bytes);
            switch (change) {
                case 1: {
                    ORecordId link = ODocumentSerializerDeltaDistributed.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.add(link);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    ORecordId link = ODocumentSerializerDeltaDistributed.readOptimizedLink(bytes);
                    if (toUpdate == null) break;
                    toUpdate.remove(link);
                    break;
                }
            }
        }
        if (toUpdate != null) {
            if (isTree) {
                toUpdate.makeTree();
            } else {
                toUpdate.makeEmbedded();
            }
        }
    }

    @Override
    protected void serializeDeltaLinkBag(BytesContainer bytes, ORidBag value) {
        this.serializeByte(bytes, value.isEmbedded() ? (byte)0 : 1);
        OMultiValueChangeTimeLine<OIdentifiable, OIdentifiable> timeline = value.getTransactionTimeLine();
        assert (timeline != null) : "Cx ollection timeline required for link types serialization";
        OVarIntSerializer.write(bytes, (long)timeline.getMultiValueChangeEvents().size());
        for (OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event : timeline.getMultiValueChangeEvents()) {
            switch (event.getChangeType()) {
                case ADD: {
                    this.serializeByte(bytes, (byte)1);
                    ODocumentSerializerDeltaDistributed.writeOptimizedLink(bytes, event.getValue());
                    break;
                }
                case UPDATE: {
                    throw new UnsupportedOperationException("update do not happen in sets, it will be like and add");
                }
                case REMOVE: {
                    this.serializeByte(bytes, (byte)4);
                    ODocumentSerializerDeltaDistributed.writeOptimizedLink(bytes, event.getOldValue());
                }
            }
        }
    }
}

