/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OPropertyEncryption;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEmbedded;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.HelperClasses;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryComparator;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryComparatorV0;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebug;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebugProperty;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OResultBinary;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OSerializableWrapper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;

public class ORecordSerializerBinaryV0
implements ODocumentSerializer {
    private final OBinaryComparatorV0 comparator = new OBinaryComparatorV0();

    @Override
    public OBinaryComparator getComparator() {
        return this.comparator;
    }

    @Override
    public void deserializePartial(ODocument document, BytesContainer bytes, String[] iFields) {
        int len;
        String className = HelperClasses.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        byte[][] fields = new byte[iFields.length][];
        for (int i = 0; i < iFields.length; ++i) {
            fields[i] = HelperClasses.bytesFromString(iFields[i]);
        }
        String fieldName = null;
        int unmarshalledFields = 0;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            OType type;
            int valuePos;
            if (len > 0) {
                boolean match = false;
                for (int i = 0; i < iFields.length; ++i) {
                    if (fields[i] == null || fields[i].length != len) continue;
                    boolean matchField = true;
                    for (int j = 0; j < len; ++j) {
                        if (bytes.bytes[bytes.offset + j] == fields[i][j]) continue;
                        matchField = false;
                        break;
                    }
                    if (!matchField) continue;
                    fieldName = iFields[i];
                    bytes.skip(len);
                    match = true;
                    break;
                }
                if (!match) {
                    bytes.skip(len + 4 + 1);
                    continue;
                }
                HelperClasses.Tuple<Integer, OType> pointerAndType = this.getPointerAndTypeFromCurrentPosition(bytes);
                valuePos = pointerAndType.getFirstVal();
                type = pointerAndType.getSecondVal();
            } else {
                OGlobalProperty prop = HelperClasses.getGlobalProperty(document, len);
                fieldName = prop.getName();
                boolean matchField = false;
                for (String f : iFields) {
                    if (!fieldName.equals(f)) continue;
                    matchField = true;
                    break;
                }
                if (!matchField) {
                    bytes.skip(4 + (prop.getType() != OType.ANY ? 0 : 1));
                    continue;
                }
                valuePos = HelperClasses.readInteger(bytes);
                type = prop.getType() != OType.ANY ? prop.getType() : HelperClasses.readOType(bytes, false);
            }
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, document);
                bytes.offset = headerCursor;
                ODocumentInternal.rawField(document, fieldName, value, type);
            } else {
                ODocumentInternal.rawField(document, fieldName, null, null);
            }
            if (++unmarshalledFields != iFields.length) continue;
            break;
        }
    }

    @Override
    public OBinaryField deserializeField(BytesContainer bytes, OClass iClass, String iFieldName, boolean embedded, OImmutableSchema schema, OPropertyEncryption encryption) {
        int classNameLen = OVarIntSerializer.readAsInteger(bytes);
        bytes.skip(classNameLen);
        byte[] field = iFieldName.getBytes();
        int len;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            OType type;
            int valuePos;
            if (len > 0) {
                if (iFieldName.length() == len) {
                    boolean match = true;
                    for (int j = 0; j < len; ++j) {
                        if (bytes.bytes[bytes.offset + j] == field[j]) continue;
                        match = false;
                        break;
                    }
                    bytes.skip(len);
                    HelperClasses.Tuple<Integer, OType> pointerAndType = this.getPointerAndTypeFromCurrentPosition(bytes);
                    valuePos = pointerAndType.getFirstVal();
                    type = pointerAndType.getSecondVal();
                    if (valuePos == 0) {
                        return null;
                    }
                    if (!match) continue;
                    if (!this.getComparator().isBinaryComparable(type)) {
                        return null;
                    }
                    bytes.offset = valuePos;
                    return new OBinaryField(iFieldName, type, bytes, null);
                }
                bytes.skip(len + 4 + 1);
                continue;
            }
            int id = len * -1 - 1;
            OGlobalProperty prop = schema.getGlobalPropertyById(id);
            if (iFieldName.equals(prop.getName())) {
                valuePos = HelperClasses.readInteger(bytes);
                type = prop.getType() != OType.ANY ? prop.getType() : HelperClasses.readOType(bytes, false);
                if (valuePos == 0) {
                    return null;
                }
                if (!this.getComparator().isBinaryComparable(type)) {
                    return null;
                }
                bytes.offset = valuePos;
                OProperty classProp = iClass.getProperty(iFieldName);
                return new OBinaryField(iFieldName, type, bytes, classProp != null ? classProp.getCollate() : null);
            }
            bytes.skip(4 + (prop.getType() != OType.ANY ? 0 : 1));
        }
        return null;
    }

    public void deserializeWithClassName(ODocument document, BytesContainer bytes) {
        this.deserialize(document, bytes);
    }

    @Override
    public void deserialize(ODocument document, BytesContainer bytes) {
        int len;
        String className = HelperClasses.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        int last = 0;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            OType type;
            int valuePos;
            String fieldName;
            if (len > 0) {
                fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                bytes.skip(len);
                HelperClasses.Tuple<Integer, OType> pointerAndType = this.getPointerAndTypeFromCurrentPosition(bytes);
                valuePos = pointerAndType.getFirstVal();
                type = pointerAndType.getSecondVal();
            } else {
                OGlobalProperty prop = HelperClasses.getGlobalProperty(document, len);
                fieldName = prop.getName();
                valuePos = HelperClasses.readInteger(bytes);
                type = prop.getType() != OType.ANY ? prop.getType() : HelperClasses.readOType(bytes, false);
            }
            if (ODocumentInternal.rawContainsField(document, fieldName)) continue;
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, document);
                if (bytes.offset > last) {
                    last = bytes.offset;
                }
                bytes.offset = headerCursor;
                ODocumentInternal.rawField(document, fieldName, value, type);
                continue;
            }
            ODocumentInternal.rawField(document, fieldName, null, null);
        }
        ORecordInternal.clearSource(document);
        if (last > bytes.offset) {
            bytes.offset = last;
        }
    }

    @Override
    public String[] getFieldNames(ODocument reference, BytesContainer bytes, boolean embedded) {
        int len;
        int classNameLen = OVarIntSerializer.readAsInteger(bytes);
        bytes.skip(classNameLen);
        ArrayList<String> result = new ArrayList<String>();
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            if (len > 0) {
                String fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                result.add(fieldName);
                bytes.skip(len + 4 + 1);
                continue;
            }
            int id = len * -1 - 1;
            OGlobalProperty prop = ODocumentInternal.getGlobalPropertyById(reference, id);
            if (prop == null) {
                throw new OSerializationException("Missing property definition for property id '" + id + "'");
            }
            result.add(prop.getName());
            bytes.skip(4 + (prop.getType() != OType.ANY ? 0 : 1));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void serialize(ODocument document, BytesContainer bytes) {
        OImmutableSchema schema = ODocumentInternal.getImmutableSchema(document);
        OPropertyEncryption encryption = ODocumentInternal.getPropertyEncryption(document);
        this.serialize(document, bytes, schema, encryption);
    }

    public void serialize(ODocument document, BytesContainer bytes, OImmutableSchema schema, OPropertyEncryption encryption) {
        OClass clazz = this.serializeClass(document, bytes);
        Map<String, OProperty> props2 = clazz != null ? clazz.propertiesMap() : null;
        Set<Map.Entry<String, ODocumentEntry>> fields = ODocumentInternal.rawEntries(document);
        int[] pos = new int[fields.size()];
        int i = 0;
        Map.Entry[] values = new Map.Entry[fields.size()];
        for (Map.Entry<String, ODocumentEntry> entry : fields) {
            OProperty prop;
            ODocumentEntry docEntry = entry.getValue();
            if (!docEntry.exists()) continue;
            if (docEntry.property == null && props2 != null && (prop = props2.get(entry.getKey())) != null && docEntry.type == prop.getType()) {
                docEntry.property = prop;
            }
            if (docEntry.property != null) {
                OVarIntSerializer.write(bytes, (long)((docEntry.property.getId() + 1) * -1));
                pos[i] = docEntry.property.getType() != OType.ANY ? bytes.alloc(4) : bytes.alloc(5);
            } else {
                HelperClasses.writeString(bytes, entry.getKey());
                pos[i] = bytes.alloc(5);
            }
            values[i] = entry;
            ++i;
        }
        this.writeEmptyString(bytes);
        int size = i;
        for (i = 0; i < size; ++i) {
            int pointer = 0;
            Object value = ((ODocumentEntry)values[i].getValue()).value;
            if (value == null) continue;
            OType type = this.getFieldType((ODocumentEntry)values[i].getValue());
            if (type == null) {
                throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
            }
            pointer = this.serializeValue(bytes, value, type, this.getLinkedType(document, type, (String)values[i].getKey()), schema, encryption);
            OIntegerSerializer.INSTANCE.serializeLiteral(pointer, bytes.bytes, pos[i]);
            if (((ODocumentEntry)values[i].getValue()).property != null && ((ODocumentEntry)values[i].getValue()).property.getType() != OType.ANY) continue;
            HelperClasses.writeOType(bytes, pos[i] + 4, type);
        }
    }

    @Override
    public Object deserializeValue(BytesContainer bytes, OType type, ORecordElement owner) {
        ORecordElement doc;
        for (doc = owner; !(doc instanceof ODocument) && doc != null; doc = doc.getOwner()) {
        }
        OImmutableSchema schema = ODocumentInternal.getImmutableSchema((ODocument)doc);
        return this.deserializeValue(bytes, type, owner, true, -1, false, schema);
    }

    protected Object deserializeEmbeddedAsDocument(BytesContainer bytes, ORecordElement owner) {
        Object value = new ODocumentEmbedded();
        this.deserializeWithClassName((ODocument)value, bytes);
        if (((ODocument)value).containsField("__orientdb_serilized_class__ ")) {
            String className = (String)((ODocument)value).field("__orientdb_serilized_class__ ");
            try {
                Class<?> clazz = Class.forName(className);
                ODocumentSerializable newValue = (ODocumentSerializable)clazz.newInstance();
                newValue.fromDocument((ODocument)value);
                value = newValue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            ODocumentInternal.addOwner((ODocument)value, owner);
        }
        return value;
    }

    protected List<HelperClasses.MapRecordInfo> getPositionsFromEmbeddedMap(BytesContainer bytes, OImmutableSchema schema) {
        ArrayList<HelperClasses.MapRecordInfo> retList = new ArrayList<HelperClasses.MapRecordInfo>();
        int numberOfElements = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < numberOfElements; ++i) {
            OType keyType = HelperClasses.readOType(bytes, false);
            String key = HelperClasses.readString(bytes);
            int valuePos = HelperClasses.readInteger(bytes);
            OType valueType = HelperClasses.readOType(bytes, false);
            HelperClasses.MapRecordInfo recordInfo = new HelperClasses.MapRecordInfo();
            recordInfo.fieldStartOffset = valuePos;
            recordInfo.fieldType = valueType;
            recordInfo.key = key;
            recordInfo.keyType = keyType;
            int currentOffset = bytes.offset;
            bytes.offset = valuePos;
            bytes.offset = valuePos;
            this.deserializeValue(bytes, valueType, null, true, -1, true, schema);
            recordInfo.fieldLength = bytes.offset - valuePos;
            bytes.offset = currentOffset;
            retList.add(recordInfo);
        }
        return retList;
    }

    private List<HelperClasses.RecordInfo> getPositionsFromEmbeddedCollection(BytesContainer bytes, OImmutableSchema schema) {
        ArrayList<HelperClasses.RecordInfo> retList = new ArrayList<HelperClasses.RecordInfo>();
        int numberOfElements = OVarIntSerializer.readAsInteger(bytes);
        HelperClasses.readByte(bytes);
        for (int i = 0; i < numberOfElements; ++i) {
            OType dataType = HelperClasses.readOType(bytes, false);
            int fieldStart = bytes.offset;
            HelperClasses.RecordInfo fieldInfo = new HelperClasses.RecordInfo();
            fieldInfo.fieldStartOffset = fieldStart;
            fieldInfo.fieldType = dataType;
            this.deserializeValue(bytes, dataType, null, true, -1, true, schema);
            fieldInfo.fieldLength = bytes.offset - fieldStart;
            retList.add(fieldInfo);
        }
        return retList;
    }

    protected List deserializeEmbeddedCollectionAsCollectionOfBytes(BytesContainer bytes, OImmutableSchema schema) {
        ArrayList<Object> retVal = new ArrayList<Object>();
        List<HelperClasses.RecordInfo> fieldsInfo = this.getPositionsFromEmbeddedCollection(bytes, schema);
        for (HelperClasses.RecordInfo fieldInfo : fieldsInfo) {
            if (fieldInfo.fieldType.isEmbedded()) {
                OResultBinary result = new OResultBinary(schema, bytes.bytes, fieldInfo.fieldStartOffset, fieldInfo.fieldLength, this);
                retVal.add(result);
                continue;
            }
            int currentOffset = bytes.offset;
            bytes.offset = fieldInfo.fieldStartOffset;
            Object value = this.deserializeValue(bytes, fieldInfo.fieldType, null);
            retVal.add(value);
            bytes.offset = currentOffset;
        }
        return retVal;
    }

    protected Map<String, Object> deserializeEmbeddedMapAsMapOfBytes(BytesContainer bytes, OImmutableSchema schema) {
        TreeMap<String, Object> retVal = new TreeMap<String, Object>();
        List<HelperClasses.MapRecordInfo> positionsWithLengths = this.getPositionsFromEmbeddedMap(bytes, schema);
        for (HelperClasses.MapRecordInfo recordInfo : positionsWithLengths) {
            Object value;
            String key = recordInfo.key;
            if (recordInfo.fieldType != null && recordInfo.fieldType.isEmbedded()) {
                value = new OResultBinary(schema, bytes.bytes, recordInfo.fieldStartOffset, recordInfo.fieldLength, this);
            } else if (recordInfo.fieldStartOffset != 0) {
                int currentOffset = bytes.offset;
                bytes.offset = recordInfo.fieldStartOffset;
                value = this.deserializeValue(bytes, recordInfo.fieldType, null);
                bytes.offset = currentOffset;
            } else {
                value = null;
            }
            retVal.put(key, value);
        }
        return retVal;
    }

    protected OResultBinary deserializeEmbeddedAsBytes(BytesContainer bytes, int valueLength, OImmutableSchema schema) {
        int startOffset = bytes.offset;
        return new OResultBinary(schema, bytes.bytes, startOffset, valueLength, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object deserializeValue(BytesContainer bytes, OType type, ORecordElement owner, boolean embeddedAsDocument, int valueLengthInBytes, boolean justRunThrough, OImmutableSchema schema) {
        if (type == null) {
            throw new ODatabaseException("Invalid type value: null");
        }
        Object value = null;
        switch (type) {
            case INTEGER: {
                return OVarIntSerializer.readAsInteger(bytes);
            }
            case LONG: {
                return OVarIntSerializer.readAsLong(bytes);
            }
            case SHORT: {
                return OVarIntSerializer.readAsShort(bytes);
            }
            case STRING: {
                if (!justRunThrough) return HelperClasses.readString(bytes);
                int length = OVarIntSerializer.readAsInteger(bytes);
                bytes.skip(length);
                return value;
            }
            case DOUBLE: {
                if (!justRunThrough) return Double.longBitsToDouble(HelperClasses.readLong(bytes));
                bytes.skip(8);
                return value;
            }
            case FLOAT: {
                if (!justRunThrough) return Float.valueOf(Float.intBitsToFloat(HelperClasses.readInteger(bytes)));
                bytes.skip(4);
                return value;
            }
            case BYTE: {
                if (!justRunThrough) return HelperClasses.readByte(bytes);
                ++bytes.offset;
                return value;
            }
            case BOOLEAN: {
                if (!justRunThrough) return HelperClasses.readByte(bytes) == 1;
                ++bytes.offset;
                return value;
            }
            case DATETIME: {
                if (!justRunThrough) return new Date(OVarIntSerializer.readAsLong(bytes));
                OVarIntSerializer.readAsLong(bytes);
                return value;
            }
            case DATE: {
                if (justRunThrough) {
                    OVarIntSerializer.readAsLong(bytes);
                    return value;
                }
                long savedTime = OVarIntSerializer.readAsLong(bytes) * 86400000L;
                savedTime = HelperClasses.convertDayToTimezone(TimeZone.getTimeZone("GMT"), ODateHelper.getDatabaseTimeZone(), savedTime);
                return new Date(savedTime);
            }
            case EMBEDDED: {
                if (!embeddedAsDocument) return this.deserializeEmbeddedAsBytes(bytes, valueLengthInBytes, schema);
                return this.deserializeEmbeddedAsDocument(bytes, owner);
            }
            case EMBEDDEDSET: {
                if (!embeddedAsDocument) return this.deserializeEmbeddedCollectionAsCollectionOfBytes(bytes, schema);
                return this.readEmbeddedSet(bytes, owner);
            }
            case EMBEDDEDLIST: {
                if (!embeddedAsDocument) return this.deserializeEmbeddedCollectionAsCollectionOfBytes(bytes, schema);
                return this.readEmbeddedList(bytes, owner);
            }
            case LINKSET: {
                ORecordLazySet collectionSet = null;
                if (justRunThrough) return HelperClasses.readLinkCollection(bytes, collectionSet, justRunThrough);
                collectionSet = new ORecordLazySet(owner);
                return HelperClasses.readLinkCollection(bytes, collectionSet, justRunThrough);
            }
            case LINKLIST: {
                ORecordLazyList collectionList = null;
                if (justRunThrough) return HelperClasses.readLinkCollection(bytes, collectionList, justRunThrough);
                collectionList = new ORecordLazyList(owner);
                return HelperClasses.readLinkCollection(bytes, collectionList, justRunThrough);
            }
            case BINARY: {
                if (!justRunThrough) return HelperClasses.readBinary(bytes);
                int len = OVarIntSerializer.readAsInteger(bytes);
                bytes.skip(len);
                return value;
            }
            case LINK: {
                return HelperClasses.readOptimizedLink(bytes, justRunThrough);
            }
            case LINKMAP: {
                return this.readLinkMap(bytes, owner, justRunThrough, schema);
            }
            case EMBEDDEDMAP: {
                if (!embeddedAsDocument) return this.deserializeEmbeddedMapAsMapOfBytes(bytes, schema);
                return this.readEmbeddedMap(bytes, owner);
            }
            case DECIMAL: {
                value = ODecimalSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
                bytes.skip(ODecimalSerializer.INSTANCE.getObjectSize(bytes.bytes, bytes.offset));
                return value;
            }
            case LINKBAG: {
                ORidBag bag = this.readRidbag(bytes);
                bag.setOwner(owner);
                return bag;
            }
            case TRANSIENT: {
                return value;
            }
            case CUSTOM: {
                try {
                    String className = HelperClasses.readString(bytes);
                    Class<?> clazz = Class.forName(className);
                    OSerializableStream stream = (OSerializableStream)clazz.newInstance();
                    byte[] bytesRepresentation = HelperClasses.readBinary(bytes);
                    if (!embeddedAsDocument) return new OResultBinary(schema, bytesRepresentation, 0, bytesRepresentation.length, this);
                    stream.fromStream(bytesRepresentation);
                    if (!(stream instanceof OSerializableWrapper)) return stream;
                    return ((OSerializableWrapper)stream).getSerializable();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return value;
    }

    protected ORidBag readRidbag(BytesContainer bytes) {
        ORidBag bag = new ORidBag();
        bag.fromStream(bytes);
        return bag;
    }

    protected OClass serializeClass(ODocument document, BytesContainer bytes) {
        OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        if (clazz != null) {
            HelperClasses.writeString(bytes, clazz.getName());
        } else {
            this.writeEmptyString(bytes);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeLinkMap(BytesContainer bytes, Map<Object, OIdentifiable> map) {
        boolean disabledAutoConversion;
        boolean bl = disabledAutoConversion = map instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)map)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(false);
        }
        try {
            int fullPos = OVarIntSerializer.write(bytes, (long)map.size());
            for (Map.Entry<Object, OIdentifiable> entry : map.entrySet()) {
                OType type = OType.STRING;
                HelperClasses.writeOType(bytes, bytes.alloc(1), type);
                HelperClasses.writeString(bytes, entry.getKey().toString());
                if (entry.getValue() == null) {
                    HelperClasses.writeNullLink(bytes);
                    continue;
                }
                HelperClasses.writeOptimizedLink(bytes, entry.getValue());
            }
            int n = fullPos;
            return n;
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(true);
            }
        }
    }

    protected Map<Object, OIdentifiable> readLinkMap(BytesContainer bytes, ORecordElement owner, boolean justRunThrough, OImmutableSchema schema) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        ORecordLazyMap result = null;
        if (!justRunThrough) {
            result = new ORecordLazyMap(owner);
        }
        while (size-- > 0) {
            OType keyType = HelperClasses.readOType(bytes, justRunThrough);
            Object key = this.deserializeValue(bytes, keyType, result, true, -1, justRunThrough, schema);
            ORecordId value = HelperClasses.readOptimizedLink(bytes, justRunThrough);
            if (value.equals(HelperClasses.NULL_RECORD_ID)) {
                result.putInternal(key, null);
                continue;
            }
            result.putInternal(key, value);
        }
        return result;
    }

    protected Object readEmbeddedMap(BytesContainer bytes, ORecordElement owner) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        OTrackedMap<Object> result = new OTrackedMap<Object>(owner);
        int last = 0;
        while (size-- > 0) {
            OType keyType = HelperClasses.readOType(bytes, false);
            Object key = this.deserializeValue(bytes, keyType, result);
            int valuePos = HelperClasses.readInteger(bytes);
            OType type = HelperClasses.readOType(bytes, false);
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, result);
                if (bytes.offset > last) {
                    last = bytes.offset;
                }
                bytes.offset = headerCursor;
                result.putInternal(key, value);
                continue;
            }
            result.putInternal(key, null);
        }
        if (last > bytes.offset) {
            bytes.offset = last;
        }
        return result;
    }

    protected Collection<?> readEmbeddedSet(BytesContainer bytes, ORecordElement owner) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        OType type = HelperClasses.readOType(bytes, false);
        if (type == OType.ANY) {
            OTrackedSet<Object> found = new OTrackedSet<Object>(owner);
            for (int i = 0; i < items; ++i) {
                OType itemType = HelperClasses.readOType(bytes, false);
                if (itemType == OType.ANY) {
                    found.addInternal((Object)null);
                    continue;
                }
                found.addInternal(this.deserializeValue(bytes, itemType, found));
            }
            return found;
        }
        return null;
    }

    protected Collection<?> readEmbeddedList(BytesContainer bytes, ORecordElement owner) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        OType type = HelperClasses.readOType(bytes, false);
        if (type == OType.ANY) {
            OTrackedList<Object> found = new OTrackedList<Object>(owner);
            for (int i = 0; i < items; ++i) {
                OType itemType = HelperClasses.readOType(bytes, false);
                if (itemType == OType.ANY) {
                    found.addInternal((Object)null);
                    continue;
                }
                found.addInternal(this.deserializeValue(bytes, itemType, found));
            }
            return found;
        }
        return null;
    }

    protected OType getLinkedType(ODocument document, OType type, String key) {
        OProperty prop;
        if (type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDSET && type != OType.EMBEDDEDMAP) {
            return null;
        }
        OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(document);
        if (immutableClass != null && (prop = immutableClass.getProperty(key)) != null) {
            return prop.getLinkedType();
        }
        return null;
    }

    @Override
    public int serializeValue(BytesContainer bytes, Object value, OType type, OType linkedType, OImmutableSchema schema, OPropertyEncryption encryption) {
        int pointer = 0;
        switch (type) {
            case INTEGER: 
            case LONG: 
            case SHORT: {
                pointer = OVarIntSerializer.write(bytes, ((Number)value).longValue());
                break;
            }
            case STRING: {
                pointer = HelperClasses.writeString(bytes, value.toString());
                break;
            }
            case DOUBLE: {
                long dg = Double.doubleToLongBits(((Number)value).doubleValue());
                pointer = bytes.alloc(8);
                OLongSerializer.INSTANCE.serializeLiteral(dg, bytes.bytes, pointer);
                break;
            }
            case FLOAT: {
                int fg = Float.floatToIntBits(((Number)value).floatValue());
                pointer = bytes.alloc(4);
                OIntegerSerializer.INSTANCE.serializeLiteral(fg, bytes.bytes, pointer);
                break;
            }
            case BYTE: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = ((Number)value).byteValue();
                break;
            }
            case BOOLEAN: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Boolean)value != false ? (byte)1 : 0;
                break;
            }
            case DATETIME: {
                if (value instanceof Number) {
                    pointer = OVarIntSerializer.write(bytes, ((Number)value).longValue());
                    break;
                }
                pointer = OVarIntSerializer.write(bytes, ((Date)value).getTime());
                break;
            }
            case DATE: {
                long dateValue = value instanceof Number ? ((Number)value).longValue() : ((Date)value).getTime();
                dateValue = HelperClasses.convertDayToTimezone(ODateHelper.getDatabaseTimeZone(), TimeZone.getTimeZone("GMT"), dateValue);
                pointer = OVarIntSerializer.write(bytes, dateValue / 86400000L);
                break;
            }
            case EMBEDDED: {
                pointer = bytes.offset;
                if (value instanceof ODocumentSerializable) {
                    ODocument cur = ((ODocumentSerializable)value).toDocument();
                    cur.field("__orientdb_serilized_class__ ", value.getClass().getName());
                    this.serialize(cur, bytes, schema, encryption);
                    break;
                }
                this.serialize((ODocument)value, bytes, schema, encryption);
                break;
            }
            case EMBEDDEDSET: 
            case EMBEDDEDLIST: {
                if (value.getClass().isArray()) {
                    pointer = this.writeEmbeddedCollection(bytes, Arrays.asList(OMultiValue.array(value)), linkedType, schema, encryption);
                    break;
                }
                pointer = this.writeEmbeddedCollection(bytes, (Collection)value, linkedType, schema, encryption);
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = (BigDecimal)value;
                pointer = bytes.alloc(ODecimalSerializer.INSTANCE.getObjectSize(decimalValue, new Object[0]));
                ODecimalSerializer.INSTANCE.serialize(decimalValue, bytes.bytes, pointer, new Object[0]);
                break;
            }
            case BINARY: {
                pointer = HelperClasses.writeBinary(bytes, (byte[])value);
                break;
            }
            case LINKSET: 
            case LINKLIST: {
                Collection ridCollection = (Collection)value;
                pointer = HelperClasses.writeLinkCollection(bytes, ridCollection);
                break;
            }
            case LINK: {
                if (!(value instanceof OIdentifiable)) {
                    throw new OValidationException("Value '" + value + "' is not a OIdentifiable");
                }
                pointer = HelperClasses.writeOptimizedLink(bytes, (OIdentifiable)value);
                break;
            }
            case LINKMAP: {
                pointer = this.writeLinkMap(bytes, (Map)value);
                break;
            }
            case EMBEDDEDMAP: {
                pointer = this.writeEmbeddedMap(bytes, (Map)value, schema, encryption);
                break;
            }
            case LINKBAG: {
                pointer = this.writeRidBag(bytes, (ORidBag)value);
                break;
            }
            case CUSTOM: {
                if (!(value instanceof OSerializableStream)) {
                    value = new OSerializableWrapper((Serializable)value);
                }
                pointer = HelperClasses.writeString(bytes, value.getClass().getName());
                HelperClasses.writeBinary(bytes, ((OSerializableStream)value).toStream());
                break;
            }
            case TRANSIENT: {
                break;
            }
        }
        return pointer;
    }

    protected int writeRidBag(BytesContainer bytes, ORidBag ridbag) {
        return ridbag.toStream(bytes);
    }

    protected int writeEmbeddedMap(BytesContainer bytes, Map<Object, Object> map, OImmutableSchema schema, OPropertyEncryption encryption) {
        int[] pos = new int[map.size()];
        int i = 0;
        Map.Entry[] values = new Map.Entry[map.size()];
        int fullPos = OVarIntSerializer.write(bytes, (long)map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            OType type = OType.STRING;
            HelperClasses.writeOType(bytes, bytes.alloc(1), type);
            HelperClasses.writeString(bytes, entry.getKey().toString());
            pos[i] = bytes.alloc(5);
            values[i] = entry;
            ++i;
        }
        for (i = 0; i < values.length; ++i) {
            Object value = values[i].getValue();
            if (value != null) {
                OType type = HelperClasses.getTypeFromValueEmbedded(value);
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
                }
                int pointer = this.serializeValue(bytes, value, type, null, schema, encryption);
                OIntegerSerializer.INSTANCE.serializeLiteral(pointer, bytes.bytes, pos[i]);
                HelperClasses.writeOType(bytes, pos[i] + 4, type);
                continue;
            }
            OIntegerSerializer.INSTANCE.serializeLiteral(0, bytes.bytes, pos[i]);
        }
        return fullPos;
    }

    protected int writeEmbeddedCollection(BytesContainer bytes, Collection<?> value, OType linkedType, OImmutableSchema schema, OPropertyEncryption encryption) {
        int pos = OVarIntSerializer.write(bytes, (long)value.size());
        HelperClasses.writeOType(bytes, bytes.alloc(1), OType.ANY);
        for (Object itemValue : value) {
            if (itemValue == null) {
                HelperClasses.writeOType(bytes, bytes.alloc(1), OType.ANY);
                continue;
            }
            OType type = linkedType == null || linkedType == OType.ANY ? HelperClasses.getTypeFromValueEmbedded(itemValue) : linkedType;
            if (type != null) {
                HelperClasses.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, itemValue, type, null, schema, encryption);
                continue;
            }
            throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
        }
        return pos;
    }

    protected OType getFieldType(ODocumentEntry entry) {
        OProperty prop;
        OType type = entry.type;
        if (type == null && (prop = entry.property) != null) {
            type = prop.getType();
        }
        if (type == null || OType.ANY == type) {
            type = OType.getTypeByValue(entry.value);
        }
        return type;
    }

    protected int writeEmptyString(BytesContainer bytes) {
        return OVarIntSerializer.write(bytes, 0L);
    }

    @Override
    public boolean isSerializingClassNameByDefault() {
        return true;
    }

    protected void skipClassName(BytesContainer bytes) {
        int classNameLen = OVarIntSerializer.readAsInteger(bytes);
        bytes.skip(classNameLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEmbeddedFieldSize(BytesContainer bytes, int currentFieldDataPos, OType type, OImmutableSchema schema) {
        int startOffset = bytes.offset;
        try {
            int fieldDataLength;
            int len = OVarIntSerializer.readAsInteger(bytes);
            if (len != 0) {
                if (len > 0) {
                    bytes.skip(len);
                }
                int nextFieldPos = HelperClasses.readInteger(bytes);
                int n = nextFieldPos - currentFieldDataPos;
                return n;
            }
            bytes.offset = currentFieldDataPos;
            this.deserializeValue(bytes, type, new ODocument(), true, -1, true, schema);
            int n = fieldDataLength = bytes.offset - currentFieldDataPos;
            return n;
        }
        finally {
            bytes.offset = startOffset;
        }
    }

    protected <RET> RET deserializeFieldTypedLoopAndReturn(BytesContainer bytes, String iFieldName, OImmutableSchema schema) {
        byte[] field = iFieldName.getBytes();
        int len;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            OType type;
            int valuePos;
            if (len > 0) {
                if (iFieldName.length() == len) {
                    boolean match = true;
                    for (int j = 0; j < len; ++j) {
                        if (bytes.bytes[bytes.offset + j] == field[j]) continue;
                        match = false;
                        break;
                    }
                    bytes.skip(len);
                    HelperClasses.Tuple<Integer, OType> pointerAndType = this.getPointerAndTypeFromCurrentPosition(bytes);
                    valuePos = pointerAndType.getFirstVal();
                    type = pointerAndType.getSecondVal();
                    if (valuePos == 0) {
                        return null;
                    }
                    if (!match) continue;
                    int fieldDataLength = -1;
                    if (type.isEmbedded()) {
                        fieldDataLength = this.getEmbeddedFieldSize(bytes, valuePos, type, schema);
                    }
                    bytes.offset = valuePos;
                    Object value = this.deserializeValue(bytes, type, null, false, fieldDataLength, false, schema);
                    return (RET)value;
                }
                bytes.skip(len + 4 + 1);
                continue;
            }
            int id = len * -1 - 1;
            OGlobalProperty prop = schema.getGlobalPropertyById(id);
            if (iFieldName.equals(prop.getName())) {
                valuePos = HelperClasses.readInteger(bytes);
                type = prop.getType() != OType.ANY ? prop.getType() : HelperClasses.readOType(bytes, false);
                int fieldDataLength = -1;
                if (type.isEmbedded()) {
                    fieldDataLength = this.getEmbeddedFieldSize(bytes, valuePos, type, schema);
                }
                if (valuePos == 0) {
                    return null;
                }
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, null, false, fieldDataLength, false, schema);
                return (RET)value;
            }
            bytes.skip(4 + (prop.getType() != OType.ANY ? 0 : 1));
        }
        return null;
    }

    @Override
    public <RET> RET deserializeFieldTyped(BytesContainer bytes, String iFieldName, boolean isEmbedded, OImmutableSchema schema, OPropertyEncryption encryption) {
        this.skipClassName(bytes);
        return this.deserializeFieldTypedLoopAndReturn(bytes, iFieldName, schema);
    }

    public HelperClasses.Tuple<Integer, OType> getPointerAndTypeFromCurrentPosition(BytesContainer bytes) {
        int valuePos = HelperClasses.readInteger(bytes);
        OType type = HelperClasses.readOType(bytes, false);
        return new HelperClasses.Tuple<Integer, OType>(valuePos, type);
    }

    @Override
    public void deserializeDebug(BytesContainer bytes, ODatabaseDocumentInternal db, ORecordSerializationDebug debugInfo, OImmutableSchema schema) {
        debugInfo.properties = new ArrayList();
        int last = 0;
        while (true) {
            ORecordSerializationDebugProperty debugProperty = new ORecordSerializationDebugProperty();
            OGlobalProperty prop = null;
            try {
                OType type;
                int valuePos;
                String fieldName;
                int len = OVarIntSerializer.readAsInteger(bytes);
                if (len != 0) {
                    debugInfo.properties.add(debugProperty);
                }
                if (len == 0) break;
                if (len > 0) {
                    fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                    bytes.skip(len);
                    HelperClasses.Tuple<Integer, OType> valuePositionAndType = this.getPointerAndTypeFromCurrentPosition(bytes);
                    valuePos = valuePositionAndType.getFirstVal();
                    type = valuePositionAndType.getSecondVal();
                } else {
                    int id;
                    debugProperty.globalId = id = len * -1 - 1;
                    prop = schema.getGlobalPropertyById(id);
                    debugProperty.valuePos = valuePos = HelperClasses.readInteger(bytes);
                    if (prop == null) continue;
                    fieldName = prop.getName();
                    type = prop.getType() != OType.ANY ? prop.getType() : HelperClasses.readOType(bytes, false);
                }
                debugProperty.name = fieldName;
                debugProperty.type = type;
                if (valuePos != 0) {
                    int headerCursor = bytes.offset;
                    bytes.offset = valuePos;
                    try {
                        debugProperty.value = this.deserializeValue(bytes, type, new ODocument());
                    }
                    catch (RuntimeException ex) {
                        debugProperty.faildToRead = true;
                        debugProperty.readingException = ex;
                        debugProperty.failPosition = bytes.offset;
                    }
                    if (bytes.offset > last) {
                        last = bytes.offset;
                    }
                    bytes.offset = headerCursor;
                    continue;
                }
                debugProperty.value = null;
            }
            catch (RuntimeException ex) {
                debugInfo.readingFailure = true;
                debugInfo.readingException = ex;
                debugInfo.failPosition = bytes.offset;
            }
        }
    }
}

