/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.parser.ODeleteStatement;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLDelete
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String NAME = "DELETE FROM";
    public static final String KEYWORD_DELETE = "DELETE";
    private static final String VALUE_NOT_FOUND = "_not_found_";
    private OSQLQuery<ODocument> query;
    private String indexName = null;
    private int recordCount = 0;
    private String lockStrategy = "NONE";
    private String returning = "COUNT";
    private List<ORecord> allDeletedRecords;
    private OSQLFilter compiledFilter;
    private boolean unsafe = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLDelete parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLDelete.getDatabase();
            this.init((OCommandRequestText)iRequest);
            this.query = null;
            this.recordCount = 0;
            if (this.parserTextUpperCase.endsWith("UNSAFE")) {
                this.unsafe = true;
                this.parserText = this.parserText.substring(0, this.parserText.length() - "UNSAFE".length() - 1);
                this.parserTextUpperCase = this.parserTextUpperCase.substring(0, this.parserTextUpperCase.length() - "UNSAFE".length() - 1);
            }
            this.parserRequiredKeyword(KEYWORD_DELETE);
            this.parserRequiredKeyword("FROM");
            String subjectName = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
            if (subjectName == null) {
                this.throwSyntaxErrorException("Invalid subject name. Expected cluster, class, index or sub-query");
            }
            if (OStringParser.startsWithIgnoreCase(subjectName, "INDEX:")) {
                this.indexName = subjectName.substring("INDEX:".length());
                if (!this.parserIsEnded()) {
                    while (!this.parserIsEnded()) {
                        String word = this.parserGetLastWord();
                        if (word.equals("LOCK")) {
                            this.lockStrategy = this.parseLock();
                        } else if (word.equals("RETURN")) {
                            this.returning = this.parseReturn();
                        } else if (word.equals("UNSAFE")) {
                            this.unsafe = true;
                        } else if (word.equalsIgnoreCase("WHERE")) {
                            this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition()), this.getContext(), "WHERE");
                        }
                        this.parserNextWord(true);
                    }
                } else {
                    this.parserSetCurrentPosition(-1);
                }
            } else if (subjectName.startsWith("(")) {
                subjectName = subjectName.trim();
                this.query = (OSQLQuery)database.command(new OSQLAsynchQuery(subjectName.substring(1, subjectName.length() - 1), this));
                this.parserNextWord(true);
                if (!this.parserIsEnded()) {
                    while (!this.parserIsEnded()) {
                        String word = this.parserGetLastWord();
                        if (word.equals("LOCK")) {
                            this.lockStrategy = this.parseLock();
                        } else if (word.equals("RETURN")) {
                            this.returning = this.parseReturn();
                        } else if (word.equals("UNSAFE")) {
                            this.unsafe = true;
                        } else if (word.equalsIgnoreCase("WHERE")) {
                            this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition()), this.getContext(), "WHERE");
                        }
                        this.parserNextWord(true);
                    }
                }
            } else {
                this.parserNextWord(true);
                while (!this.parserIsEnded()) {
                    String word = this.parserGetLastWord();
                    if (word.equals("LOCK")) {
                        this.lockStrategy = this.parseLock();
                    } else if (word.equals("RETURN")) {
                        this.returning = this.parseReturn();
                    } else {
                        this.parserGoBack();
                        break;
                    }
                    this.parserNextWord(true);
                }
                String condition = this.parserGetCurrentPosition() > -1 ? " " + this.parserText.substring(this.parserGetCurrentPosition()) : "";
                this.query = (OSQLQuery)database.command(new OSQLAsynchQuery("select from " + this.getSelectTarget(subjectName) + condition, this));
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    private String getSelectTarget(String subjectName) {
        if (this.preParsedStatement == null) {
            return subjectName;
        }
        return ((ODeleteStatement)this.preParsedStatement).fromClause.toString();
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        boolean result;
        ODatabaseDocumentInternal database;
        OIndexInternal index;
        if (this.query == null && this.indexName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (!this.returning.equalsIgnoreCase("COUNT")) {
            this.allDeletedRecords = new ArrayList<ORecord>();
        }
        if (this.query != null) {
            this.query.setContext(this.getContext());
            Object prevLockValue = this.query.getContext().getVariable("$locking");
            if (this.lockStrategy.equals("RECORD")) {
                this.query.getContext().setVariable("$locking", (Object)OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK);
            }
            this.query.execute(iArgs);
            this.query.getContext().setVariable("$locking", prevLockValue);
            if (this.returning.equalsIgnoreCase("COUNT")) {
                return this.recordCount;
            }
            return this.allDeletedRecords;
        }
        if (this.compiledFilter != null) {
            this.compiledFilter.bindParameters(iArgs);
        }
        if ((index = (database = OCommandExecutorSQLDelete.getDatabase()).getMetadata().getIndexManagerInternal().getIndex(database, this.indexName).getInternal()) == null) {
            throw new OCommandExecutionException("Target index '" + this.indexName + "' not found");
        }
        OIndexAbstract.manualIndexesWarning();
        Object key = null;
        Object value = VALUE_NOT_FOUND;
        if (this.compiledFilter == null || this.compiledFilter.getRootCondition() == null) {
            if (this.returning.equalsIgnoreCase("COUNT")) {
                long total = index.size();
                index.clear();
                return total;
            }
            Iterator cursor = index.stream().iterator();
            while (cursor.hasNext()) {
                ORawPair entry = (ORawPair)cursor.next();
                OIdentifiable rec = (OIdentifiable)entry.second;
                if ((rec = rec.getRecord()) == null) continue;
                this.allDeletedRecords.add((ORecord)rec);
            }
            index.clear();
            return this.allDeletedRecords;
        }
        if ("key".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
            key = this.getIndexKey(index.getDefinition(), this.compiledFilter.getRootCondition().getRight());
        } else if ("rid".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
            value = OSQLHelper.getValue(this.compiledFilter.getRootCondition().getRight());
        } else if (this.compiledFilter.getRootCondition().getLeft() instanceof OSQLFilterCondition) {
            OSQLFilterCondition rightCondition;
            OSQLFilterCondition leftCondition = (OSQLFilterCondition)this.compiledFilter.getRootCondition().getLeft();
            if ("key".equalsIgnoreCase(leftCondition.getLeft().toString())) {
                key = this.getIndexKey(index.getDefinition(), leftCondition.getRight());
            }
            if ("rid".equalsIgnoreCase((rightCondition = (OSQLFilterCondition)this.compiledFilter.getRootCondition().getRight()).getLeft().toString())) {
                value = OSQLHelper.getValue(rightCondition.getRight());
            }
        }
        if (value != VALUE_NOT_FOUND) {
            assert (key != null);
            result = index.remove(key, (OIdentifiable)value);
        } else {
            result = index.remove(key);
        }
        if (this.returning.equalsIgnoreCase("COUNT")) {
            return result ? 1 : 0;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDistributedTimeout() {
        return OCommandExecutorSQLDelete.getDatabase().getConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean result(Object iRecord) {
        ORecordAbstract record = (ORecordAbstract)((OIdentifiable)iRecord).getRecord();
        if (record instanceof ODocument && this.compiledFilter != null && !Boolean.TRUE.equals(this.compiledFilter.evaluate(record, (ODocument)record, this.getContext()))) {
            return true;
        }
        try {
            if (record.getIdentity().isValid()) {
                OClass cls;
                if (this.returning.equalsIgnoreCase("BEFORE")) {
                    this.allDeletedRecords.add(record);
                }
                if (!this.unsafe && record instanceof ODocument && (cls = ((ODocument)record).getSchemaClass()) != null) {
                    if (cls.isSubClassOf("V")) {
                        throw new OCommandExecutionException("'DELETE' command cannot delete vertices. Use 'DELETE VERTEX' command instead, or apply the 'UNSAFE' keyword to force it");
                    }
                    if (cls.isSubClassOf("E")) {
                        throw new OCommandExecutionException("'DELETE' command cannot delete edges. Use 'DELETE EDGE' command instead, or apply the 'UNSAFE' keyword to force it");
                    }
                }
                record.delete();
                ++this.recordCount;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.lockStrategy.equalsIgnoreCase("RECORD")) {
                ((OAbstractPaginatedStorage)OCommandExecutorSQLDelete.getDatabase().getStorage()).releaseWriteLock(record.getIdentity());
            }
        }
    }

    @Override
    public String getSyntax() {
        return "DELETE FROM <Class>|RID|cluster:<cluster> [UNSAFE] [LOCK <NONE|RECORD>] [RETURN <COUNT|BEFORE>] [WHERE <condition>*]";
    }

    @Override
    public void end() {
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_DELETE;
    }

    protected String parseReturn() throws OCommandSQLParsingException {
        String returning = this.parserNextWord(true);
        if (!returning.equalsIgnoreCase("COUNT") && !returning.equalsIgnoreCase("BEFORE")) {
            this.throwParsingException("Invalid RETURN value set to '" + returning + "' but it should be COUNT (default), BEFORE. Example: " + "RETURN" + " BEFORE");
        }
        return returning;
    }

    private Object getIndexKey(OIndexDefinition indexDefinition, Object value) {
        if (indexDefinition instanceof OCompositeIndexDefinition) {
            if (value instanceof List) {
                List values = (List)value;
                ArrayList<Object> keyParams = new ArrayList<Object>(values.size());
                for (Object o : values) {
                    keyParams.add(OSQLHelper.getValue(o));
                }
                return indexDefinition.createValue(keyParams);
            }
            if ((value = OSQLHelper.getValue(value)) instanceof OCompositeKey) {
                return value;
            }
            return indexDefinition.createValue(value);
        }
        return OSQLHelper.getValue(value);
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS;
    }

    @Override
    public Object getResult() {
        return null;
    }
}

