/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import java.util.List;

public class OOrderByOptimizer {
    boolean canBeUsedByOrderBy(OIndex index, List<OPair<String, String>> orderedFields) {
        if (orderedFields.isEmpty()) {
            return false;
        }
        if (!index.supportsOrderedIterations()) {
            return false;
        }
        OIndexDefinition definition = index.getDefinition();
        List<String> fields = definition.getFields();
        int endIndex = Math.min(fields.size(), orderedFields.size());
        String firstOrder = orderedFields.get(0).getValue();
        for (int i = 0; i < endIndex; ++i) {
            String indexFieldName;
            OPair<String, String> pair = orderedFields.get(i);
            if (!firstOrder.equals(pair.getValue())) {
                return false;
            }
            String orderFieldName = (String)orderedFields.get(i).getKey();
            if (orderFieldName.equals(indexFieldName = fields.get(i))) continue;
            return false;
        }
        return true;
    }

    boolean canBeUsedByOrderByAfterFilter(OIndex index, List<String> equalsFilterFields, List<OPair<String, String>> orderedFields) {
        int i;
        if (orderedFields.isEmpty()) {
            return false;
        }
        if (!index.supportsOrderedIterations()) {
            return false;
        }
        OIndexDefinition definition = index.getDefinition();
        List<String> indexFields = definition.getFields();
        int endIndex = Math.min(indexFields.size(), equalsFilterFields.size());
        String firstOrder = orderedFields.get(0).getValue();
        for (i = 0; i < endIndex; ++i) {
            String indexFieldName;
            String equalsFieldName = equalsFilterFields.get(i);
            if (equalsFieldName.equals(indexFieldName = indexFields.get(i))) continue;
            return false;
        }
        endIndex = Math.min(indexFields.size(), orderedFields.size() + equalsFilterFields.size());
        if (endIndex == equalsFilterFields.size()) {
            return false;
        }
        for (i = equalsFilterFields.size(); i < endIndex; ++i) {
            String indexFieldName;
            int fieldOrderInOrderByClause = i - equalsFilterFields.size();
            OPair<String, String> pair = orderedFields.get(fieldOrderInOrderByClause);
            if (!firstOrder.equals(pair.getValue())) {
                return false;
            }
            String orderFieldName = (String)pair.getKey();
            if (orderFieldName.equals(indexFieldName = indexFields.get(i))) continue;
            return false;
        }
        return true;
    }
}

