/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import java.util.Map;
import java.util.Optional;

public class CountFromIndexStep
extends AbstractExecutionStep {
    private final OIndexIdentifier target;
    private final String alias;
    private long count = 0L;
    private boolean executed = false;

    public CountFromIndexStep(OIndexIdentifier targetIndex, String alias, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.target = targetIndex;
        this.alias = alias;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return !CountFromIndexStep.this.executed;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                if (CountFromIndexStep.this.executed) {
                    throw new IllegalStateException();
                }
                long begin = CountFromIndexStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    ODatabaseDocumentInternal database = (ODatabaseDocumentInternal)ctx.getDatabase();
                    OIndexInternal idx = database.getMetadata().getIndexManagerInternal().getIndex(database, CountFromIndexStep.this.target.getIndexName()).getInternal();
                    long size = idx.size();
                    CountFromIndexStep.this.executed = true;
                    OResultInternal result = new OResultInternal();
                    result.setProperty(CountFromIndexStep.this.alias, size);
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    CountFromIndexStep.this.count = CountFromIndexStep.this.count + (System.nanoTime() - begin);
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }

            @Override
            public void reset() {
                CountFromIndexStep.this.reset();
            }
        };
    }

    @Override
    public void reset() {
        this.executed = false;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        return spaces + "+ CALCULATE INDEX SIZE: " + this.target;
    }
}

