/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBetweenCondition;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OCollection;
import com.orientechnologies.orient.core.sql.parser.OEqualsCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OGeOperator;
import com.orientechnologies.orient.core.sql.parser.OGtOperator;
import com.orientechnologies.orient.core.sql.parser.OLeOperator;
import com.orientechnologies.orient.core.sql.parser.OLtOperator;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class DeleteFromIndexStep
extends AbstractExecutionStep {
    protected final OIndexInternal index;
    private final OBinaryCondition additional;
    private final OBooleanExpression ridCondition;
    private final boolean orderAsc;
    private ORawPair<Object, ORID> nextEntry = null;
    private final OBooleanExpression condition;
    private boolean inited = false;
    private Stream<ORawPair<Object, ORID>> stream;
    private Iterator<ORawPair<Object, ORID>> streamIterator;
    private long cost = 0L;
    private final Set<Stream<ORawPair<Object, ORID>>> acquiredStreams = Collections.newSetFromMap(new IdentityHashMap());

    public DeleteFromIndexStep(OIndex index, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, OBooleanExpression ridCondition, OCommandContext ctx, boolean profilingEnabled) {
        this(index, condition, additionalRangeCondition, ridCondition, true, ctx, profilingEnabled);
    }

    private DeleteFromIndexStep(OIndex index, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, OBooleanExpression ridCondition, boolean orderAsc, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.index = index.getInternal();
        this.condition = condition;
        this.additional = additionalRangeCondition;
        this.ridCondition = ridCondition;
        this.orderAsc = orderAsc;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init();
        return new OResultSet(){
            private int localCount = 0;

            @Override
            public boolean hasNext() {
                return this.localCount < nRecords && DeleteFromIndexStep.this.nextEntry != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                long begin = DeleteFromIndexStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    ORawPair entry = DeleteFromIndexStep.this.nextEntry;
                    OResultInternal result = new OResultInternal();
                    ORID value = (ORID)entry.second;
                    DeleteFromIndexStep.this.index.remove(entry.first, value);
                    ++this.localCount;
                    DeleteFromIndexStep.this.nextEntry = DeleteFromIndexStep.this.loadNextEntry(ctx);
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    if (DeleteFromIndexStep.this.profilingEnabled) {
                        DeleteFromIndexStep.this.cost = DeleteFromIndexStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                DeleteFromIndexStep.this.closeStreams();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void closeStreams() {
        for (Stream<ORawPair<Object, ORID>> stream : this.acquiredStreams) {
            stream.close();
        }
        this.acquiredStreams.clear();
    }

    @Override
    public void close() {
        super.close();
        this.closeStreams();
    }

    private synchronized void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            this.init(this.condition);
            this.nextEntry = this.loadNextEntry(this.ctx);
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    private ORawPair<Object, ORID> loadNextEntry(OCommandContext commandContext) {
        while (this.streamIterator.hasNext()) {
            ORawPair<Object, ORID> entry = this.streamIterator.next();
            if (this.ridCondition == null) {
                return entry;
            }
            OResultInternal res = new OResultInternal();
            res.setProperty("rid", entry.second);
            if (!this.ridCondition.evaluate(res, commandContext)) continue;
            return entry;
        }
        return null;
    }

    private void init(OBooleanExpression condition) {
        if (this.index.getDefinition() == null) {
            return;
        }
        if (condition == null) {
            this.processFlatIteration();
        } else if (condition instanceof OBinaryCondition) {
            this.processBinaryCondition();
        } else if (condition instanceof OBetweenCondition) {
            this.processBetweenCondition();
        } else if (condition instanceof OAndBlock) {
            this.processAndBlock();
        } else {
            throw new OCommandExecutionException("search for index for " + condition + " is not supported yet");
        }
    }

    private void processAndBlock() {
        OCollection fromKey = DeleteFromIndexStep.indexKeyFrom((OAndBlock)this.condition, this.additional);
        OCollection toKey = DeleteFromIndexStep.indexKeyTo((OAndBlock)this.condition, this.additional);
        boolean fromKeyIncluded = DeleteFromIndexStep.indexKeyFromIncluded((OAndBlock)this.condition, this.additional);
        boolean toKeyIncluded = DeleteFromIndexStep.indexKeyToIncluded((OAndBlock)this.condition, this.additional);
        this.init(fromKey, fromKeyIncluded, toKey, toKeyIncluded);
    }

    private void processFlatIteration() {
        this.stream = this.orderAsc ? this.index.stream() : this.index.descStream();
        this.storeAcquiredStream(this.stream);
        this.streamIterator = this.stream.iterator();
    }

    private void storeAcquiredStream(Stream<ORawPair<Object, ORID>> stream) {
        if (stream != null) {
            this.acquiredStreams.add(stream);
        }
    }

    private void init(OCollection fromKey, boolean fromKeyIncluded, OCollection toKey, boolean toKeyIncluded) {
        Object secondValue = fromKey.execute((OResult)null, this.ctx);
        Object thirdValue = toKey.execute((OResult)null, this.ctx);
        OIndexDefinition indexDef = this.index.getDefinition();
        if (this.index.supportsOrderedIterations()) {
            this.stream = this.index.streamEntriesBetween(DeleteFromIndexStep.toBetweenIndexKey(indexDef, secondValue), fromKeyIncluded, DeleteFromIndexStep.toBetweenIndexKey(indexDef, thirdValue), toKeyIncluded, this.orderAsc);
            this.storeAcquiredStream(this.stream);
        } else if (this.additional == null && DeleteFromIndexStep.allEqualities((OAndBlock)this.condition)) {
            this.stream = this.index.streamEntries(DeleteFromIndexStep.toIndexKey(indexDef, secondValue), this.orderAsc);
            this.storeAcquiredStream(this.stream);
        } else {
            throw new UnsupportedOperationException("Cannot evaluate " + this.condition + " on index " + this.index);
        }
        this.streamIterator = this.stream.iterator();
    }

    private static boolean allEqualities(OAndBlock condition) {
        if (condition == null) {
            return false;
        }
        for (OBooleanExpression exp : condition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                if (!(((OBinaryCondition)exp).getOperator() instanceof OEqualsCompareOperator)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void processBetweenCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OExpression key = ((OBetweenCondition)this.condition).getFirst();
        if (!key.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        OExpression second = ((OBetweenCondition)this.condition).getSecond();
        OExpression third = ((OBetweenCondition)this.condition).getThird();
        Object secondValue = second.execute((OResult)null, this.ctx);
        Object thirdValue = third.execute((OResult)null, this.ctx);
        this.stream = this.index.streamEntriesBetween(DeleteFromIndexStep.toBetweenIndexKey(definition, secondValue), true, DeleteFromIndexStep.toBetweenIndexKey(definition, thirdValue), true, this.orderAsc);
        this.storeAcquiredStream(this.stream);
        this.streamIterator = this.stream.iterator();
    }

    private void processBinaryCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OBinaryCompareOperator operator = ((OBinaryCondition)this.condition).getOperator();
        OExpression left = ((OBinaryCondition)this.condition).getLeft();
        if (!left.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        Object rightValue = ((OBinaryCondition)this.condition).getRight().execute((OResult)null, this.ctx);
        this.stream = this.createStream(operator, definition, rightValue, this.ctx);
        this.storeAcquiredStream(this.stream);
        this.streamIterator = this.stream.iterator();
    }

    private static Collection toIndexKey(OIndexDefinition definition, Object rightValue) {
        if (definition.getFields().size() == 1 && rightValue instanceof Collection) {
            rightValue = ((Collection)rightValue).iterator().next();
        }
        if (!((rightValue = rightValue instanceof List ? definition.createValue((List)rightValue) : definition.createValue(rightValue)) instanceof Collection)) {
            rightValue = Collections.singleton(rightValue);
        }
        return (Collection)rightValue;
    }

    private static Object toBetweenIndexKey(OIndexDefinition definition, Object rightValue) {
        if (definition.getFields().size() == 1 && rightValue instanceof Collection) {
            rightValue = ((Collection)rightValue).iterator().next();
        }
        rightValue = definition.createValue(rightValue);
        if (definition.getFields().size() > 1 && !(rightValue instanceof Collection)) {
            rightValue = Collections.singleton(rightValue);
        }
        return rightValue;
    }

    private Stream<ORawPair<Object, ORID>> createStream(OBinaryCompareOperator operator, OIndexDefinition definition, Object value, OCommandContext ctx) {
        boolean orderAsc = this.orderAsc;
        if (operator instanceof OEqualsCompareOperator) {
            return this.index.streamEntries(DeleteFromIndexStep.toIndexKey(definition, value), orderAsc);
        }
        if (operator instanceof OGeOperator) {
            return this.index.streamEntriesMajor(value, true, orderAsc);
        }
        if (operator instanceof OGtOperator) {
            return this.index.streamEntriesMajor(value, false, orderAsc);
        }
        if (operator instanceof OLeOperator) {
            return this.index.streamEntriesMinor(value, true, orderAsc);
        }
        if (operator instanceof OLtOperator) {
            return this.index.streamEntriesMinor(value, false, orderAsc);
        }
        throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
    }

    protected boolean isOrderAsc() {
        return this.orderAsc;
    }

    private static OCollection indexKeyFrom(OAndBlock keyCondition, OBinaryCondition additional) {
        OCollection result = new OCollection(-1);
        for (OBooleanExpression exp : keyCondition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                OBinaryCondition binaryCond = (OBinaryCondition)exp;
                OBinaryCompareOperator operator = binaryCond.getOperator();
                if (operator instanceof OEqualsCompareOperator || operator instanceof OGtOperator || operator instanceof OGeOperator) {
                    result.add(binaryCond.getRight());
                    continue;
                }
                if (additional == null) continue;
                result.add(additional.getRight());
                continue;
            }
            throw new UnsupportedOperationException("Cannot execute index query with " + exp);
        }
        return result;
    }

    private static OCollection indexKeyTo(OAndBlock keyCondition, OBinaryCondition additional) {
        OCollection result = new OCollection(-1);
        for (OBooleanExpression exp : keyCondition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                OBinaryCondition binaryCond = (OBinaryCondition)exp;
                OBinaryCompareOperator operator = binaryCond.getOperator();
                if (operator instanceof OEqualsCompareOperator || operator instanceof OLtOperator || operator instanceof OLeOperator) {
                    result.add(binaryCond.getRight());
                    continue;
                }
                if (additional == null) continue;
                result.add(additional.getRight());
                continue;
            }
            throw new UnsupportedOperationException("Cannot execute index query with " + exp);
        }
        return result;
    }

    private static boolean indexKeyFromIncluded(OAndBlock keyCondition, OBinaryCondition additional) {
        OBooleanExpression exp = keyCondition.getSubBlocks().get(keyCondition.getSubBlocks().size() - 1);
        if (exp instanceof OBinaryCondition) {
            OBinaryCompareOperator operator = ((OBinaryCondition)exp).getOperator();
            OBinaryCompareOperator additionalOperator = Optional.ofNullable(additional).map(OBinaryCondition::getOperator).orElse(null);
            if (DeleteFromIndexStep.isGreaterOperator(operator)) {
                return DeleteFromIndexStep.isIncludeOperator(operator);
            }
            return additionalOperator == null || DeleteFromIndexStep.isIncludeOperator(additionalOperator) && DeleteFromIndexStep.isGreaterOperator(additionalOperator);
        }
        throw new UnsupportedOperationException("Cannot execute index query with " + exp);
    }

    private static boolean isGreaterOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OGeOperator || operator instanceof OGtOperator;
    }

    private static boolean isLessOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OLeOperator || operator instanceof OLtOperator;
    }

    private static boolean isIncludeOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OGeOperator || operator instanceof OLeOperator;
    }

    private static boolean indexKeyToIncluded(OAndBlock keyCondition, OBinaryCondition additional) {
        OBooleanExpression exp = keyCondition.getSubBlocks().get(keyCondition.getSubBlocks().size() - 1);
        if (exp instanceof OBinaryCondition) {
            OBinaryCompareOperator operator = ((OBinaryCondition)exp).getOperator();
            OBinaryCompareOperator additionalOperator = Optional.ofNullable(additional).map(OBinaryCondition::getOperator).orElse(null);
            if (DeleteFromIndexStep.isLessOperator(operator)) {
                return DeleteFromIndexStep.isIncludeOperator(operator);
            }
            return additionalOperator == null || DeleteFromIndexStep.isIncludeOperator(additionalOperator) && DeleteFromIndexStep.isLessOperator(additionalOperator);
        }
        throw new UnsupportedOperationException("Cannot execute index query with " + exp);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ DELETE FROM INDEX " + this.index.getName();
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        String additional = Optional.ofNullable(this.additional).map(oBinaryCondition -> " and " + oBinaryCondition).orElse("");
        result = result + Optional.ofNullable(this.condition).map(oBooleanExpression -> "\n" + OExecutionStepInternal.getIndent(depth, indent) + "  " + oBooleanExpression + additional).orElse("");
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

