/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.viewmanager.ViewManager;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OCommandInterruptedException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OQueryStats;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OBetweenCondition;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OCollection;
import com.orientechnologies.orient.core.sql.parser.OContainsAnyCondition;
import com.orientechnologies.orient.core.sql.parser.OContainsKeyOperator;
import com.orientechnologies.orient.core.sql.parser.OContainsTextCondition;
import com.orientechnologies.orient.core.sql.parser.OContainsValueOperator;
import com.orientechnologies.orient.core.sql.parser.OEqualsCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OGeOperator;
import com.orientechnologies.orient.core.sql.parser.OGtOperator;
import com.orientechnologies.orient.core.sql.parser.OInCondition;
import com.orientechnologies.orient.core.sql.parser.OLeOperator;
import com.orientechnologies.orient.core.sql.parser.OLtOperator;
import com.orientechnologies.orient.core.sql.parser.OValueExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FetchFromIndexStep
extends AbstractExecutionStep {
    protected OIndexInternal index;
    protected OBooleanExpression condition;
    private OBinaryCondition additionalRangeCondition;
    private boolean orderAsc;
    protected String indexName;
    private long cost = 0L;
    private long count = 0L;
    private boolean inited = false;
    private Stream<ORawPair<Object, ORID>> stream;
    private Iterator<ORawPair<Object, ORID>> indexIterator;
    private final List<Stream<ORawPair<Object, ORID>>> nextStreams = new ArrayList<Stream<ORawPair<Object, ORID>>>();
    private OMultiCollectionIterator<Map.Entry<Object, OIdentifiable>> customIterator;
    private Iterator nullKeyIterator;
    private ORawPair<Object, ORID> nextEntry = null;
    private final Set<Stream<ORawPair<Object, ORID>>> acquiredStreams = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<Stream<ORID>> acquiredRidStreams = new HashSet<Stream<ORID>>();

    public FetchFromIndexStep(OIndex index, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, OCommandContext ctx, boolean profilingEnabled) {
        this(index, condition, additionalRangeCondition, true, ctx, profilingEnabled);
    }

    public FetchFromIndexStep(OIndex index, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, boolean orderAsc, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.index = index.getInternal();
        this.indexName = index.getName();
        this.condition = condition;
        this.additionalRangeCondition = additionalRangeCondition;
        this.orderAsc = orderAsc;
        OSharedContext sharedContext = ((ODatabaseDocumentInternal)ctx.getDatabase()).getSharedContext();
        ViewManager viewManager = sharedContext.getViewManager();
        viewManager.startUsingViewIndex(this.indexName);
    }

    private FetchFromIndexStep(String indexName, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, boolean orderAsc, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.indexName = indexName;
        this.condition = condition;
        this.additionalRangeCondition = additionalRangeCondition;
        this.orderAsc = orderAsc;
        OSharedContext sharedContext = ((ODatabaseDocumentInternal)ctx.getDatabase()).getSharedContext();
        ViewManager viewManager = sharedContext.getViewManager();
        viewManager.startUsingViewIndex(indexName);
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init(ctx.getDatabase());
        return new OResultSet(){
            private int localCount = 0;

            @Override
            public boolean hasNext() {
                if (FetchFromIndexStep.this.timedOut) {
                    throw new OTimeoutException("Command execution timeout");
                }
                if (this.localCount >= nRecords) {
                    return false;
                }
                if (FetchFromIndexStep.this.nextEntry == null) {
                    FetchFromIndexStep.this.fetchNextEntry();
                }
                return FetchFromIndexStep.this.nextEntry != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                if (this.localCount % 100 == 0 && OExecutionThreadLocal.isInterruptCurrentOperation()) {
                    throw new OCommandInterruptedException("The command has been interrupted");
                }
                long begin = FetchFromIndexStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    Object key = ((FetchFromIndexStep)FetchFromIndexStep.this).nextEntry.first;
                    OIdentifiable value = (OIdentifiable)((FetchFromIndexStep)FetchFromIndexStep.this).nextEntry.second;
                    FetchFromIndexStep.this.nextEntry = null;
                    ++this.localCount;
                    OResultInternal result = new OResultInternal();
                    result.setProperty("key", FetchFromIndexStep.convertKey(key));
                    result.setProperty("rid", value);
                    ctx.setVariable("$current", result);
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    if (FetchFromIndexStep.this.profilingEnabled) {
                        FetchFromIndexStep.this.cost = FetchFromIndexStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                FetchFromIndexStep.this.closeStreams();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private static Object convertKey(Object key) {
        if (key instanceof OCompositeKey) {
            return new ArrayList<Object>(((OCompositeKey)key).getKeys());
        }
        return key;
    }

    private void fetchNextEntry() {
        this.nextEntry = null;
        if (this.stream != null) {
            while (!this.indexIterator.hasNext()) {
                if (!this.nextStreams.isEmpty()) {
                    this.stream = this.nextStreams.remove(0);
                    this.storeAcquiredStream(this.stream);
                    this.cursorToIterator();
                    continue;
                }
                this.stream = null;
                this.indexIterator = null;
                break;
            }
            if (this.indexIterator != null) {
                this.nextEntry = this.indexIterator.next();
            }
        }
        if (this.nextEntry == null && this.customIterator != null && this.customIterator.hasNext()) {
            Map.Entry<Object, OIdentifiable> entry = this.customIterator.next();
            this.nextEntry = new ORawPair<Object, ORID>(entry.getKey(), entry.getValue().getIdentity());
        }
        if (this.nextEntry == null && this.nullKeyIterator != null && this.nullKeyIterator.hasNext()) {
            OIdentifiable nextValue = (OIdentifiable)this.nullKeyIterator.next();
            this.nextEntry = new ORawPair<Object, ORID>(null, nextValue.getIdentity());
        }
        if (this.nextEntry == null) {
            this.updateIndexStats();
        } else {
            ++this.count;
        }
    }

    private void storeAcquiredStream(Stream<ORawPair<Object, ORID>> stream) {
        if (stream != null) {
            this.acquiredStreams.add(stream);
        }
    }

    private void updateIndexStats() {
        OQueryStats stats = OQueryStats.get((ODatabaseDocumentInternal)this.ctx.getDatabase());
        if (this.index == null) {
            return;
        }
        String indexName = this.index.getName();
        boolean range = false;
        int size = 0;
        if (this.condition != null) {
            if (this.condition instanceof OBinaryCondition) {
                size = 1;
            } else if (this.condition instanceof OBetweenCondition) {
                size = 1;
                range = true;
            } else if (this.condition instanceof OAndBlock) {
                OAndBlock andBlock = (OAndBlock)this.condition;
                size = andBlock.getSubBlocks().size();
                OBooleanExpression lastOp = andBlock.getSubBlocks().get(andBlock.getSubBlocks().size() - 1);
                if (lastOp instanceof OBinaryCondition) {
                    OBinaryCompareOperator op = ((OBinaryCondition)lastOp).getOperator();
                    range = op.isRangeOperator();
                }
            } else if (this.condition instanceof OInCondition) {
                size = 1;
            }
        }
        stats.pushIndexStats(indexName, size, range, this.additionalRangeCondition != null, this.count);
    }

    private synchronized void init(ODatabase db) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.init(this.condition, (ODatabaseDocumentInternal)db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(OBooleanExpression condition, ODatabaseDocumentInternal db) {
        block12: {
            long begin;
            long l = begin = this.profilingEnabled ? System.nanoTime() : 0L;
            if (this.index == null) {
                this.index = db.getMetadata().getIndexManagerInternal().getIndex(db, this.indexName).getInternal();
            }
            try {
                if (this.index.getDefinition() == null) {
                    return;
                }
                if (condition == null) {
                    this.processFlatIteration();
                    break block12;
                }
                if (condition instanceof OBinaryCondition) {
                    this.processBinaryCondition();
                    break block12;
                }
                if (condition instanceof OBetweenCondition) {
                    this.processBetweenCondition();
                    break block12;
                }
                if (condition instanceof OAndBlock) {
                    this.processAndBlock();
                    break block12;
                }
                if (condition instanceof OInCondition) {
                    this.processInCondition();
                    break block12;
                }
                throw new OCommandExecutionException("search for index for " + condition + " is not supported yet");
            }
            finally {
                if (this.profilingEnabled) {
                    this.cost += System.nanoTime() - begin;
                }
            }
        }
    }

    private void processInCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OInCondition inCondition = (OInCondition)this.condition;
        OExpression left = inCondition.getLeft();
        if (!left.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        Object rightValue = inCondition.evaluateRight((OResult)null, this.ctx);
        OEqualsCompareOperator equals = new OEqualsCompareOperator(-1);
        if (OMultiValue.isMultiValue(rightValue)) {
            this.customIterator = new OMultiCollectionIterator();
            for (Object item : OMultiValue.getMultiValueIterable(rightValue)) {
                if (item instanceof OResult) {
                    if (((OResult)item).isElement()) {
                        item = ((OResult)item).getElement().orElseThrow(IllegalStateException::new);
                    } else if (((OResult)item).getPropertyNames().size() == 1) {
                        item = ((OResult)item).getProperty(((OResult)item).getPropertyNames().iterator().next());
                    }
                }
                final Iterator localCursor = this.createCursor(equals, definition, item, this.ctx).iterator();
                final Object itemRef = item;
                this.customIterator.add(new Iterator<Map.Entry>(){

                    @Override
                    public boolean hasNext() {
                        return localCursor.hasNext();
                    }

                    @Override
                    public Map.Entry next() {
                        if (!localCursor.hasNext()) {
                            throw new IllegalStateException();
                        }
                        final ORawPair value = (ORawPair)localCursor.next();
                        return new Map.Entry(){

                            public Object getKey() {
                                return itemRef;
                            }

                            public Object getValue() {
                                return value.second;
                            }

                            public Object setValue(Object value2) {
                                return null;
                            }
                        };
                    }
                });
            }
            this.customIterator.reset();
        } else {
            this.stream = this.createCursor(equals, definition, rightValue, this.ctx);
            this.storeAcquiredStream(this.stream);
            this.cursorToIterator();
        }
        this.fetchNextEntry();
    }

    private void processAndBlock() {
        OCollection fromKey = FetchFromIndexStep.indexKeyFrom((OAndBlock)this.condition, this.additionalRangeCondition);
        OCollection toKey = FetchFromIndexStep.indexKeyTo((OAndBlock)this.condition, this.additionalRangeCondition);
        boolean fromKeyIncluded = FetchFromIndexStep.indexKeyFromIncluded((OAndBlock)this.condition, this.additionalRangeCondition);
        boolean toKeyIncluded = FetchFromIndexStep.indexKeyToIncluded((OAndBlock)this.condition, this.additionalRangeCondition);
        this.init(fromKey, fromKeyIncluded, toKey, toKeyIncluded);
    }

    private void processFlatIteration() {
        this.stream = this.isOrderAsc() ? this.index.stream() : this.index.descStream();
        this.storeAcquiredStream(this.stream);
        this.cursorToIterator();
        this.fetchNullKeys();
        if (this.stream != null) {
            this.fetchNextEntry();
        }
    }

    private void fetchNullKeys() {
        if (this.index.getDefinition().isNullValuesIgnored()) {
            this.nullKeyIterator = Collections.emptyIterator();
            return;
        }
        Stream<ORID> stream = this.index.getRids(null);
        this.acquiredRidStreams.add(stream);
        this.nullKeyIterator = stream.iterator();
    }

    private void init(OCollection fromKey, boolean fromKeyIncluded, OCollection toKey, boolean toKeyIncluded) {
        List<OCollection> secondValueCombinations = this.cartesianProduct(fromKey);
        List<OCollection> thirdValueCombinations = this.cartesianProduct(toKey);
        OIndexDefinition indexDef = this.index.getDefinition();
        for (int i = 0; i < secondValueCombinations.size(); ++i) {
            Object secondValue = secondValueCombinations.get(i).execute((OResult)null, this.ctx);
            if (secondValue instanceof List && ((List)secondValue).size() == 1 && indexDef.getFields().size() == 1 && !(indexDef instanceof OIndexDefinitionMultiValue)) {
                secondValue = ((List)secondValue).get(0);
            }
            secondValue = FetchFromIndexStep.unboxOResult(secondValue);
            Object thirdValue = thirdValueCombinations.get(i).execute((OResult)null, this.ctx);
            if (thirdValue instanceof List && ((List)thirdValue).size() == 1 && indexDef.getFields().size() == 1 && !(indexDef instanceof OIndexDefinitionMultiValue)) {
                thirdValue = ((List)thirdValue).get(0);
            }
            thirdValue = FetchFromIndexStep.unboxOResult(thirdValue);
            try {
                secondValue = this.convertToIndexDefinitionTypes(secondValue, indexDef.getTypes());
                thirdValue = this.convertToIndexDefinitionTypes(thirdValue, indexDef.getTypes());
            }
            catch (Exception e) {
                if (!(secondValue instanceof Collection) || !secondValue.equals(thirdValue)) continue;
                ((Collection)secondValue).forEach(item -> {
                    Object itemVal = this.convertToIndexDefinitionTypes(item, indexDef.getTypes());
                    if (this.index.supportsOrderedIterations()) {
                        Object from = FetchFromIndexStep.toBetweenIndexKey(indexDef, itemVal);
                        Object to = FetchFromIndexStep.toBetweenIndexKey(indexDef, itemVal);
                        if (from == null && to == null) {
                            this.stream = this.getStreamForNullKey();
                            this.storeAcquiredStream(this.stream);
                        } else {
                            this.stream = this.index.streamEntriesBetween(from, fromKeyIncluded, to, toKeyIncluded, this.isOrderAsc());
                            this.storeAcquiredStream(this.stream);
                        }
                    } else if (this.additionalRangeCondition == null && FetchFromIndexStep.allEqualities((OAndBlock)this.condition)) {
                        this.stream = this.index.streamEntries(FetchFromIndexStep.toIndexKey(indexDef, itemVal), this.isOrderAsc());
                        this.storeAcquiredStream(this.stream);
                    } else if (FetchFromIndexStep.isFullTextIndex(this.index)) {
                        this.stream = this.index.streamEntries(FetchFromIndexStep.toIndexKey(indexDef, itemVal), this.isOrderAsc());
                        this.storeAcquiredStream(this.stream);
                    } else {
                        throw new UnsupportedOperationException("Cannot evaluate " + this.condition + " on index " + this.index);
                    }
                    this.nextStreams.add(this.stream);
                });
                continue;
            }
            if (this.index.supportsOrderedIterations()) {
                Object from = FetchFromIndexStep.toBetweenIndexKey(indexDef, secondValue);
                Object to = FetchFromIndexStep.toBetweenIndexKey(indexDef, thirdValue);
                if (from == null && to == null) {
                    this.stream = this.getStreamForNullKey();
                    this.storeAcquiredStream(this.stream);
                } else {
                    this.stream = this.index.streamEntriesBetween(from, fromKeyIncluded, to, toKeyIncluded, this.isOrderAsc());
                    this.storeAcquiredStream(this.stream);
                }
            } else if (this.additionalRangeCondition == null && FetchFromIndexStep.allEqualities((OAndBlock)this.condition)) {
                this.stream = this.index.streamEntries(FetchFromIndexStep.toIndexKey(indexDef, secondValue), this.isOrderAsc());
                this.storeAcquiredStream(this.stream);
            } else if (FetchFromIndexStep.isFullTextIndex(this.index)) {
                this.stream = this.index.streamEntries(FetchFromIndexStep.toIndexKey(indexDef, secondValue), this.isOrderAsc());
                this.storeAcquiredStream(this.stream);
            } else {
                throw new UnsupportedOperationException("Cannot evaluate " + this.condition + " on index " + this.index);
            }
            this.nextStreams.add(this.stream);
        }
        if (this.nextStreams.size() > 0) {
            this.stream = this.nextStreams.remove(0);
            this.storeAcquiredStream(this.stream);
            this.cursorToIterator();
            this.fetchNextEntry();
        }
    }

    private void cursorToIterator() {
        this.indexIterator = this.stream != null ? this.stream.iterator() : null;
    }

    private static boolean isFullTextIndex(OIndex index) {
        return index.getType().equalsIgnoreCase("FULLTEXT") && !index.getAlgorithm().equalsIgnoreCase("LUCENE");
    }

    private Stream<ORawPair<Object, ORID>> getStreamForNullKey() {
        Stream<ORID> stream = this.index.getRids(null);
        this.acquiredRidStreams.add(stream);
        return stream.map(rid -> new ORawPair<Object, ORID>(null, (ORID)rid));
    }

    private static Object unboxOResult(Object value) {
        if (value instanceof List) {
            try (Stream stream = ((List)value).stream();){
                List list = stream.map(FetchFromIndexStep::unboxOResult).collect(Collectors.toList());
                return list;
            }
        }
        if (value instanceof OResult) {
            if (((OResult)value).isElement()) {
                return ((OResult)value).getIdentity().orElse(null);
            }
            Set<String> props2 = ((OResult)value).getPropertyNames();
            if (props2.size() == 1) {
                return ((OResult)value).getProperty(props2.iterator().next());
            }
        }
        return value;
    }

    private List<OCollection> cartesianProduct(OCollection key) {
        return this.cartesianProduct(new OCollection(-1), key);
    }

    private List<OCollection> cartesianProduct(OCollection head, OCollection key) {
        if (key.getExpressions().size() == 0) {
            return Collections.singletonList(head);
        }
        OExpression nextElementInKey = key.getExpressions().get(0);
        Object value = nextElementInKey.execute(new OResultInternal(), this.ctx);
        if (value instanceof Iterable && !(value instanceof OIdentifiable)) {
            ArrayList<OCollection> result = new ArrayList<OCollection>();
            for (Object elemInKey : (Collection)value) {
                OCollection newHead = new OCollection(-1);
                for (OExpression exp : head.getExpressions()) {
                    newHead.add(exp.copy());
                }
                newHead.add(FetchFromIndexStep.toExpression(elemInKey, this.ctx));
                OCollection tail = key.copy();
                tail.getExpressions().remove(0);
                result.addAll(this.cartesianProduct(newHead, tail));
            }
            return result;
        }
        OCollection newHead = new OCollection(-1);
        for (OExpression exp : head.getExpressions()) {
            newHead.add(exp.copy());
        }
        newHead.add(nextElementInKey);
        OCollection tail = key.copy();
        tail.getExpressions().remove(0);
        return this.cartesianProduct(newHead, tail);
    }

    private static OExpression toExpression(Object value, OCommandContext ctx) {
        return new OValueExpression(value);
    }

    private Object convertToIndexDefinitionTypes(Object val, OType[] types) {
        if (val == null) {
            return null;
        }
        if (OMultiValue.isMultiValue(val)) {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            for (Object o : OMultiValue.getMultiValueIterable(val)) {
                result.add(OType.convert(o, types[i++].getDefaultJavaType()));
            }
            if (this.condition instanceof OAndBlock) {
                for (int j = 0; j < ((OAndBlock)this.condition).getSubBlocks().size(); ++j) {
                    HashMap<Object, String> newValue;
                    OBooleanExpression subExp = ((OAndBlock)this.condition).getSubBlocks().get(j);
                    if (!(subExp instanceof OBinaryCondition)) continue;
                    if (((OBinaryCondition)subExp).getOperator() instanceof OContainsKeyOperator) {
                        newValue = new HashMap<Object, String>();
                        newValue.put(result.get(j), "");
                        result.set(j, newValue);
                        continue;
                    }
                    if (!(((OBinaryCondition)subExp).getOperator() instanceof OContainsValueOperator)) continue;
                    newValue = new HashMap();
                    newValue.put("", (String)result.get(j));
                    result.set(j, newValue);
                }
            }
            return result;
        }
        return OType.convert(val, types[0].getDefaultJavaType());
    }

    private static boolean allEqualities(OAndBlock condition) {
        if (condition == null) {
            return false;
        }
        for (OBooleanExpression exp : condition.getSubBlocks()) {
            if (!(exp instanceof OBinaryCondition ? !(((OBinaryCondition)exp).getOperator() instanceof OEqualsCompareOperator) && !(((OBinaryCondition)exp).getOperator() instanceof OContainsKeyOperator) && !(((OBinaryCondition)exp).getOperator() instanceof OContainsValueOperator) : !(exp instanceof OInCondition))) continue;
            return false;
        }
        return true;
    }

    private void processBetweenCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OExpression key = ((OBetweenCondition)this.condition).getFirst();
        if (!key.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        OExpression second = ((OBetweenCondition)this.condition).getSecond();
        OExpression third = ((OBetweenCondition)this.condition).getThird();
        Object secondValue = second.execute((OResult)null, this.ctx);
        secondValue = FetchFromIndexStep.unboxOResult(secondValue);
        Object thirdValue = third.execute((OResult)null, this.ctx);
        thirdValue = FetchFromIndexStep.unboxOResult(thirdValue);
        this.stream = this.index.streamEntriesBetween(FetchFromIndexStep.toBetweenIndexKey(definition, secondValue), true, FetchFromIndexStep.toBetweenIndexKey(definition, thirdValue), true, this.isOrderAsc());
        this.storeAcquiredStream(this.stream);
        this.cursorToIterator();
        if (this.stream != null) {
            this.fetchNextEntry();
        }
    }

    private void processBinaryCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OBinaryCompareOperator operator = ((OBinaryCondition)this.condition).getOperator();
        OExpression left = ((OBinaryCondition)this.condition).getLeft();
        if (!left.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        Object rightValue = ((OBinaryCondition)this.condition).getRight().execute((OResult)null, this.ctx);
        this.stream = this.createCursor(operator, definition, rightValue, this.ctx);
        this.storeAcquiredStream(this.stream);
        this.cursorToIterator();
        if (this.stream != null) {
            this.fetchNextEntry();
        }
    }

    private static Collection toIndexKey(OIndexDefinition definition, Object rightValue) {
        if (definition.getFields().size() == 1 && rightValue instanceof Collection) {
            rightValue = ((Collection)rightValue).iterator().next();
        }
        if (rightValue instanceof List) {
            rightValue = definition.createValue((List)rightValue);
        } else if (!(rightValue instanceof OCompositeKey)) {
            rightValue = definition.createValue(rightValue);
        }
        if (!(rightValue instanceof Collection)) {
            rightValue = Collections.singleton(rightValue);
        }
        return (Collection)rightValue;
    }

    private static Object toBetweenIndexKey(OIndexDefinition definition, Object rightValue) {
        if (definition.getFields().size() == 1 && rightValue instanceof Collection) {
            rightValue = ((Collection)rightValue).size() > 0 ? ((Collection)rightValue).iterator().next() : null;
        }
        rightValue = rightValue instanceof Collection ? definition.createValue(((Collection)rightValue).toArray()) : definition.createValue(rightValue);
        return rightValue;
    }

    private Stream<ORawPair<Object, ORID>> createCursor(OBinaryCompareOperator operator, OIndexDefinition definition, Object value, OCommandContext ctx) {
        boolean orderAsc = this.isOrderAsc();
        if (operator instanceof OEqualsCompareOperator || operator instanceof OContainsKeyOperator || operator instanceof OContainsValueOperator) {
            return this.index.streamEntries(FetchFromIndexStep.toIndexKey(definition, value), orderAsc);
        }
        if (operator instanceof OGeOperator) {
            return this.index.streamEntriesMajor(value, true, orderAsc);
        }
        if (operator instanceof OGtOperator) {
            return this.index.streamEntriesMajor(value, false, orderAsc);
        }
        if (operator instanceof OLeOperator) {
            return this.index.streamEntriesMinor(value, true, orderAsc);
        }
        if (operator instanceof OLtOperator) {
            return this.index.streamEntriesMinor(value, false, orderAsc);
        }
        throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
    }

    protected boolean isOrderAsc() {
        return this.orderAsc;
    }

    private static OCollection indexKeyFrom(OAndBlock keyCondition, OBinaryCondition additional) {
        OCollection result = new OCollection(-1);
        for (OBooleanExpression exp : keyCondition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                OBinaryCondition binaryCond = (OBinaryCondition)exp;
                OBinaryCompareOperator operator = binaryCond.getOperator();
                if (operator instanceof OEqualsCompareOperator || operator instanceof OGtOperator || operator instanceof OGeOperator || operator instanceof OContainsKeyOperator || operator instanceof OContainsValueOperator) {
                    result.add(binaryCond.getRight());
                    continue;
                }
                if (additional == null) continue;
                result.add(additional.getRight());
                continue;
            }
            if (exp instanceof OInCondition) {
                OExpression item = new OExpression(-1);
                if (((OInCondition)exp).getRightMathExpression() != null) {
                    item.setMathExpression(((OInCondition)exp).getRightMathExpression());
                    result.add(item);
                    continue;
                }
                if (((OInCondition)exp).getRightParam() != null) {
                    OBaseExpression e = new OBaseExpression(-1);
                    e.setInputParam(((OInCondition)exp).getRightParam().copy());
                    item.setMathExpression(e);
                    result.add(item);
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            if (exp instanceof OContainsAnyCondition) {
                if (((OContainsAnyCondition)exp).getRight() != null) {
                    result.add(((OContainsAnyCondition)exp).getRight());
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            if (exp instanceof OContainsTextCondition) {
                if (((OContainsTextCondition)exp).getRight() != null) {
                    result.add(((OContainsTextCondition)exp).getRight());
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            throw new UnsupportedOperationException("Cannot execute index query with " + exp);
        }
        return result;
    }

    private static OCollection indexKeyTo(OAndBlock keyCondition, OBinaryCondition additional) {
        OCollection result = new OCollection(-1);
        for (OBooleanExpression exp : keyCondition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                OBinaryCondition binaryCond = (OBinaryCondition)exp;
                OBinaryCompareOperator operator = binaryCond.getOperator();
                if (operator instanceof OEqualsCompareOperator || operator instanceof OLtOperator || operator instanceof OLeOperator || operator instanceof OContainsKeyOperator || operator instanceof OContainsValueOperator) {
                    result.add(binaryCond.getRight());
                    continue;
                }
                if (additional == null) continue;
                result.add(additional.getRight());
                continue;
            }
            if (exp instanceof OInCondition) {
                OExpression item = new OExpression(-1);
                if (((OInCondition)exp).getRightMathExpression() != null) {
                    item.setMathExpression(((OInCondition)exp).getRightMathExpression());
                    result.add(item);
                    continue;
                }
                if (((OInCondition)exp).getRightParam() != null) {
                    OBaseExpression e = new OBaseExpression(-1);
                    e.setInputParam(((OInCondition)exp).getRightParam().copy());
                    item.setMathExpression(e);
                    result.add(item);
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            if (exp instanceof OContainsAnyCondition) {
                if (((OContainsAnyCondition)exp).getRight() != null) {
                    result.add(((OContainsAnyCondition)exp).getRight());
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            if (exp instanceof OContainsTextCondition) {
                result.add(((OContainsTextCondition)exp).getRight());
                continue;
            }
            throw new UnsupportedOperationException("Cannot execute index query with " + exp);
        }
        return result;
    }

    private static boolean indexKeyFromIncluded(OAndBlock keyCondition, OBinaryCondition additional) {
        OBooleanExpression exp = keyCondition.getSubBlocks().get(keyCondition.getSubBlocks().size() - 1);
        OBinaryCompareOperator additionalOperator = Optional.ofNullable(additional).map(OBinaryCondition::getOperator).orElse(null);
        if (exp instanceof OBinaryCondition) {
            OBinaryCompareOperator operator = ((OBinaryCondition)exp).getOperator();
            if (FetchFromIndexStep.isGreaterOperator(operator)) {
                return FetchFromIndexStep.isIncludeOperator(operator);
            }
            return additionalOperator == null || FetchFromIndexStep.isIncludeOperator(additionalOperator) && FetchFromIndexStep.isGreaterOperator(additionalOperator);
        }
        if (exp instanceof OInCondition || exp instanceof OContainsAnyCondition) {
            return additional == null || FetchFromIndexStep.isIncludeOperator(additionalOperator) && FetchFromIndexStep.isGreaterOperator(additionalOperator);
        }
        if (exp instanceof OContainsTextCondition) {
            return true;
        }
        throw new UnsupportedOperationException("Cannot execute index query with " + exp);
    }

    private static boolean isGreaterOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OGeOperator || operator instanceof OGtOperator;
    }

    private static boolean isLessOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OLeOperator || operator instanceof OLtOperator;
    }

    private static boolean isIncludeOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OGeOperator || operator instanceof OLeOperator;
    }

    private static boolean indexKeyToIncluded(OAndBlock keyCondition, OBinaryCondition additional) {
        OBooleanExpression exp = keyCondition.getSubBlocks().get(keyCondition.getSubBlocks().size() - 1);
        OBinaryCompareOperator additionalOperator = Optional.ofNullable(additional).map(OBinaryCondition::getOperator).orElse(null);
        if (exp instanceof OBinaryCondition) {
            OBinaryCompareOperator operator = ((OBinaryCondition)exp).getOperator();
            if (FetchFromIndexStep.isLessOperator(operator)) {
                return FetchFromIndexStep.isIncludeOperator(operator);
            }
            return additionalOperator == null || FetchFromIndexStep.isIncludeOperator(additionalOperator) && FetchFromIndexStep.isLessOperator(additionalOperator);
        }
        if (exp instanceof OInCondition || exp instanceof OContainsAnyCondition) {
            return additionalOperator == null || FetchFromIndexStep.isIncludeOperator(additionalOperator) && FetchFromIndexStep.isLessOperator(additionalOperator);
        }
        if (exp instanceof OContainsTextCondition) {
            return true;
        }
        throw new UnsupportedOperationException("Cannot execute index query with " + exp);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ FETCH FROM INDEX " + this.indexName;
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        if (this.condition != null) {
            String additional = Optional.ofNullable(this.additionalRangeCondition).map(rangeCondition -> " and " + rangeCondition).orElse("");
            result = result + "\n" + OExecutionStepInternal.getIndent(depth, indent) + "  " + this.condition + additional;
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        result.setProperty("indexName", this.index.getName());
        if (this.condition != null) {
            result.setProperty("condition", this.condition.serialize());
        }
        if (this.additionalRangeCondition != null) {
            result.setProperty("additionalRangeCondition", this.additionalRangeCondition.serialize());
        }
        result.setProperty("orderAsc", this.orderAsc);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.indexName = (String)fromResult.getProperty("indexName");
            if (fromResult.getProperty("condition") != null) {
                this.condition = OBooleanExpression.deserializeFromOResult((OResult)fromResult.getProperty("condition"));
            }
            if (fromResult.getProperty("additionalRangeCondition") != null) {
                this.additionalRangeCondition = new OBinaryCondition(-1);
                this.additionalRangeCondition.deserialize((OResult)fromResult.getProperty("additionalRangeCondition"));
            }
            this.orderAsc = (Boolean)fromResult.getProperty("orderAsc");
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }

    @Override
    public void reset() {
        this.index = null;
        this.condition = Optional.ofNullable(this.condition).map(OBooleanExpression::copy).orElse(null);
        this.additionalRangeCondition = Optional.ofNullable(this.additionalRangeCondition).map(OBinaryCondition::copy).orElse(null);
        this.cost = 0L;
        this.count = 0L;
        this.inited = false;
        this.stream = null;
        this.indexIterator = null;
        this.customIterator = null;
        this.nullKeyIterator = null;
        this.nextEntry = null;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new FetchFromIndexStep(this.indexName, (OBooleanExpression)Optional.ofNullable(this.condition).map(OBooleanExpression::copy).orElse(null), (OBinaryCondition)Optional.ofNullable(this.additionalRangeCondition).map(OBinaryCondition::copy).orElse(null), this.orderAsc, ctx, this.profilingEnabled);
    }

    private void closeStreams() {
        for (Stream<ORawPair<Object, ORID>> stream : this.acquiredStreams) {
            stream.close();
        }
        this.acquiredStreams.clear();
        for (Stream<Object> stream : this.acquiredRidStreams) {
            stream.close();
        }
        this.acquiredRidStreams.clear();
    }

    @Override
    public void close() {
        super.close();
        this.closeStreams();
        OSharedContext sharedContext = ((ODatabaseDocumentInternal)this.ctx.getDatabase()).getSharedContext();
        ViewManager viewManager = sharedContext.getViewManager();
        viewManager.endUsingViewIndex(this.indexName);
    }
}

