/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GlobalLetQueryStep
extends AbstractExecutionStep {
    private final OIdentifier varName;
    private final OInternalExecutionPlan subExecutionPlan;
    private boolean executed = false;

    public GlobalLetQueryStep(OIdentifier varName, OStatement query, OCommandContext ctx, boolean profilingEnabled, List<String> scriptVars) {
        super(ctx, profilingEnabled);
        this.varName = varName;
        OBasicCommandContext subCtx = new OBasicCommandContext();
        if (scriptVars != null) {
            scriptVars.forEach(x -> subCtx.declareScriptVariable((String)x));
        }
        subCtx.setDatabase(ctx.getDatabase());
        subCtx.setParent(ctx);
        this.subExecutionPlan = query.toString().contains("?") ? query.createExecutionPlanNoCache(subCtx, profilingEnabled) : query.createExecutionPlan(subCtx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.calculate(ctx);
        return new OInternalResultSet();
    }

    private void calculate(OCommandContext ctx) {
        if (this.executed) {
            return;
        }
        ctx.setVariable(this.varName.getStringValue(), this.toList(new OLocalResultSet(this.subExecutionPlan)));
        this.executed = true;
    }

    private List<OResult> toList(OLocalResultSet oLocalResultSet) {
        ArrayList<OResult> result = new ArrayList<OResult>();
        while (oLocalResultSet.hasNext()) {
            result.add(oLocalResultSet.next());
        }
        oLocalResultSet.close();
        return result;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        return spaces + "+ LET (once)\n" + spaces + "  " + this.varName + " = \n" + this.box(spaces + "    ", this.subExecutionPlan.prettyPrint(0, indent));
    }

    @Override
    public List<OExecutionPlan> getSubExecutionPlans() {
        return Collections.singletonList(this.subExecutionPlan);
    }

    private String box(String spaces, String s) {
        String[] rows = s.split("\n");
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+-------------------------\n");
        for (String row : rows) {
            result.append(spaces);
            result.append("| ");
            result.append(row);
            result.append("\n");
        }
        result.append(spaces);
        result.append("+-------------------------");
        return result.toString();
    }
}

