/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OScriptExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import java.util.List;

public class IfStep
extends AbstractExecutionStep {
    protected OBooleanExpression condition;
    protected OScriptExecutionPlan positivePlan;
    protected OScriptExecutionPlan negativePlan;
    private Boolean conditionMet = null;
    public List<OStatement> positiveStatements;
    public List<OStatement> negativeStatements;

    public IfStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.init(ctx);
        if (this.conditionMet.booleanValue()) {
            this.initPositivePlan(ctx);
            return this.positivePlan.fetchNext(nRecords);
        }
        this.initNegativePlan(ctx);
        if (this.negativePlan != null) {
            return this.negativePlan.fetchNext(nRecords);
        }
        return new OInternalResultSet();
    }

    protected void init(OCommandContext ctx) {
        if (this.conditionMet == null) {
            this.conditionMet = this.condition.evaluate((OResult)null, ctx);
        }
    }

    public void initPositivePlan(OCommandContext ctx) {
        if (this.positivePlan == null) {
            OBasicCommandContext subCtx1 = new OBasicCommandContext();
            subCtx1.setParent(ctx);
            OScriptExecutionPlan positivePlan = new OScriptExecutionPlan(subCtx1);
            for (OStatement stm : this.positiveStatements) {
                positivePlan.chain(stm.createExecutionPlan(subCtx1, this.profilingEnabled), this.profilingEnabled);
            }
            this.setPositivePlan(positivePlan);
        }
    }

    public void initNegativePlan(OCommandContext ctx) {
        if (this.negativePlan == null && this.negativeStatements != null && this.negativeStatements.size() > 0) {
            OBasicCommandContext subCtx2 = new OBasicCommandContext();
            subCtx2.setParent(ctx);
            OScriptExecutionPlan negativePlan = new OScriptExecutionPlan(subCtx2);
            for (OStatement stm : this.negativeStatements) {
                negativePlan.chain(stm.createExecutionPlan(subCtx2, this.profilingEnabled), this.profilingEnabled);
            }
            this.setNegativePlan(negativePlan);
        }
    }

    public OBooleanExpression getCondition() {
        return this.condition;
    }

    public void setCondition(OBooleanExpression condition) {
        this.condition = condition;
    }

    public OScriptExecutionPlan getPositivePlan() {
        return this.positivePlan;
    }

    public void setPositivePlan(OScriptExecutionPlan positivePlan) {
        this.positivePlan = positivePlan;
    }

    public OScriptExecutionPlan getNegativePlan() {
        return this.negativePlan;
    }

    public void setNegativePlan(OScriptExecutionPlan negativePlan) {
        this.negativePlan = negativePlan;
    }
}

