/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OrderByStep
extends AbstractExecutionStep {
    private final OOrderBy orderBy;
    private final long timeoutMillis;
    private Integer maxResults;
    private long cost = 0L;
    private List<OResult> cachedResult = null;
    private int nextElement = 0;

    public OrderByStep(OOrderBy orderBy, OCommandContext ctx, long timeoutMillis, boolean profilingEnabled) {
        this(orderBy, null, ctx, timeoutMillis, profilingEnabled);
    }

    public OrderByStep(OOrderBy orderBy, Integer maxResults, OCommandContext ctx, long timeoutMillis, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.orderBy = orderBy;
        this.maxResults = maxResults;
        if (this.maxResults != null && this.maxResults < 0) {
            this.maxResults = null;
        }
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (this.cachedResult == null) {
            this.cachedResult = new ArrayList<OResult>();
            this.prev.ifPresent(p -> this.init((OExecutionStepInternal)p, ctx));
        }
        return new OResultSet(){
            private int currentBatchReturned = 0;
            private int offset = OrderByStep.access$000(OrderByStep.this);

            @Override
            public boolean hasNext() {
                if (this.currentBatchReturned >= nRecords) {
                    return false;
                }
                return OrderByStep.this.cachedResult.size() > OrderByStep.this.nextElement;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                long begin = OrderByStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (this.currentBatchReturned >= nRecords) {
                        throw new IllegalStateException();
                    }
                    if (OrderByStep.this.cachedResult.size() <= OrderByStep.this.nextElement) {
                        throw new IllegalStateException();
                    }
                    OResult result = (OResult)OrderByStep.this.cachedResult.get(this.offset + this.currentBatchReturned);
                    OrderByStep.this.nextElement++;
                    ++this.currentBatchReturned;
                    OResult oResult = result;
                    return oResult;
                }
                finally {
                    if (OrderByStep.this.profilingEnabled) {
                        OrderByStep.this.cost = OrderByStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                OrderByStep.this.prev.ifPresent(p -> p.close());
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return new HashMap<String, Long>();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(OExecutionStepInternal p, OCommandContext ctx) {
        OResultSet lastBatch;
        long timeoutBegin = System.currentTimeMillis();
        long maxElementsAllowed = OGlobalConfiguration.QUERY_MAX_HEAP_ELEMENTS_ALLOWED_PER_OP.getValueAsLong();
        boolean sorted = true;
        while ((lastBatch = p.syncPull(ctx, 100)).hasNext()) {
            while (lastBatch.hasNext()) {
                if (this.timeoutMillis > 0L && timeoutBegin + this.timeoutMillis < System.currentTimeMillis()) {
                    this.sendTimeout();
                }
                if (this.timedOut) break;
                OResult item = lastBatch.next();
                long begin = this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    this.cachedResult.add(item);
                    if (maxElementsAllowed >= 0L && maxElementsAllowed < (long)this.cachedResult.size()) {
                        this.cachedResult.clear();
                        throw new OCommandExecutionException("Limit of allowed elements for in-heap ORDER BY in a single query exceeded (" + maxElementsAllowed + ") . You can set " + OGlobalConfiguration.QUERY_MAX_HEAP_ELEMENTS_ALLOWED_PER_OP.getKey() + " to increase this limit");
                    }
                    sorted = false;
                    if (this.maxResults == null || this.maxResults * 2 >= this.cachedResult.size()) continue;
                    this.cachedResult.sort((a, b) -> this.orderBy.compare((OResult)a, (OResult)b, ctx));
                    this.cachedResult = new ArrayList<OResult>(this.cachedResult.subList(0, this.maxResults));
                    sorted = true;
                }
                finally {
                    if (!this.profilingEnabled) continue;
                    this.cost += System.nanoTime() - begin;
                }
            }
            if (this.timedOut) break;
            long begin = this.profilingEnabled ? System.nanoTime() : 0L;
            try {
                if (sorted || this.maxResults == null || this.maxResults >= this.cachedResult.size()) continue;
                this.cachedResult.sort((a, b) -> this.orderBy.compare((OResult)a, (OResult)b, ctx));
                this.cachedResult = new ArrayList<OResult>(this.cachedResult.subList(0, this.maxResults));
                sorted = true;
            }
            finally {
                if (!this.profilingEnabled) continue;
                this.cost += System.nanoTime() - begin;
            }
        }
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            if (!sorted) {
                this.cachedResult.sort((a, b) -> this.orderBy.compare((OResult)a, (OResult)b, ctx));
            }
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ " + this.orderBy;
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        result = result + (this.maxResults != null ? "\n  (buffer size: " + this.maxResults + ")" : "");
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

