/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import java.util.Map;
import java.util.Optional;

public class ProjectionCalculationStep
extends AbstractExecutionStep {
    protected final OProjection projection;
    protected long cost = 0L;

    public ProjectionCalculationStep(OProjection projection, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.projection = projection;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (!this.prev.isPresent()) {
            throw new IllegalStateException("Cannot calculate projections without a previous source");
        }
        final OResultSet parentRs = ((OExecutionStepInternal)this.prev.get()).syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return parentRs.hasNext();
            }

            @Override
            public OResult next() {
                OResult item = parentRs.next();
                Object oldCurrent = ctx.getVariable("$current");
                ctx.setVariable("$current", item);
                OResult result = ProjectionCalculationStep.this.calculateProjections(ctx, item);
                ctx.setVariable("$current", oldCurrent);
                return result;
            }

            @Override
            public void close() {
                parentRs.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OResult calculateProjections(OCommandContext ctx, OResult next) {
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            OResult oResult = this.projection.calculateSingle(ctx, next);
            return oResult;
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ CALCULATE PROJECTIONS";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        result = result + "\n" + spaces + "  " + this.projection.toString() + "";
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new ProjectionCalculationStep(this.projection.copy(), ctx, this.profilingEnabled);
    }
}

