/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OTimeout;

public class TimeoutStep
extends AbstractExecutionStep {
    private final OTimeout timeout;
    private Long expiryTime;

    public TimeoutStep(OTimeout timeout, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.timeout = timeout;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (this.expiryTime == null) {
            this.expiryTime = System.currentTimeMillis() + this.timeout.getVal().longValue();
        }
        if (System.currentTimeMillis() > this.expiryTime) {
            return this.fail();
        }
        return this.getPrev().get().syncPull(ctx, nRecords);
    }

    private OResultSet fail() {
        this.timedOut = true;
        this.sendTimeout();
        if ("RETURN".equals(this.timeout.getFailureStrategy())) {
            return new OInternalResultSet();
        }
        throw new OTimeoutException("Timeout expired");
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        return OExecutionStepInternal.getIndent(depth, indent) + "+ TIMEOUT (" + this.timeout.getVal().toString() + " millis)";
    }

    @Override
    public void reset() {
        this.expiryTime = null;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new TimeoutStep(this.timeout.copy(), ctx, this.profilingEnabled);
    }
}

