/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.graph;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.functions.graph.OSQLFunctionMoveFiltered;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OSQLFunctionIn
extends OSQLFunctionMoveFiltered {
    public static final String NAME = "in";

    public OSQLFunctionIn() {
        super(NAME, 0, -1);
    }

    @Override
    protected Object move(ODatabase graph, OIdentifiable iRecord, String[] iLabels) {
        return this.v2v(graph, iRecord, ODirection.IN, iLabels);
    }

    @Override
    protected Object move(ODatabase graph, OIdentifiable iRecord, String[] iLabels, Iterable<OIdentifiable> iPossibleResults) {
        Object result;
        int size;
        if (iPossibleResults == null) {
            return this.v2v(graph, iRecord, ODirection.IN, iLabels);
        }
        if (!iPossibleResults.iterator().hasNext()) {
            return Collections.emptyList();
        }
        Object edges = this.v2e(graph, iRecord, ODirection.IN, iLabels);
        if (edges instanceof OSizeable && (size = ((OSizeable)edges).size()) > supernodeThreshold && (result = this.fetchFromIndex(graph, iRecord, iPossibleResults, iLabels)) != null) {
            return result;
        }
        return this.v2v(graph, iRecord, ODirection.IN, iLabels);
    }

    private Object fetchFromIndex(ODatabase graph, OIdentifiable iFrom, Iterable<OIdentifiable> to, String[] iEdgeTypes) {
        String edgeClassName = null;
        if (iEdgeTypes == null) {
            edgeClassName = "E";
        } else if (iEdgeTypes.length == 1) {
            edgeClassName = iEdgeTypes[0];
        } else {
            return null;
        }
        OClass edgeClass = graph.getMetadata().getSchema().getClass(edgeClassName);
        if (edgeClass == null) {
            return null;
        }
        Set<OIndex> indexes = edgeClass.getInvolvedIndexes(NAME, "out");
        if (indexes == null || indexes.size() == 0) {
            return null;
        }
        OIndex index = indexes.iterator().next();
        OMultiCollectionIterator result = new OMultiCollectionIterator();
        for (OIdentifiable identifiable : to) {
            OCompositeKey key = new OCompositeKey(iFrom, identifiable);
            Stream<ORID> stream = index.getInternal().getRids(key);
            Throwable throwable = null;
            try {
                result.add(stream.map(edge -> ((ODocument)edge.getRecord()).rawField("out")).collect(Collectors.toSet()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return result;
    }
}

