/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class OSQLStaticReflectiveFunction
extends OSQLFunctionAbstract {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new HashMap();
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE;
    private static final Map<Class<?>, Integer> PRIMITIVE_WEIGHT;
    private Method[] methods;

    public OSQLStaticReflectiveFunction(String name, int minParams, int maxParams, Method ... methods) {
        super(name, minParams, maxParams);
        this.methods = methods;
        Arrays.sort(methods, (m1, m2) -> {
            Class<?>[] m2Params;
            Class<?>[] m1Params = m1.getParameterTypes();
            int c = m1Params.length - (m2Params = m2.getParameterTypes()).length;
            if (c == 0) {
                for (int i = 0; i < m1Params.length; ++i) {
                    if (!m1Params[i].isPrimitive() || !m2Params[i].isPrimitive() || m1Params[i].equals(m2Params[i])) continue;
                    c += PRIMITIVE_WEIGHT.get(m1Params[i]) - PRIMITIVE_WEIGHT.get(m2Params[i]);
                }
            }
            return c;
        });
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Supplier<String> paramsPrettyPrint = () -> Arrays.stream(iParams).map(p -> p + " [ " + p.getClass().getName() + " ]").collect(Collectors.joining(", ", "(", ")"));
        Method method = this.pickMethod(iParams);
        if (method == null) {
            throw new OQueryParsingException("Unable to find a function for " + this.name + paramsPrettyPrint.get());
        }
        try {
            return method.invoke(null, iParams);
        }
        catch (ReflectiveOperationException e) {
            throw OException.wrapException(new OQueryParsingException("Error executing function " + this.name + paramsPrettyPrint.get()), e);
        }
        catch (IllegalArgumentException x) {
            OLogManager.instance().error(this, "Error executing function %s", x, this.name);
            return null;
        }
    }

    @Override
    public String getSyntax() {
        return this.getName();
    }

    private Method pickMethod(Object[] iParams) {
        for (Method m : this.methods) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (iParams.length != parameterTypes.length) continue;
            boolean match = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (iParams[i] == null || OSQLStaticReflectiveFunction.isAssignable(iParams[i].getClass(), parameterTypes[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return m;
        }
        return null;
    }

    private static boolean isAssignable(Class<?> iFromClass, Class<?> iToClass) {
        BiFunction<Class, Class, Class> autoboxer = (from, to) -> {
            if (from.isPrimitive() && !to.isPrimitive()) {
                return PRIMITIVE_TO_WRAPPER.get(from);
            }
            if (to.isPrimitive() && !from.isPrimitive()) {
                return WRAPPER_TO_PRIMITIVE.get(from);
            }
            return from;
        };
        Class fromClass = autoboxer.apply(iFromClass, iToClass);
        if (fromClass == null) {
            return false;
        }
        if (fromClass.equals(iToClass)) {
            return true;
        }
        if (fromClass.isPrimitive()) {
            if (!iToClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(fromClass)) {
                return Long.TYPE.equals(iToClass) || Float.TYPE.equals(iToClass) || Double.TYPE.equals(iToClass);
            }
            if (Long.TYPE.equals(fromClass)) {
                return Float.TYPE.equals(iToClass) || Double.TYPE.equals(iToClass);
            }
            if (Boolean.TYPE.equals(fromClass)) {
                return false;
            }
            if (Double.TYPE.equals(fromClass)) {
                return false;
            }
            if (Float.TYPE.equals(fromClass)) {
                return Double.TYPE.equals(iToClass);
            }
            if (Character.TYPE.equals(fromClass)) {
                return Integer.TYPE.equals(iToClass) || Long.TYPE.equals(iToClass) || Float.TYPE.equals(iToClass) || Double.TYPE.equals(iToClass);
            }
            if (Short.TYPE.equals(fromClass)) {
                return Integer.TYPE.equals(iToClass) || Long.TYPE.equals(iToClass) || Float.TYPE.equals(iToClass) || Double.TYPE.equals(iToClass);
            }
            if (Byte.TYPE.equals(fromClass)) {
                return Short.TYPE.equals(iToClass) || Integer.TYPE.equals(iToClass) || Long.TYPE.equals(iToClass) || Float.TYPE.equals(iToClass) || Double.TYPE.equals(iToClass);
            }
            return false;
        }
        return iToClass.isAssignableFrom(fromClass);
    }

    static {
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Void.TYPE, Void.TYPE);
        WRAPPER_TO_PRIMITIVE = new HashMap();
        for (Class<?> primitive : PRIMITIVE_TO_WRAPPER.keySet()) {
            Class<?> wrapper;
            if (primitive.equals(wrapper = PRIMITIVE_TO_WRAPPER.get(primitive))) continue;
            WRAPPER_TO_PRIMITIVE.put(wrapper, primitive);
        }
        PRIMITIVE_WEIGHT = new HashMap();
        PRIMITIVE_WEIGHT.put(Boolean.TYPE, 1);
        PRIMITIVE_WEIGHT.put(Character.TYPE, 2);
        PRIMITIVE_WEIGHT.put(Byte.TYPE, 3);
        PRIMITIVE_WEIGHT.put(Short.TYPE, 4);
        PRIMITIVE_WEIGHT.put(Integer.TYPE, 5);
        PRIMITIVE_WEIGHT.put(Long.TYPE, 6);
        PRIMITIVE_WEIGHT.put(Float.TYPE, 7);
        PRIMITIVE_WEIGHT.put(Double.TYPE, 8);
        PRIMITIVE_WEIGHT.put(Void.TYPE, 9);
    }
}

