/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.ONumber;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OAlterClassStatement
extends ODDLStatement {
    protected OIdentifier name;
    public OClass.ATTRIBUTES property;
    protected OIdentifier identifierValue;
    protected List<OIdentifier> identifierListValue;
    protected Boolean add;
    protected Boolean remove;
    protected ONumber numberValue;
    protected Boolean booleanValue;
    public OIdentifier customKey;
    public OExpression customValue;
    protected OInteger defaultClusterId;
    protected OIdentifier defaultClusterName;
    protected String customString;
    protected boolean unsafe;

    public OAlterClassStatement(int id) {
        super(id);
    }

    public OAlterClassStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        block26: {
            block25: {
                builder.append("ALTER CLASS ");
                this.name.toString(params, builder);
                if (this.property == null) break block25;
                builder.append(" " + this.property.name() + " ");
                switch (this.property) {
                    case NAME: 
                    case SHORTNAME: 
                    case ADDCLUSTER: 
                    case REMOVECLUSTER: 
                    case DESCRIPTION: 
                    case ENCRYPTION: {
                        if (this.numberValue != null) {
                            this.numberValue.toString(params, builder);
                            break;
                        }
                        if (this.identifierValue != null) {
                            this.identifierValue.toString(params, builder);
                            break;
                        }
                        builder.append("null");
                        break;
                    }
                    case CLUSTERSELECTION: {
                        if (this.identifierValue != null) {
                            this.identifierValue.toString(params, builder);
                            break;
                        }
                        if (this.customString != null) {
                            builder.append('\'').append(this.customString).append('\'');
                            break;
                        }
                        builder.append("null");
                        break;
                    }
                    case SUPERCLASS: {
                        if (Boolean.TRUE.equals(this.add)) {
                            builder.append("+");
                        } else if (Boolean.TRUE.equals(this.remove)) {
                            builder.append("-");
                        }
                        if (this.identifierValue == null) {
                            builder.append("null");
                            break;
                        }
                        this.identifierValue.toString(params, builder);
                        break;
                    }
                    case SUPERCLASSES: {
                        if (this.identifierListValue == null) {
                            builder.append("null");
                            break;
                        }
                        boolean first = true;
                        for (OIdentifier ident : this.identifierListValue) {
                            if (!first) {
                                builder.append(", ");
                            }
                            ident.toString(params, builder);
                            first = false;
                        }
                        break block26;
                    }
                    case OVERSIZE: {
                        this.numberValue.toString(params, builder);
                        break;
                    }
                    case STRICTMODE: 
                    case ABSTRACT: {
                        builder.append(this.booleanValue);
                        break;
                    }
                    case CUSTOM: {
                        this.customKey.toString(params, builder);
                        builder.append("=");
                        if (this.customValue == null) {
                            builder.append("null");
                            break;
                        }
                        this.customValue.toString(params, builder);
                    }
                }
                break block26;
            }
            if (this.defaultClusterId != null) {
                builder.append(" DEFAULTCLUSTER ");
                this.defaultClusterId.toString(params, builder);
            } else if (this.defaultClusterName != null) {
                builder.append(" DEFAULTCLUSTER ");
                this.defaultClusterName.toString(params, builder);
            }
        }
        if (this.unsafe) {
            builder.append(" UNSAFE");
        }
    }

    @Override
    public OStatement copy() {
        OAlterClassStatement result = new OAlterClassStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.property = this.property;
        result.identifierValue = this.identifierValue == null ? null : this.identifierValue.copy();
        result.identifierListValue = this.identifierListValue == null ? null : this.identifierListValue.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.add = this.add;
        result.remove = this.remove;
        result.numberValue = this.numberValue == null ? null : this.numberValue.copy();
        result.booleanValue = this.booleanValue;
        result.customKey = this.customKey == null ? null : this.customKey.copy();
        result.customValue = this.customValue == null ? null : this.customValue.copy();
        result.customString = this.customString;
        result.defaultClusterId = this.defaultClusterId == null ? null : this.defaultClusterId.copy();
        result.defaultClusterName = this.defaultClusterName == null ? null : this.defaultClusterName.copy();
        result.unsafe = this.unsafe;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAlterClassStatement that = (OAlterClassStatement)o;
        if (this.unsafe != that.unsafe) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.property != that.property) {
            return false;
        }
        if (this.identifierValue != null ? !this.identifierValue.equals(that.identifierValue) : that.identifierValue != null) {
            return false;
        }
        if (this.identifierListValue != null ? !this.identifierListValue.equals(that.identifierListValue) : that.identifierListValue != null) {
            return false;
        }
        if (this.add != null ? !this.add.equals(that.add) : that.add != null) {
            return false;
        }
        if (this.remove != null ? !this.remove.equals(that.remove) : that.remove != null) {
            return false;
        }
        if (this.numberValue != null ? !this.numberValue.equals(that.numberValue) : that.numberValue != null) {
            return false;
        }
        if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) {
            return false;
        }
        if (this.customKey != null ? !this.customKey.equals(that.customKey) : that.customKey != null) {
            return false;
        }
        if (this.customValue != null ? !this.customValue.equals(that.customValue) : that.customValue != null) {
            return false;
        }
        if (this.defaultClusterId != null ? !this.defaultClusterId.equals(that.defaultClusterId) : that.defaultClusterId != null) {
            return false;
        }
        if (this.defaultClusterName != null ? !this.defaultClusterName.equals(that.defaultClusterName) : that.defaultClusterName != null) {
            return false;
        }
        return this.customString != null ? this.customString.equals(that.customString) : that.customString == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.property != null ? this.property.hashCode() : 0);
        result = 31 * result + (this.identifierValue != null ? this.identifierValue.hashCode() : 0);
        result = 31 * result + (this.identifierListValue != null ? this.identifierListValue.hashCode() : 0);
        result = 31 * result + (this.add != null ? this.add.hashCode() : 0);
        result = 31 * result + (this.remove != null ? this.remove.hashCode() : 0);
        result = 31 * result + (this.numberValue != null ? this.numberValue.hashCode() : 0);
        result = 31 * result + (this.booleanValue != null ? this.booleanValue.hashCode() : 0);
        result = 31 * result + (this.customKey != null ? this.customKey.hashCode() : 0);
        result = 31 * result + (this.customValue != null ? this.customValue.hashCode() : 0);
        result = 31 * result + (this.defaultClusterId != null ? this.defaultClusterId.hashCode() : 0);
        result = 31 * result + (this.defaultClusterName != null ? this.defaultClusterName.hashCode() : 0);
        result = 31 * result + (this.customString != null ? this.customString.hashCode() : 0);
        result = 31 * result + (this.unsafe ? 1 : 0);
        return result;
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        int clusterId;
        OClass oClass = ctx.getDatabase().getMetadata().getSchema().getClass(this.name.getStringValue());
        if (oClass == null) {
            throw new OCommandExecutionException("Class not found: " + this.name);
        }
        if (this.property != null) {
            switch (this.property) {
                case NAME: {
                    if (!this.unsafe) {
                        this.checkNotEdge(oClass);
                        this.checkNotIndexed(oClass);
                    }
                    try {
                        oClass.setName(this.identifierValue.getStringValue());
                        break;
                    }
                    catch (Exception e) {
                        OException x = OException.wrapException(new OCommandExecutionException("Invalid class name: " + this.toString()), e);
                        throw x;
                    }
                }
                case SHORTNAME: {
                    if (this.identifierValue != null) {
                        try {
                            oClass.setShortName(this.identifierValue.getStringValue());
                            break;
                        }
                        catch (Exception e) {
                            OException x = OException.wrapException(new OCommandExecutionException("Invalid class name: " + this.toString()), e);
                            throw x;
                        }
                    }
                    throw new OCommandExecutionException("Invalid class name: " + this.toString());
                }
                case ADDCLUSTER: {
                    if (this.identifierValue != null) {
                        oClass.addCluster(this.identifierValue.getStringValue());
                        break;
                    }
                    if (this.numberValue != null) {
                        oClass.addClusterId(this.numberValue.getValue().intValue());
                        break;
                    }
                    throw new OCommandExecutionException("Invalid cluster value: " + this.toString());
                }
                case REMOVECLUSTER: {
                    clusterId = -1;
                    if (this.identifierValue != null) {
                        clusterId = ctx.getDatabase().getClusterIdByName(this.identifierValue.getStringValue());
                        if (clusterId < 0) {
                            throw new OCommandExecutionException("Cluster not found: " + this.toString());
                        }
                    } else if (this.numberValue != null) {
                        clusterId = this.numberValue.getValue().intValue();
                    } else {
                        throw new OCommandExecutionException("Invalid cluster value: " + this.toString());
                    }
                    oClass.removeClusterId(clusterId);
                    break;
                }
                case DESCRIPTION: {
                    if (this.identifierValue != null) {
                        oClass.setDescription(this.identifierValue.getStringValue());
                        break;
                    }
                    throw new OCommandExecutionException("Invalid class name: " + this.toString());
                }
                case ENCRYPTION: {
                    break;
                }
                case CLUSTERSELECTION: {
                    if (this.identifierValue != null) {
                        oClass.setClusterSelection(this.identifierValue.getStringValue());
                        break;
                    }
                    if (this.customString != null) {
                        oClass.setClusterSelection(this.customString);
                        break;
                    }
                    oClass.setClusterSelection("null");
                    break;
                }
                case SUPERCLASS: {
                    this.doSetSuperclass(ctx, oClass, this.identifierValue);
                    break;
                }
                case SUPERCLASSES: {
                    if (this.identifierListValue == null) {
                        oClass.setSuperClasses(Collections.EMPTY_LIST);
                        break;
                    }
                    this.doSetSuperclasses(ctx, oClass, this.identifierListValue);
                    break;
                }
                case OVERSIZE: {
                    oClass.setOverSize(this.numberValue.getValue().floatValue());
                    break;
                }
                case STRICTMODE: {
                    oClass.setStrictMode(this.booleanValue);
                    break;
                }
                case ABSTRACT: {
                    oClass.setAbstract(this.booleanValue);
                    break;
                }
                case CUSTOM: {
                    Object value = null;
                    if (this.customValue != null) {
                        value = this.customValue.execute((OIdentifiable)null, ctx);
                    }
                    if (value != null) {
                        value = "" + value;
                    }
                    oClass.setCustom(this.customKey.getStringValue(), (String)value);
                }
            }
        } else if (this.defaultClusterId != null) {
            oClass.setDefaultClusterId(this.defaultClusterId.getValue().intValue());
        } else if (this.defaultClusterName != null) {
            clusterId = ctx.getDatabase().getClusterIdByName(this.defaultClusterName.getStringValue());
            oClass.setDefaultClusterId(clusterId);
        }
        OInternalResultSet resultSet = new OInternalResultSet();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "ALTER CLASS");
        result.setProperty("className", this.name.getStringValue());
        result.setProperty("result", "OK");
        return resultSet;
    }

    private void checkNotIndexed(OClass oClass) {
        Set<OIndex> indexes = oClass.getIndexes();
        if (indexes != null && indexes.size() > 0) {
            throw new OCommandExecutionException("Cannot rename class '" + oClass.getName() + "' because it has indexes defined on it. Drop indexes before or use UNSAFE (at your won risk)");
        }
    }

    private void checkNotEdge(OClass oClass) {
        if (oClass.isSubClassOf("E")) {
            throw new OCommandExecutionException("Cannot alter class '" + oClass + "' because is an Edge class and could break vertices. Use UNSAFE if you want to force it");
        }
    }

    private void doSetSuperclass(OCommandContext ctx, OClass oClass, OIdentifier superclassName) {
        if (superclassName == null) {
            throw new OCommandExecutionException("Invalid superclass name: " + this.toString());
        }
        OClass superclass = ctx.getDatabase().getMetadata().getSchema().getClass(superclassName.getStringValue());
        if (superclass == null) {
            throw new OCommandExecutionException("superclass not found: " + this.toString());
        }
        if (Boolean.TRUE.equals(this.add)) {
            oClass.addSuperClass(superclass);
        } else if (Boolean.TRUE.equals(this.remove)) {
            oClass.removeSuperClass(superclass);
        } else {
            oClass.setSuperClasses(Collections.singletonList(superclass));
        }
    }

    private void doSetSuperclasses(OCommandContext ctx, OClass oClass, List<OIdentifier> superclassNames) {
        if (superclassNames == null) {
            throw new OCommandExecutionException("Invalid superclass name: " + this.toString());
        }
        ArrayList<OClass> superclasses = new ArrayList<OClass>();
        for (OIdentifier superclassName : superclassNames) {
            OClass superclass = ctx.getDatabase().getMetadata().getSchema().getClass(superclassName.getStringValue());
            if (superclass == null) {
                throw new OCommandExecutionException("superclass not found: " + this.toString());
            }
            superclasses.add(superclass);
        }
        if (Boolean.TRUE.equals(this.add)) {
            for (OClass superclass : superclasses) {
                oClass.addSuperClass(superclass);
            }
        } else if (Boolean.TRUE.equals(this.remove)) {
            for (OClass superclass : superclasses) {
                oClass.removeSuperClass(superclass);
            }
        } else {
            oClass.setSuperClasses(superclasses);
        }
    }
}

