/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.Map;

public class OBeginStatement
extends OSimpleExecStatement {
    protected OIdentifier isolation;

    public OBeginStatement(int id) {
        super(id);
    }

    public OBeginStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ctx.getDatabase().begin();
        OInternalResultSet result = new OInternalResultSet();
        OResultInternal item = new OResultInternal();
        item.setProperty("operation", "begin");
        if (this.isolation != null) {
            ctx.getDatabase().getTransaction().setIsolationLevel(OTransaction.ISOLATION_LEVEL.valueOf(this.isolation.getStringValue()));
            item.setProperty("isolation", this.isolation.getStringValue());
        }
        result.add(item);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("BEGIN");
        if (this.isolation != null) {
            builder.append(" ISOLATION ");
            this.isolation.toString(params, builder);
        }
    }

    @Override
    public OBeginStatement copy() {
        OBeginStatement result = new OBeginStatement(-1);
        result.isolation = this.isolation == null ? null : this.isolation.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBeginStatement that = (OBeginStatement)o;
        return !(this.isolation != null ? !this.isolation.equals(that.isolation) : that.isolation != null);
    }

    public int hashCode() {
        return this.isolation != null ? this.isolation.hashCode() : 0;
    }
}

