/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OClusterList
extends SimpleNode {
    protected List<OIdentifier> clusters = new ArrayList<OIdentifier>();

    public OClusterList(int id) {
        super(id);
    }

    public OClusterList(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("cluster:[");
        boolean first = true;
        for (OIdentifier id : this.clusters) {
            if (!first) {
                builder.append(",");
            }
            id.toString(params, builder);
            first = false;
        }
        builder.append("]");
    }

    public List<OCluster> toListOfClusters() {
        ArrayList<OCluster> result = new ArrayList<OCluster>();
        for (OIdentifier id : this.clusters) {
            OCluster cluster = new OCluster(-1);
            cluster.clusterName = id.getStringValue();
            result.add(cluster);
        }
        return result;
    }

    @Override
    public OClusterList copy() {
        OClusterList result = new OClusterList(-1);
        result.clusters = this.clusters.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OClusterList that = (OClusterList)o;
        return !(this.clusters != null ? !this.clusters.equals(that.clusters) : that.clusters != null);
    }

    public int hashCode() {
        return this.clusters != null ? this.clusters.hashCode() : 0;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.clusters != null) {
            result.setProperty("clusters", this.clusters.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("clusters") != null) {
            this.clusters = new ArrayList<OIdentifier>();
            List ser = (List)fromResult.getProperty("clusters");
            for (OResult item : ser) {
                OIdentifier id = OIdentifier.deserialize(item);
                this.clusters.add(id);
            }
        }
    }
}

