/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OContainsValueOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OOrBlock;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OContainsValueCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OContainsValueOperator operator;
    protected OOrBlock condition;
    protected OExpression expression;

    public OContainsValueCondition(int id) {
        super(id);
    }

    public OContainsValueCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        if (leftValue instanceof Map) {
            Map map = (Map)leftValue;
            if (this.condition != null) {
                for (Object o : map.values()) {
                    if (!this.condition.evaluate(o, ctx)) continue;
                    return true;
                }
                return false;
            }
            Object rightValue = this.expression.execute(currentRecord, ctx);
            return map.values().contains(rightValue);
        }
        return false;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        if (leftValue instanceof Map) {
            Map map = (Map)leftValue;
            if (this.condition != null) {
                for (Object o : map.values()) {
                    if (!this.condition.evaluate(o, ctx)) continue;
                    return true;
                }
                return false;
            }
            Object rightValue = this.expression.execute(currentRecord, ctx);
            return map.values().contains(rightValue);
        }
        return false;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" CONTAINSVALUE ");
        if (this.condition != null) {
            builder.append("(");
            this.condition.toString(params, builder);
            builder.append(")");
        } else {
            this.expression.toString(params, builder);
        }
    }

    @Override
    public boolean supportsBasicCalculation() {
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        if (this.condition == null) {
            return 0;
        }
        return this.condition.getNumberOfExternalCalculations();
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        if (this.condition == null) {
            return Collections.EMPTY_LIST;
        }
        return this.condition.getExternalCalculationConditions();
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.left != null && this.left.needsAliases(aliases)) {
            return true;
        }
        if (this.condition != null && this.condition.needsAliases(aliases)) {
            return true;
        }
        return this.expression != null && this.expression.needsAliases(aliases);
    }

    @Override
    public OContainsValueCondition copy() {
        OContainsValueCondition result = new OContainsValueCondition(-1);
        result.left = this.left.copy();
        result.operator = this.operator;
        result.condition = this.condition == null ? null : this.condition.copy();
        result.expression = this.expression == null ? null : this.expression.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.left.extractSubQueries(collector);
        if (this.condition != null) {
            this.condition.extractSubQueries(collector);
        }
        if (this.expression != null) {
            this.expression.extractSubQueries(collector);
        }
    }

    @Override
    public boolean refersToParent() {
        if (this.left != null && this.left.refersToParent()) {
            return true;
        }
        if (this.condition != null && this.condition.refersToParent()) {
            return true;
        }
        return this.expression != null && this.condition.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OContainsValueCondition that = (OContainsValueCondition)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return !(this.expression != null ? !this.expression.equals(that.expression) : that.expression != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        List<String> leftX = this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
        List<String> expressionX = this.expression == null ? null : this.expression.getMatchPatternInvolvedAliases();
        List<String> conditionX = this.condition == null ? null : this.condition.getMatchPatternInvolvedAliases();
        ArrayList<String> result = new ArrayList<String>();
        if (leftX != null) {
            result.addAll(leftX);
        }
        if (expressionX != null) {
            result.addAll(expressionX);
        }
        if (conditionX != null) {
            result.addAll(conditionX);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public boolean isCacheable() {
        if (this.left != null && !this.left.isCacheable()) {
            return false;
        }
        if (this.condition != null && !this.condition.isCacheable()) {
            return false;
        }
        return this.expression == null || this.expression.isCacheable();
    }

    public OExpression getExpression() {
        return this.expression;
    }

    public OExpression getLeft() {
        return this.left;
    }
}

