/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;
import java.util.Objects;

public class OCreateSecurityPolicyStatement
extends OSimpleExecStatement {
    protected OIdentifier name;
    protected OBooleanExpression create;
    protected OBooleanExpression read;
    protected OBooleanExpression beforeUpdate;
    protected OBooleanExpression afterUpdate;
    protected OBooleanExpression delete;
    protected OBooleanExpression execute;

    public OCreateSecurityPolicyStatement(int id) {
        super(id);
    }

    public OCreateSecurityPolicyStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ODatabaseSession db = (ODatabaseSession)ctx.getDatabase();
        OSecurityInternal security = ((ODatabaseInternal)((Object)db)).getSharedContext().getSecurity();
        OSecurityPolicy policy = security.createSecurityPolicy(db, this.name.getStringValue());
        policy.setActive(true);
        if (this.create != null) {
            policy.setCreateRule(this.create.toString());
        }
        if (this.read != null) {
            policy.setReadRule(this.read.toString());
        }
        if (this.beforeUpdate != null) {
            policy.setBeforeUpdateRule(this.beforeUpdate.toString());
        }
        if (this.afterUpdate != null) {
            policy.setAfterUpdateRule(this.afterUpdate.toString());
        }
        if (this.delete != null) {
            policy.setDeleteRule(this.delete.toString());
        }
        if (this.execute != null) {
            policy.setExecuteRule(this.execute.toString());
        }
        security.saveSecurityPolicy(db, policy);
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "create security policy");
        result.setProperty("name", this.name.getStringValue());
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE SECURITY POLICY ");
        this.name.toString(params, builder);
        boolean first = true;
        if (this.create != null) {
            if (first) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("CREATE = (");
            this.create.toString(params, builder);
            builder.append(")");
            first = false;
        }
        if (this.read != null) {
            if (first) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("READ = (");
            this.read.toString(params, builder);
            builder.append(")");
            first = false;
        }
        if (this.beforeUpdate != null) {
            if (first) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("BEFORE UPDATE = (");
            this.beforeUpdate.toString(params, builder);
            builder.append(")");
            first = false;
        }
        if (this.afterUpdate != null) {
            if (first) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("AFTER UPDATE = (");
            this.afterUpdate.toString(params, builder);
            builder.append(")");
            first = false;
        }
        if (this.delete != null) {
            if (first) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("DELETE = (");
            this.delete.toString(params, builder);
            builder.append(")");
            first = false;
        }
        if (this.execute != null) {
            if (first) {
                builder.append(" SET ");
            } else {
                builder.append(", ");
            }
            builder.append("EXECUTE = (");
            this.execute.toString(params, builder);
            builder.append(")");
            first = false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateSecurityPolicyStatement that = (OCreateSecurityPolicyStatement)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.create, that.create) && Objects.equals(this.read, that.read) && Objects.equals(this.beforeUpdate, that.beforeUpdate) && Objects.equals(this.afterUpdate, that.afterUpdate) && Objects.equals(this.delete, that.delete) && Objects.equals(this.execute, that.execute);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.create, this.read, this.beforeUpdate, this.afterUpdate, this.delete, this.execute);
    }

    @Override
    public OStatement copy() {
        OCreateSecurityPolicyStatement result = new OCreateSecurityPolicyStatement(-1);
        result.name = this.name.copy();
        result.create = this.create == null ? null : this.create.copy();
        result.read = this.read == null ? null : this.read.copy();
        result.beforeUpdate = this.beforeUpdate == null ? null : this.beforeUpdate.copy();
        result.afterUpdate = this.afterUpdate == null ? null : this.afterUpdate.copy();
        result.delete = this.delete == null ? null : this.delete.copy();
        result.execute = this.execute == null ? null : this.execute.copy();
        return result;
    }

    @Override
    public boolean executinPlanCanBeCached() {
        if (this.create != null && !this.create.isCacheable()) {
            return false;
        }
        if (this.read != null && !this.read.isCacheable()) {
            return false;
        }
        if (this.beforeUpdate != null && !this.beforeUpdate.isCacheable()) {
            return false;
        }
        if (this.afterUpdate != null && !this.afterUpdate.isCacheable()) {
            return false;
        }
        if (this.delete != null && !this.delete.isCacheable()) {
            return false;
        }
        return this.execute == null || this.execute.isCacheable();
    }
}

