/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class ODropClusterStatement
extends ODDLStatement {
    protected OIdentifier name;
    protected OInteger id;
    protected boolean ifExists = false;

    public ODropClusterStatement(int id) {
        super(id);
    }

    public ODropClusterStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        int clusterId;
        ODatabaseInternal database = (ODatabaseInternal)ctx.getDatabase();
        if (this.id != null) {
            clusterId = this.id.getValue().intValue();
        } else {
            clusterId = database.getStorage().getClusterIdByName(this.name.getStringValue());
            if (clusterId < 0) {
                if (this.ifExists) {
                    return new OInternalResultSet();
                }
                throw new OCommandExecutionException("Cluster not found: " + this.name);
            }
        }
        for (OClass iClass : database.getMetadata().getSchema().getClasses()) {
            for (int i : iClass.getClusterIds()) {
                if (i != clusterId) continue;
                throw new OCommandExecutionException("Cannot drop cluster " + clusterId + " because it's used by class " + iClass.getName());
            }
        }
        String clusterName = database.getClusterNameById(clusterId);
        if (clusterName == null) {
            if (this.ifExists) {
                return new OInternalResultSet();
            }
            throw new OCommandExecutionException("Cluster not found: " + clusterId);
        }
        ((OMetadataInternal)database.getMetadata()).getCommandCache().invalidateResultsOfCluster(clusterName);
        database.dropCluster(clusterId);
        OInternalResultSet rs = new OInternalResultSet();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "drop cluster");
        result.setProperty("clusterName", this.name == null ? null : this.name.getStringValue());
        result.setProperty("clusterId", this.id == null ? (Number)null : (Number)this.id.getValue());
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DROP CLUSTER ");
        if (this.name != null) {
            this.name.toString(params, builder);
        } else {
            this.id.toString(params, builder);
        }
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        }
    }

    @Override
    public ODropClusterStatement copy() {
        ODropClusterStatement result = new ODropClusterStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.id = this.id == null ? null : this.id.copy();
        result.ifExists = this.ifExists;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODropClusterStatement that = (ODropClusterStatement)o;
        if (this.ifExists != that.ifExists) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.ifExists ? 1 : 0);
        return result;
    }
}

