/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class ODropViewStatement
extends ODDLStatement {
    public OIdentifier name;
    public boolean ifExists = false;

    public ODropViewStatement(int id) {
        super(id);
    }

    public ODropViewStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OSchema schema = ctx.getDatabase().getMetadata().getSchema();
        OView view = schema.getView(this.name.getStringValue());
        if (view == null) {
            if (this.ifExists) {
                return new OInternalResultSet();
            }
            throw new OCommandExecutionException("View " + this.name.getStringValue() + " does not exist");
        }
        if (view.count() > 0L) {
            if (view.isVertexType()) {
                throw new OCommandExecutionException("'DROP VIEW' command cannot drop view '" + this.name.getStringValue() + "' because it contains Vertices. Use 'DELETE VERTEX' command first to avoid broken edges in a database, or apply the 'UNSAFE' keyword to force it");
            }
            if (view.isEdgeType()) {
                throw new OCommandExecutionException("'DROP VIEW' command cannot drop view '" + this.name.getStringValue() + "' because it contains Edges. Use 'DELETE EDGE' command first to avoid broken vertices in a database, or apply the 'UNSAFE' keyword to force it");
            }
        }
        schema.dropView(this.name.getStringValue());
        OInternalResultSet rs = new OInternalResultSet();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "drop view");
        result.setProperty("viewName", this.name.getStringValue());
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DROP VIEW ");
        this.name.toString(params, builder);
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        }
    }

    @Override
    public ODropViewStatement copy() {
        ODropViewStatement result = new ODropViewStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.ifExists = this.ifExists;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODropViewStatement that = (ODropViewStatement)o;
        if (this.ifExists != that.ifExists) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        return result;
    }
}

