/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OHaStatusStatement
extends OSimpleExecStatement {
    public boolean servers = false;
    public boolean db = false;
    public boolean latency = false;
    public boolean messages = false;
    public boolean outputText = false;
    public boolean locks = false;

    public OHaStatusStatement(int id) {
        super(id);
    }

    public OHaStatusStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("HA STATUS");
        if (this.servers) {
            builder.append(" -servers");
        }
        if (this.db) {
            builder.append(" -db");
        }
        if (this.latency) {
            builder.append(" -latency");
        }
        if (this.messages) {
            builder.append(" -messages");
        }
        if (this.locks) {
            builder.append(" -locks");
        }
        if (this.outputText) {
            builder.append(" -output=text");
        }
        if (this.servers) {
            builder.append(" -servers");
        }
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        if (this.outputText) {
            OLogManager.instance().info((Object)this, "HA STATUS with text output is deprecated", new Object[0]);
        }
        ODatabaseDocumentInternal database = (ODatabaseDocumentInternal)ctx.getDatabase();
        OInternalResultSet rs = new OInternalResultSet();
        try {
            Map<String, Object> res = database.getHaStatus(this.servers, this.db, this.latency, this.messages);
            if (res != null) {
                OResultInternal row = new OResultInternal();
                res.entrySet().forEach(x -> row.setProperty((String)x.getKey(), x.getValue()));
                rs.add(row);
            }
            return rs;
        }
        catch (Exception x2) {
            throw OException.wrapException(new OCommandExecutionException("Cannot execute HA STATUS"), x2);
        }
    }
}

