/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OIndexName;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OIndexIdentifier
extends SimpleNode {
    protected Type type;
    protected String indexNameString;
    protected OIndexName indexName;

    public OIndexIdentifier(int id) {
        super(id);
    }

    public OIndexIdentifier(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        switch (this.type) {
            case INDEX: {
                builder.append("INDEX");
                break;
            }
            case VALUES: {
                builder.append("INDEXVALUES");
                break;
            }
            case VALUESASC: {
                builder.append("INDEXVALUESASC");
                break;
            }
            case VALUESDESC: {
                builder.append("INDEXVALUESDESC");
            }
        }
        builder.append(":");
        if (this.indexNameString != null) {
            builder.append(this.indexNameString);
        } else {
            this.indexName.toString(params, builder);
        }
    }

    public String getIndexName() {
        if (this.indexName != null) {
            return this.indexName.toString();
        }
        return this.indexNameString;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public OIndexIdentifier copy() {
        OIndexIdentifier result = new OIndexIdentifier(-1);
        result.type = this.type;
        result.indexNameString = this.indexNameString;
        result.indexName = this.indexName.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexIdentifier that = (OIndexIdentifier)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.indexNameString != null ? !this.indexNameString.equals(that.indexNameString) : that.indexNameString != null) {
            return false;
        }
        return !(this.indexName != null ? !this.indexName.equals(that.indexName) : that.indexName != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.indexNameString != null ? this.indexNameString.hashCode() : 0);
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        return result;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("type", this.type.toString());
        result.setProperty("indexNameString", this.indexNameString);
        if (this.indexName != null) {
            result.setProperty("indexName", this.indexName.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.type = Type.valueOf((String)fromResult.getProperty("type"));
        this.indexNameString = (String)fromResult.getProperty("indexNameString");
        if (fromResult.getProperty("indexName") != null) {
            this.indexName = new OIndexName(-1);
            this.indexName.deserialize((OResult)fromResult.getProperty("indexName"));
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setIndexNameString(String indexNameString) {
        this.indexNameString = indexNameString;
    }

    public void setIndexName(OIndexName indexName) {
        this.indexName = indexName;
    }

    public static enum Type {
        INDEX,
        VALUES,
        VALUESASC,
        VALUESDESC;

    }
}

