/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OInstanceofCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OIdentifier right;
    protected String rightString;

    public OInstanceofCondition(int id) {
        super(id);
    }

    public OInstanceofCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        if (currentRecord == null) {
            return false;
        }
        Object record = currentRecord.getRecord();
        if (record == null) {
            return false;
        }
        if (!(record instanceof ODocument)) {
            return false;
        }
        ODocument doc = (ODocument)record;
        OClass clazz = doc.getSchemaClass();
        if (clazz == null) {
            return false;
        }
        if (this.right != null) {
            return clazz.isSubClassOf(this.right.getStringValue());
        }
        if (this.rightString != null) {
            return clazz.isSubClassOf(this.decode(this.rightString));
        }
        return false;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        if (currentRecord == null) {
            return false;
        }
        if (!currentRecord.isElement()) {
            return false;
        }
        Object record = currentRecord.getElement().get().getRecord();
        if (record == null) {
            return false;
        }
        if (!(record instanceof ODocument)) {
            return false;
        }
        ODocument doc = (ODocument)record;
        OClass clazz = doc.getSchemaClass();
        if (clazz == null) {
            return false;
        }
        if (this.right != null) {
            return clazz.isSubClassOf(this.right.getStringValue());
        }
        if (this.rightString != null) {
            return clazz.isSubClassOf(this.decode(this.rightString));
        }
        return false;
    }

    private String decode(String rightString) {
        if (rightString == null) {
            return null;
        }
        return OStringSerializerHelper.decode(rightString.substring(1, rightString.length() - 1));
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" instanceof ");
        if (this.right != null) {
            this.right.toString(params, builder);
        } else if (this.rightString != null) {
            builder.append(this.rightString);
        }
    }

    @Override
    public boolean supportsBasicCalculation() {
        return this.left.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        if (!this.left.supportsBasicCalculation()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        if (!this.left.supportsBasicCalculation()) {
            return Collections.singletonList(this.left);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        return this.left.needsAliases(aliases);
    }

    @Override
    public OInstanceofCondition copy() {
        OInstanceofCondition result = new OInstanceofCondition(-1);
        result.left = this.left.copy();
        result.right = this.right == null ? null : this.right.copy();
        result.rightString = this.rightString;
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.left.extractSubQueries(collector);
    }

    @Override
    public boolean refersToParent() {
        return this.left != null && this.left.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OInstanceofCondition that = (OInstanceofCondition)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        return !(this.rightString != null ? !this.rightString.equals(that.rightString) : that.rightString != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.rightString != null ? this.rightString.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        return this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
    }

    @Override
    public boolean isCacheable() {
        return this.left.isCacheable();
    }
}

