/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OIsNotDefinedCondition
extends OBooleanExpression {
    protected OExpression expression;

    public OIsNotDefinedCondition(int id) {
        super(id);
    }

    public OIsNotDefinedCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object elem = currentRecord.getRecord();
        if (elem instanceof OElement) {
            return !this.expression.isDefinedFor((OElement)elem);
        }
        return true;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        return !this.expression.isDefinedFor(currentRecord);
    }

    @Override
    public boolean supportsBasicCalculation() {
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        return 0;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        return this.expression.needsAliases(aliases);
    }

    @Override
    public OIsNotDefinedCondition copy() {
        OIsNotDefinedCondition result = new OIsNotDefinedCondition(-1);
        result.expression = this.expression.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.expression.extractSubQueries(collector);
    }

    @Override
    public boolean refersToParent() {
        return this.expression != null && this.expression.refersToParent();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.expression.toString(params, builder);
        builder.append(" is not defined");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIsNotDefinedCondition that = (OIsNotDefinedCondition)o;
        return !(this.expression != null ? !this.expression.equals(that.expression) : that.expression != null);
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        return this.expression.getMatchPatternInvolvedAliases();
    }

    @Override
    public boolean isCacheable() {
        return this.expression.isCacheable();
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }
}

