/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OMatchFilterItem;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OMatchFilter
extends SimpleNode {
    protected List<OMatchFilterItem> items = new ArrayList<OMatchFilterItem>();

    public OMatchFilter(int id) {
        super(id);
    }

    public OMatchFilter(OrientSql p, int id) {
        super(p, id);
    }

    public String getAlias() {
        for (OMatchFilterItem item : this.items) {
            if (item.alias == null) continue;
            return item.alias.getStringValue();
        }
        return null;
    }

    public void setAlias(String alias) {
        boolean found = false;
        for (OMatchFilterItem item : this.items) {
            if (item.alias == null) continue;
            item.alias = new OIdentifier(alias);
            found = true;
            break;
        }
        if (!found) {
            OMatchFilterItem newItem = new OMatchFilterItem(-1);
            newItem.alias = new OIdentifier(alias);
            this.items.add(newItem);
        }
    }

    public OWhereClause getFilter() {
        for (OMatchFilterItem item : this.items) {
            if (item.filter == null) continue;
            return item.filter;
        }
        return null;
    }

    public void setFilter(OWhereClause filter) {
        boolean found = false;
        for (OMatchFilterItem item : this.items) {
            if (item.filter == null) continue;
            item.filter = filter;
            found = true;
            break;
        }
        if (!found) {
            OMatchFilterItem newItem = new OMatchFilterItem(-1);
            newItem.filter = filter;
            this.items.add(newItem);
        }
    }

    public OWhereClause getWhileCondition() {
        for (OMatchFilterItem item : this.items) {
            if (item.whileCondition == null) continue;
            return item.whileCondition;
        }
        return null;
    }

    public String getClassName(OCommandContext context) {
        for (OMatchFilterItem item : this.items) {
            if (item.className == null) continue;
            if (item.className.value instanceof String) {
                return (String)item.className.value;
            }
            if (item.className.value instanceof SimpleNode) {
                StringBuilder builder = new StringBuilder();
                ((SimpleNode)item.className.value).toString(context == null ? null : context.getInputParameters(), builder);
                return builder.toString();
            }
            return item.className.toString();
        }
        return null;
    }

    public String getClusterName(OCommandContext context) {
        for (OMatchFilterItem item : this.items) {
            if (item.clusterName != null) {
                return item.clusterName.getStringValue();
            }
            if (item.clusterId == null) continue;
            int cid = item.clusterId.value.intValue();
            String clusterName = context.getDatabase().getClusterNameById(cid);
            if (clusterName == null) continue;
            return clusterName;
        }
        return null;
    }

    public ORid getRid(OCommandContext context) {
        for (OMatchFilterItem item : this.items) {
            if (item.rid == null) continue;
            return item.rid;
        }
        return null;
    }

    public Integer getMaxDepth() {
        for (OMatchFilterItem item : this.items) {
            if (item.maxDepth == null) continue;
            return item.maxDepth.value.intValue();
        }
        return null;
    }

    public boolean isOptional() {
        for (OMatchFilterItem item : this.items) {
            if (!Boolean.TRUE.equals(item.optional)) continue;
            return true;
        }
        return false;
    }

    public String getDepthAlias() {
        for (OMatchFilterItem item : this.items) {
            if (item.depthAlias == null) continue;
            return item.depthAlias.getStringValue();
        }
        return null;
    }

    public String getPathAlias() {
        for (OMatchFilterItem item : this.items) {
            if (item.pathAlias == null) continue;
            return item.pathAlias.getStringValue();
        }
        return null;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("{");
        boolean first = true;
        for (OMatchFilterItem item : this.items) {
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
        builder.append("}");
    }

    @Override
    public OMatchFilter copy() {
        OMatchFilter result = new OMatchFilter(-1);
        result.items = this.items == null ? null : this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMatchFilter that = (OMatchFilter)o;
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }
}

