/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class OMatchesCondition
extends OBooleanExpression {
    protected OExpression expression;
    protected String right;
    protected OExpression rightExpression;
    protected OInputParameter rightParam;

    public OMatchesCondition(int id) {
        super(id);
    }

    public OMatchesCondition(OrientSql p, int id) {
        super(p, id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        String regex = this.right;
        if (regex != null) {
            regex = regex.substring(1, regex.length() - 1);
        } else if (this.rightExpression != null) {
            Object val = this.rightExpression.execute(currentRecord, ctx);
            if (!(val instanceof String)) return false;
            regex = (String)val;
        } else {
            Object paramVal = this.rightParam.getValue(ctx.getInputParameters());
            if (!(paramVal instanceof String)) return false;
            regex = (String)paramVal;
        }
        Object value = this.expression.execute(currentRecord, ctx);
        return this.matches(value, regex, ctx);
    }

    private boolean matches(Object value, String regex, OCommandContext ctx) {
        String key = "MATCHES_" + regex.hashCode();
        Pattern p = (Pattern)ctx.getVariable(key);
        if (p == null) {
            p = Pattern.compile(regex);
            ctx.setVariable(key, p);
        }
        if (value instanceof CharSequence) {
            return p.matcher((CharSequence)value).matches();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        String regex = this.right;
        if (regex != null) {
            regex = regex.substring(1, regex.length() - 1);
        } else if (this.rightExpression != null) {
            Object val = this.rightExpression.execute(currentRecord, ctx);
            if (!(val instanceof String)) return false;
            regex = (String)val;
        } else {
            Object paramVal = this.rightParam.getValue(ctx.getInputParameters());
            if (!(paramVal instanceof String)) return false;
            regex = (String)paramVal;
        }
        Object value = this.expression.execute(currentRecord, ctx);
        return this.matches(value, regex, ctx);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.expression.toString(params, builder);
        builder.append(" MATCHES ");
        if (this.right != null) {
            builder.append(this.right);
        } else if (this.rightExpression != null) {
            this.rightExpression.toString(params, builder);
        } else {
            this.rightParam.toString(params, builder);
        }
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (!this.expression.supportsBasicCalculation()) {
            return false;
        }
        return this.rightExpression == null || this.rightExpression.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int result = 0;
        if (this.expression != null && !this.expression.supportsBasicCalculation()) {
            ++result;
        }
        if (this.rightExpression != null && !this.rightExpression.supportsBasicCalculation()) {
            ++result;
        }
        return result;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.expression != null && !this.expression.supportsBasicCalculation()) {
            result.add(this.expression);
        }
        if (this.rightExpression != null && !this.rightExpression.supportsBasicCalculation()) {
            result.add(this.rightExpression);
        }
        return result;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.expression.needsAliases(aliases)) {
            return true;
        }
        return this.rightExpression.needsAliases(aliases);
    }

    @Override
    public OMatchesCondition copy() {
        OMatchesCondition result = new OMatchesCondition(-1);
        result.expression = this.expression == null ? null : this.expression.copy();
        result.right = this.right;
        result.rightParam = this.rightParam == null ? null : this.rightParam.copy();
        result.rightExpression = this.rightExpression == null ? null : this.rightExpression.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.expression.extractSubQueries(collector);
        if (this.rightExpression != null) {
            this.rightExpression.extractSubQueries(collector);
        }
    }

    @Override
    public boolean refersToParent() {
        if (this.expression != null && this.expression.refersToParent()) {
            return true;
        }
        return this.rightExpression != null && this.rightExpression.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMatchesCondition that = (OMatchesCondition)o;
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        if (this.rightExpression != null ? !this.rightExpression.equals(that.rightExpression) : that.rightExpression != null) {
            return false;
        }
        return this.rightParam != null ? this.rightParam.equals(that.rightParam) : that.rightParam == null;
    }

    public int hashCode() {
        int result = this.expression != null ? this.expression.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.rightExpression != null ? this.rightExpression.hashCode() : 0);
        result = 31 * result + (this.rightParam != null ? this.rightParam.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.expression.getMatchPatternInvolvedAliases());
        if (this.rightExpression != null) {
            result.addAll(this.rightExpression.getMatchPatternInvolvedAliases());
        }
        return result;
    }

    @Override
    public boolean isCacheable() {
        if (!this.expression.isCacheable()) {
            return false;
        }
        return this.rightExpression == null || this.rightExpression.isCacheable();
    }
}

