/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OPositionalParameter
extends OInputParameter {
    protected int paramNumber;

    public OPositionalParameter(int id) {
        super(id);
    }

    public OPositionalParameter(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public String toString() {
        return "?";
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        Object finalValue = this.bindFromInputParams(params);
        if (finalValue == this) {
            builder.append("?");
        } else if (finalValue instanceof String) {
            builder.append("\"");
            builder.append(OExpression.encode(finalValue.toString()));
            builder.append("\"");
        } else if (finalValue instanceof SimpleNode) {
            ((SimpleNode)finalValue).toString(params, builder);
        } else {
            builder.append(finalValue);
        }
    }

    @Override
    public Object getValue(Map<Object, Object> params) {
        Object result = null;
        if (params != null) {
            result = params.get(this.paramNumber);
        }
        return result;
    }

    @Override
    public Object bindFromInputParams(Map<Object, Object> params) {
        if (params != null) {
            Object value = params.get(this.paramNumber);
            Object result = this.toParsedTree(value);
            return result;
        }
        return this;
    }

    @Override
    public OPositionalParameter copy() {
        OPositionalParameter result = new OPositionalParameter(-1);
        result.paramNumber = this.paramNumber;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OPositionalParameter that = (OPositionalParameter)o;
        return this.paramNumber == that.paramNumber;
    }

    public int hashCode() {
        return this.paramNumber;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = (OResultInternal)super.serialize();
        result.setProperty("paramNumber", this.paramNumber);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        this.paramNumber = (Integer)fromResult.getProperty("paramNumber");
    }
}

