/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.OParenthesisExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OUpdateItem
extends SimpleNode {
    public static final int OPERATOR_EQ = 0;
    public static final int OPERATOR_PLUSASSIGN = 1;
    public static final int OPERATOR_MINUSASSIGN = 2;
    public static final int OPERATOR_STARASSIGN = 3;
    public static final int OPERATOR_SLASHASSIGN = 4;
    protected OIdentifier left;
    protected OModifier leftModifier;
    protected int operator;
    protected OExpression right;

    public OUpdateItem(int id) {
        super(id);
    }

    public OUpdateItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        if (this.leftModifier != null) {
            this.leftModifier.toString(params, builder);
        }
        switch (this.operator) {
            case 0: {
                builder.append(" = ");
                break;
            }
            case 1: {
                builder.append(" += ");
                break;
            }
            case 2: {
                builder.append(" -= ");
                break;
            }
            case 3: {
                builder.append(" *= ");
                break;
            }
            case 4: {
                builder.append(" /= ");
            }
        }
        this.right.toString(params, builder);
    }

    @Override
    public OUpdateItem copy() {
        OUpdateItem result = new OUpdateItem(-1);
        result.left = this.left == null ? null : this.left.copy();
        result.leftModifier = this.leftModifier == null ? null : this.leftModifier.copy();
        result.operator = this.operator;
        result.right = this.right == null ? null : this.right.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OUpdateItem that = (OUpdateItem)o;
        if (this.operator != that.operator) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.leftModifier != null ? !this.leftModifier.equals(that.leftModifier) : that.leftModifier != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.leftModifier != null ? this.leftModifier.hashCode() : 0);
        result = 31 * result + this.operator;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public void applyUpdate(OResultInternal doc, OCommandContext ctx) {
        Object rightValue = this.right.execute(doc, ctx);
        OType type = this.calculateTypeForThisItem(doc, ctx);
        OClass linkedType = this.calculateLinkedTypeForThisItem(doc, ctx);
        rightValue = OUpdateItem.convertToType(rightValue, type, linkedType, ctx);
        if (this.leftModifier == null) {
            this.applyOperation(doc, this.left, rightValue, ctx);
        } else {
            Object val = doc.getProperty(this.left.getStringValue());
            if (val == null) {
                val = this.initSchemafullCollections(doc, this.left.getStringValue());
            }
            this.leftModifier.setValue(doc, val, rightValue, ctx);
        }
    }

    private Object initSchemafullCollections(OResultInternal doc, String propName) {
        OClass oClass = doc.getElement().flatMap(x -> x.getSchemaType()).orElse(null);
        if (oClass == null) {
            return null;
        }
        OProperty prop = oClass.getProperty(propName);
        if (prop == null) {
            return null;
        }
        Cloneable result = null;
        if (prop.getType() == OType.EMBEDDEDMAP || prop.getType() == OType.LINKMAP) {
            result = new HashMap();
            doc.setProperty(propName, result);
        } else if (prop.getType() == OType.EMBEDDEDLIST || prop.getType() == OType.LINKLIST) {
            result = new ArrayList();
            doc.setProperty(propName, result);
        } else if (prop.getType() == OType.EMBEDDEDSET || prop.getType() == OType.LINKSET) {
            result = new HashSet();
            doc.setProperty(propName, result);
        }
        return result;
    }

    private OClass calculateLinkedTypeForThisItem(OResultInternal doc, OCommandContext ctx) {
        return null;
    }

    private OType calculateTypeForThisItem(OResultInternal doc, OCommandContext ctx) {
        OElement elem = doc.toElement();
        OClass clazz = elem.getSchemaType().orElse(null);
        if (clazz == null) {
            return null;
        }
        return this.calculateTypeForThisItem(clazz, this.left.getStringValue(), this.leftModifier, ctx);
    }

    private OType calculateTypeForThisItem(OClass clazz, String propName, OModifier modifier, OCommandContext ctx) {
        OProperty prop = clazz.getProperty(propName);
        if (prop == null) {
            return null;
        }
        OType type = prop.getType();
        if (type == OType.LINKMAP && modifier != null) {
            if (prop.getLinkedClass() != null && modifier.next != null) {
                if (modifier.suffix == null) {
                    return null;
                }
                return this.calculateTypeForThisItem(prop.getLinkedClass(), modifier.suffix.toString(), modifier.next, ctx);
            }
            return OType.LINK;
        }
        return null;
    }

    public void applyOperation(OResultInternal doc, OIdentifier attrName, Object rightValue, OCommandContext ctx) {
        switch (this.operator) {
            case 0: {
                Object newValue = OUpdateItem.convertResultToDocument(rightValue);
                newValue = OUpdateItem.convertToPropertyType(doc, attrName, newValue, ctx);
                doc.setProperty(attrName.getStringValue(), newValue);
                break;
            }
            case 2: {
                doc.setProperty(attrName.getStringValue(), this.calculateNewValue(doc, ctx, OMathExpression.Operator.MINUS));
                break;
            }
            case 1: {
                doc.setProperty(attrName.getStringValue(), this.calculateNewValue(doc, ctx, OMathExpression.Operator.PLUS));
                break;
            }
            case 4: {
                doc.setProperty(attrName.getStringValue(), this.calculateNewValue(doc, ctx, OMathExpression.Operator.SLASH));
                break;
            }
            case 3: {
                doc.setProperty(attrName.getStringValue(), this.calculateNewValue(doc, ctx, OMathExpression.Operator.STAR));
            }
        }
    }

    public static Object convertToPropertyType(OResultInternal res, OIdentifier attrName, Object newValue, OCommandContext ctx) {
        OElement doc = res.toElement();
        Optional<OClass> optSchema = doc.getSchemaType();
        if (!optSchema.isPresent()) {
            return newValue;
        }
        OProperty prop = optSchema.get().getProperty(attrName.getStringValue());
        if (prop == null) {
            return newValue;
        }
        OType type = prop.getType();
        OClass linkedClass = prop.getLinkedClass();
        return OUpdateItem.convertToType(newValue, type, linkedClass, ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object convertToType(Object value, OType type, OClass linkedClass, OCommandContext ctx) {
        if (type == null) {
            return value;
        }
        if (!(value instanceof Collection)) return value;
        if (type == OType.LINK) {
            if (((Collection)value).size() == 0) {
                return null;
            }
            if (((Collection)value).size() != 1) throw new OCommandExecutionException("Cannot assign a collection to a LINK property");
            return ((Collection)value).iterator().next();
        }
        if (type == OType.EMBEDDEDLIST && linkedClass != null) {
            return ((Collection)value).stream().map(item -> OUpdateItem.convertToType(item, linkedClass, ctx)).collect(Collectors.toList());
        }
        if (type != OType.EMBEDDEDSET) return value;
        if (linkedClass == null) return value;
        return ((Collection)value).stream().map(item -> OUpdateItem.convertToType(item, linkedClass, ctx)).collect(Collectors.toSet());
    }

    private static Object convertToType(Object item, OClass linkedClass, OCommandContext ctx) {
        if (item instanceof OElement) {
            OClass currentType = ((OElement)item).getSchemaType().orElse(null);
            if (currentType == null || !currentType.isSubClassOf(linkedClass)) {
                OElement result = ((ODatabaseSession)ctx.getDatabase()).newElement(linkedClass.getName());
                for (String prop : ((OElement)item).getPropertyNames()) {
                    result.setProperty(prop, ((OElement)item).getProperty(prop));
                }
                return result;
            }
            return item;
        }
        if (item instanceof Map) {
            OElement result = ((ODatabaseSession)ctx.getDatabase()).newElement(linkedClass.getName());
            ((Map)item).entrySet().stream().forEach(x -> result.setProperty((String)x.getKey(), x.getValue()));
            return result;
        }
        return item;
    }

    public static Object convertResultToDocument(Object value) {
        if (value instanceof OResult) {
            return ((OResult)value).toElement();
        }
        if (value instanceof OIdentifiable) {
            return value;
        }
        if (value instanceof List && OUpdateItem.containsOResult((Collection)value)) {
            return ((List)value).stream().map(x -> OUpdateItem.convertResultToDocument(x)).collect(Collectors.toList());
        }
        if (value instanceof Set && OUpdateItem.containsOResult((Collection)value)) {
            return ((Set)value).stream().map(x -> OUpdateItem.convertResultToDocument(x)).collect(Collectors.toSet());
        }
        return value;
    }

    public static boolean containsOResult(Collection value) {
        return value.stream().anyMatch(x -> x instanceof OResult);
    }

    private Object calculateNewValue(OResultInternal doc, OCommandContext ctx, OMathExpression.Operator explicitOperator) {
        OExpression leftEx = new OExpression(this.left.copy());
        if (this.leftModifier != null) {
            ((OBaseExpression)leftEx.mathExpression).modifier = this.leftModifier.copy();
        }
        OMathExpression mathExp = new OMathExpression(-1);
        mathExp.getChildExpressions().add(leftEx.getMathExpression());
        mathExp.getChildExpressions().add(new OParenthesisExpression(this.right.copy()));
        mathExp.getOperators().add(explicitOperator);
        return mathExp.execute(doc, ctx);
    }

    public OIdentifier getLeft() {
        return this.left;
    }

    public void setLeft(OIdentifier left) {
        this.left = left;
    }

    public OModifier getLeftModifier() {
        return this.leftModifier;
    }

    public void setLeftModifier(OModifier leftModifier) {
        this.leftModifier = leftModifier;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public OExpression getRight() {
        return this.right;
    }

    public void setRight(OExpression right) {
        this.right = right;
    }
}

