/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.type.OBuffer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ORawBuffer
extends OBuffer {
    public int version;
    public byte recordType;

    public ORawBuffer() {
        this.version = 0;
    }

    public ORawBuffer(byte[] buffer, int version, byte recordType) {
        this.buffer = buffer;
        this.version = version;
        this.recordType = recordType;
    }

    public ORawBuffer(ORecord iRecord) {
        this.buffer = iRecord.toStream();
        this.version = iRecord.getVersion();
        this.recordType = ORecordInternal.getRecordType(iRecord);
    }

    @Override
    public void readExternal(ObjectInput iInput) throws IOException, ClassNotFoundException {
        super.readExternal(iInput);
        this.version = iInput.readInt();
        this.recordType = iInput.readByte();
    }

    @Override
    public void writeExternal(ObjectOutput iOutput) throws IOException {
        super.writeExternal(iOutput);
        iOutput.writeInt(this.version);
        iOutput.writeByte(this.recordType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ORawBuffer that = (ORawBuffer)o;
        if (this.recordType != that.recordType) {
            return false;
        }
        return this.version == that.version;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + this.recordType;
        return result;
    }
}

