/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache;

import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class OCachePointer {
    private static final AtomicIntegerFieldUpdater<OCachePointer> REFERRERS_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OCachePointer.class, "referrersCount");
    private static final AtomicLongFieldUpdater<OCachePointer> READERS_WRITERS_REFERRER_UPDATER = AtomicLongFieldUpdater.newUpdater(OCachePointer.class, "readersWritersReferrer");
    private static final int WRITERS_OFFSET = 32;
    private static final int READERS_MASK = -1;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private volatile int referrersCount;
    private volatile long readersWritersReferrer;
    private volatile WritersListener writersListener;
    private final OPointer pointer;
    private final OByteBufferPool bufferPool;
    private long version;
    private final long fileId;
    private final int pageIndex;
    private OLogSequenceNumber endLSN;
    private int hash;

    public OCachePointer(OPointer pointer, OByteBufferPool bufferPool, long fileId, int pageIndex) {
        this.pointer = pointer;
        this.bufferPool = bufferPool;
        if (fileId < 0L) {
            throw new IllegalStateException("File id has invalid value " + fileId);
        }
        if (pageIndex < 0) {
            throw new IllegalStateException("Page index has invalid value " + pageIndex);
        }
        this.fileId = fileId;
        this.pageIndex = pageIndex;
    }

    public void setWritersListener(WritersListener writersListener) {
        this.writersListener = writersListener;
    }

    public long getFileId() {
        return this.fileId;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void incrementReadersReferrer() {
        long readersWriters = READERS_WRITERS_REFERRER_UPDATER.get(this);
        int readers = OCachePointer.getReaders(readersWriters);
        int writers = OCachePointer.getWriters(readersWriters);
        ++readers;
        while (!READERS_WRITERS_REFERRER_UPDATER.compareAndSet(this, readersWriters, OCachePointer.composeReadersWriters(readers, writers))) {
            readersWriters = READERS_WRITERS_REFERRER_UPDATER.get(this);
            readers = OCachePointer.getReaders(readersWriters);
            writers = OCachePointer.getWriters(readersWriters);
            ++readers;
        }
        WritersListener wl = this.writersListener;
        if (wl != null && writers > 0 && readers == 1) {
            wl.removeOnlyWriters(this.fileId, this.pageIndex);
        }
        this.incrementReferrer();
    }

    public void decrementReadersReferrer() {
        long readersWriters = READERS_WRITERS_REFERRER_UPDATER.get(this);
        int readers = OCachePointer.getReaders(readersWriters);
        int writers = OCachePointer.getWriters(readersWriters);
        assert (--readers >= 0);
        while (!READERS_WRITERS_REFERRER_UPDATER.compareAndSet(this, readersWriters, OCachePointer.composeReadersWriters(readers, writers))) {
            readersWriters = READERS_WRITERS_REFERRER_UPDATER.get(this);
            readers = OCachePointer.getReaders(readersWriters);
            writers = OCachePointer.getWriters(readersWriters);
            assert (--readers >= 0);
        }
        WritersListener wl = this.writersListener;
        if (wl != null && writers > 0 && readers == 0) {
            wl.addOnlyWriters(this.fileId, this.pageIndex);
        }
        this.decrementReferrer();
    }

    public void incrementWritersReferrer() {
        long readersWriters = READERS_WRITERS_REFERRER_UPDATER.get(this);
        int readers = OCachePointer.getReaders(readersWriters);
        int writers = OCachePointer.getWriters(readersWriters);
        ++writers;
        while (!READERS_WRITERS_REFERRER_UPDATER.compareAndSet(this, readersWriters, OCachePointer.composeReadersWriters(readers, writers))) {
            readersWriters = READERS_WRITERS_REFERRER_UPDATER.get(this);
            readers = OCachePointer.getReaders(readersWriters);
            writers = OCachePointer.getWriters(readersWriters);
            ++writers;
        }
        this.incrementReferrer();
    }

    public void decrementWritersReferrer() {
        long readersWriters = READERS_WRITERS_REFERRER_UPDATER.get(this);
        int readers = OCachePointer.getReaders(readersWriters);
        int writers = OCachePointer.getWriters(readersWriters);
        assert (--writers >= 0);
        while (!READERS_WRITERS_REFERRER_UPDATER.compareAndSet(this, readersWriters, OCachePointer.composeReadersWriters(readers, writers))) {
            readersWriters = READERS_WRITERS_REFERRER_UPDATER.get(this);
            readers = OCachePointer.getReaders(readersWriters);
            writers = OCachePointer.getWriters(readersWriters);
            assert (--writers >= 0);
        }
        WritersListener wl = this.writersListener;
        if (wl != null && readers == 0 && writers == 0) {
            wl.removeOnlyWriters(this.fileId, this.pageIndex);
        }
        this.decrementReferrer();
    }

    boolean isLockAcquiredByCurrentThread() {
        return this.readWriteLock.getReadHoldCount() > 0 || this.readWriteLock.isWriteLockedByCurrentThread();
    }

    public void incrementReferrer() {
        REFERRERS_COUNT_UPDATER.incrementAndGet(this);
    }

    public void decrementReferrer() {
        int rf = REFERRERS_COUNT_UPDATER.decrementAndGet(this);
        if (rf == 0 && this.pointer != null) {
            this.bufferPool.release(this.pointer);
        }
        if (rf < 0) {
            throw new IllegalStateException("Invalid direct memory state, number of referrers cannot be negative " + rf);
        }
    }

    public ByteBuffer getBuffer() {
        if (this.pointer == null) {
            return null;
        }
        return this.pointer.getNativeByteBuffer();
    }

    public OPointer getPointer() {
        return this.pointer;
    }

    public ByteBuffer getBufferDuplicate() {
        if (this.pointer == null) {
            return null;
        }
        ByteBuffer duplicate = this.pointer.getNativeByteBuffer().duplicate().order(ByteOrder.nativeOrder());
        duplicate.rewind();
        return duplicate;
    }

    public void acquireExclusiveLock() {
        this.readWriteLock.writeLock().lock();
        ++this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public void releaseExclusiveLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public void acquireSharedLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseSharedLock() {
        this.readWriteLock.readLock().unlock();
    }

    public boolean tryAcquireSharedLock() {
        return this.readWriteLock.readLock().tryLock();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCachePointer that = (OCachePointer)o;
        if (this.fileId != that.fileId) {
            return false;
        }
        return this.pageIndex == that.pageIndex;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int result = (int)(this.fileId ^ this.fileId >>> 32);
        this.hash = result = 31 * result + this.pageIndex;
        return this.hash;
    }

    public String toString() {
        return "OCachePointer{referrersCount=" + this.referrersCount + '}';
    }

    private static long composeReadersWriters(int readers, int writers) {
        return (long)writers << 32 | (long)readers;
    }

    private static int getReaders(long readersWriters) {
        return (int)(readersWriters & 0xFFFFFFFFFFFFFFFFL);
    }

    private static int getWriters(long readersWriters) {
        return (int)(readersWriters >>> 32);
    }

    public OLogSequenceNumber getEndLSN() {
        return this.endLSN;
    }

    void setEndLSN(OLogSequenceNumber endLSN) {
        this.endLSN = endLSN;
    }

    public static interface WritersListener {
        public void addOnlyWriters(long var1, long var3);

        public void removeOnlyWriters(long var1, long var3);
    }
}

