/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local;

import com.orientechnologies.common.collection.closabledictionary.OClosableEntry;
import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.directmemory.ODirectMemoryAllocator;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.thread.OScheduledThreadPoolExecutorWithLogging;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OQuarto;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OInvalidStorageEncryptionKeyException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OWriteCacheException;
import com.orientechnologies.orient.core.storage.OChecksumMode;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.cache.local.doublewritelog.DoubleWriteLog;
import com.orientechnologies.orient.core.storage.fs.AsyncFile;
import com.orientechnologies.orient.core.storage.fs.IOResult;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.OPageIsBrokenListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.MetaDataRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.zip.CRC32;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class OWOWCache
extends OAbstractWriteCache
implements OWriteCache,
OCachePointer.WritersListener {
    private static final String ALGORITHM_NAME = "AES";
    private static final String TRANSFORMATION = "AES/CTR/NoPadding";
    private static final ThreadLocal<Cipher> CIPHER = ThreadLocal.withInitial(OWOWCache::getCipherInstance);
    private static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP_V1 = "name_id_map.cm";
    private static final String NAME_ID_MAP_V2 = "name_id_map_v2.cm";
    private static final String NAME_ID_MAP_V2_T = "name_id_map_v2_t.cm";
    public static final long MAGIC_NUMBER_WITH_CHECKSUM = 4207608830L;
    public static final long MAGIC_NUMBER_WITH_CHECKSUM_ENCRYPTED = 1L;
    private static final long MAGIC_NUMBER_WITHOUT_CHECKSUM = 4012948655L;
    private static final long MAGIC_NUMBER_WITHOUT_CHECKSUM_ENCRYPTED = 2L;
    private static final int MAGIC_NUMBER_OFFSET = 0;
    public static final int CHECKSUM_OFFSET = 8;
    private static final int PAGE_OFFSET_TO_CHECKSUM_FROM = 12;
    private static final int CHUNK_SIZE = 0x4000000;
    private static final OScheduledThreadPoolExecutorWithLogging commitExecutor;
    private static final ExecutorService cacheEventsPublisher;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final int diskSizeCheckInterval = OGlobalConfiguration.DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES.getValueAsInteger();
    private final List<WeakReference<OLowDiskSpaceListener>> lowDiskSpaceListeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final List<WeakReference<OPageIsBrokenListener>> pageIsBrokenListeners = new CopyOnWriteArrayList<WeakReference<OPageIsBrokenListener>>();
    private final AtomicLong lastDiskSpaceCheck = new AtomicLong(0L);
    private final Path storagePath;
    private final FileStore fileStore;
    private final OClosableLinkedContainer<Long, OFile> files;
    private final ConcurrentHashMap<PageKey, OCachePointer> writeCachePages = new ConcurrentHashMap();
    private final ConcurrentSkipListSet<PageKey> exclusiveWritePages = new ConcurrentSkipListSet();
    private final ConcurrentHashMap<PageKey, OLogSequenceNumber> dirtyPages = new ConcurrentHashMap();
    private final HashMap<PageKey, OLogSequenceNumber> localDirtyPages = new HashMap();
    private final TreeMap<Long, TreeSet<PageKey>> localDirtyPagesBySegment = new TreeMap();
    private final AtomicLong amountOfNewPagesAdded = new AtomicLong();
    private final AtomicLong writeCacheSize = new AtomicLong();
    private final AtomicLong exclusiveWriteCacheSize = new AtomicLong();
    private final LongAdder cacheOverflowCountSum = new LongAdder();
    private final OBinarySerializer<String> stringSerializer;
    private final int pageSize;
    private final OWriteAheadLog writeAheadLog;
    private final OLockManager<PageKey> lockManager = new OPartitionedLockManager<PageKey>();
    private final OReadersWriterSpinLock filesLock = new OReadersWriterSpinLock();
    private final ConcurrentMap<String, Integer> nameIdMap = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<Integer, String> idNameMap = new ConcurrentHashMap<Integer, String>();
    private final Random fileIdGen = new Random();
    private Path nameIdMapHolderPath;
    private final int id;
    private final OByteBufferPool bufferPool;
    private final String storageName;
    private volatile OChecksumMode checksumMode;
    private Throwable flushError;
    private final byte[] iv;
    private final byte[] aesKey;
    private final boolean useNativeOsAPI;
    private final int exclusiveWriteCacheMaxSize;
    private final boolean callFsync;
    private final int chunkSize;
    private final long pagesFlushInterval;
    private volatile boolean stopFlush;
    private volatile Future<?> flushFuture;
    private final ConcurrentHashMap<ExclusiveFlushTask, CountDownLatch> triggeredTasks = new ConcurrentHashMap();
    private final int shutdownTimeout;
    private final List<WeakReference<OBackgroundExceptionListener>> backgroundExceptionListeners = new CopyOnWriteArrayList<WeakReference<OBackgroundExceptionListener>>();
    private final DoubleWriteLog doubleWriteLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWOWCache(int pageSize, OByteBufferPool bufferPool, OWriteAheadLog writeAheadLog, DoubleWriteLog doubleWriteLog, long pagesFlushInterval, int shutdownTimeout, long exclusiveWriteCacheMaxSize, Path storagePath, String storageName, OBinarySerializer<String> stringSerializer, OClosableLinkedContainer<Long, OFile> files, int id, OChecksumMode checksumMode, byte[] iv, byte[] aesKey, boolean callFsync, boolean useNativeOsAPI) {
        if (aesKey != null && aesKey.length != 16 && aesKey.length != 24 && aesKey.length != 32) {
            throw new OInvalidStorageEncryptionKeyException("Invalid length of the encryption key, provided size is " + aesKey.length);
        }
        if (aesKey != null && iv == null) {
            throw new OInvalidStorageEncryptionKeyException("IV can not be null");
        }
        this.useNativeOsAPI = useNativeOsAPI;
        this.shutdownTimeout = shutdownTimeout;
        this.pagesFlushInterval = pagesFlushInterval;
        this.iv = iv;
        this.aesKey = aesKey;
        this.callFsync = callFsync;
        this.filesLock.acquireWriteLock();
        try {
            this.id = id;
            this.files = files;
            this.chunkSize = 0x4000000 / pageSize;
            this.pageSize = pageSize;
            this.writeAheadLog = writeAheadLog;
            this.bufferPool = bufferPool;
            this.checksumMode = checksumMode;
            this.exclusiveWriteCacheMaxSize = OWOWCache.normalizeMemory(exclusiveWriteCacheMaxSize, pageSize);
            this.storagePath = storagePath;
            try {
                this.fileStore = Files.getFileStore(this.storagePath);
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error during retrieving of file store"), e);
            }
            this.stringSerializer = stringSerializer;
            this.storageName = storageName;
            this.doubleWriteLog = doubleWriteLog;
            if (pagesFlushInterval > 0L) {
                this.flushFuture = commitExecutor.schedule(new PeriodicFlushTask(), pagesFlushInterval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public void loadRegisteredFiles() throws IOException, InterruptedException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            this.doubleWriteLog.open(this.storageName, this.storagePath, this.pageSize);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public void addBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        this.backgroundExceptionListeners.add(new WeakReference<OBackgroundExceptionListener>(listener));
    }

    @Override
    public void removeBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        ArrayList<WeakReference<OBackgroundExceptionListener>> itemsToRemove = new ArrayList<WeakReference<OBackgroundExceptionListener>>(1);
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener l = (OBackgroundExceptionListener)ref.get();
            if (l == null || !l.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.backgroundExceptionListeners.removeAll(itemsToRemove);
    }

    private void fireBackgroundDataFlushExceptionEvent(Throwable e) {
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener listener = (OBackgroundExceptionListener)ref.get();
            if (listener == null) continue;
            listener.onException(e);
        }
    }

    private static int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)pageSize;
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    @Override
    public Path getRootDirectory() {
        return this.storagePath;
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.lowDiskSpaceListeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void addPageIsBrokenListener(OPageIsBrokenListener listener) {
        this.pageIsBrokenListeners.add(new WeakReference<OPageIsBrokenListener>(listener));
    }

    @Override
    public void removePageIsBrokenListener(OPageIsBrokenListener listener) {
        ArrayList<WeakReference<OPageIsBrokenListener>> itemsToRemove = new ArrayList<WeakReference<OPageIsBrokenListener>>(1);
        for (WeakReference<OPageIsBrokenListener> ref : this.pageIsBrokenListeners) {
            OPageIsBrokenListener pageIsBrokenListener = (OPageIsBrokenListener)ref.get();
            if (pageIsBrokenListener != null && !pageIsBrokenListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.pageIsBrokenListeners.removeAll(itemsToRemove);
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>(1);
        for (WeakReference<OLowDiskSpaceListener> ref : this.lowDiskSpaceListeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.lowDiskSpaceListeners.removeAll(itemsToRemove);
    }

    private void freeSpaceCheckAfterNewPageAdd() throws IOException {
        long lastSpaceCheck;
        long newPagesAdded = this.amountOfNewPagesAdded.addAndGet(1L);
        if (newPagesAdded - (lastSpaceCheck = this.lastDiskSpaceCheck.get()) > (long)this.diskSizeCheckInterval || lastSpaceCheck == 0L) {
            long freeSpace = Files.getFileStore(this.storagePath).getUsableSpace();
            if (freeSpace < this.freeSpaceLimit) {
                this.callLowSpaceListeners(new OLowDiskSpaceInformation(freeSpace, this.freeSpaceLimit));
            }
            this.lastDiskSpaceCheck.lazySet(newPagesAdded);
        }
    }

    private void callLowSpaceListeners(final OLowDiskSpaceInformation information) {
        cacheEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference lowDiskSpaceListenerWeakReference : OWOWCache.this.lowDiskSpaceListeners) {
                    OLowDiskSpaceListener listener = (OLowDiskSpaceListener)lowDiskSpaceListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.lowDiskSpace(information);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during notification of low disk space for storage " + OWOWCache.this.storageName, e, new Object[0]);
                    }
                }
            }
        });
    }

    private void callPageIsBrokenListeners(final String fileName, final long pageIndex) {
        cacheEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference pageIsBrokenListenerWeakReference : OWOWCache.this.pageIsBrokenListeners) {
                    OPageIsBrokenListener listener = (OPageIsBrokenListener)pageIsBrokenListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.pageIsBroken(fileName, pageIndex);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during notification of page is broken for storage " + OWOWCache.this.storageName, e, new Object[0]);
                    }
                }
            }
        });
    }

    @Override
    public long bookFileId(String fileName) {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null) {
                if (fileId < 0) {
                    long l = OWOWCache.composeFileId(this.id, -fileId.intValue());
                    return l;
                }
                throw new OStorageException("File " + fileName + " has already been added to the storage");
            }
            while (true) {
                int nextId;
                if (this.idNameMap.containsKey(nextId = this.fileIdGen.nextInt(0x7FFFFFFE) + 1) || this.idNameMap.containsKey(-nextId)) continue;
                this.nameIdMap.put(fileName, -nextId);
                this.idNameMap.put(-nextId, fileName);
                long l = OWOWCache.composeFileId(this.id, nextId);
                return l;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public boolean fileIdsAreEqual(long firsId, long secondId) {
        int secondIntId;
        int firstIntId = OWOWCache.extractFileId(firsId);
        return firstIntId == (secondIntId = OWOWCache.extractFileId(secondId));
    }

    @Override
    public long loadFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                long externalId = OWOWCache.composeFileId(this.id, fileId);
                OFile fileClassic = this.files.get(externalId);
                if (fileClassic != null) {
                    long l = externalId;
                    return l;
                }
                throw new OStorageException("File with given name " + fileName + " only partially registered in storage");
            }
            if (fileId == null) {
                int nextId;
                while (this.idNameMap.containsKey(nextId = this.fileIdGen.nextInt(0x7FFFFFFE) + 1) || this.idNameMap.containsKey(-nextId)) {
                }
                fileId = nextId;
            } else {
                this.idNameMap.remove(fileId);
                fileId = -fileId.intValue();
            }
            OFile fileClassic = this.createFileInstance(fileName, fileId);
            if (!fileClassic.exists()) {
                throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageName);
            }
            OLogManager.instance().debug((Object)this, "File '" + fileName + "' is not registered in 'file name - id' map, but exists in file system. Registering it", new Object[0]);
            OWOWCache.openFile(fileClassic);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.idNameMap.put(fileId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId, fileClassic.getName()), true);
            long l = externalId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Load file was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long addFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                throw new OStorageException("File with name " + fileName + " already exists in storage " + this.storageName);
            }
            if (fileId == null) {
                int nextId;
                while (this.idNameMap.containsKey(nextId = this.fileIdGen.nextInt(0x7FFFFFFE) + 1) || this.idNameMap.containsKey(-nextId)) {
                }
                fileId = nextId;
            } else {
                this.idNameMap.remove(fileId);
                fileId = -fileId.intValue();
            }
            OFile fileClassic = this.createFileInstance(fileName, fileId);
            OWOWCache.createFile(fileClassic, this.callFsync);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.idNameMap.put(fileId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId, fileClassic.getName()), true);
            long l = externalId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File add was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long fileIdByName(String fileName) {
        Integer intId = (Integer)this.nameIdMap.get(fileName);
        if (intId == null || intId < 0) {
            return -1L;
        }
        return OWOWCache.composeFileId(this.id, intId);
    }

    @Override
    public int internalFileId(long fileId) {
        return OWOWCache.extractFileId(fileId);
    }

    @Override
    public long externalFileId(int fileId) {
        return OWOWCache.composeFileId(this.id, fileId);
    }

    @Override
    public Long getMinimalNotFlushedSegment() {
        Future<Long> future = commitExecutor.submit(new FindMinDirtySegment());
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void updateDirtyPagesTable(OCachePointer pointer, OLogSequenceNumber startLSN) {
        long fileId = pointer.getFileId();
        long pageIndex = pointer.getPageIndex();
        PageKey pageKey = new PageKey(this.internalFileId(fileId), pageIndex);
        OLogSequenceNumber dirtyLSN = startLSN != null ? startLSN : this.writeAheadLog.end();
        if (dirtyLSN == null) {
            dirtyLSN = new OLogSequenceNumber(0L, 0L);
        }
        this.dirtyPages.putIfAbsent(pageKey, dirtyLSN);
    }

    @Override
    public void create() {
    }

    @Override
    public void open() {
    }

    @Override
    public long addFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer existingFileId = (Integer)this.nameIdMap.get(fileName);
            int intId = OWOWCache.extractFileId(fileId);
            if (existingFileId != null && existingFileId >= 0) {
                if (existingFileId == intId) {
                    throw new OStorageException("File with name '" + fileName + "'' already exists in storage '" + this.storageName + "'");
                }
                throw new OStorageException("File with given name '" + fileName + "' already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFile fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                if (!fileClassic.getName().equals(OWOWCache.createInternalFileName(fileName, intId))) {
                    throw new OStorageException("File with given id exists but has different name " + fileClassic.getName() + " vs. proposed " + fileName);
                }
                fileClassic.shrink(0L);
                if (this.callFsync) {
                    fileClassic.synch();
                }
            } else {
                fileClassic = this.createFileInstance(fileName, intId);
                OWOWCache.createFile(fileClassic, this.callFsync);
                this.files.add(fileId, fileClassic);
            }
            this.idNameMap.remove(-intId);
            this.nameIdMap.put(fileName, intId);
            this.idNameMap.put(intId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, intId, fileClassic.getName()), true);
            long l = fileId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File add was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public boolean checkLowDiskSpace() throws IOException {
        long freeSpace = this.fileStore.getUsableSpace();
        return freeSpace < this.freeSpaceLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeFuzzyCheckpoint(long segmentId, byte[] lastMetadata) throws IOException {
        this.filesLock.acquireReadLock();
        try {
            this.doubleWriteLog.startCheckpoint();
            try {
                OLogSequenceNumber startLSN = this.writeAheadLog.begin(segmentId);
                if (startLSN == null) {
                    return;
                }
                this.writeAheadLog.logFuzzyCheckPointStart(startLSN);
                if (lastMetadata != null) {
                    this.writeAheadLog.log(new MetaDataRecord(lastMetadata));
                }
                for (Integer intId : this.nameIdMap.values()) {
                    if (intId < 0 || !this.callFsync) continue;
                    long fileId = OWOWCache.composeFileId(this.id, intId);
                    OClosableEntry<Long, OFile> entry = this.files.acquire(fileId);
                    try {
                        OFile fileClassic = entry.get();
                        fileClassic.synch();
                    }
                    finally {
                        this.files.release(entry);
                    }
                }
                this.writeAheadLog.logFuzzyCheckPointEnd();
                this.writeAheadLog.flush();
                this.writeAheadLog.cutAllSegmentsSmallerThan(segmentId);
                this.doubleWriteLog.truncate();
            }
            finally {
                this.doubleWriteLog.endCheckpoint();
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Fuzzy checkpoint was interrupted"), e);
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void flushTillSegment(long segmentId) {
        Future<Void> future = commitExecutor.submit(new FlushTillSegmentTask(segmentId));
        try {
            future.get();
        }
        catch (Exception e) {
            throw ODatabaseException.wrapException(new OStorageException("Error during data flush"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fileName) {
        this.filesLock.acquireReadLock();
        try {
            Integer intId = (Integer)this.nameIdMap.get(fileName);
            if (intId != null && intId >= 0) {
                OFile fileClassic = this.files.get(this.externalFileId(intId));
                if (fileClassic == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = fileClassic.exists();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            int intId = OWOWCache.extractFileId(fileId);
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFile file = this.files.get(fileId);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void restoreModeOn() throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.doubleWriteLog.restoreModeOn();
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public void restoreModeOff() {
        this.filesLock.acquireWriteLock();
        try {
            this.doubleWriteLog.restoreModeOff();
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public void checkCacheOverflow() throws InterruptedException {
        while (this.exclusiveWriteCacheSize.get() > (long)this.exclusiveWriteCacheMaxSize) {
            CountDownLatch cacheBoundaryLatch = new CountDownLatch(1);
            CountDownLatch completionLatch = new CountDownLatch(1);
            ExclusiveFlushTask exclusiveFlushTask = new ExclusiveFlushTask(cacheBoundaryLatch, completionLatch);
            this.triggeredTasks.put(exclusiveFlushTask, completionLatch);
            commitExecutor.submit(exclusiveFlushTask);
            cacheBoundaryLatch.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(long fileId, long pageIndex, OCachePointer dataPointer) {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PageKey pageKey = new PageKey(intId, pageIndex);
            Lock groupLock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                OCachePointer pagePointer = this.writeCachePages.get(pageKey);
                if (pagePointer == null) {
                    this.doPutInCache(dataPointer, pageKey);
                } else assert (pagePointer.equals(dataPointer));
            }
            finally {
                groupLock.unlock();
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    private void doPutInCache(OCachePointer dataPointer, PageKey pageKey) {
        this.writeCachePages.put(pageKey, dataPointer);
        this.writeCacheSize.incrementAndGet();
        dataPointer.setWritersListener(this);
        dataPointer.incrementWritersReferrer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> files() {
        this.filesLock.acquireReadLock();
        try {
            HashMap result = new HashMap(1000);
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                result.put(entry.getKey(), OWOWCache.composeFileId(this.id, (Integer)entry.getValue()));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCachePointer load(long fileId, long startPageIndex, OModifiableBoolean cacheHit, boolean verifyChecksums) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PageKey pageKey = new PageKey(intId, startPageIndex);
            Lock pageLock = this.lockManager.acquireSharedLock(pageKey);
            OCachePointer pagePointer = this.writeCachePages.get(pageKey);
            if (pagePointer == null) {
                try {
                    OCachePointer filePagePointer = this.loadFileContent(intId, startPageIndex, verifyChecksums);
                    if (filePagePointer != null) {
                        filePagePointer.incrementReadersReferrer();
                    }
                    OCachePointer oCachePointer = filePagePointer;
                    return oCachePointer;
                }
                finally {
                    pageLock.unlock();
                }
            }
            pagePointer.incrementReadersReferrer();
            pageLock.unlock();
            cacheHit.setValue(true);
            OCachePointer oCachePointer = pagePointer;
            return oCachePointer;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocateNewPage(long fileId) throws IOException {
        this.filesLock.acquireReadLock();
        try {
            OClosableEntry<Long, OFile> entry = this.files.acquire(fileId);
            try {
                OFile fileClassic = entry.get();
                long allocatedPosition = fileClassic.allocateSpace(this.pageSize);
                long allocationIndex = allocatedPosition / (long)this.pageSize;
                this.freeSpaceCheckAfterNewPageAdd();
                int pageIndex = (int)allocationIndex;
                if (pageIndex < 0) {
                    throw new IllegalStateException("Illegal page index value " + pageIndex);
                }
                int n = pageIndex;
                this.files.release(entry);
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.files.release(entry);
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OStorageException("Allocation of page was interrupted"), e);
                }
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void addOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.incrementAndGet();
        this.exclusiveWritePages.add(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void removeOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.decrementAndGet();
        this.exclusiveWritePages.remove(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void flush(long fileId) {
        Future<Void> future = commitExecutor.submit(new FileFlushTask(Collections.singleton(OWOWCache.extractFileId(fileId))));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OException.wrapException(new OInterruptedException("File flush was interrupted"), e);
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File flush was abnormally terminated"), e);
        }
    }

    @Override
    public void flush() {
        Future<Void> future = commitExecutor.submit(new FileFlushTask(this.nameIdMap.values()));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OException.wrapException(new OInterruptedException("File flush was interrupted"), e);
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File flush was abnormally terminated"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireReadLock();
        try {
            OClosableEntry<Long, OFile> entry = this.files.acquire(fileId);
            try {
                long l = entry.get().getFileSize() / (long)this.pageSize;
                this.files.release(entry);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.files.release(entry);
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OStorageException("Calculation of file size was interrupted"), e);
                }
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public long getExclusiveWriteCachePagesSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            ORawPair<String, String> file;
            Future<ORawPair<String, String>> future = commitExecutor.submit(new DeleteFileTask(fileId));
            try {
                file = future.get();
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OInterruptedException("File data removal was interrupted"), e);
            }
            catch (Exception e) {
                throw OException.wrapException(new OWriteCacheException("File data removal was abnormally terminated"), e);
            }
            if (file != null) {
                this.writeNameIdEntry(new NameFileIdEntry((String)file.first, -intId, (String)file.second), true);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            this.removeCachedPages(intId);
            OClosableEntry<Long, OFile> entry = this.files.acquire(fileId);
            try {
                entry.get().shrink(0L);
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File truncation was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String newFileName) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            String oldOsFileName;
            OClosableEntry<Long, OFile> entry = this.files.acquire(fileId);
            if (entry == null) {
                return;
            }
            String newOsFileName = OWOWCache.createInternalFileName(newFileName, intId);
            try {
                OFile file = entry.get();
                oldOsFileName = file.getName();
                Path newFile = this.storagePath.resolve(newOsFileName);
                file.renameTo(newFile);
            }
            finally {
                this.files.release(entry);
            }
            String oldFileName = (String)this.idNameMap.get(intId);
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, intId);
            this.idNameMap.put(intId, newFileName);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1, oldOsFileName), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, intId, newOsFileName), true);
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Rename of file was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    private void stopFlush() {
        this.stopFlush = true;
        for (CountDownLatch completionLatch : this.triggeredTasks.values()) {
            try {
                if (completionLatch.await(this.shutdownTimeout, TimeUnit.MINUTES)) continue;
                throw new OWriteCacheException("Can not shutdown data flush for storage " + this.storageName);
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OWriteCacheException("Flush of the data for storage " + this.storageName + " has been interrupted"), e);
            }
        }
        if (this.flushFuture != null) {
            try {
                this.flushFuture.get(this.shutdownTimeout, TimeUnit.MINUTES);
            }
            catch (InterruptedException | CancellationException exception) {
            }
            catch (ExecutionException e) {
                throw OException.wrapException(new OWriteCacheException("Error in execution of data flush for storage " + this.storageName), e);
            }
            catch (TimeoutException e) {
                throw OException.wrapException(new OWriteCacheException("Can not shutdown data flush for storage " + this.storageName), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] close() throws IOException {
        this.flush();
        this.stopFlush();
        this.filesLock.acquireWriteLock();
        try {
            Serializable intId2;
            Collection fileIds = this.nameIdMap.values();
            ArrayList<Long> closedIds = new ArrayList<Long>(1000);
            HashMap<Integer, String> idFileNameMap = new HashMap<Integer, String>(1000);
            for (Serializable intId2 : fileIds) {
                if ((Integer)intId2 < 0) continue;
                long extId = OWOWCache.composeFileId(this.id, (Integer)intId2);
                OFile fileClassic = this.files.remove(extId);
                idFileNameMap.put((Integer)intId2, fileClassic.getName());
                fileClassic.close();
                closedIds.add(extId);
            }
            FileChannel nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
            intId2 = null;
            try {
                nameIdMapHolder.truncate(0L);
                for (Map.Entry entry : this.nameIdMap.entrySet()) {
                    String fileName = (Integer)entry.getValue() >= 0 ? (String)idFileNameMap.get(entry.getValue()) : (String)entry.getKey();
                    this.writeNameIdEntry(new NameFileIdEntry((String)entry.getKey(), (Integer)entry.getValue(), fileName), false);
                }
                nameIdMapHolder.force(true);
            }
            catch (Throwable throwable) {
                intId2 = throwable;
                throw throwable;
            }
            finally {
                if (nameIdMapHolder != null) {
                    if (intId2 != null) {
                        try {
                            nameIdMapHolder.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)intId2).addSuppressed(throwable);
                        }
                    } else {
                        nameIdMapHolder.close();
                    }
                }
            }
            this.doubleWriteLog.close();
            this.nameIdMap.clear();
            this.idNameMap.clear();
            long[] ids = new long[closedIds.size()];
            int n = 0;
            Object object = closedIds.iterator();
            while (object.hasNext()) {
                long id;
                ids[n] = id = ((Long)((Object)object.next())).longValue();
                ++n;
            }
            object = ids;
            return object;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long fileId, boolean flush) {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            if (flush) {
                this.flush(intId);
            } else {
                this.removeCachedPages(intId);
            }
            if (!this.files.close(fileId)) {
                throw new OStorageException("Can not close file with id " + this.internalFileId(fileId) + " because it is still in use");
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String restoreFileById(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() != -intId) continue;
                this.addFile((String)entry.getKey(), fileId);
                String string = (String)entry.getKey();
                return string;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        return null;
    }

    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>(0);
        this.filesLock.acquireWriteLock();
        try {
            for (Integer intId : this.nameIdMap.values()) {
                if (intId < 0) continue;
                this.checkFileStoredPages(commandOutputListener, 5000, errors, intId);
            }
            OPageDataVerificationError[] oPageDataVerificationErrorArray = errors.toArray(new OPageDataVerificationError[0]);
            return oPageDataVerificationErrorArray;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileStoredPages(OCommandOutputListener commandOutputListener, int notificationTimeOut, List<OPageDataVerificationError> errors, Integer intId) throws InterruptedException {
        boolean fileIsCorrect;
        long externalId = OWOWCache.composeFileId(this.id, intId);
        OClosableEntry<Long, OFile> entry = this.files.acquire(externalId);
        OFile fileClassic = entry.get();
        String fileName = (String)this.idNameMap.get(intId);
        try {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Flashing file " + fileName + "... ");
            }
            this.flush(intId.intValue());
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Start verification of content of " + fileName + "file ...\n");
            }
            long time = System.currentTimeMillis();
            long filledUpTo = fileClassic.getFileSize();
            fileIsCorrect = true;
            for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                boolean checkSumIncorrect = false;
                boolean magicNumberIncorrect = false;
                byte[] data = new byte[this.pageSize];
                OPointer pointer = this.bufferPool.acquireDirect(true);
                try {
                    ByteBuffer byteBuffer = pointer.getNativeByteBuffer();
                    fileClassic.read(pos, byteBuffer, true);
                    byteBuffer.rewind();
                    byteBuffer.get(data);
                }
                finally {
                    this.bufferPool.release(pointer);
                }
                long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                if (magicNumber != 4207608830L && magicNumber != 4012948655L && magicNumber != 1L && magicNumber != 2L) {
                    magicNumberIncorrect = true;
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file '" + fileName + "' does not match!\n");
                    }
                    fileIsCorrect = false;
                }
                if (magicNumber != 4012948655L) {
                    int storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8);
                    CRC32 crc32 = new CRC32();
                    crc32.update(data, 12, data.length - 12);
                    int calculatedCRC32 = (int)crc32.getValue();
                    if (storedCRC32 != calculatedCRC32) {
                        checkSumIncorrect = true;
                        if (commandOutputListener != null) {
                            commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file '" + fileName + "' is incorrect!\n");
                        }
                        fileIsCorrect = false;
                    }
                }
                if (magicNumberIncorrect || checkSumIncorrect) {
                    errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileName));
                }
                if (commandOutputListener == null || System.currentTimeMillis() - time <= (long)notificationTimeOut) continue;
                time = notificationTimeOut;
                commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed...\n");
            }
        }
        catch (IOException ioe) {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Error: Error during processing of file '" + fileName + "'. " + ioe.getMessage() + "\n");
            }
            fileIsCorrect = false;
        }
        finally {
            this.files.release(entry);
        }
        if (!fileIsCorrect) {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Verification of file '" + fileName + "' is finished with errors.\n");
            }
        } else if (commandOutputListener != null) {
            commandOutputListener.onMessage("Verification of file '" + fileName + "' is successfully finished.\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] delete() throws IOException {
        ArrayList<Long> result = new ArrayList<Long>(1024);
        this.filesLock.acquireWriteLock();
        try {
            Iterator iterator = this.nameIdMap.values().iterator();
            while (iterator.hasNext()) {
                ORawPair<String, String> file;
                int internalFileId = (Integer)iterator.next();
                if (internalFileId < 0) continue;
                long externalId = OWOWCache.composeFileId(this.id, internalFileId);
                Future<ORawPair<String, String>> future = commitExecutor.submit(new DeleteFileTask(externalId));
                try {
                    file = future.get();
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OInterruptedException("File data removal was interrupted"), e);
                }
                catch (Exception e) {
                    throw OException.wrapException(new OWriteCacheException("File data removal was abnormally terminated"), e);
                }
                if (file == null) continue;
                result.add(externalId);
            }
            if (this.nameIdMapHolderPath != null) {
                if (Files.exists(this.nameIdMapHolderPath, new LinkOption[0])) {
                    Files.delete(this.nameIdMapHolderPath);
                }
                this.nameIdMapHolderPath = null;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        this.stopFlush();
        long[] fIds = new long[result.size()];
        int n = 0;
        for (Long fid : result) {
            fIds[n] = fid;
            ++n;
        }
        this.doubleWriteLog.close();
        return fIds;
    }

    @Override
    public String fileNameById(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        return (String)this.idNameMap.get(intId);
    }

    @Override
    public String nativeFileNameById(long fileId) {
        OFile fileClassic = this.files.get(fileId);
        if (fileClassic != null) {
            return fileClassic.getName();
        }
        return null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public long getCacheOverflowCount() {
        return this.cacheOverflowCountSum.sum();
    }

    public long getWriteCacheSize() {
        return this.writeCacheSize.get();
    }

    public long getExclusiveWriteCacheSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    private static void openFile(OFile fileClassic) {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            throw new OStorageException("File " + fileClassic + " does not exist.");
        }
    }

    private static void createFile(OFile fileClassic, boolean callFsync) throws IOException {
        if (!fileClassic.exists()) {
            fileClassic.create();
            if (callFsync) {
                fileClassic.synch();
            }
        } else {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
            fileClassic.shrink(0L);
            if (callFsync) {
                fileClassic.synch();
            }
        }
    }

    private void initNameIdMapping() throws IOException, InterruptedException {
        if (!Files.exists(this.storagePath, new LinkOption[0])) {
            Files.createDirectories(this.storagePath, new FileAttribute[0]);
        }
        Path nameIdMapHolderV1 = this.storagePath.resolve(NAME_ID_MAP_V1);
        Path nameIdMapHolderV2 = this.storagePath.resolve(NAME_ID_MAP_V2);
        if (Files.exists(nameIdMapHolderV1, new LinkOption[0])) {
            if (Files.exists(nameIdMapHolderV2, new LinkOption[0])) {
                Files.delete(nameIdMapHolderV2);
            }
            this.nameIdMapHolderPath = nameIdMapHolderV1;
            try (FileChannel nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);){
                this.readNameIdMapV1(nameIdMapHolder);
                this.convertNameIdMapFromV1ToV2();
            }
            this.nameIdMapHolderPath = this.storagePath.resolve(NAME_ID_MAP_V2);
            Files.delete(nameIdMapHolderV1);
        } else {
            this.nameIdMapHolderPath = this.storagePath.resolve(NAME_ID_MAP_V2);
            try (FileChannel nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);){
                this.readNameIdMapV2(nameIdMapHolder);
            }
        }
    }

    private void convertNameIdMapFromV1ToV2() throws IOException {
        Path nameIdMapHolderFileV2T = this.storagePath.resolve(NAME_ID_MAP_V2_T);
        if (Files.exists(nameIdMapHolderFileV2T, new LinkOption[0])) {
            Files.delete(nameIdMapHolderFileV2T);
        }
        FileChannel v2NameIdMapHolder = FileChannel.open(nameIdMapHolderFileV2T, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            if ((Integer)nameIdEntry.getValue() >= 0) {
                OFile fileClassic = this.files.get(this.externalFileId((Integer)nameIdEntry.getValue()));
                String fileSystemName = fileClassic.getName();
                NameFileIdEntry nameFileIdEntry = new NameFileIdEntry((String)nameIdEntry.getKey(), (Integer)nameIdEntry.getValue(), fileSystemName);
                this.writeNameIdEntry(v2NameIdMapHolder, nameFileIdEntry, false);
                continue;
            }
            NameFileIdEntry nameFileIdEntry = new NameFileIdEntry((String)nameIdEntry.getKey(), (Integer)nameIdEntry.getValue(), "");
            this.writeNameIdEntry(v2NameIdMapHolder, nameFileIdEntry, false);
        }
        v2NameIdMapHolder.force(true);
        v2NameIdMapHolder.close();
        Files.move(nameIdMapHolderFileV2T, this.storagePath.resolve(NAME_ID_MAP_V2), new CopyOption[0]);
    }

    private OFile createFileInstance(String fileName, int fileId) {
        String internalFileName = OWOWCache.createInternalFileName(fileName, fileId);
        return new AsyncFile(this.storagePath.resolve(internalFileName), this.pageSize, this.useNativeOsAPI);
    }

    private static String createInternalFileName(String fileName, int fileId) {
        int extSeparator = fileName.lastIndexOf(46);
        String prefix = extSeparator < 0 ? fileName : (extSeparator == 0 ? "" : fileName.substring(0, extSeparator));
        String suffix = extSeparator < 0 || extSeparator == fileName.length() - 1 ? "" : fileName.substring(extSeparator + 1);
        prefix = prefix + "_" + fileId;
        if (extSeparator >= 0) {
            return prefix + "." + suffix;
        }
        return prefix;
    }

    private void readNameIdMapV2(FileChannel nameIdMapHolder) throws IOException, InterruptedException {
        NameFileIdEntry nameFileIdEntry;
        this.nameIdMap.clear();
        long localFileCounter = -1L;
        nameIdMapHolder.position(0L);
        HashMap<Integer, String> idFileNameMap = new HashMap<Integer, String>(1000);
        while ((nameFileIdEntry = this.readNextNameIdEntryV2(nameIdMapHolder)) != null) {
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
            this.idNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.name);
            idFileNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.fileSystemName);
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            long externalId;
            int fileId = (Integer)nameIdEntry.getValue();
            if (fileId < 0 || this.files.get(externalId = OWOWCache.composeFileId(this.id, (Integer)nameIdEntry.getValue())) != null) continue;
            Path path = this.storagePath.resolve((String)idFileNameMap.get(nameIdEntry.getValue()));
            AsyncFile file = new AsyncFile(path, this.pageSize, this.useNativeOsAPI);
            if (file.exists()) {
                file.open();
                this.files.add(externalId, file);
                continue;
            }
            this.idNameMap.remove(fileId);
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId);
            this.idNameMap.put(-fileId, (String)nameIdEntry.getKey());
        }
    }

    private void readNameIdMapV1(FileChannel nameIdMapHolder) throws IOException, InterruptedException {
        Set<String> files;
        NameFileIdEntry nameFileIdEntry;
        HashMap<Integer, HashSet<String>> filesWithNegativeIds = new HashMap<Integer, HashSet<String>>(1000);
        this.nameIdMap.clear();
        long localFileCounter = -1L;
        nameIdMapHolder.position(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntryV1(nameIdMapHolder)) != null) {
            Integer existingId;
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            if ((existingId = (Integer)this.nameIdMap.get(nameFileIdEntry.name)) != null && existingId < 0 && (files = (HashSet<String>)filesWithNegativeIds.get(existingId)) != null) {
                files.remove(nameFileIdEntry.name);
                if (files.isEmpty()) {
                    filesWithNegativeIds.remove(existingId);
                }
            }
            if (nameFileIdEntry.fileId < 0) {
                files = (Set)filesWithNegativeIds.get(nameFileIdEntry.fileId);
                if (files == null) {
                    files = new HashSet<String>(8);
                    files.add(nameFileIdEntry.name);
                    filesWithNegativeIds.put(nameFileIdEntry.fileId, (HashSet<String>)files);
                } else {
                    files.add(nameFileIdEntry.name);
                }
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
            this.idNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.name);
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            long externalId;
            if ((Integer)nameIdEntry.getValue() < 0 || this.files.get(externalId = OWOWCache.composeFileId(this.id, (Integer)nameIdEntry.getValue())) != null) continue;
            AsyncFile fileClassic = new AsyncFile(this.storagePath.resolve((String)nameIdEntry.getKey()), this.pageSize, this.useNativeOsAPI);
            if (fileClassic.exists()) {
                fileClassic.open();
                this.files.add(externalId, fileClassic);
                continue;
            }
            Integer fileId = (Integer)this.nameIdMap.get(nameIdEntry.getKey());
            if (fileId == null || fileId <= 0) continue;
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId.intValue());
            this.idNameMap.remove(fileId);
            this.idNameMap.put(-fileId.intValue(), (String)nameIdEntry.getKey());
        }
        HashSet<String> fixedFiles = new HashSet<String>(8);
        for (Map.Entry entry : filesWithNegativeIds.entrySet()) {
            files = (Set)entry.getValue();
            if (files.size() <= 1) continue;
            this.idNameMap.remove(entry.getKey());
            for (String fileName : files) {
                int nextId;
                while (this.idNameMap.containsKey(nextId = this.fileIdGen.nextInt(0x7FFFFFFE) + 1) || this.idNameMap.containsKey(-nextId)) {
                }
                int fileId = nextId;
                this.nameIdMap.put(fileName, -fileId);
                this.idNameMap.put(-fileId, fileName);
                fixedFiles.add(fileName);
            }
        }
        if (!fixedFiles.isEmpty()) {
            OLogManager.instance().warn((Object)this, "Removed files " + fixedFiles + " had duplicated ids. Problem is fixed automatically.", new Object[0]);
        }
    }

    private NameFileIdEntry readNextNameIdEntryV1(FileChannel nameIdMapHolder) throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            OIOUtils.readByteBuffer(buffer, nameIdMapHolder);
            buffer.rewind();
            int nameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(nameSize + 8);
            OIOUtils.readByteBuffer(buffer, nameIdMapHolder);
            buffer.rewind();
            String name = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            int fileId = (int)buffer.getLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException ignore) {
            return null;
        }
    }

    private NameFileIdEntry readNextNameIdEntryV2(FileChannel nameIdMapHolder) throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            OIOUtils.readByteBuffer(buffer, nameIdMapHolder);
            buffer.rewind();
            int fileId = buffer.getInt();
            int nameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(nameSize);
            OIOUtils.readByteBuffer(buffer, nameIdMapHolder);
            buffer.rewind();
            String name = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            buffer = ByteBuffer.allocate(4);
            OIOUtils.readByteBuffer(buffer, nameIdMapHolder);
            buffer.rewind();
            int fileNameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(fileNameSize);
            OIOUtils.readByteBuffer(buffer, nameIdMapHolder);
            buffer.rewind();
            String fileName = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            return new NameFileIdEntry(name, fileId, fileName);
        }
        catch (EOFException ignore) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        try (FileChannel nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            this.writeNameIdEntry(nameIdMapHolder, nameFileIdEntry, sync);
        }
    }

    private void writeNameIdEntry(FileChannel nameIdMapHolder, NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        int nameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.name, new Object[0]);
        int fileNameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.fileSystemName, new Object[0]);
        ByteBuffer serializedRecord = ByteBuffer.allocate(12 + nameSize + fileNameSize);
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(nameFileIdEntry.fileId, serializedRecord, new Object[]{0});
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(nameSize, serializedRecord, new Object[]{4});
        this.stringSerializer.serializeInByteBufferObject(nameFileIdEntry.name, serializedRecord, 8);
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(fileNameSize, serializedRecord, new Object[]{8 + nameSize});
        this.stringSerializer.serializeInByteBufferObject(nameFileIdEntry.fileSystemName, serializedRecord, 12 + nameSize);
        serializedRecord.position(0);
        OIOUtils.writeByteBuffer(serializedRecord, nameIdMapHolder, nameIdMapHolder.size());
        nameIdMapHolder.write(serializedRecord);
        if (sync) {
            nameIdMapHolder.force(true);
        }
    }

    private void removeCachedPages(int fileId) {
        Future<Void> future = commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OInterruptedException("File data removal was interrupted"), e);
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File data removal was abnormally terminated"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OCachePointer loadFileContent(int internalFileId, long pageIndex, boolean verifyChecksums) throws IOException {
        long fileId = OWOWCache.composeFileId(this.id, internalFileId);
        try {
            OClosableEntry<Long, OFile> entry = this.files.acquire(fileId);
            try {
                OFile fileClassic = entry.get();
                if (fileClassic == null) {
                    throw new IllegalArgumentException("File with id " + internalFileId + " not found in WOW Cache");
                }
                long pagePosition = pageIndex * (long)this.pageSize;
                long pageEndPosition = pagePosition + (long)this.pageSize;
                if (fileClassic.getFileSize() >= pageEndPosition) {
                    OPointer pointer = this.bufferPool.acquireDirect(true);
                    ByteBuffer buffer = pointer.getNativeByteBuffer();
                    assert (buffer.position() == 0);
                    assert (buffer.order() == ByteOrder.nativeOrder());
                    fileClassic.read(pagePosition, buffer, false);
                    if (verifyChecksums && (this.checksumMode == OChecksumMode.StoreAndVerify || this.checksumMode == OChecksumMode.StoreAndThrow || this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode) && !this.verifyMagicChecksumAndDecryptPage(buffer, internalFileId, pageIndex)) {
                        OPointer doubleWritePointer = this.doubleWriteLog.loadPage(internalFileId, (int)pageIndex, this.bufferPool);
                        if (doubleWritePointer == null) {
                            this.assertPageIsBroken(pageIndex, fileId, pointer);
                        } else {
                            this.bufferPool.release(pointer);
                            buffer = doubleWritePointer.getNativeByteBuffer();
                            assert (buffer.position() == 0);
                            pointer = doubleWritePointer;
                            if (!this.verifyMagicChecksumAndDecryptPage(buffer, internalFileId, pageIndex)) {
                                this.assertPageIsBroken(pageIndex, fileId, pointer);
                            }
                        }
                    }
                    buffer.position(0);
                    OCachePointer oCachePointer = new OCachePointer(pointer, this.bufferPool, fileId, (int)pageIndex);
                    return oCachePointer;
                }
                OPointer pointer = this.doubleWriteLog.loadPage(internalFileId, (int)pageIndex, this.bufferPool);
                if (pointer != null) {
                    ByteBuffer buffer = pointer.getNativeByteBuffer();
                    assert (buffer.position() == 0);
                    if (verifyChecksums && (this.checksumMode == OChecksumMode.StoreAndVerify || this.checksumMode == OChecksumMode.StoreAndThrow || this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode) && !this.verifyMagicChecksumAndDecryptPage(buffer, internalFileId, pageIndex)) {
                        this.assertPageIsBroken(pageIndex, fileId, pointer);
                    }
                }
                OCachePointer oCachePointer = null;
                return oCachePointer;
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Data load was interrupted"), e);
        }
    }

    private void assertPageIsBroken(long pageIndex, long fileId, OPointer pointer) {
        String message = "Magic number verification failed for page `" + pageIndex + "` of `" + this.fileNameById(fileId) + "`.";
        OLogManager.instance().error(this, "%s", null, message);
        if (this.checksumMode == OChecksumMode.StoreAndThrow) {
            this.bufferPool.release(pointer);
            throw new OStorageException(message);
        }
        if (this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode) {
            this.dumpStackTrace(message);
            this.callPageIsBrokenListeners(this.fileNameById(fileId), pageIndex);
        }
    }

    private void addMagicChecksumAndEncryption(int intId, int pageIndex, ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.nativeOrder());
        if (this.checksumMode != OChecksumMode.Off) {
            buffer.position(12);
            CRC32 crc32 = new CRC32();
            crc32.update(buffer);
            int computedChecksum = (int)crc32.getValue();
            buffer.position(8);
            buffer.putInt(computedChecksum);
        }
        if (this.aesKey != null) {
            long magicNumber = buffer.getLong(0);
            long updateCounter = magicNumber >>> 8;
            magicNumber = this.checksumMode == OChecksumMode.Off ? updateCounter << 8 | 2L : ++updateCounter << 8 | 1L;
            buffer.putLong(0, magicNumber);
            this.doEncryptionDecryption(intId, pageIndex, 1, buffer, updateCounter);
        } else {
            buffer.putLong(0, this.checksumMode == OChecksumMode.Off ? 4012948655L : 4207608830L);
        }
    }

    private void doEncryptionDecryption(int intId, int pageIndex, int mode, ByteBuffer buffer, long updateCounter) {
        try {
            int i;
            Cipher cipher = CIPHER.get();
            SecretKeySpec aesKey = new SecretKeySpec(this.aesKey, ALGORITHM_NAME);
            byte[] updatedIv = new byte[this.iv.length];
            for (i = 0; i < 4; ++i) {
                updatedIv[i] = (byte)(this.iv[i] ^ pageIndex >>> i & 0xFF);
            }
            for (i = 0; i < 4; ++i) {
                updatedIv[i + 4] = (byte)(this.iv[i + 4] ^ intId >>> i & 0xFF);
            }
            for (i = 0; i < 7; ++i) {
                updatedIv[i + 8] = (byte)((long)this.iv[i + 8] ^ updateCounter >>> i & 0xFFL);
            }
            updatedIv[updatedIv.length - 1] = this.iv[this.iv.length - 1];
            cipher.init(mode, (Key)aesKey, new IvParameterSpec(updatedIv));
            ByteBuffer outBuffer = ByteBuffer.allocate(buffer.capacity() - 8).order(ByteOrder.nativeOrder());
            buffer.position(8);
            cipher.doFinal(buffer, outBuffer);
            buffer.position(8);
            outBuffer.position(0);
            buffer.put(outBuffer);
        }
        catch (InvalidKeyException e) {
            throw OException.wrapException(new OInvalidStorageEncryptionKeyException(e.getMessage()), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("Invalid IV.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IllegalStateException("Unexpected exception during CRT encryption.", e);
        }
    }

    private boolean verifyMagicChecksumAndDecryptPage(ByteBuffer buffer, int intId, long pageIndex) {
        assert (buffer.order() == ByteOrder.nativeOrder());
        buffer.position(0);
        long magicNumber = OLongSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        if (this.aesKey == null && magicNumber != 4207608830L || magicNumber != 4207608830L && (magicNumber & 0xFFL) != 1L) {
            if (this.aesKey == null && magicNumber != 4012948655L || magicNumber != 4012948655L && (magicNumber & 0xFFL) != 2L) {
                return false;
            }
            if (this.aesKey != null && (magicNumber & 0xFFL) == 2L) {
                this.doEncryptionDecryption(intId, (int)pageIndex, 2, buffer, magicNumber >>> 8);
            }
            return true;
        }
        if (this.aesKey != null && (magicNumber & 0xFFL) == 1L) {
            this.doEncryptionDecryption(intId, (int)pageIndex, 2, buffer, magicNumber >>> 8);
        }
        buffer.position(8);
        int storedChecksum = OIntegerSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        buffer.position(12);
        CRC32 crc32 = new CRC32();
        crc32.update(buffer);
        int computedChecksum = (int)crc32.getValue();
        return computedChecksum == storedChecksum;
    }

    private void dumpStackTrace(String message) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(message);
        Exception exception = new Exception();
        exception.printStackTrace(printWriter);
        printWriter.flush();
        OLogManager.instance().error(this, stringWriter.toString(), null, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fsyncFiles() throws InterruptedException, IOException {
        Iterator iterator = this.idNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            int intFileId = (Integer)iterator.next();
            if (intFileId < 0) continue;
            long extFileId = this.externalFileId(intFileId);
            OClosableEntry<Long, OFile> fileEntry = this.files.acquire(extFileId);
            try {
                OFile fileClassic = fileEntry.get();
                fileClassic.synch();
            }
            finally {
                this.files.release(fileEntry);
            }
        }
        this.doubleWriteLog.truncate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveCachePages(int internalFileId) {
        Iterator<Map.Entry<PageKey, OCachePointer>> entryIterator = this.writeCachePages.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<PageKey, OCachePointer> entry = entryIterator.next();
            PageKey pageKey = entry.getKey();
            if (pageKey.fileId != internalFileId) continue;
            OCachePointer pagePointer = entry.getValue();
            Lock groupLock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                pagePointer.acquireExclusiveLock();
                try {
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    this.writeCacheSize.decrementAndGet();
                    this.removeFromDirtyPages(pageKey);
                }
                finally {
                    pagePointer.releaseExclusiveLock();
                }
                entryIterator.remove();
            }
            finally {
                groupLock.unlock();
            }
        }
    }

    public void setChecksumMode(OChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    private void convertSharedDirtyPagesToLocal() {
        for (Map.Entry<PageKey, OLogSequenceNumber> entry : this.dirtyPages.entrySet()) {
            OLogSequenceNumber localLSN = this.localDirtyPages.get(entry.getKey());
            if (localLSN != null && localLSN.compareTo(entry.getValue()) <= 0) continue;
            this.localDirtyPages.put(entry.getKey(), entry.getValue());
            long segment = entry.getValue().getSegment();
            TreeSet<PageKey> pages = this.localDirtyPagesBySegment.get(segment);
            if (pages == null) {
                pages = new TreeSet();
                pages.add(entry.getKey());
                this.localDirtyPagesBySegment.put(segment, pages);
                continue;
            }
            pages.add(entry.getKey());
        }
        for (Map.Entry<PageKey, OLogSequenceNumber> entry : this.localDirtyPages.entrySet()) {
            this.dirtyPages.remove(entry.getKey(), entry.getValue());
        }
    }

    private void removeFromDirtyPages(PageKey pageKey) {
        this.dirtyPages.remove(pageKey);
        OLogSequenceNumber lsn = this.localDirtyPages.remove(pageKey);
        if (lsn != null) {
            long segment = lsn.getSegment();
            TreeSet<PageKey> pages = this.localDirtyPagesBySegment.get(segment);
            assert (pages != null);
            boolean removed = pages.remove(pageKey);
            if (pages.isEmpty()) {
                this.localDirtyPagesBySegment.remove(segment);
            }
            assert (removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushWriteCacheFromMinLSN(long segStart, long segEnd, int pagesFlushLimit) throws InterruptedException, IOException {
        this.convertSharedDirtyPagesToLocal();
        int copiedPages = 0;
        ArrayList<List<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>> chunks = new ArrayList<List<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>>(16);
        ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>> chunk = new ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>(16);
        long currentSegment = segStart;
        int chunksSize = 0;
        OLogSequenceNumber maxFullLogLSN = null;
        block3: while (chunksSize < pagesFlushLimit) {
            if (!chunk.isEmpty()) {
                throw new IllegalStateException("Chunk is not empty !");
            }
            TreeSet<PageKey> segmentPages = this.localDirtyPagesBySegment.get(currentSegment);
            if (segmentPages == null) {
                if (++currentSegment < segEnd) continue;
                break;
            }
            Iterator<PageKey> lsnPagesIterator = segmentPages.iterator();
            ArrayList<PageKey> pageKeysToFlush = new ArrayList<PageKey>(pagesFlushLimit);
            while (lsnPagesIterator.hasNext() && pageKeysToFlush.size() < pagesFlushLimit - chunksSize) {
                PageKey pageKey = lsnPagesIterator.next();
                pageKeysToFlush.add(pageKey);
            }
            long lastPageIndex = -1L;
            long lastFileId = -1L;
            for (PageKey pageKey : pageKeysToFlush) {
                OCachePointer pointer;
                if (lastFileId == -1L) {
                    if (!chunk.isEmpty()) {
                        throw new IllegalStateException("Chunk is not empty !");
                    }
                } else {
                    if (lastPageIndex == -1L) {
                        throw new IllegalStateException("Last page index is -1");
                    }
                    if (!(lastFileId == (long)pageKey.fileId && lastPageIndex == pageKey.pageIndex - 1L || chunk.isEmpty())) {
                        chunks.add(chunk);
                        chunksSize += chunk.size();
                        chunk = new ArrayList();
                    }
                }
                if ((pointer = this.writeCachePages.get(pageKey)) == null) {
                    if (chunk.isEmpty()) break block3;
                    chunks.add(chunk);
                    chunk = new ArrayList();
                    break block3;
                }
                if (pointer.tryAcquireSharedLock()) {
                    OLogSequenceNumber fullLogLSN;
                    long version;
                    OPointer directPointer = this.bufferPool.acquireDirect(false);
                    ByteBuffer copy = directPointer.getNativeByteBuffer();
                    assert (copy.position() == 0);
                    try {
                        version = pointer.getVersion();
                        ByteBuffer buffer = pointer.getBufferDuplicate();
                        fullLogLSN = pointer.getEndLSN();
                        assert (buffer != null);
                        buffer.position(0);
                        copy.position(0);
                        copy.put(buffer);
                        this.removeFromDirtyPages(pageKey);
                        ++copiedPages;
                    }
                    finally {
                        pointer.releaseSharedLock();
                    }
                    if (fullLogLSN != null && (maxFullLogLSN == null || fullLogLSN.compareTo(maxFullLogLSN) > 0)) {
                        maxFullLogLSN = fullLogLSN;
                    }
                    copy.position(0);
                    chunk.add(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(version, copy, directPointer, pointer));
                    if (chunksSize + chunk.size() >= pagesFlushLimit) {
                        if (!chunk.isEmpty()) {
                            chunks.add(chunk);
                            chunksSize += chunk.size();
                            chunk = new ArrayList();
                        }
                        lastPageIndex = -1L;
                        lastFileId = -1L;
                        continue;
                    }
                    lastPageIndex = pageKey.pageIndex;
                    lastFileId = pageKey.fileId;
                    continue;
                }
                if (!chunk.isEmpty()) {
                    chunks.add(chunk);
                    chunksSize += chunk.size();
                    chunk = new ArrayList();
                }
                maxFullLogLSN = null;
                lastPageIndex = -1L;
                lastFileId = -1L;
            }
            if (chunk.isEmpty()) continue;
            chunks.add(chunk);
            chunksSize += chunk.size();
            chunk = new ArrayList();
        }
        if (!chunk.isEmpty()) {
            throw new IllegalStateException("Chunk is not empty !");
        }
        int flushedPages = this.flushPages(chunks, maxFullLogLSN);
        if (copiedPages != flushedPages) {
            throw new IllegalStateException("Copied pages (" + copiedPages + " ) != flushed pages (" + flushedPages + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flushPages(List<List<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>> chunks, OLogSequenceNumber fullLogLSN) throws InterruptedException, IOException {
        boolean fsyncFiles;
        if (chunks.isEmpty()) {
            return 0;
        }
        if (fullLogLSN != null) {
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLsn();
            while (flushedLSN == null || flushedLSN.compareTo(fullLogLSN) < 0) {
                this.writeAheadLog.flush();
                flushedLSN = this.writeAheadLog.getFlushedLsn();
            }
        }
        int flushedPages = 0;
        OPointer[] containerPointers = new OPointer[chunks.size()];
        ByteBuffer[] containerBuffers = new ByteBuffer[chunks.size()];
        int[] chunkPositions = new int[chunks.size()];
        int[] chunkFileIds = new int[chunks.size()];
        HashMap<Long, List> buffersByFileId = new HashMap<Long, List>();
        try {
            for (int i = 0; i < chunks.size(); ++i) {
                List<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>> list = chunks.get(i);
                flushedPages += list.size();
                OPointer containerPointer = ODirectMemoryAllocator.instance().allocate(list.size() * this.pageSize, -1, false);
                ByteBuffer containerBuffer = containerPointer.getNativeByteBuffer();
                assert (containerBuffer.position() == 0);
                containerPointers[i] = containerPointer;
                containerBuffers[i] = containerBuffer;
                for (OQuarto<Long, ByteBuffer, OPointer, OCachePointer> oQuarto : list) {
                    ByteBuffer byteBuffer = (ByteBuffer)oQuarto.two;
                    OCachePointer pointer = (OCachePointer)oQuarto.four;
                    this.addMagicChecksumAndEncryption(OWOWCache.extractFileId(pointer.getFileId()), pointer.getPageIndex(), byteBuffer);
                    byteBuffer.position(0);
                    containerBuffer.put(byteBuffer);
                }
                OQuarto<Long, ByteBuffer, OPointer, OCachePointer> firstPage = list.get(0);
                OCachePointer oCachePointer = (OCachePointer)firstPage.four;
                long l = oCachePointer.getFileId();
                int pageIndex = oCachePointer.getPageIndex();
                List fileBuffers = buffersByFileId.computeIfAbsent(l, id -> new ArrayList());
                fileBuffers.add(new ORawPair<Long, ByteBuffer>((long)pageIndex * (long)this.pageSize, containerBuffer));
                chunkPositions[i] = pageIndex;
                chunkFileIds[i] = this.internalFileId(l);
            }
            fsyncFiles = this.doubleWriteLog.write(containerBuffers, chunkFileIds, chunkPositions);
            ArrayList acquiredFiles = new ArrayList(buffersByFileId.size());
            ArrayList<IOResult> arrayList = new ArrayList<IOResult>(buffersByFileId.size());
            Iterator filesIterator = buffersByFileId.entrySet().iterator();
            Map.Entry entry = null;
            while (true) {
                Iterator fileEntry;
                if (entry == null) {
                    if (!filesIterator.hasNext()) break;
                    entry = filesIterator.next();
                }
                if ((fileEntry = this.files.tryAcquire((Long)entry.getKey())) != null) {
                    OFile oFile = ((OClosableEntry)((Object)fileEntry)).get();
                    List list = (List)entry.getValue();
                    arrayList.add(oFile.write(list));
                    acquiredFiles.add(fileEntry);
                    entry = null;
                    continue;
                }
                assert (arrayList.size() == acquiredFiles.size());
                if (!arrayList.isEmpty()) {
                    for (IOResult iOResult : arrayList) {
                        iOResult.await();
                    }
                    for (OClosableEntry oClosableEntry : acquiredFiles) {
                        this.files.release(oClosableEntry);
                    }
                    arrayList.clear();
                    acquiredFiles.clear();
                    continue;
                }
                Thread.yield();
            }
            assert (arrayList.size() == acquiredFiles.size());
            if (!arrayList.isEmpty()) {
                for (IOResult iOResult : arrayList) {
                    iOResult.await();
                }
                for (OClosableEntry oClosableEntry : acquiredFiles) {
                    this.files.release(oClosableEntry);
                }
            }
        }
        finally {
            for (OPointer containerPointer : containerPointers) {
                ODirectMemoryAllocator.instance().deallocate(containerPointer);
            }
        }
        if (fsyncFiles) {
            this.fsyncFiles();
        }
        for (List list : chunks) {
            for (OQuarto chunkPage : list) {
                block32: {
                    OCachePointer pointer = (OCachePointer)chunkPage.four;
                    PageKey pageKey = new PageKey(this.internalFileId(pointer.getFileId()), pointer.getPageIndex());
                    long l = (Long)chunkPage.one;
                    Lock lock = this.lockManager.acquireExclusiveLock(pageKey);
                    try {
                        if (!pointer.tryAcquireSharedLock()) continue;
                        try {
                            if (l != pointer.getVersion()) break block32;
                            this.writeCachePages.remove(pageKey);
                            this.writeCacheSize.decrementAndGet();
                            pointer.decrementWritersReferrer();
                            pointer.setWritersListener(null);
                        }
                        finally {
                            pointer.releaseSharedLock();
                        }
                    }
                    finally {
                        lock.unlock();
                        continue;
                    }
                }
                this.bufferPool.release((OPointer)chunkPage.three);
            }
        }
        return flushedPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushExclusiveWriteCache(CountDownLatch latch, long pagesToFlush) throws InterruptedException, IOException {
        Iterator<PageKey> iterator = this.exclusiveWritePages.iterator();
        int flushedPages = 0;
        int copiedPages = 0;
        long ewcSize = this.exclusiveWriteCacheSize.get();
        pagesToFlush = Math.min(Math.max(pagesToFlush, (long)this.chunkSize), ewcSize);
        ArrayList<List<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>> chunks = new ArrayList<List<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>>(16);
        ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>> chunk = new ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>(16);
        if (latch != null && ewcSize <= (long)this.exclusiveWriteCacheMaxSize) {
            latch.countDown();
        }
        OLogSequenceNumber maxFullLogLSN = null;
        int chunksSize = 0;
        block3: while ((long)chunksSize < pagesToFlush) {
            long lastFileId = -1L;
            long lastPageIndex = -1L;
            while ((long)(chunksSize + chunk.size()) < pagesToFlush) {
                if (!iterator.hasNext()) {
                    if (chunk.isEmpty()) break block3;
                    chunks.add(chunk);
                    break block3;
                }
                PageKey pageKey = iterator.next();
                OCachePointer pointer = this.writeCachePages.get(pageKey);
                if (pointer == null) {
                    iterator.remove();
                    continue;
                }
                if (pointer.tryAcquireSharedLock()) {
                    OLogSequenceNumber fullLSN;
                    long version;
                    OPointer directPointer = this.bufferPool.acquireDirect(false);
                    ByteBuffer copy = directPointer.getNativeByteBuffer();
                    assert (copy.position() == 0);
                    try {
                        version = pointer.getVersion();
                        ByteBuffer buffer = pointer.getBufferDuplicate();
                        fullLSN = pointer.getEndLSN();
                        assert (buffer != null);
                        buffer.position(0);
                        copy.position(0);
                        copy.put(buffer);
                        this.removeFromDirtyPages(pageKey);
                        ++copiedPages;
                    }
                    finally {
                        pointer.releaseSharedLock();
                    }
                    if (fullLSN != null && (maxFullLogLSN == null || maxFullLogLSN.compareTo(fullLSN) < 0)) {
                        maxFullLogLSN = fullLSN;
                    }
                    copy.position(0);
                    if (chunk.isEmpty()) {
                        chunk.add(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(version, copy, directPointer, pointer));
                    } else if (lastFileId != pointer.getFileId() || lastPageIndex != (long)(pointer.getPageIndex() - 1)) {
                        chunks.add(chunk);
                        chunk = new ArrayList();
                        if ((chunksSize += chunk.size()) - flushedPages >= this.chunkSize) {
                            flushedPages += this.flushPages(chunks, maxFullLogLSN);
                            chunks.clear();
                            if (latch != null && this.exclusiveWriteCacheSize.get() <= (long)this.exclusiveWriteCacheMaxSize) {
                                latch.countDown();
                            }
                            maxFullLogLSN = null;
                        }
                        chunk.add(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(version, copy, directPointer, pointer));
                    } else {
                        chunk.add(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(version, copy, directPointer, pointer));
                    }
                    lastFileId = pointer.getFileId();
                    lastPageIndex = pointer.getPageIndex();
                    continue;
                }
                if (!chunk.isEmpty()) {
                    chunks.add(chunk);
                    chunksSize += chunk.size();
                    chunk = new ArrayList();
                }
                if (chunksSize - flushedPages >= this.chunkSize) {
                    flushedPages += this.flushPages(chunks, maxFullLogLSN);
                    chunks.clear();
                    if (latch != null && this.exclusiveWriteCacheSize.get() <= (long)this.exclusiveWriteCacheMaxSize) {
                        latch.countDown();
                    }
                    maxFullLogLSN = null;
                }
                lastFileId = -1L;
                lastPageIndex = -1L;
            }
            if (chunk.isEmpty()) continue;
            chunks.add(chunk);
            chunk = new ArrayList();
            if ((chunksSize += chunk.size()) - flushedPages < this.chunkSize) continue;
            flushedPages += this.flushPages(chunks, maxFullLogLSN);
            chunks.clear();
            maxFullLogLSN = null;
            if (latch == null || this.exclusiveWriteCacheSize.get() > (long)this.exclusiveWriteCacheMaxSize) continue;
            latch.countDown();
        }
        if (copiedPages != (flushedPages += this.flushPages(chunks, maxFullLogLSN))) {
            throw new IllegalStateException("Copied pages (" + copiedPages + " ) != flushed pages (" + flushedPages + ")");
        }
    }

    private static Cipher getCipherInstance() {
        try {
            return Cipher.getInstance(TRANSFORMATION);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw OException.wrapException(new OSecurityException("Implementation of encryption AES/CTR/NoPadding is absent"), e);
        }
    }

    static {
        cacheEventsPublisher = new OThreadPoolExecutorWithLogging(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new CacheEventsPublisherFactory());
        commitExecutor = new OScheduledThreadPoolExecutorWithLogging(1, new FlushThreadFactory());
        commitExecutor.setMaximumPoolSize(1);
    }

    private static final class CacheEventsPublisherFactory
    implements ThreadFactory {
        private CacheEventsPublisherFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Write Cache Event Publisher");
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        }
    }

    private static final class FlushThreadFactory
    implements ThreadFactory {
        private FlushThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Write Cache Flush Task");
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        }
    }

    private final class DeleteFileTask
    implements Callable<ORawPair<String, String>> {
        private final long externalFileId;

        private DeleteFileTask(long externalFileId) {
            this.externalFileId = externalFileId;
        }

        @Override
        public ORawPair<String, String> call() throws Exception {
            int internalFileId = OAbstractWriteCache.extractFileId(this.externalFileId);
            long fileId = OAbstractWriteCache.composeFileId(OWOWCache.this.id, internalFileId);
            OWOWCache.this.doRemoveCachePages(internalFileId);
            OFile fileClassic = (OFile)OWOWCache.this.files.remove(fileId);
            if (fileClassic != null) {
                if (fileClassic.exists()) {
                    fileClassic.delete();
                }
                String name = (String)OWOWCache.this.idNameMap.get(internalFileId);
                OWOWCache.this.idNameMap.remove(internalFileId);
                OWOWCache.this.nameIdMap.put(name, -internalFileId);
                OWOWCache.this.idNameMap.put(-internalFileId, name);
                return new ORawPair<String, String>(fileClassic.getName(), name);
            }
            return null;
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final int fileId;

        private RemoveFilePagesTask(int fileId) {
            this.fileId = fileId;
        }

        @Override
        public Void call() {
            OWOWCache.this.doRemoveCachePages(this.fileId);
            return null;
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final Set<Integer> fileIdSet;

        private FileFlushTask(Collection<Integer> fileIds) {
            this.fileIdSet = new HashSet<Integer>(fileIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not flush file data because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            OWOWCache.this.writeAheadLog.flush();
            TreeSet<PageKey> pagesToFlush = new TreeSet<PageKey>();
            for (Map.Entry entry : OWOWCache.this.writeCachePages.entrySet()) {
                PageKey pageKey = (PageKey)entry.getKey();
                if (!this.fileIdSet.contains(pageKey.fileId)) continue;
                pagesToFlush.add(pageKey);
            }
            OLogSequenceNumber maxLSN = null;
            ArrayList<List<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>> chunks = new ArrayList<List<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>>(OWOWCache.this.chunkSize);
            for (PageKey pageKey : pagesToFlush) {
                if (!this.fileIdSet.contains(pageKey.fileId)) continue;
                OCachePointer pagePointer = (OCachePointer)OWOWCache.this.writeCachePages.get(pageKey);
                Lock pageLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getBufferDuplicate();
                        OPointer directPointer = OWOWCache.this.bufferPool.acquireDirect(false);
                        ByteBuffer copy = directPointer.getNativeByteBuffer();
                        assert (copy.position() == 0);
                        assert (buffer != null);
                        buffer.position(0);
                        copy.put(buffer);
                        OLogSequenceNumber endLSN = pagePointer.getEndLSN();
                        if (endLSN != null && (maxLSN == null || endLSN.compareTo(maxLSN) > 0)) {
                            maxLSN = endLSN;
                        }
                        chunks.add(Collections.singletonList(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(pagePointer.getVersion(), copy, directPointer, pagePointer)));
                        OWOWCache.this.removeFromDirtyPages(pageKey);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                }
                finally {
                    pageLock.unlock();
                    continue;
                }
                if (chunks.size() < 4 * OWOWCache.this.chunkSize) continue;
                OWOWCache.this.flushPages(chunks, maxLSN);
                chunks.clear();
            }
            OWOWCache.this.flushPages(chunks, maxLSN);
            if (OWOWCache.this.callFsync) {
                Iterator<Object> iterator = this.fileIdSet.iterator();
                while (iterator.hasNext()) {
                    int iFileId = (Integer)iterator.next();
                    long finalId = OAbstractWriteCache.composeFileId(OWOWCache.this.id, iFileId);
                    OClosableEntry entry = OWOWCache.this.files.acquire(finalId);
                    if (entry == null) continue;
                    try {
                        ((OFile)entry.get()).synch();
                    }
                    finally {
                        OWOWCache.this.files.release(entry);
                    }
                }
            }
            return null;
        }
    }

    final class FindMinDirtySegment
    implements Callable<Long> {
        FindMinDirtySegment() {
        }

        @Override
        public Long call() {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not calculate minimum LSN because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            OWOWCache.this.convertSharedDirtyPagesToLocal();
            if (OWOWCache.this.localDirtyPagesBySegment.isEmpty()) {
                return null;
            }
            return (Long)OWOWCache.this.localDirtyPagesBySegment.firstKey();
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long flushInterval;
            block17: {
                block16: {
                    if (OWOWCache.this.stopFlush) {
                        return;
                    }
                    flushInterval = OWOWCache.this.pagesFlushInterval;
                    if (OWOWCache.this.flushError == null) break block16;
                    OLogManager.instance().errorNoDb(this, "Can not flush data because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                    if (flushInterval > 0L && !OWOWCache.this.stopFlush) {
                        OWOWCache.this.flushFuture = commitExecutor.schedule(this, flushInterval, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                if (!OWOWCache.this.writeCachePages.isEmpty()) break block17;
                if (flushInterval > 0L && !OWOWCache.this.stopFlush) {
                    OWOWCache.this.flushFuture = commitExecutor.schedule(this, flushInterval, TimeUnit.MILLISECONDS);
                }
                return;
            }
            try {
                try {
                    long ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
                    if (ewcSize >= 0L) {
                        OWOWCache.this.flushExclusiveWriteCache(null, Math.min(ewcSize, (long)(4 * OWOWCache.this.chunkSize)));
                        if (OWOWCache.this.exclusiveWriteCacheSize.get() > 0L) {
                            flushInterval = 1L;
                        }
                    }
                    OLogSequenceNumber begin = OWOWCache.this.writeAheadLog.begin();
                    OLogSequenceNumber end = OWOWCache.this.writeAheadLog.end();
                    long segments = end.getSegment() - begin.getSegment() + 1L;
                    if (segments > 1L) {
                        long firstSegmentIndex;
                        OWOWCache.this.convertSharedDirtyPagesToLocal();
                        Map.Entry firstSegment = OWOWCache.this.localDirtyPagesBySegment.firstEntry();
                        if (firstSegment != null && (firstSegmentIndex = ((Long)firstSegment.getKey()).longValue()) < end.getSegment()) {
                            OWOWCache.this.flushWriteCacheFromMinLSN(firstSegmentIndex, firstSegmentIndex + 1L, OWOWCache.this.chunkSize);
                        }
                        if ((firstSegment = OWOWCache.this.localDirtyPagesBySegment.firstEntry()) != null && (Long)firstSegment.getKey() < end.getSegment()) {
                            flushInterval = 1L;
                        }
                    }
                }
                catch (Error | Exception t) {
                    OLogManager.instance().error(this, "Exception during data flush", t, new Object[0]);
                    OWOWCache.this.fireBackgroundDataFlushExceptionEvent(t);
                    OWOWCache.this.flushError = t;
                }
            }
            finally {
                if (flushInterval > 0L && !OWOWCache.this.stopFlush) {
                    OWOWCache.this.flushFuture = commitExecutor.schedule(this, flushInterval, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private final class ExclusiveFlushTask
    implements Runnable {
        private final CountDownLatch cacheBoundaryLatch;
        private final CountDownLatch completionLatch;

        private ExclusiveFlushTask(CountDownLatch cacheBoundaryLatch, CountDownLatch completionLatch) {
            this.cacheBoundaryLatch = cacheBoundaryLatch;
            this.completionLatch = completionLatch;
        }

        @Override
        public void run() {
            if (OWOWCache.this.stopFlush) {
                return;
            }
            try {
                if (OWOWCache.this.flushError != null) {
                    OLogManager.instance().errorNoDb(this, "Can not flush data because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                    return;
                }
                if (OWOWCache.this.writeCachePages.isEmpty()) {
                    return;
                }
                long ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
                assert (ewcSize >= 0L);
                if (this.cacheBoundaryLatch != null && ewcSize <= (long)OWOWCache.this.exclusiveWriteCacheMaxSize) {
                    this.cacheBoundaryLatch.countDown();
                }
                if (ewcSize > (long)OWOWCache.this.exclusiveWriteCacheMaxSize) {
                    OWOWCache.this.flushExclusiveWriteCache(this.cacheBoundaryLatch, OWOWCache.this.chunkSize);
                }
            }
            catch (Error | Exception t) {
                OLogManager.instance().error(this, "Exception during data flush", t, new Object[0]);
                OWOWCache.this.fireBackgroundDataFlushExceptionEvent(t);
                OWOWCache.this.flushError = t;
            }
            finally {
                if (this.cacheBoundaryLatch != null) {
                    this.cacheBoundaryLatch.countDown();
                }
                if (this.completionLatch != null) {
                    this.completionLatch.countDown();
                }
            }
        }
    }

    private final class FlushTillSegmentTask
    implements Callable<Void> {
        private final long segmentId;

        private FlushTillSegmentTask(long segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public Void call() throws Exception {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not flush data till provided segment because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            OWOWCache.this.convertSharedDirtyPagesToLocal();
            Map.Entry firstEntry = OWOWCache.this.localDirtyPagesBySegment.firstEntry();
            if (firstEntry == null) {
                return null;
            }
            long minDirtySegment = (Long)firstEntry.getKey();
            while (minDirtySegment < this.segmentId) {
                this.flushExclusivePagesIfNeeded();
                OWOWCache.this.flushWriteCacheFromMinLSN(OWOWCache.this.writeAheadLog.begin().getSegment(), this.segmentId, OWOWCache.this.chunkSize);
                firstEntry = OWOWCache.this.localDirtyPagesBySegment.firstEntry();
                if (firstEntry == null) {
                    return null;
                }
                minDirtySegment = (Long)firstEntry.getKey();
            }
            return null;
        }

        private void flushExclusivePagesIfNeeded() throws InterruptedException, IOException {
            long ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
            assert (ewcSize >= 0L);
            if ((double)ewcSize >= 0.8 * (double)OWOWCache.this.exclusiveWriteCacheMaxSize) {
                OWOWCache.this.flushExclusiveWriteCache(null, ewcSize);
            }
        }
    }

    private static final class PageKey
    implements Comparable<PageKey> {
        private final int fileId;
        private final long pageIndex;

        private PageKey(int fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        @Override
        public int compareTo(PageKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            return Long.compare(this.pageIndex, other.pageIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        public int hashCode() {
            int result = this.fileId;
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        public String toString() {
            return "PageKey{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public PageKey previous() {
            return this.pageIndex == -1L ? this : new PageKey(this.fileId, this.pageIndex - 1L);
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final int fileId;
        private final String fileSystemName;

        private NameFileIdEntry(String name, int fileId) {
            this.name = name;
            this.fileId = fileId;
            this.fileSystemName = name;
        }

        private NameFileIdEntry(String name, int fileId, String fileSystemName) {
            this.name = name;
            this.fileId = fileId;
            this.fileSystemName = fileSystemName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.fileSystemName.equals(that.fileSystemName);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.fileId;
            result = 31 * result + this.fileSystemName.hashCode();
            return result;
        }
    }
}

