/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCacheEntryImpl;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OCacheEntryChanges;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class OAtomicOperationBinaryTracking
implements OAtomicOperation {
    private final int storageId;
    private final OLogSequenceNumber startLSN;
    private final long operationUnitId;
    private boolean rollback;
    private final Set<String> lockedObjects = new HashSet<String>();
    private final Map<Long, FileChanges> fileChanges = new HashMap<Long, FileChanges>();
    private final Map<String, Long> newFileNamesId = new HashMap<String, Long>();
    private final Set<Long> deletedFiles = new HashSet<Long>();
    private final Map<String, Long> deletedFileNameIdMap = new HashMap<String, Long>();
    private final OReadCache readCache;
    private final OWriteCache writeCache;
    private final Map<String, OAtomicOperationMetadata<?>> metadata = new LinkedHashMap();
    private int componentOperationsCount;
    private final Set<OBonsaiBucketPointer> deletedBonsaiPointers = new HashSet<OBonsaiBucketPointer>();
    private final Map<ORawPair<Integer, Integer>, Set<Integer>> deletedRecordPositions = new HashMap<ORawPair<Integer, Integer>, Set<Integer>>();

    OAtomicOperationBinaryTracking(OLogSequenceNumber startLSN, long operationUnitId, OReadCache readCache, OWriteCache writeCache, int storageId) {
        this.storageId = storageId;
        this.startLSN = startLSN;
        this.operationUnitId = operationUnitId;
        this.readCache = readCache;
        this.writeCache = writeCache;
    }

    @Override
    public long getOperationUnitId() {
        return this.operationUnitId;
    }

    @Override
    public OCacheEntry loadPageForWrite(long fileId, long pageIndex, boolean checkPinnedPages, int pageCount, boolean verifyChecksum) throws IOException {
        assert (pageCount > 0);
        if (this.deletedFiles.contains(fileId = OAtomicOperationBinaryTracking.checkFileIdCompatibility(fileId, this.storageId))) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.computeIfAbsent(fileId, k -> new FileChanges());
        if (changesContainer.isNew) {
            if (pageIndex <= changesContainer.maxNewPageIndex) {
                return (OCacheEntry)changesContainer.pageChangesMap.get(pageIndex);
            }
            return null;
        }
        OCacheEntryChanges pageChangesContainer = (OCacheEntryChanges)changesContainer.pageChangesMap.get(pageIndex);
        if (OAtomicOperationBinaryTracking.checkChangesFilledUpTo(changesContainer, pageIndex)) {
            if (pageChangesContainer == null) {
                OCacheEntry delegate = this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, verifyChecksum);
                if (delegate != null) {
                    pageChangesContainer = new OCacheEntryChanges(verifyChecksum);
                    changesContainer.pageChangesMap.put(pageIndex, pageChangesContainer);
                    pageChangesContainer.delegate = delegate;
                    return pageChangesContainer;
                }
            } else {
                if (pageChangesContainer.isNew) {
                    return pageChangesContainer;
                }
                pageChangesContainer.delegate = this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, verifyChecksum);
                return pageChangesContainer;
            }
        }
        return null;
    }

    @Override
    public OCacheEntry loadPageForRead(long fileId, long pageIndex, boolean checkPinnedPages, int pageCount) throws IOException {
        assert (pageCount > 0);
        if (this.deletedFiles.contains(fileId = OAtomicOperationBinaryTracking.checkFileIdCompatibility(fileId, this.storageId))) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        if (changesContainer == null) {
            return this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, true);
        }
        if (changesContainer.isNew) {
            if (pageIndex <= changesContainer.maxNewPageIndex) {
                return (OCacheEntry)changesContainer.pageChangesMap.get(pageIndex);
            }
            return null;
        }
        OCacheEntryChanges pageChangesContainer = (OCacheEntryChanges)changesContainer.pageChangesMap.get(pageIndex);
        if (OAtomicOperationBinaryTracking.checkChangesFilledUpTo(changesContainer, pageIndex)) {
            if (pageChangesContainer == null) {
                return this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, true);
            }
            if (pageChangesContainer.isNew) {
                return pageChangesContainer;
            }
            pageChangesContainer.delegate = this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, true);
            return pageChangesContainer;
        }
        return null;
    }

    @Override
    public void addMetadata(OAtomicOperationMetadata<?> metadata) {
        this.metadata.put(metadata.getKey(), metadata);
    }

    @Override
    public OAtomicOperationMetadata<?> getMetadata(String key) {
        return this.metadata.get(key);
    }

    private Map<String, OAtomicOperationMetadata<?>> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @Override
    public void addDeletedRidBag(OBonsaiBucketPointer rootPointer) {
        this.deletedBonsaiPointers.add(rootPointer);
    }

    @Override
    public Set<OBonsaiBucketPointer> getDeletedBonsaiPointers() {
        return this.deletedBonsaiPointers;
    }

    @Override
    public OCacheEntry addPage(long fileId) {
        if (this.deletedFiles.contains(fileId = OAtomicOperationBinaryTracking.checkFileIdCompatibility(fileId, this.storageId))) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        assert (changesContainer != null);
        long filledUpTo = this.internalFilledUpTo(fileId, changesContainer);
        OCacheEntryChanges pageChangesContainer = (OCacheEntryChanges)changesContainer.pageChangesMap.get(filledUpTo);
        assert (pageChangesContainer == null);
        pageChangesContainer = new OCacheEntryChanges(false);
        pageChangesContainer.isNew = true;
        changesContainer.pageChangesMap.put(filledUpTo, pageChangesContainer);
        changesContainer.maxNewPageIndex = filledUpTo;
        pageChangesContainer.delegate = new OCacheEntryImpl(fileId, (int)filledUpTo, new OCachePointer(null, null, fileId, (int)filledUpTo), false);
        return pageChangesContainer;
    }

    @Override
    public void releasePageFromRead(OCacheEntry cacheEntry) {
        if (cacheEntry instanceof OCacheEntryChanges) {
            this.releasePageFromWrite(cacheEntry);
        } else {
            this.readCache.releaseFromRead(cacheEntry, this.writeCache);
        }
    }

    @Override
    public void releasePageFromWrite(OCacheEntry cacheEntry) {
        OCacheEntryChanges real = (OCacheEntryChanges)cacheEntry;
        if (this.deletedFiles.contains(cacheEntry.getFileId())) {
            throw new OStorageException("File with id " + cacheEntry.getFileId() + " is deleted.");
        }
        if (cacheEntry.getCachePointer().getBuffer() != null) {
            this.readCache.releaseFromRead(real.getDelegate(), this.writeCache);
        } else assert (real.isNew || !cacheEntry.isLockAcquiredByCurrentThread());
    }

    @Override
    public long filledUpTo(long fileId) {
        if (this.deletedFiles.contains(fileId = OAtomicOperationBinaryTracking.checkFileIdCompatibility(fileId, this.storageId))) {
            throw new OStorageException("File with id " + fileId + " is deleted.");
        }
        FileChanges changesContainer = this.fileChanges.get(fileId);
        return this.internalFilledUpTo(fileId, changesContainer);
    }

    private long internalFilledUpTo(long fileId, FileChanges changesContainer) {
        if (changesContainer == null) {
            changesContainer = new FileChanges();
            this.fileChanges.put(fileId, changesContainer);
        } else {
            if (changesContainer.isNew || changesContainer.maxNewPageIndex > -2L) {
                return changesContainer.maxNewPageIndex + 1L;
            }
            if (changesContainer.truncate) {
                return 0L;
            }
        }
        return this.writeCache.getFilledUpTo(fileId);
    }

    private static boolean checkChangesFilledUpTo(FileChanges changesContainer, long pageIndex) {
        if (changesContainer == null) {
            return true;
        }
        if (changesContainer.isNew || changesContainer.maxNewPageIndex > -2L) {
            return pageIndex < changesContainer.maxNewPageIndex + 1L;
        }
        return !changesContainer.truncate;
    }

    @Override
    public long addFile(String fileName) {
        boolean isNew;
        long fileId;
        if (this.newFileNamesId.containsKey(fileName)) {
            throw new OStorageException("File with name " + fileName + " already exists.");
        }
        if (this.deletedFileNameIdMap.containsKey(fileName)) {
            fileId = this.deletedFileNameIdMap.remove(fileName);
            this.deletedFiles.remove(fileId);
            isNew = false;
        } else {
            fileId = this.writeCache.bookFileId(fileName);
            isNew = true;
        }
        this.newFileNamesId.put(fileName, fileId);
        FileChanges fileChanges = new FileChanges();
        fileChanges.isNew = isNew;
        fileChanges.fileName = fileName;
        fileChanges.maxNewPageIndex = -1L;
        this.fileChanges.put(fileId, fileChanges);
        return fileId;
    }

    @Override
    public long loadFile(String fileName) throws IOException {
        Long fileId = this.newFileNamesId.get(fileName);
        if (fileId == null) {
            fileId = this.writeCache.loadFile(fileName);
        }
        this.fileChanges.computeIfAbsent(fileId, k -> new FileChanges());
        return fileId;
    }

    @Override
    public void deleteFile(long fileId) {
        FileChanges fileChanges = this.fileChanges.remove(fileId = OAtomicOperationBinaryTracking.checkFileIdCompatibility(fileId, this.storageId));
        if (fileChanges != null && fileChanges.fileName != null) {
            this.newFileNamesId.remove(fileChanges.fileName);
        } else {
            this.deletedFiles.add(fileId);
            String f = this.writeCache.fileNameById(fileId);
            if (f != null) {
                this.deletedFileNameIdMap.put(f, fileId);
            }
        }
    }

    @Override
    public boolean isFileExists(String fileName) {
        if (this.newFileNamesId.containsKey(fileName)) {
            return true;
        }
        if (this.deletedFileNameIdMap.containsKey(fileName)) {
            return false;
        }
        return this.writeCache.exists(fileName);
    }

    @Override
    public String fileNameById(long fileId) {
        FileChanges fileChanges = this.fileChanges.get(fileId = OAtomicOperationBinaryTracking.checkFileIdCompatibility(fileId, this.storageId));
        if (fileChanges != null && fileChanges.fileName != null) {
            return fileChanges.fileName;
        }
        if (this.deletedFiles.contains(fileId)) {
            throw new OStorageException("File with id " + fileId + " was deleted.");
        }
        return this.writeCache.fileNameById(fileId);
    }

    @Override
    public void truncateFile(long fileId) {
        fileId = OAtomicOperationBinaryTracking.checkFileIdCompatibility(fileId, this.storageId);
        FileChanges fileChanges = this.fileChanges.computeIfAbsent(fileId, k -> new FileChanges());
        fileChanges.pageChangesMap.clear();
        fileChanges.maxNewPageIndex = -1L;
        if (fileChanges.isNew) {
            return;
        }
        fileChanges.truncate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber commitChanges(OWriteAheadLog writeAheadLog) throws IOException {
        OLogSequenceNumber txEndLsn = null;
        if (writeAheadLog != null) {
            OCacheEntryChanges filePageChanges;
            long pageIndex;
            Map.Entry filePageChangesEntry;
            Iterator filePageChangesIterator;
            long fileId;
            FileChanges fileChanges;
            OLogSequenceNumber startLSN = writeAheadLog.end();
            for (long l : this.deletedFiles) {
                writeAheadLog.log(new OFileDeletedWALRecord(this.operationUnitId, l));
            }
            for (Map.Entry<Long, FileChanges> entry : this.fileChanges.entrySet()) {
                fileChanges = entry.getValue();
                fileId = entry.getKey();
                if (fileChanges.isNew) {
                    writeAheadLog.log(new OFileCreatedWALRecord(this.operationUnitId, fileChanges.fileName, fileId));
                } else if (fileChanges.truncate) {
                    OLogManager.instance().warn((Object)this, "You performing truncate operation which is considered unsafe because can not be rolled back, as result data can be incorrectly restored after crash, this operation is not recommended to be used", new Object[0]);
                }
                filePageChangesIterator = fileChanges.pageChangesMap.entrySet().iterator();
                while (filePageChangesIterator.hasNext()) {
                    filePageChangesEntry = filePageChangesIterator.next();
                    if (((OCacheEntryChanges)filePageChangesEntry.getValue()).changes.hasChanges()) {
                        pageIndex = (Long)filePageChangesEntry.getKey();
                        filePageChanges = (OCacheEntryChanges)filePageChangesEntry.getValue();
                        OLogSequenceNumber changesLSN = writeAheadLog.log(new OUpdatePageRecord(pageIndex, fileId, this.operationUnitId, filePageChanges.changes));
                        filePageChanges.setChangeLSN(changesLSN);
                        continue;
                    }
                    filePageChangesIterator.remove();
                }
            }
            txEndLsn = writeAheadLog.logAtomicOperationEndRecord(this.operationUnitId, this.rollback, this.startLSN, this.getMetadata());
            for (long l : this.deletedFiles) {
                this.readCache.deleteFile(l, this.writeCache);
            }
            for (Map.Entry<Long, FileChanges> entry : this.fileChanges.entrySet()) {
                fileChanges = entry.getValue();
                fileId = entry.getKey();
                if (fileChanges.isNew) {
                    this.readCache.addFile(fileChanges.fileName, this.newFileNamesId.get(fileChanges.fileName), this.writeCache);
                } else if (fileChanges.truncate) {
                    OLogManager.instance().warn((Object)this, "You performing truncate operation which is considered unsafe because can not be rolled back, as result data can be incorrectly restored after crash, this operation is not recommended to be used", new Object[0]);
                    this.readCache.truncateFile(fileId, this.writeCache);
                }
                filePageChangesIterator = fileChanges.pageChangesMap.entrySet().iterator();
                while (filePageChangesIterator.hasNext()) {
                    filePageChangesEntry = filePageChangesIterator.next();
                    if (((OCacheEntryChanges)filePageChangesEntry.getValue()).changes.hasChanges()) {
                        pageIndex = (Long)filePageChangesEntry.getKey();
                        filePageChanges = (OCacheEntryChanges)filePageChangesEntry.getValue();
                        OCacheEntry cacheEntry = this.readCache.loadForWrite(fileId, pageIndex, true, this.writeCache, filePageChanges.verifyCheckSum, startLSN);
                        if (cacheEntry == null) {
                            assert (filePageChanges.isNew);
                            do {
                                if (cacheEntry == null) continue;
                                this.readCache.releaseFromWrite(cacheEntry, this.writeCache, true);
                            } while ((long)(cacheEntry = this.readCache.allocateNewPage(fileId, this.writeCache, startLSN)).getPageIndex() != pageIndex);
                        }
                        try {
                            ODurablePage durablePage = new ODurablePage(cacheEntry);
                            cacheEntry.setEndLSN(txEndLsn);
                            durablePage.restoreChanges(filePageChanges.changes);
                            durablePage.setLsn(filePageChanges.getChangeLSN());
                            continue;
                        }
                        finally {
                            this.readCache.releaseFromWrite(cacheEntry, this.writeCache, true);
                            continue;
                        }
                    }
                    filePageChangesIterator.remove();
                }
            }
        } else {
            Iterator<Object> iterator = this.deletedFiles.iterator();
            while (iterator.hasNext()) {
                long l = iterator.next();
                this.readCache.deleteFile(l, this.writeCache);
            }
            for (Map.Entry entry : this.fileChanges.entrySet()) {
                FileChanges fileChanges = (FileChanges)entry.getValue();
                long fileId = (Long)entry.getKey();
                if (fileChanges.isNew) {
                    this.readCache.addFile(fileChanges.fileName, this.newFileNamesId.get(fileChanges.fileName), this.writeCache);
                } else if (fileChanges.truncate) {
                    this.readCache.truncateFile(fileId, this.writeCache);
                }
                for (Map.Entry filePageChangesEntry : fileChanges.pageChangesMap.entrySet()) {
                    OCacheEntryChanges filePageChanges = (OCacheEntryChanges)filePageChangesEntry.getValue();
                    if (!filePageChanges.changes.hasChanges()) continue;
                    long pageIndex = (Long)filePageChangesEntry.getKey();
                    OCacheEntry cacheEntry = this.readCache.loadForWrite(fileId, pageIndex, true, this.writeCache, true, null);
                    if (cacheEntry == null) {
                        assert (filePageChanges.isNew);
                        do {
                            if (cacheEntry == null) continue;
                            this.readCache.releaseFromWrite(cacheEntry, this.writeCache, true);
                        } while ((long)(cacheEntry = this.readCache.allocateNewPage(fileId, this.writeCache, null)).getPageIndex() != pageIndex);
                    }
                    try {
                        ODurablePage durablePage = new ODurablePage(cacheEntry);
                        durablePage.restoreChanges(filePageChanges.changes);
                    }
                    finally {
                        this.readCache.releaseFromWrite(cacheEntry, this.writeCache, true);
                    }
                }
            }
        }
        return txEndLsn;
    }

    @Override
    public void rollbackInProgress() {
        this.rollback = true;
    }

    @Override
    public boolean isRollbackInProgress() {
        return this.rollback;
    }

    @Override
    public void addLockedObject(String lockedObject) {
        this.lockedObjects.add(lockedObject);
    }

    @Override
    public boolean containsInLockedObjects(String objectToLock) {
        return this.lockedObjects.contains(objectToLock);
    }

    @Override
    public Iterable<String> lockedObjects() {
        return this.lockedObjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAtomicOperationBinaryTracking operation = (OAtomicOperationBinaryTracking)o;
        return this.operationUnitId == operation.operationUnitId;
    }

    public int hashCode() {
        return Long.hashCode(this.operationUnitId);
    }

    private static int storageId(long fileId) {
        return (int)(fileId >>> 32);
    }

    private static long composeFileId(long fileId, int storageId) {
        return (long)storageId << 32 | fileId;
    }

    private static long checkFileIdCompatibility(long fileId, int storageId) {
        if (storageId == -1) {
            return fileId;
        }
        if (OAtomicOperationBinaryTracking.storageId(fileId) == 0) {
            return OAtomicOperationBinaryTracking.composeFileId(fileId, storageId);
        }
        return fileId;
    }

    @Override
    public void addDeletedRecordPosition(int clusterId, int pageIndex, int recordPosition) {
        ORawPair<Integer, Integer> key = new ORawPair<Integer, Integer>(clusterId, pageIndex);
        Set recordPositions = this.deletedRecordPositions.computeIfAbsent(key, k -> new HashSet());
        recordPositions.add(recordPosition);
    }

    @Override
    public Set<Integer> getBookedRecordPositions(int clusterId, int pageIndex) {
        return this.deletedRecordPositions.getOrDefault(new ORawPair<Integer, Integer>(clusterId, pageIndex), Collections.emptySet());
    }

    @Override
    public void incrementComponentOperations() {
        ++this.componentOperationsCount;
    }

    @Override
    public void decrementComponentOperations() {
        --this.componentOperationsCount;
    }

    @Override
    public int getComponentOperations() {
        return this.componentOperationsCount;
    }

    private static final class FileChanges {
        private final Map<Long, OCacheEntryChanges> pageChangesMap = new HashMap<Long, OCacheEntryChanges>();
        private long maxNewPageIndex = -2L;
        private boolean isNew;
        private boolean truncate;
        private String fileName;

        private FileChanges() {
        }
    }
}

