/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.common.WriteableWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class OAtomicOperationPageOperationsTracking
implements OAtomicOperation {
    private final Map<String, OAtomicOperationMetadata<?>> metadata = new LinkedHashMap();
    private final OReadCache readCache;
    private final OWriteCache writeCache;
    private final OWriteAheadLog writeAheadLog;
    private final long operationUnitId;
    private int componentOperationsCounter;
    private final Set<String> lockedObjects = new HashSet<String>();
    private boolean rollbackInProgress;
    private final List<OLogSequenceNumber> pageOperationRefs = new ArrayList<OLogSequenceNumber>();
    private final List<PageOperationRecord> pageOperationCache = new ArrayList<PageOperationRecord>();
    private long sizeSerializedOperations = 0L;
    private final int operationsCacheLimit;
    private final Set<OBonsaiBucketPointer> deletedBonsaiPointers = new HashSet<OBonsaiBucketPointer>();
    private final OLogSequenceNumber startLSN;
    private final Map<ORawPair<Integer, Integer>, Set<Integer>> deletedRecordPositions = new HashMap<ORawPair<Integer, Integer>, Set<Integer>>();

    OAtomicOperationPageOperationsTracking(OReadCache readCache, OWriteCache writeCache, OWriteAheadLog writeAheadLog, long operationUnitId, int operationsCacheLimit, OLogSequenceNumber startLSN) {
        this.readCache = readCache;
        this.writeCache = writeCache;
        this.operationUnitId = operationUnitId;
        this.writeAheadLog = writeAheadLog;
        this.operationsCacheLimit = operationsCacheLimit;
        this.startLSN = startLSN;
    }

    @Override
    public OCacheEntry loadPageForWrite(long fileId, long pageIndex, boolean checkPinnedPages, int pageCount, boolean verifyChecksum) throws IOException {
        return this.readCache.loadForWrite(fileId, pageIndex, checkPinnedPages, this.writeCache, verifyChecksum, null);
    }

    @Override
    public OCacheEntry loadPageForRead(long fileId, long pageIndex, boolean checkPinnedPages, int pageCount) throws IOException {
        return this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, true);
    }

    @Override
    public void releasePageFromRead(OCacheEntry cacheEntry) {
        this.readCache.releaseFromRead(cacheEntry, this.writeCache);
    }

    @Override
    public void releasePageFromWrite(OCacheEntry cacheEntry) throws IOException {
        List<PageOperationRecord> pageOperationRecords = cacheEntry.getPageOperations();
        OLogSequenceNumber lastLSN = null;
        for (PageOperationRecord pageOperationRecord : pageOperationRecords) {
            pageOperationRecord.setOperationUnitId(this.operationUnitId);
            pageOperationRecord.setFileId(cacheEntry.getFileId());
            pageOperationRecord.setPageIndex(cacheEntry.getPageIndex());
            OLogSequenceNumber lsn = this.writeAheadLog.log(pageOperationRecord);
            this.pageOperationRefs.add(lsn);
            this.sizeSerializedOperations += (long)pageOperationRecord.serializedSize();
            lastLSN = lsn;
            if (this.sizeSerializedOperations <= (long)this.operationsCacheLimit) {
                this.pageOperationCache.add(pageOperationRecord);
                continue;
            }
            this.pageOperationCache.clear();
        }
        if (lastLSN != null) {
            ODurablePage.setPageLSN(lastLSN, cacheEntry);
            cacheEntry.setEndLSN(lastLSN);
        }
        this.readCache.releaseFromWrite(cacheEntry, this.writeCache, true);
    }

    @Override
    public OCacheEntry addPage(long fileId) throws IOException {
        return this.readCache.allocateNewPage(fileId, this.writeCache, null);
    }

    @Override
    public long filledUpTo(long fileId) {
        return this.writeCache.getFilledUpTo(fileId);
    }

    @Override
    public long addFile(String fileName) throws IOException {
        return this.readCache.addFile(fileName, this.writeCache);
    }

    @Override
    public long loadFile(String fileName) throws IOException {
        return this.writeCache.loadFile(fileName);
    }

    @Override
    public void deleteFile(long fileId) throws IOException {
        this.readCache.deleteFile(fileId, this.writeCache);
    }

    @Override
    public boolean isFileExists(String fileName) {
        return this.writeCache.exists(fileName);
    }

    @Override
    public String fileNameById(long fileId) {
        return this.writeCache.fileNameById(fileId);
    }

    @Override
    public void truncateFile(long fileId) throws IOException {
        this.readCache.truncateFile(fileId, this.writeCache);
    }

    @Override
    public void addDeletedRidBag(OBonsaiBucketPointer rootPointer) {
        this.deletedBonsaiPointers.add(rootPointer);
    }

    @Override
    public Set<OBonsaiBucketPointer> getDeletedBonsaiPointers() {
        return this.deletedBonsaiPointers;
    }

    @Override
    public boolean containsInLockedObjects(String lockName) {
        return this.lockedObjects.contains(lockName);
    }

    @Override
    public void addLockedObject(String lockName) {
        this.lockedObjects.add(lockName);
    }

    @Override
    public Iterable<String> lockedObjects() {
        return this.lockedObjects;
    }

    @Override
    public void rollbackInProgress() {
        this.rollbackInProgress = true;
    }

    @Override
    public boolean isRollbackInProgress() {
        return this.rollbackInProgress;
    }

    @Override
    public long getOperationUnitId() {
        return this.operationUnitId;
    }

    @Override
    public OLogSequenceNumber commitChanges(OWriteAheadLog writeAheadLog) throws IOException {
        if (this.rollbackInProgress) {
            if (!this.pageOperationCache.isEmpty()) {
                for (int i = this.pageOperationCache.size() - 1; i >= 0; --i) {
                    PageOperationRecord pageOperationRecord = this.pageOperationCache.get(i);
                    this.revertPageOperation(pageOperationRecord);
                }
            } else if (!this.pageOperationRefs.isEmpty()) {
                int chunkSize = 1000;
                ArrayList<PageOperationRecord> chunkToRevert = new ArrayList<PageOperationRecord>();
                int startIndex = this.pageOperationRefs.size() - 1000;
                int endIndex = this.pageOperationRefs.size();
                if (startIndex < 0) {
                    startIndex = 0;
                }
                while (true) {
                    List<WriteableWALRecord> walRecords = writeAheadLog.read(this.pageOperationRefs.get(startIndex), 1000);
                    int recordsRead = 0;
                    while (true) {
                        for (WriteableWALRecord walRecord : walRecords) {
                            int index = recordsRead + startIndex;
                            if (startIndex + recordsRead >= endIndex) break;
                            if (!walRecord.getLsn().equals(this.pageOperationRefs.get(index))) continue;
                            chunkToRevert.add((PageOperationRecord)walRecord);
                            ++recordsRead;
                        }
                        if (recordsRead >= endIndex - startIndex) break;
                        walRecords = writeAheadLog.read(this.pageOperationRefs.get(recordsRead + startIndex), 1000);
                    }
                    Collections.reverse(chunkToRevert);
                    for (PageOperationRecord pageOperationRecord : chunkToRevert) {
                        this.revertPageOperation(pageOperationRecord);
                    }
                    chunkToRevert.clear();
                    if (startIndex == 0) break;
                    endIndex = startIndex;
                    if ((startIndex -= recordsRead) >= 0) continue;
                    startIndex = 0;
                }
            }
        }
        return writeAheadLog.logAtomicOperationEndRecord(this.operationUnitId, this.rollbackInProgress, this.startLSN, this.getMetadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertPageOperation(PageOperationRecord pageOperationRecord) throws IOException {
        OLogSequenceNumber lastLSN = null;
        OCacheEntry cacheEntry = this.readCache.loadForWrite(pageOperationRecord.getFileId(), pageOperationRecord.getPageIndex(), false, this.writeCache, true, null);
        try {
            pageOperationRecord.undo(cacheEntry);
            List<PageOperationRecord> rollbackOperationRecords = cacheEntry.getPageOperations();
            for (PageOperationRecord rollbackOperationRecord : rollbackOperationRecords) {
                rollbackOperationRecord.setOperationUnitId(this.operationUnitId);
                rollbackOperationRecord.setFileId(cacheEntry.getFileId());
                rollbackOperationRecord.setPageIndex(cacheEntry.getPageIndex());
                lastLSN = this.writeAheadLog.log(rollbackOperationRecord);
            }
            if (lastLSN != null) {
                ODurablePage.setPageLSN(lastLSN, cacheEntry);
                cacheEntry.setEndLSN(lastLSN);
            }
        }
        finally {
            this.readCache.releaseFromWrite(cacheEntry, this.writeCache, true);
        }
    }

    @Override
    public void addMetadata(OAtomicOperationMetadata<?> metadata) {
        this.metadata.put(metadata.getKey(), metadata);
    }

    @Override
    public OAtomicOperationMetadata<?> getMetadata(String key) {
        return this.metadata.get(key);
    }

    private Map<String, OAtomicOperationMetadata<?>> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @Override
    public void addDeletedRecordPosition(int clusterId, int pageIndex, int recordPosition) {
        ORawPair<Integer, Integer> key = new ORawPair<Integer, Integer>(clusterId, pageIndex);
        Set recordPositions = this.deletedRecordPositions.computeIfAbsent(key, k -> new HashSet());
        recordPositions.add(recordPosition);
    }

    @Override
    public Set<Integer> getBookedRecordPositions(int clusterId, int pageIndex) {
        return this.deletedRecordPositions.getOrDefault(new ORawPair<Integer, Integer>(clusterId, pageIndex), Collections.emptySet());
    }

    @Override
    public void incrementComponentOperations() {
        ++this.componentOperationsCounter;
    }

    @Override
    public void decrementComponentOperations() {
        --this.componentOperationsCounter;
    }

    @Override
    public int getComponentOperations() {
        return this.componentOperationsCounter;
    }
}

