/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.operationsfreezer;

import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.operationsfreezer.WaitingListNode;
import java.util.concurrent.atomic.AtomicReference;

final class WaitingList {
    private final AtomicReference<WaitingListNode> head = new AtomicReference();
    private final AtomicReference<WaitingListNode> tail = new AtomicReference();

    WaitingList() {
    }

    public void addThreadInWaitingList(Thread thread) {
        WaitingListNode last;
        WaitingListNode node = new WaitingListNode(thread);
        while (!this.tail.compareAndSet(last = this.tail.get(), node)) {
        }
        if (last == null) {
            this.head.set(node);
        } else {
            last.next = node;
            last.linkLatch.countDown();
        }
    }

    public WaitingListNode cutWaitingList() {
        WaitingListNode head;
        WaitingListNode tail;
        while (true) {
            tail = this.tail.get();
            head = this.head.get();
            if (tail == null) {
                return null;
            }
            if (head == null) {
                Thread.yield();
                continue;
            }
            if (head == tail) {
                return new WaitingListNode(head.item);
            }
            if (this.head.compareAndSet(head, tail)) break;
        }
        WaitingListNode node = head;
        node.waitTillAllLinksWillBeCreated();
        while (node.next != tail) {
            node = node.next;
            node.waitTillAllLinksWillBeCreated();
        }
        node.next = new WaitingListNode(tail.item);
        return head;
    }
}

