/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitBodyRecord;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class OAtomicUnitEndRecord
extends OOperationUnitBodyRecord {
    private boolean rollback;
    private Map<String, OAtomicOperationMetadata<?>> atomicOperationMetadataMap = new LinkedHashMap();

    public OAtomicUnitEndRecord() {
    }

    public OAtomicUnitEndRecord(long operationUnitId, boolean rollback, Map<String, OAtomicOperationMetadata<?>> atomicOperationMetadataMap) {
        super(operationUnitId);
        this.rollback = rollback;
        if (atomicOperationMetadataMap != null && atomicOperationMetadataMap.size() > 0) {
            this.atomicOperationMetadataMap = atomicOperationMetadataMap;
        }
    }

    public boolean isRollback() {
        return this.rollback;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        buffer.put(this.rollback ? (byte)1 : 0);
        if (this.atomicOperationMetadataMap.size() > 0) {
            for (Map.Entry<String, OAtomicOperationMetadata<?>> entry : this.atomicOperationMetadataMap.entrySet()) {
                if (entry.getKey().equals("cluster.record.rid")) {
                    buffer.put((byte)1);
                    ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)entry.getValue();
                    Object rids = recordOperationMetadata.getValue();
                    buffer.putInt(rids.size());
                    Iterator iterator = rids.iterator();
                    while (iterator.hasNext()) {
                        ORID rid = (ORID)iterator.next();
                        buffer.putLong(rid.getClusterPosition());
                        buffer.putInt(rid.getClusterId());
                    }
                    continue;
                }
                throw new IllegalStateException("Invalid metadata key cluster.record.rid");
            }
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        this.rollback = buffer.get() > 0;
        this.atomicOperationMetadataMap = new LinkedHashMap();
        byte metadataId = buffer.get();
        if (metadataId == 1) {
            int collectionsSize = buffer.getInt();
            ORecordOperationMetadata recordOperationMetadata = new ORecordOperationMetadata();
            for (int i = 0; i < collectionsSize; ++i) {
                long clusterPosition = buffer.getLong();
                int clusterId = buffer.getInt();
                recordOperationMetadata.addRid(new ORecordId(clusterId, clusterPosition));
            }
            this.atomicOperationMetadataMap.put(recordOperationMetadata.getKey(), recordOperationMetadata);
        } else if (metadataId > 0) {
            throw new IllegalStateException("Invalid metadata entry id " + metadataId);
        }
    }

    public Map<String, OAtomicOperationMetadata<?>> getAtomicOperationMetadata() {
        return Collections.unmodifiableMap(this.atomicOperationMetadataMap);
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 1 + this.metadataSize();
    }

    private int metadataSize() {
        int size = 1;
        for (Map.Entry<String, OAtomicOperationMetadata<?>> entry : this.atomicOperationMetadataMap.entrySet()) {
            if (entry.getKey().equals("cluster.record.rid")) {
                ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)entry.getValue();
                size += 4;
                Object rids = recordOperationMetadata.getValue();
                size += rids.size() * 12;
                continue;
            }
            throw new IllegalStateException("Invalid metadata key cluster.record.rid");
        }
        return size;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public String toString() {
        return this.toString("rollback=" + this.rollback);
    }

    @Override
    public int getId() {
        return 9;
    }
}

