/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractCheckPointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.nio.ByteBuffer;

public class OFuzzyCheckpointStartRecord
extends OAbstractCheckPointStartRecord {
    private volatile OLogSequenceNumber lsn;
    private OLogSequenceNumber flushedLsn;

    public OFuzzyCheckpointStartRecord() {
    }

    public OFuzzyCheckpointStartRecord(OLogSequenceNumber previousCheckpoint, OLogSequenceNumber flushedLsn) {
        super(previousCheckpoint);
        this.flushedLsn = flushedLsn;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        OLongSerializer.INSTANCE.serializeNative(this.flushedLsn.getSegment(), content, offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(this.flushedLsn.getPosition(), content, offset += 8, new Object[0]);
        return offset += 8;
    }

    @Override
    public void toStream(ByteBuffer buffer) {
        super.toStream(buffer);
        buffer.putLong(this.flushedLsn.getSegment());
        buffer.putLong(this.flushedLsn.getPosition());
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        long segment = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        long position = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.flushedLsn = new OLogSequenceNumber(segment, position);
        return offset += 8;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    public OLogSequenceNumber getFlushedLsn() {
        return this.flushedLsn;
    }

    @Override
    public OLogSequenceNumber getLsn() {
        return this.lsn;
    }

    @Override
    public void setLsn(OLogSequenceNumber lsn) {
        this.lsn = lsn;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public String toString() {
        return "OFuzzyCheckpointStartRecord{lsn=" + this.lsn + "} " + super.toString();
    }
}

