/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.bucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2Bucket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class CellBTreeMultiValueV2BucketAddAllNonLeafEntriesPO
extends PageOperationRecord {
    private int prevSize;
    private List<CellBTreeMultiValueV2Bucket.NonLeafEntry> nonLeafEntries;
    private OBinarySerializer keySerializer;
    private boolean isEncrypted;

    public CellBTreeMultiValueV2BucketAddAllNonLeafEntriesPO() {
    }

    public CellBTreeMultiValueV2BucketAddAllNonLeafEntriesPO(int prevSize, List<CellBTreeMultiValueV2Bucket.NonLeafEntry> nonLeafEntries, OBinarySerializer keySerializer, boolean isEncrypted) {
        this.prevSize = prevSize;
        this.nonLeafEntries = nonLeafEntries;
        this.keySerializer = keySerializer;
        this.isEncrypted = isEncrypted;
    }

    public int getPrevSize() {
        return this.prevSize;
    }

    public List<CellBTreeMultiValueV2Bucket.NonLeafEntry> getNonLeafEntries() {
        return this.nonLeafEntries;
    }

    public OBinarySerializer getKeySerializer() {
        return this.keySerializer;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        bucket.addAll(this.nonLeafEntries, this.keySerializer, this.isEncrypted);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        bucket.shrink(this.prevSize, this.keySerializer, this.isEncrypted);
    }

    @Override
    public int getId() {
        return 134;
    }

    @Override
    public int serializedSize() {
        int size = 10;
        for (CellBTreeMultiValueV2Bucket.NonLeafEntry nonLeafEntry : this.nonLeafEntries) {
            size += 12 + nonLeafEntry.key.length;
        }
        return super.serializedSize() + size;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.prevSize);
        buffer.put(this.keySerializer.getId());
        buffer.put(this.isEncrypted ? (byte)1 : 0);
        buffer.putInt(this.nonLeafEntries.size());
        for (CellBTreeMultiValueV2Bucket.NonLeafEntry nonLeafEntry : this.nonLeafEntries) {
            buffer.putInt(nonLeafEntry.leftChild);
            buffer.putInt(nonLeafEntry.rightChild);
            buffer.putInt(nonLeafEntry.key.length);
            buffer.put(nonLeafEntry.key);
        }
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.prevSize = buffer.getInt();
        this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
        this.isEncrypted = buffer.get() > 0;
        int entriesSize = buffer.getInt();
        this.nonLeafEntries = new ArrayList<CellBTreeMultiValueV2Bucket.NonLeafEntry>(entriesSize);
        for (int i = 0; i < entriesSize; ++i) {
            int leftChild = buffer.getInt();
            int rightChild = buffer.getInt();
            int keyLen = buffer.getInt();
            byte[] key = new byte[keyLen];
            buffer.get(key);
            CellBTreeMultiValueV2Bucket.NonLeafEntry nonLeafEntry = new CellBTreeMultiValueV2Bucket.NonLeafEntry(key, leftChild, rightChild);
            this.nonLeafEntries.add(nonLeafEntry);
        }
    }
}

