/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.bucket;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2Bucket;
import java.nio.ByteBuffer;

public final class CellBTreeMultiValueV2BucketCreateMainLeafEntryPO
extends PageOperationRecord {
    private int index;
    private byte[] key;
    private ORID value;
    private long mId;

    public CellBTreeMultiValueV2BucketCreateMainLeafEntryPO() {
    }

    public CellBTreeMultiValueV2BucketCreateMainLeafEntryPO(int index, byte[] key, ORID value, long mId) {
        this.index = index;
        this.key = key;
        this.value = value;
        this.mId = mId;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getKey() {
        return this.key;
    }

    public ORID getValue() {
        return this.value;
    }

    public long getmId() {
        return this.mId;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        boolean result = bucket.createMainLeafEntry(this.index, this.key, this.value, this.mId);
        if (!result) {
            throw new IllegalStateException("Can not redo create main leaf entry operation");
        }
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        bucket.removeMainLeafEntry(this.index, this.key.length);
    }

    @Override
    public int getId() {
        return 125;
    }

    @Override
    public int serializedSize() {
        int size = 8 + this.key.length + 8 + 1;
        if (this.value != null) {
            size += 10;
        }
        return super.serializedSize() + size;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putInt(this.key.length);
        buffer.put(this.key);
        buffer.putLong(this.mId);
        if (this.value == null) {
            buffer.put((byte)0);
        } else {
            buffer.put((byte)1);
            buffer.putShort((short)this.value.getClusterId());
            buffer.putLong(this.value.getClusterPosition());
        }
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        int len = buffer.getInt();
        this.key = new byte[len];
        buffer.get(this.key);
        this.mId = buffer.getLong();
        if (buffer.get() > 0) {
            short clusterId = buffer.getShort();
            long clusterPosition = buffer.getLong();
            this.value = new ORecordId(clusterId, clusterPosition);
        }
    }
}

