/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.entrypoint;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2EntryPoint;
import java.nio.ByteBuffer;

public final class CellBTreeMultiValueV2EntryPointSetTreeSizePO
extends PageOperationRecord {
    private long treeSize;
    private long prevTreeSize;

    public CellBTreeMultiValueV2EntryPointSetTreeSizePO() {
    }

    public CellBTreeMultiValueV2EntryPointSetTreeSizePO(long treeSize, long prevTreeSize) {
        this.treeSize = treeSize;
        this.prevTreeSize = prevTreeSize;
    }

    public long getTreeSize() {
        return this.treeSize;
    }

    public long getPrevTreeSize() {
        return this.prevTreeSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2EntryPoint bucket = new CellBTreeMultiValueV2EntryPoint(cacheEntry);
        bucket.setTreeSize(this.treeSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2EntryPoint bucket = new CellBTreeMultiValueV2EntryPoint(cacheEntry);
        bucket.setTreeSize(this.prevTreeSize);
    }

    @Override
    public int getId() {
        return 145;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putLong(this.treeSize);
        buffer.putLong(this.prevTreeSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.treeSize = buffer.getLong();
        this.prevTreeSize = buffer.getLong();
    }
}

