/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v1.entrypoint;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v1.CellBTreeSingleValueEntryPointV1;
import java.nio.ByteBuffer;

public final class CellBTreeEntryPointSingleValueV1SetTreeSizePO
extends PageOperationRecord {
    private long prevTreeSize;
    private long treeSize;

    public CellBTreeEntryPointSingleValueV1SetTreeSizePO() {
    }

    public CellBTreeEntryPointSingleValueV1SetTreeSizePO(long prevTreeSize, long treeSize) {
        this.prevTreeSize = prevTreeSize;
        this.treeSize = treeSize;
    }

    public long getPrevTreeSize() {
        return this.prevTreeSize;
    }

    public long getTreeSize() {
        return this.treeSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueEntryPointV1 bucket = new CellBTreeSingleValueEntryPointV1(cacheEntry);
        bucket.setTreeSize(this.treeSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueEntryPointV1 bucket = new CellBTreeSingleValueEntryPointV1(cacheEntry);
        bucket.setTreeSize(this.prevTreeSize);
    }

    @Override
    public int getId() {
        return 74;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putLong(this.treeSize);
        buffer.putLong(this.prevTreeSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.treeSize = buffer.getLong();
        this.prevTreeSize = buffer.getLong();
    }
}

