/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.nullbucket;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueV3NullBucket;
import java.nio.ByteBuffer;

public final class CellBTreeNullBucketSingleValueV3SetValuePO
extends PageOperationRecord {
    private ORID prevValue;
    private ORID value;

    public CellBTreeNullBucketSingleValueV3SetValuePO() {
    }

    public CellBTreeNullBucketSingleValueV3SetValuePO(ORID prevValue, ORID value) {
        this.prevValue = prevValue;
        this.value = value;
    }

    public ORID getPrevValue() {
        return this.prevValue;
    }

    public ORID getValue() {
        return this.value;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueV3NullBucket bucket = new CellBTreeSingleValueV3NullBucket(cacheEntry);
        bucket.setValue(this.value);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueV3NullBucket bucket = new CellBTreeSingleValueV3NullBucket(cacheEntry);
        if (this.prevValue == null) {
            bucket.removeValue();
        } else {
            bucket.setValue(this.prevValue);
        }
    }

    @Override
    public int getId() {
        return 91;
    }

    @Override
    public int serializedSize() {
        int size = 11;
        if (this.prevValue != null) {
            size += 10;
        }
        return super.serializedSize() + size;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putShort((short)this.value.getClusterId());
        buffer.putLong(this.value.getClusterPosition());
        if (this.prevValue != null) {
            buffer.put((byte)1);
            buffer.putShort((short)this.prevValue.getClusterId());
            buffer.putLong(this.prevValue.getClusterPosition());
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        short clusterId = buffer.getShort();
        long clusterPosition = buffer.getLong();
        this.value = new ORecordId(clusterId, clusterPosition);
        if (buffer.get() > 0) {
            clusterId = buffer.getShort();
            clusterPosition = buffer.getLong();
            this.prevValue = new ORecordId(clusterId, clusterPosition);
        }
    }
}

